/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class IssuerAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_issuerAltName;
    private ArrayList<GeneralName> issuerAltName = new ArrayList();

    public IssuerAltNameExtension() {
        super(TYPE);
    }

    public IssuerAltNameExtension(GeneralName generalName) {
        this(generalName, false);
    }

    public IssuerAltNameExtension(GeneralName generalName, boolean bl2) {
        super(TYPE, bl2);
        this.issuerAltName.add(generalName);
        this.setValue(this.toByteArray());
    }

    public IssuerAltNameExtension(Vector<GeneralName> vector) {
        this((List<GeneralName>)vector);
    }

    public IssuerAltNameExtension(List<GeneralName> list) {
        this(list, false);
    }

    public IssuerAltNameExtension(Vector<GeneralName> vector, boolean bl2) {
        this((List<GeneralName>)vector, bl2);
    }

    public IssuerAltNameExtension(List<GeneralName> list, boolean bl2) {
        super(TYPE, bl2);
        this.issuerAltName = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.setValue(this.toByteArray());
    }

    public IssuerAltNameExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public ArrayList<GeneralName> getIssuerAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuerAltName;
    }

    public Enumeration<GeneralName> issuerAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.issuerAltName == null ? null : new VectorOverArrayList<GeneralName>(this.issuerAltName).elements();
    }

    public void addIssuerAltName(GeneralName generalName) {
        this.issuerAltName.add(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.issuerAltName));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(byteArrayInputStream);
            this.issuerAltName = new ArrayList();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.issuerAltName.add(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
            if (this.issuerAltName.size() == 0) {
                throw new ASN1FormatException("No GeneralName defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("issuerAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.issuerAltName != null) {
            stringBuffer.append("issuerAltNames = {");
            boolean bl2 = false;
            int n2 = this.issuerAltName.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.issuerAltName.get(i2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

