/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class KeyUsageExtension
extends X509Extension {
    public static final int DIGITAL_SIGNATURE = 0;
    public static final int NON_REPUDIATION = 1;
    public static final int KEY_ENCIPHERMENT = 2;
    public static final int DATA_ENCIPHERMENT = 3;
    public static final int KEY_AGREEMENT = 4;
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final int ENCIPHER_ONLY = 7;
    public static final int DECIPHER_ONLY = 8;
    private static final String[] description = new String[]{"DIGITAL SIGNATURE", "NON REPUDIATION", "KEY ENCIPHERMENT", "DATA ENCIPHERMENT", "KEY AGREEMENT", "KEY CERT_SIGN", "CRL SIGN", "ENCIPHER ONLY", "DECIPHER ONLY"};
    private static final int[] LIST = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final ASN1ObjectID TYPE = PKIX.id_ce_keyUsage;
    private boolean[] keyUsage = new boolean[LIST.length];

    public KeyUsageExtension() {
        super(TYPE);
    }

    public KeyUsageExtension(boolean bl2) {
        super(TYPE, bl2);
        this.setValue(this.toByteArray());
    }

    public KeyUsageExtension(int[] nArray, boolean bl2) {
        super(TYPE, bl2);
        this.setUsageFlags(nArray);
    }

    public KeyUsageExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public boolean hasUsageFlag(int n2) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyUsage != null && n2 < this.keyUsage.length ? this.keyUsage[n2] : false;
    }

    public void setUsageFlag(int n2) {
        this.doSetUsageFlag(n2);
        this.setValue(this.toByteArray());
    }

    public void setUsageFlags(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.doSetUsageFlag(nArray[i2]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearUsageFlag(int n2) {
        if (this.keyUsage != null && n2 < this.keyUsage.length) {
            this.keyUsage[n2] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllUsageFlags() {
        if (this.keyUsage != null) {
            int n2 = this.keyUsage.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.keyUsage[i2] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetUsageFlag(int n2) {
        if (this.keyUsage == null || this.keyUsage.length < LIST.length) {
            boolean[] blArray = new boolean[LIST.length];
            if (this.keyUsage != null) {
                System.arraycopy(this.keyUsage, 0, blArray, 0, this.keyUsage.length);
            }
            this.keyUsage = blArray;
        }
        this.keyUsage[n2] = true;
    }

    private byte[] toByteArray() {
        ASN1BitString aSN1BitString = new ASN1BitString(this.keyUsage.length);
        for (int i2 = 0; i2 < this.keyUsage.length; ++i2) {
            if (!this.keyUsage[i2]) continue;
            aSN1BitString.setBit(i2);
        }
        byte[] byArray = Utils.toBytes(aSN1BitString);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            int n2;
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString aSN1BitString = new ASN1BitString(unsyncByteArrayInputStream);
            this.keyUsage = new boolean[aSN1BitString.bitLength()];
            try {
                for (n2 = 0; n2 < this.keyUsage.length; ++n2) {
                    this.keyUsage[n2] = aSN1BitString.testBit(n2);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown key usage flag: " + n2);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    public boolean[] getKeyUsage() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyUsage;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("keyUsageExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl2 = false;
        for (int i2 = 0; i2 < LIST.length; ++i2) {
            if (!this.hasUsageFlag(i2)) continue;
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(description[i2]);
            bl2 = true;
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

