/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class NameConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_nameConstraints;
    private ArrayList<GeneralName> permitted;
    private ArrayList<GeneralName> excluded;

    public NameConstraintsExtension() {
        super(TYPE);
    }

    public NameConstraintsExtension(Vector<GeneralName> vector, Vector<GeneralName> vector2) {
        this((List<GeneralName>)vector, (List<GeneralName>)vector2);
    }

    public NameConstraintsExtension(List<GeneralName> list, List<GeneralName> list2) {
        this(list, list2, true);
    }

    public NameConstraintsExtension(Vector<GeneralName> vector, Vector<GeneralName> vector2, boolean bl2) {
        this((List<GeneralName>)vector, (List<GeneralName>)vector2, bl2);
    }

    public NameConstraintsExtension(List<GeneralName> list, List<GeneralName> list2, boolean bl2) {
        super(TYPE, bl2);
        ArrayList<Object> arrayList = list == null ? null : (this.permitted = list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.excluded = list2 == null ? null : (list2 instanceof ArrayList ? (ArrayList<Object>)list2 : new ArrayList<GeneralName>(list2));
        this.setValue(this.toByteArray());
    }

    public NameConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Vector<GeneralName> getPermittedSubtrees() {
        ArrayList<GeneralName> arrayList = this.getPermittedSubtreesAsList();
        return arrayList == null ? null : new VectorOverArrayList<GeneralName>(arrayList);
    }

    public ArrayList<GeneralName> getPermittedSubtreesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.permitted;
    }

    public Vector<GeneralName> getExcludedSubtrees() {
        ArrayList<GeneralName> arrayList = this.getExcludedSubtreesAsList();
        return arrayList == null ? null : new VectorOverArrayList<GeneralName>(arrayList);
    }

    public ArrayList<GeneralName> getExcludedSubtreesAsList() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.excluded;
    }

    public void addPermittedSubtree(GeneralName generalName) {
        if (this.permitted == null) {
            this.permitted = new ArrayList();
        }
        this.permitted.add(generalName);
        this.setValue(this.toByteArray());
    }

    public void addExcludedSubtree(GeneralName generalName) {
        if (this.excluded == null) {
            this.excluded = new ArrayList();
        }
        this.excluded.add(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence;
        int n2;
        int n3;
        Object object;
        ASN1Sequence aSN1Sequence2 = new ASN1Sequence();
        if (this.permitted != null && this.permitted.size() > 0) {
            object = new ASN1GenericConstructed(0);
            n3 = this.permitted.size();
            for (n2 = 0; n2 < n3; ++n2) {
                aSN1Sequence = new ASN1Sequence();
                aSN1Sequence.addElement(this.permitted.get(n2));
                ((ASN1GenericConstructed)object).addElement(aSN1Sequence);
            }
            aSN1Sequence2.addElement((ASN1Object)object);
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            object = new ASN1GenericConstructed(1);
            n3 = this.excluded.size();
            for (n2 = 0; n2 < n3; ++n2) {
                aSN1Sequence = new ASN1Sequence();
                aSN1Sequence.addElement(this.excluded.get(n2));
                ((ASN1GenericConstructed)object).addElement(aSN1Sequence);
            }
            aSN1Sequence2.addElement((ASN1Object)object);
        }
        object = Utils.toBytes(aSN1Sequence2);
        this.isDecoded = true;
        return object;
    }

    private void decodeValue() {
        try {
            ASN1Sequence aSN1Sequence;
            ASN1SequenceInputStream aSN1SequenceInputStream;
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream2 = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream2.hasMoreData() && aSN1SequenceInputStream2.getCurrentTag() == 0) {
                aSN1SequenceInputStream2.setCurrentTag(16);
                aSN1SequenceInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
                this.permitted = new ArrayList();
                while (aSN1SequenceInputStream.hasMoreData()) {
                    aSN1Sequence = new ASN1Sequence(aSN1SequenceInputStream);
                    this.permitted.add(new GeneralName(Utils.toStream(aSN1Sequence.elementAt(0))));
                }
                aSN1SequenceInputStream.terminate();
            }
            if (aSN1SequenceInputStream2.hasMoreData() && aSN1SequenceInputStream2.getCurrentTag() == 1) {
                aSN1SequenceInputStream2.setCurrentTag(16);
                aSN1SequenceInputStream = new ASN1SequenceInputStream(aSN1SequenceInputStream2);
                this.excluded = new ArrayList();
                while (aSN1SequenceInputStream.hasMoreData()) {
                    aSN1Sequence = new ASN1Sequence(aSN1SequenceInputStream);
                    this.excluded.add(new GeneralName(Utils.toStream(aSN1Sequence.elementAt(0))));
                }
                aSN1SequenceInputStream.terminate();
            }
            aSN1SequenceInputStream2.terminate();
            if (this.permitted == null && this.excluded == null) {
                throw new ASN1FormatException("No name constraints defined for extension");
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        int n2;
        int n3;
        boolean bl2;
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("nameConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl3 = false;
        if (this.getPermittedSubtreesAsList() != null) {
            stringBuffer.append("permitted = {");
            bl2 = false;
            n3 = this.getPermittedSubtreesAsList().size();
            for (n2 = 0; n2 < n3; ++n2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getPermittedSubtreesAsList().get(n2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
            bl3 = true;
        }
        if (this.getExcludedSubtreesAsList() != null) {
            if (bl3) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("excluded = {");
            bl2 = false;
            n3 = this.getExcludedSubtreesAsList().size();
            for (n2 = 0; n2 < n3; ++n2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.getExcludedSubtreesAsList().get(n2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

