/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1BitString;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class NetscapeCertTypeExtension
extends X509Extension {
    public static final int SSL_CLIENT = 0;
    public static final int SSL_SERVER = 1;
    public static final int SMIME = 2;
    public static final int OBJECT_SIGNING = 3;
    public static final int SSL_CA = 5;
    public static final int SMIME_CA = 6;
    public static final int OBJECT_SIGNING_CA = 7;
    private static final int RESERVED = 4;
    private static final int[] LIST = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final String[] description = new String[]{"SSL CLIENT", "SSL SERVER", "SMIME", "OBJECT SIGNING", "RESERVED", "SSL_CA", "SMIME CA", "OBJECT SIGNING_CA"};
    private static final ASN1ObjectID TYPE = X509Extension.id_netscape_ce_type;
    private boolean[] certUsage = new boolean[LIST.length];

    public NetscapeCertTypeExtension() {
        super(TYPE);
    }

    public NetscapeCertTypeExtension(boolean bl2) {
        super(TYPE, bl2);
        this.setValue(this.toByteArray());
    }

    public NetscapeCertTypeExtension(int[] nArray, boolean bl2) {
        super(TYPE, bl2);
        this.setUsageFlags(nArray);
    }

    public NetscapeCertTypeExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public boolean hasUsageFlag(int n2) {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.certUsage != null && n2 < this.certUsage.length ? this.certUsage[n2] : false;
    }

    public void setUsageFlag(int n2) {
        this.doSetUsageFlag(n2);
        this.setValue(this.toByteArray());
    }

    public void setUsageFlags(int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.doSetUsageFlag(nArray[i2]);
        }
        this.setValue(this.toByteArray());
    }

    public void clearUsageFlag(int n2) {
        if (this.certUsage != null && n2 < this.certUsage.length) {
            this.certUsage[n2] = false;
        }
        this.setValue(this.toByteArray());
    }

    public void clearAllUsageFlags() {
        if (this.certUsage != null) {
            int n2 = this.certUsage.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.certUsage[i2] = false;
            }
            this.setValue(this.toByteArray());
        }
    }

    private void doSetUsageFlag(int n2) {
        if (this.certUsage == null || this.certUsage.length < LIST.length) {
            boolean[] blArray = new boolean[LIST.length];
            if (this.certUsage != null) {
                System.arraycopy(this.certUsage, 0, blArray, 0, this.certUsage.length);
            }
            this.certUsage = blArray;
        }
        this.certUsage[n2] = true;
    }

    private byte[] toByteArray() {
        ASN1BitString aSN1BitString = new ASN1BitString(this.certUsage.length);
        for (int i2 = 0; i2 < this.certUsage.length; ++i2) {
            if (!this.certUsage[i2]) continue;
            aSN1BitString.setBit(i2);
        }
        byte[] byArray = Utils.toBytes(aSN1BitString);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            int n2;
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1BitString aSN1BitString = new ASN1BitString(unsyncByteArrayInputStream);
            this.certUsage = new boolean[aSN1BitString.bitLength()];
            try {
                for (n2 = 0; n2 < this.certUsage.length; ++n2) {
                    this.certUsage[n2] = aSN1BitString.testBit(n2);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ASN1FormatException("Unknown cert usage flag: " + n2);
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("netscapeCertTypeExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl2 = false;
        for (int i2 = 0; i2 < LIST.length; ++i2) {
            if (!this.hasUsageFlag(i2)) continue;
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(description[i2]);
            bl2 = true;
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

