/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericPrimitive;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class PolicyConstraintsExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_policyConstraints;
    private BigInteger requireExplicit;
    private BigInteger inhibitMapping;

    public PolicyConstraintsExtension() {
        super(TYPE);
    }

    public PolicyConstraintsExtension(BigInteger bigInteger, BigInteger bigInteger2) {
        this(bigInteger, bigInteger2, false);
    }

    public PolicyConstraintsExtension(BigInteger bigInteger, BigInteger bigInteger2, boolean bl2) {
        super(TYPE, bl2);
        this.requireExplicit = bigInteger;
        this.inhibitMapping = bigInteger2;
        this.setValue(this.toByteArray());
    }

    public PolicyConstraintsExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public BigInteger getRequireExplicitPolicy() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.requireExplicit;
    }

    public BigInteger getInhibitPolicyMapping() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.inhibitMapping;
    }

    private byte[] toByteArray() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.requireExplicit != null) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.requireExplicit), 0));
        }
        if (this.inhibitMapping != null) {
            aSN1Sequence.addElement(new ASN1GenericPrimitive(new ASN1Integer(this.inhibitMapping), 1));
        }
        byte[] byArray = Utils.toBytes(aSN1Sequence);
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 0) {
                aSN1SequenceInputStream.setCurrentTag(2);
                this.requireExplicit = ASN1Integer.inputValue(aSN1SequenceInputStream);
            } else {
                this.requireExplicit = null;
            }
            if (aSN1SequenceInputStream.hasMoreData() && aSN1SequenceInputStream.getCurrentTag() == 1) {
                aSN1SequenceInputStream.setCurrentTag(2);
                this.inhibitMapping = ASN1Integer.inputValue(aSN1SequenceInputStream);
            } else {
                this.inhibitMapping = null;
            }
            if (this.requireExplicit == null && this.inhibitMapping == null) {
                throw new ASN1FormatException("Malformed extension contents");
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("policyConstraintsExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        boolean bl2 = false;
        if (this.getRequireExplicitPolicy() != null) {
            stringBuffer.append("requireExplicit = " + this.getRequireExplicitPolicy());
            bl2 = true;
        }
        if (this.getInhibitPolicyMapping() != null) {
            if (bl2) {
                stringBuffer.append(", ");
            }
            stringBuffer.append("inhibitMapping = " + this.getInhibitPolicyMapping());
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

