/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VectorOverArrayList;

public class SubjectAltNameExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectAltName;
    private ArrayList<GeneralName> subjAltName = new ArrayList();

    public SubjectAltNameExtension() {
        super(TYPE);
    }

    public SubjectAltNameExtension(GeneralName generalName) {
        this(generalName, false);
    }

    public SubjectAltNameExtension(GeneralName generalName, boolean bl2) {
        super(TYPE, bl2);
        this.subjAltName.add(generalName);
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(Vector<GeneralName> vector) {
        this((List<GeneralName>)vector);
    }

    public SubjectAltNameExtension(List<GeneralName> list) {
        this(list, false);
    }

    public SubjectAltNameExtension(Vector<GeneralName> vector, boolean bl2) {
        this((List<GeneralName>)vector, bl2);
    }

    public SubjectAltNameExtension(List<GeneralName> list, boolean bl2) {
        super(TYPE, bl2);
        this.subjAltName = list == null ? null : (list instanceof ArrayList ? (ArrayList<Object>)list : new ArrayList<GeneralName>(list));
        this.setValue(this.toByteArray());
    }

    public SubjectAltNameExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public Enumeration<GeneralName> subjectAltName() {
        ArrayList<GeneralName> arrayList = this.getSubjectAltName();
        return arrayList == null ? null : new VectorOverArrayList<GeneralName>(arrayList).elements();
    }

    public ArrayList<GeneralName> getSubjectAltName() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.subjAltName;
    }

    public void addSubjectAltName(GeneralName generalName) {
        this.subjAltName.add(generalName);
        this.setValue(this.toByteArray());
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1Sequence((List<? extends ASN1Object>)this.subjAltName));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getValue());
            ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(unsyncByteArrayInputStream);
            this.subjAltName = new ArrayList();
            while (aSN1SequenceInputStream.hasMoreData()) {
                this.subjAltName.add(new GeneralName(aSN1SequenceInputStream));
            }
            aSN1SequenceInputStream.terminate();
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer("subjectAltNameExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = [");
        if (this.subjAltName != null) {
            stringBuffer.append("subjectAltNames = {");
            boolean bl2 = false;
            int n2 = this.subjAltName.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(this.subjAltName.get(i2).toString());
                bl2 = true;
            }
            stringBuffer.append("}");
        }
        stringBuffer.append("]}");
        return stringBuffer.toString();
    }
}

