/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cert.ext;

import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.cert.PKIX;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SubjectKeyIDExtension
extends X509Extension {
    private static final ASN1ObjectID TYPE = PKIX.id_ce_subjectKeyIdentifier;
    private byte[] keyID = null;

    public SubjectKeyIDExtension() {
        super(TYPE);
    }

    public SubjectKeyIDExtension(byte[] byArray) {
        this(byArray, false);
    }

    public SubjectKeyIDExtension(byte[] byArray, boolean bl2) {
        super(TYPE, bl2);
        this.keyID = byArray;
        this.setValue(this.toByteArray());
    }

    public SubjectKeyIDExtension(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public byte[] getSubjectKeyID() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return this.keyID;
    }

    private byte[] toByteArray() {
        byte[] byArray = Utils.toBytes(new ASN1OctetString(this.keyID));
        this.isDecoded = true;
        return byArray;
    }

    private void decodeValue() {
        try {
            this.keyID = ASN1OctetString.inputValue(new UnsyncByteArrayInputStream(this.getValue()));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.toString());
        }
        this.isDecoded = true;
    }

    @Override
    public String toString() {
        if (!this.isDecoded) {
            this.decodeValue();
        }
        return "subjectKeyIDExtension {oid = " + TYPE.toStringCompact() + ", critical = " + this.getCritical() + ", value = " + (this.getSubjectKeyID() != null ? Utils.toHexString(this.getSubjectKeyID()) : "") + "}";
    }
}

