/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.ObjectOutputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.a;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.Utils;

public final class AES
extends BlockCipher {
    private AlgorithmIdentifier g = null;
    private int h;
    private int i;
    private int j;
    private int[] k;
    private int[] l;
    private byte[] m;
    private byte[] n;
    private int o;
    private int p;
    private int q;
    private int r;
    private int s;
    private int t;
    private int u;
    private int v;
    private int w;
    private int x;
    private int y;
    private int z;
    private int A;
    private int B;
    private int C;
    private int D;
    private int[] E;
    private int[] F;
    public static final int AES128_KEY_LENGTH = 128;
    public static final int AES192_KEY_LENGTH = 192;
    public static final int AES256_KEY_LENGTH = 256;
    private static int[][] G = new int[256][8];
    private static final int[] H = new int[30];
    private static final int[] I = new int[256];
    private static final int[] J = new int[256];
    private static final int[] K = new int[256];
    private static final int[] L = new int[256];
    private static final int[] M = new int[256];
    private static final int[] N = new int[256];
    private static final int[] O = new int[256];
    private static final int[] P = new int[256];
    private static final int[] Q = new int[256];
    private static final int[] R = new int[256];
    private static final int[] S = new int[256];
    private static final int[] T = new int[256];
    private static final int[] U = new int[256];
    private static final int[] V = new int[256];
    private ObjectOutputStream W = null;

    private static void h() {
        AES.i();
        AES.j();
        AES.k();
        AES.l();
        AES.m();
        AES.n();
    }

    private static void i() {
        for (int i2 = 0; i2 < 256; ++i2) {
            AES.G[i2][0] = i2;
            for (int i3 = 1; i3 < 8; ++i3) {
                int n2 = G[i2][i3 - 1];
                AES.G[i2][i3] = (n2 >> 7 & 1) == 0 ? n2 << 1 : (n2 << 1 ^ 0x1B) & 0xFF;
            }
        }
    }

    private static void j() {
        int n2 = 1;
        for (int i2 = 2; i2 <= 30; ++i2) {
            AES.H[i2 - 1] = Utils.bytesToWord((byte)n2, 0, 0, 0);
            n2 = AES.b(2, n2 & 0xFF);
        }
    }

    private static void k() {
        for (int i2 = 0; i2 < 256; ++i2) {
            int n2 = AES.b(i2);
            AES.I[i2] = (n2 & 1) * 31 ^ (n2 >> 1 & 1) * 62 ^ (n2 >> 2 & 1) * 124 ^ (n2 >> 3 & 1) * 248 ^ (n2 >> 4 & 1) * 241 ^ (n2 >> 5 & 1) * 227 ^ (n2 >> 6 & 1) * 199 ^ (n2 >> 7 & 1) * 143 ^ 0x63;
            AES.J[AES.I[i2]] = i2;
        }
    }

    private static void l() {
        for (int i2 = 0; i2 < 256; ++i2) {
            byte by2 = (byte)I[i2];
            byte by3 = (byte)AES.b(I[i2], 2);
            byte by4 = (byte)AES.b(I[i2], 3);
            AES.K[i2] = Utils.bytesToWord(by3, by2, by2, by4);
            AES.L[i2] = Utils.bytesToWord(by4, by3, by2, by2);
            AES.M[i2] = Utils.bytesToWord(by2, by4, by3, by2);
            AES.N[i2] = Utils.bytesToWord(by2, by2, by4, by3);
        }
    }

    private static void m() {
        for (int i2 = 0; i2 < 256; ++i2) {
            byte by2 = (byte)AES.b(J[i2], 14);
            byte by3 = (byte)AES.b(J[i2], 9);
            byte by4 = (byte)AES.b(J[i2], 13);
            byte by5 = (byte)AES.b(J[i2], 11);
            AES.O[i2] = Utils.bytesToWord(by2, by3, by4, by5);
            AES.P[i2] = Utils.bytesToWord(by5, by2, by3, by4);
            AES.Q[i2] = Utils.bytesToWord(by4, by5, by2, by3);
            AES.R[i2] = Utils.bytesToWord(by3, by4, by5, by2);
        }
    }

    private static void n() {
        for (int i2 = 0; i2 < 256; ++i2) {
            byte by2 = (byte)AES.b(i2, 14);
            byte by3 = (byte)AES.b(i2, 9);
            byte by4 = (byte)AES.b(i2, 13);
            byte by5 = (byte)AES.b(i2, 11);
            AES.S[i2] = Utils.bytesToWord(by2, by3, by4, by5);
            AES.T[i2] = Utils.bytesToWord(by5, by2, by3, by4);
            AES.U[i2] = Utils.bytesToWord(by4, by5, by2, by3);
            AES.V[i2] = Utils.bytesToWord(by3, by4, by5, by2);
        }
    }

    public AES() {
        this.d = 0;
        this.a(4, 4);
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        oracle.security.crypto.core.a.a(symmetricKey, 256);
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.a(algorithmIdentifier, symmetricKey);
        this.f = randomBitsSource;
        this.a = null;
        this.a(algorithmIdentifier);
        this.e = symmetricKey;
        this.a((SymmetricKey)this.e);
        this.c();
        this.c = iD;
    }

    private void a(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey) throws InvalidKeyException {
        byte[] byArray = symmetricKey.d();
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID()) && byArray.length == 16 || algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID()) && byArray.length == 24 || algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID()) && byArray.length == 32 || algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID()) && byArray.length == 32) {
            return;
        }
        throw new InvalidKeyException("Key size did not match size specified in the AlgorithmIdentifier");
    }

    private void a(int n2, int n3) {
        if (n2 != 4 && n2 != 6 && n2 != 8) {
            throw new IllegalArgumentException("invalid Nb value " + n2);
        }
        if (n3 != 4 && n3 != 6 && n3 != 8) {
            throw new IllegalArgumentException("invalid Nk value " + n3);
        }
        this.h = n2;
        this.b = 4 * n2;
        this.i = n3;
        int n4 = n2 == 8 || n3 == 8 ? 14 : (this.j = n2 == 4 && n3 == 4 ? 10 : 12);
        if (this.k != null) {
            Utils.setArray(this.k, 0);
        }
        if (this.l != null) {
            Utils.setArray(this.l, 0);
        }
        if (this.m != null) {
            Utils.setArray(this.m, (byte)0);
        }
        if (this.n != null) {
            Utils.setArray(this.n, (byte)0);
        }
        this.k = new int[(this.j + 1) * n2];
        this.l = new int[(this.j + 1) * n2];
        this.m = new byte[4 * n2];
        this.n = new byte[4 * n2];
    }

    private void a(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.getOID().equals(AlgID.aes128_ECB.getOID())) {
            this.d = 0;
            this.a(4, 4);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_ECB.getOID())) {
            this.d = 0;
            this.a(4, 6);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_ECB.getOID())) {
            this.d = 0;
            this.a(4, 8);
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes128_CBC.getOID())) {
            this.d = 1;
            this.a(4, 4);
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes192_CBC.getOID())) {
            this.d = 1;
            this.a(4, 6);
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else if (algorithmIdentifier.getOID().equals(AlgID.aes256_CBC.getOID())) {
            this.d = 1;
            this.a(4, 8);
            this.b(CryptoUtils.getIV(algorithmIdentifier));
        } else {
            throw new AlgorithmIdentifierException("Unknown (or unsupported) AES algorithm identifier " + algorithmIdentifier);
        }
    }

    private void b(byte[] byArray) throws AlgorithmIdentifierException {
        try {
            if (byArray != null) {
                this.a(byArray);
            } else if (this.a == null) {
                this.a(this.b().randomBytes(new byte[this.getBlockSize()]));
            } else {
                this.a(this.a);
            }
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    private void a(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n2;
        byte[] byArray = symmetricKey.d();
        int n3 = byArray.length * 8;
        int n4 = n3 == 128 ? 4 : (n3 == 192 ? 6 : (n2 = n3 == 256 ? 8 : -1));
        if (n2 < 0) {
            throw new InvalidKeyException("Invalid keysize " + n3);
        }
        if (n2 != this.i) {
            this.a(this.h, n2);
        }
        for (int i2 = 0; i2 < this.h * (this.j + 1); ++i2) {
            if (i2 < this.i) {
                this.k[i2] = Utils.bytesToWord(byArray[4 * i2], byArray[4 * i2 + 1], byArray[4 * i2 + 2], byArray[4 * i2 + 3]);
            } else {
                int n5 = this.k[i2 - 1];
                if (i2 % this.i == 0) {
                    byte by2 = (byte)(n5 >> 24);
                    byte by3 = (byte)(n5 >> 16);
                    byte by4 = (byte)(n5 >> 8);
                    byte by5 = (byte)n5;
                    n5 = AES.c(by2 & 0xFF | (by5 & 0xFF) << 8 | (by4 & 0xFF) << 16 | (by3 & 0xFF) << 24) ^ H[i2 / this.i];
                } else if (this.i > 6 && i2 % this.i == 4) {
                    n5 = AES.c(n5);
                }
                this.k[i2] = this.k[i2 - this.i] ^ n5;
            }
            if (i2 < this.h || i2 >= this.h * this.j) {
                this.l[i2] = this.k[i2];
                continue;
            }
            byte[] byArray2 = Utils.wordToBytes(this.k[i2]);
            this.l[i2] = S[byArray2[0] & 0xFF] ^ T[byArray2[1] & 0xFF] ^ U[byArray2[2] & 0xFF] ^ V[byArray2[3] & 0xFF];
        }
        Utils.wordsToBytes(this.k, this.j * this.h, this.m, 0, this.h);
        Utils.wordsToBytes(this.l, 0, this.n, 0, this.h);
    }

    @Override
    protected void a(byte[] byArray, int n2, byte[] byArray2, int n3) throws CipherException {
        if (this.h != 4) {
            if (this.h == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.h == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("Invalid blocksize " + this.h);
        }
        this.d(byArray, n2, byArray2, n3);
    }

    @Override
    protected void b(byte[] byArray, int n2, byte[] byArray2, int n3) throws CipherException {
        if (this.h != 4) {
            if (this.h == 6) {
                throw new CipherException("not implemented for blocksize 192");
            }
            if (this.h == 8) {
                throw new CipherException("not implemented for blocksize 256");
            }
            throw new CipherException("Invalid blocking parameter " + this.h);
        }
        this.c(byArray, n2, byArray2, n3);
    }

    @Override
    public String algName() {
        return "AES-" + this.i * 32;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        AlgorithmIdentifier algorithmIdentifier = this.h == 4 ? (this.d == 0 ? (this.i == 4 ? AlgID.aes128_ECB : (this.i == 6 ? AlgID.aes192_ECB : (this.i == 8 ? AlgID.aes256_ECB : null))) : (this.d == 1 ? (this.i == 4 ? new CBCAlgorithmIdentifier(AlgID.aes128_CBC, this.getIV()) : (this.i == 6 ? new CBCAlgorithmIdentifier(AlgID.aes192_CBC, this.getIV()) : (this.i == 8 ? new CBCAlgorithmIdentifier(AlgID.aes256_CBC, this.getIV()) : null))) : null)) : null;
        return algorithmIdentifier;
    }

    public int getKeySize() {
        return 4 * this.i;
    }

    @Override
    public void erase() {
        super.erase();
        this.j = 0;
        this.i = 0;
        this.h = 0;
        this.b = 0;
        Utils.setArray(this.k, 0);
        Utils.setArray(this.l, 0);
        Utils.setArray(this.m, (byte)0);
        Utils.setArray(this.n, (byte)0);
        this.v = 0;
        this.u = 0;
        this.t = 0;
        this.s = 0;
        this.r = 0;
        this.q = 0;
        this.p = 0;
        this.o = 0;
        this.D = 0;
        this.C = 0;
        this.B = 0;
        this.A = 0;
        this.z = 0;
        this.y = 0;
        this.x = 0;
        this.w = 0;
        if (this.W != null) {
            this.W = null;
        }
    }

    public String toString() {
        return this.algName();
    }

    private void c(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.o = Utils.bytesToWord(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]) ^ this.k[0];
        this.p = Utils.bytesToWord(byArray[n2 + 4], byArray[n2 + 5], byArray[n2 + 6], byArray[n2 + 7]) ^ this.k[1];
        this.q = Utils.bytesToWord(byArray[n2 + 8], byArray[n2 + 9], byArray[n2 + 10], byArray[n2 + 11]) ^ this.k[2];
        this.r = Utils.bytesToWord(byArray[n2 + 12], byArray[n2 + 13], byArray[n2 + 14], byArray[n2 + 15]) ^ this.k[3];
        for (int i2 = 1; i2 < this.j; ++i2) {
            int n4 = this.o;
            int n5 = this.p;
            int n6 = this.q;
            int n7 = this.r;
            this.o = K[n4 >>> 24 & 0xFF] ^ L[n5 >>> 16 & 0xFF] ^ M[n6 >>> 8 & 0xFF] ^ N[n7 & 0xFF] ^ this.k[i2 * 4];
            this.p = K[n5 >>> 24 & 0xFF] ^ L[n6 >>> 16 & 0xFF] ^ M[n7 >>> 8 & 0xFF] ^ N[n4 & 0xFF] ^ this.k[i2 * 4 + 1];
            this.q = K[n6 >>> 24 & 0xFF] ^ L[n7 >>> 16 & 0xFF] ^ M[n4 >>> 8 & 0xFF] ^ N[n5 & 0xFF] ^ this.k[i2 * 4 + 2];
            this.r = K[n7 >>> 24 & 0xFF] ^ L[n4 >>> 16 & 0xFF] ^ M[n5 >>> 8 & 0xFF] ^ N[n6 & 0xFF] ^ this.k[i2 * 4 + 3];
            if (this.W == null) continue;
            try {
                this.W.writeObject(new int[]{this.o, this.p, this.q, this.r});
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("iv trace mode broken:  " + iOException);
            }
        }
        byArray2[n3] = (byte)(I[this.o >>> 24 & 0xFF] ^ this.m[0]);
        byArray2[n3 + 1] = (byte)(I[this.p >>> 16 & 0xFF] ^ this.m[1]);
        byArray2[n3 + 2] = (byte)(I[this.q >>> 8 & 0xFF] ^ this.m[2]);
        byArray2[n3 + 3] = (byte)(I[this.r & 0xFF] ^ this.m[3]);
        byArray2[n3 + 4] = (byte)(I[this.p >>> 24 & 0xFF] ^ this.m[4]);
        byArray2[n3 + 5] = (byte)(I[this.q >>> 16 & 0xFF] ^ this.m[5]);
        byArray2[n3 + 6] = (byte)(I[this.r >>> 8 & 0xFF] ^ this.m[6]);
        byArray2[n3 + 7] = (byte)(I[this.o & 0xFF] ^ this.m[7]);
        byArray2[n3 + 8] = (byte)(I[this.q >>> 24 & 0xFF] ^ this.m[8]);
        byArray2[n3 + 9] = (byte)(I[this.r >>> 16 & 0xFF] ^ this.m[9]);
        byArray2[n3 + 10] = (byte)(I[this.o >>> 8 & 0xFF] ^ this.m[10]);
        byArray2[n3 + 11] = (byte)(I[this.p & 0xFF] ^ this.m[11]);
        byArray2[n3 + 12] = (byte)(I[this.r >>> 24 & 0xFF] ^ this.m[12]);
        byArray2[n3 + 13] = (byte)(I[this.o >>> 16 & 0xFF] ^ this.m[13]);
        byArray2[n3 + 14] = (byte)(I[this.p >>> 8 & 0xFF] ^ this.m[14]);
        byArray2[n3 + 15] = (byte)(I[this.q & 0xFF] ^ this.m[15]);
    }

    private void d(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.o = Utils.bytesToWord(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]) ^ this.l[4 * this.j];
        this.p = Utils.bytesToWord(byArray[n2 + 4], byArray[n2 + 5], byArray[n2 + 6], byArray[n2 + 7]) ^ this.l[4 * this.j + 1];
        this.q = Utils.bytesToWord(byArray[n2 + 8], byArray[n2 + 9], byArray[n2 + 10], byArray[n2 + 11]) ^ this.l[4 * this.j + 2];
        this.r = Utils.bytesToWord(byArray[n2 + 12], byArray[n2 + 13], byArray[n2 + 14], byArray[n2 + 15]) ^ this.l[4 * this.j + 3];
        for (int i2 = this.j - 1; i2 > 0; --i2) {
            this.w = this.o;
            this.x = this.p;
            this.y = this.q;
            this.z = this.r;
            this.o = O[this.w >>> 24 & 0xFF] ^ P[this.z >>> 16 & 0xFF] ^ Q[this.y >>> 8 & 0xFF] ^ R[this.x & 0xFF] ^ this.l[i2 * 4];
            this.p = O[this.x >>> 24 & 0xFF] ^ P[this.w >>> 16 & 0xFF] ^ Q[this.z >>> 8 & 0xFF] ^ R[this.y & 0xFF] ^ this.l[i2 * 4 + 1];
            this.q = O[this.y >>> 24 & 0xFF] ^ P[this.x >>> 16 & 0xFF] ^ Q[this.w >>> 8 & 0xFF] ^ R[this.z & 0xFF] ^ this.l[i2 * 4 + 2];
            this.r = O[this.z >>> 24 & 0xFF] ^ P[this.y >>> 16 & 0xFF] ^ Q[this.x >>> 8 & 0xFF] ^ R[this.w & 0xFF] ^ this.l[i2 * 4 + 3];
            if (this.W == null) continue;
            try {
                this.W.writeObject(new int[]{this.o, this.p, this.q, this.r});
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException("iv trace mode broken:  " + iOException);
            }
        }
        byArray2[n3] = (byte)(J[this.o >>> 24 & 0xFF] ^ this.n[0]);
        byArray2[n3 + 1] = (byte)(J[this.r >>> 16 & 0xFF] ^ this.n[1]);
        byArray2[n3 + 2] = (byte)(J[this.q >>> 8 & 0xFF] ^ this.n[2]);
        byArray2[n3 + 3] = (byte)(J[this.p & 0xFF] ^ this.n[3]);
        byArray2[n3 + 4] = (byte)(J[this.p >>> 24 & 0xFF] ^ this.n[4]);
        byArray2[n3 + 5] = (byte)(J[this.o >>> 16 & 0xFF] ^ this.n[5]);
        byArray2[n3 + 6] = (byte)(J[this.r >>> 8 & 0xFF] ^ this.n[6]);
        byArray2[n3 + 7] = (byte)(J[this.q & 0xFF] ^ this.n[7]);
        byArray2[n3 + 8] = (byte)(J[this.q >>> 24 & 0xFF] ^ this.n[8]);
        byArray2[n3 + 9] = (byte)(J[this.p >>> 16 & 0xFF] ^ this.n[9]);
        byArray2[n3 + 10] = (byte)(J[this.o >>> 8 & 0xFF] ^ this.n[10]);
        byArray2[n3 + 11] = (byte)(J[this.r & 0xFF] ^ this.n[11]);
        byArray2[n3 + 12] = (byte)(J[this.r >>> 24 & 0xFF] ^ this.n[12]);
        byArray2[n3 + 13] = (byte)(J[this.q >>> 16 & 0xFF] ^ this.n[13]);
        byArray2[n3 + 14] = (byte)(J[this.p >>> 8 & 0xFF] ^ this.n[14]);
        byArray2[n3 + 15] = (byte)(J[this.o & 0xFF] ^ this.n[15]);
    }

    private static int b(int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            if ((n3 >> i2 & 1) == 0) continue;
            n4 ^= G[n2][i2];
        }
        return n4;
    }

    private static int a(int n2) {
        int n3 = 0;
        while (n2 >> n3 != 0) {
            ++n3;
        }
        return n3 - 1;
    }

    private static int c(int n2, int n3) {
        int n4;
        int n5 = 0;
        while ((n4 = AES.a(n2) - AES.a(n3)) >= 0) {
            n2 ^= n3 << n4;
            n5 ^= 1 << n4;
        }
        return n5;
    }

    private static int d(int n2, int n3) {
        int n4 = 0;
        for (int i2 = 0; i2 <= AES.a(n3); ++i2) {
            if ((n3 >> i2 & 1) == 0) continue;
            n4 ^= n2 << i2;
        }
        return n4;
    }

    private static int b(int n2) {
        int n3 = 283;
        if (n2 == 0) {
            return 0;
        }
        int n4 = 1;
        int n5 = 0;
        while (n2 != 0) {
            int n6 = AES.c(n3, n2);
            int n7 = n3 ^ AES.d(n2, n6);
            int n8 = n5 ^ AES.d(n4, n6);
            n3 = n2;
            n2 = n7;
            n5 = n4;
            n4 = n8;
        }
        return n5;
    }

    private static int c(int n2) {
        byte by2 = (byte)(n2 >> 24);
        byte by3 = (byte)(n2 >> 16);
        byte by4 = (byte)(n2 >> 8);
        byte by5 = (byte)n2;
        by2 = (byte)I[by2 & 0xFF];
        by3 = (byte)I[by3 & 0xFF];
        by4 = (byte)I[by4 & 0xFF];
        by5 = (byte)I[by5 & 0xFF];
        return by5 & 0xFF | (by4 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by2 & 0xFF) << 24;
    }

    private static int d(int n2) {
        byte[] byArray = Utils.wordToBytes(n2);
        return Utils.bytesToWord(byArray[1], byArray[2], byArray[3], byArray[0]);
    }

    private void a(ObjectOutputStream objectOutputStream) {
        this.W = objectOutputStream;
    }

    static {
        AES.h();
    }
}

