/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.c;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public abstract class BlockCipher
extends Cipher {
    protected byte[] a;
    private byte[] g;
    protected int b;
    protected Padding.ID c;

    protected BlockCipher() {
        this.b = 0;
        this.d = 0;
        this.c = Padding.NONE;
    }

    protected BlockCipher(int n2) {
        this.b = n2;
        this.d = 0;
        this.c = Padding.NONE;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        try {
            this.initialize(algorithmIdentifier, (SymmetricKey)key, Padding.NONE, randomBitsSource);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
    }

    @Override
    public byte[] decrypt(byte[] byArray, int n2, int n3, boolean bl2) throws CipherException {
        this.d();
        if (n3 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        byte[] byArray2 = new byte[n3];
        this.decrypt(byArray, n2, n3, byArray2, 0);
        if (bl2) {
            return BlockCipher.a(this.c, this.b, byArray2);
        }
        return byArray2;
    }

    @Override
    public void decrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        this.d();
        this.a(byArray, n2, n3, byArray2, n4);
    }

    private void a(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (n3 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        if (this.d == 0) {
            int n5 = n2;
            int n6 = n4;
            while (n5 < n2 + n3) {
                this.a(byArray, n5, byArray2, n6);
                n5 += this.b;
                n6 += this.b;
            }
        } else {
            int n7 = n2;
            int n8 = n4;
            while (n7 < n2 + n3) {
                this.a(byArray, n7, byArray2, n8);
                for (int i2 = 0; i2 < this.b; ++i2) {
                    int n9 = n8 + i2;
                    byArray2[n9] = (byte)(byArray2[n9] ^ this.g[i2]);
                }
                System.arraycopy(byArray, n7, this.g, 0, this.b);
                n7 += this.b;
                n8 += this.b;
            }
        }
    }

    protected abstract void a(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    @Override
    public byte[] encrypt(byte[] byArray, int n2, int n3, boolean bl2) throws CipherException {
        this.e();
        if (bl2) {
            byArray = BlockCipher.a(this.c, this.b, byArray, n2, n3);
            n2 = 0;
            n3 = byArray.length;
        } else if (n3 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        byte[] byArray2 = new byte[n3];
        this.encrypt(byArray, n2, n3, byArray2, 0);
        return byArray2;
    }

    @Override
    public void encrypt(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        this.e();
        this.b(byArray, n2, n3, byArray2, n4);
    }

    private void b(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (n3 % this.b != 0) {
            throw new CipherException("Data size is not a multiple of block size");
        }
        if (this.d == 0) {
            int n5 = n2;
            int n6 = n4;
            while (n5 < n2 + n3) {
                this.b(byArray, n5, byArray2, n6);
                n5 += this.b;
                n6 += this.b;
            }
        } else {
            int n7 = n2;
            int n8 = n4;
            while (n7 < n2 + n3) {
                for (int i2 = 0; i2 < this.b; ++i2) {
                    int n9 = i2;
                    this.g[n9] = (byte)(this.g[n9] ^ byArray[n7 + i2]);
                }
                this.b(this.g, 0, byArray2, n8);
                System.arraycopy(byArray2, n8, this.g, 0, this.b);
                n7 += this.b;
                n8 += this.b;
            }
        }
    }

    protected abstract void b(byte[] var1, int var2, byte[] var3, int var4) throws CipherException;

    @Override
    public byte[] wrapKey(PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot wrap encrypted key");
        }
        return this.b(oracle.security.crypto.core.c.a(privateKey));
    }

    @Override
    public byte[] wrapKey(SymmetricKey symmetricKey) throws CipherException {
        return this.b(symmetricKey.d());
    }

    private byte[] b(byte[] byArray) throws CipherException {
        this.f();
        byte[] byArray2 = BlockCipher.a(this.c, this.b, byArray, 0, byArray.length);
        byte[] byArray3 = new byte[byArray2.length];
        this.b(byArray2, 0, byArray2.length, byArray3, 0);
        this.a();
        return byArray3;
    }

    @Override
    public PrivateKey unwrapPrivateKey(byte[] byArray) throws CipherException {
        PrivateKey privateKey;
        byte[] byArray2 = this.c(byArray);
        try {
            privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        }
        catch (IOException iOException) {
            throw new CipherException(iOException.toString());
        }
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    @Override
    public SymmetricKey unwrapSymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) throws CipherException {
        byte[] byArray2 = this.c(byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2, algorithmIdentifier);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    private byte[] c(byte[] byArray) throws CipherException {
        this.g();
        byte[] byArray2 = new byte[byArray.length];
        this.a(byArray, 0, byArray.length, byArray2, 0);
        this.a();
        return BlockCipher.a(this.c, this.b, byArray2);
    }

    @Override
    public void erase() {
        super.erase();
    }

    @Override
    public final int getBlockSize() {
        return this.b;
    }

    @Override
    public final byte[] getIV() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.a == null) {
            return null;
        }
        return (byte[])this.a.clone();
    }

    protected void a(byte[] byArray) throws CipherException {
        if (byArray != null) {
            if (byArray.length != this.b) {
                throw new CipherException("IV length is not equal to block size");
            }
            this.a = (byte[])byArray.clone();
            if (this.g != null && this.g.length == this.b) {
                System.arraycopy(this.a, 0, this.g, 0, this.a.length);
            } else {
                this.g = (byte[])byArray.clone();
            }
        } else {
            this.a = null;
            this.g = null;
        }
        this.c();
    }

    @Override
    public final Padding.ID getPaddingID() {
        return this.c;
    }

    final void a() {
        if (this.a != null && this.g != null) {
            System.arraycopy(this.a, 0, this.g, 0, this.a.length);
        }
    }

    static byte[] a(Padding.ID iD, int n2, byte[] byArray, int n3, int n4) throws CipherException {
        if (iD == Padding.PKCS5) {
            if (n2 < 0 || n2 > 255) {
                throw new CipherException("Block size must be between 0 and 255");
            }
            byte by2 = (byte)(n2 - n4 % n2);
            int n5 = n4 + by2;
            byte[] byArray2 = new byte[n5];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            for (int i2 = n4; i2 < n5; ++i2) {
                byArray2[i2] = by2;
            }
            return byArray2;
        }
        if (n4 % n2 == 0) {
            if (n3 == 0 && n4 == byArray.length) {
                return byArray;
            }
            byte[] byArray3 = new byte[n4];
            System.arraycopy(byArray, n3, byArray3, 0, n4);
            return byArray3;
        }
        throw new CipherException("Data size is not a multiple of block size");
    }

    static byte[] a(Padding.ID iD, int n2, byte[] byArray) throws CipherException {
        if (iD == Padding.PKCS5) {
            int n3 = byArray[byArray.length - 1] & 0xFF;
            if (n3 > n2) {
                throw new CipherException("Invalid padding string (or incorrect password)");
            }
            int n4 = byArray.length;
            for (int i2 = byArray.length - n3; i2 < n4; ++i2) {
                if (byArray[i2] == n3) continue;
                throw new CipherException("Invalid padding string (or incorrect password)");
            }
            byte[] byArray2 = new byte[byArray.length - n3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        if (byArray.length % n2 == 0) {
            return byArray;
        }
        throw new CipherException("Data size is not a multiple of block size");
    }
}

