/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.Coder;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PublicKey;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.IntConstant;
import oracle.security.crypto.util.OIDManager;

public abstract class Cipher
extends Coder {
    private a a;
    protected int d;
    protected Key e;
    protected RandomBitsSource f;
    public static final int ECB = 0;
    public static final int CBC = 1;

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        return Cipher.getInstance(algorithmIdentifier, key, null);
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, Key key, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.a(clazz);
        cipher.initialize(algorithmIdentifier, key, randomBitsSource);
        return cipher;
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        return Cipher.getInstance(algorithmIdentifier, symmetricKey, iD, null);
    }

    public static Cipher getInstance(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.a(clazz);
        cipher.initialize(algorithmIdentifier, symmetricKey, iD, randomBitsSource);
        return cipher;
    }

    public static Cipher getInstance(PrivateKey privateKey) throws AlgorithmIdentifierException, InvalidKeyException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        AlgorithmIdentifier algorithmIdentifier = privateKey.getAlgID();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for the private key with AlgorithmIdentifier: " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.a(clazz);
        try {
            cipher.initialize(algorithmIdentifier, privateKey);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
        return cipher;
    }

    public static Cipher getInstance(PublicKey publicKey) throws AlgorithmIdentifierException, InvalidKeyException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        AlgorithmIdentifier algorithmIdentifier = publicKey.getAlgID();
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class<?> clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "cipher");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for the public key with AlgorithmIdentifier: " + algorithmIdentifier.getOID());
        }
        Cipher cipher = Cipher.a(clazz);
        try {
            cipher.initialize(algorithmIdentifier, publicKey);
        }
        catch (CipherException cipherException) {
            throw new AlgorithmIdentifierException(cipherException.toString());
        }
        return cipher;
    }

    protected Cipher() {
    }

    private static Cipher a(Class clazz) throws AlgorithmIdentifierException {
        Cipher cipher;
        try {
            cipher = (Cipher)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Cipher.");
        }
        return cipher;
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        this.initialize(algorithmIdentifier, key, null);
    }

    public abstract void initialize(AlgorithmIdentifier var1, Key var2, RandomBitsSource var3) throws AlgorithmIdentifierException, InvalidKeyException, CipherException;

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        this.initialize(algorithmIdentifier, symmetricKey, iD, null);
    }

    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD, RandomBitsSource randomBitsSource) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        throw new AlgorithmIdentifierException("This Cipher instance is not a block Cipher");
    }

    public Key cloneKey() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.e != null) {
            return (Key)this.e.clone();
        }
        return null;
    }

    public byte[] decrypt(byte[] byArray) throws CipherException {
        return this.decrypt(byArray, 0, byArray.length);
    }

    public byte[] decrypt(byte[] byArray, boolean bl2) throws CipherException {
        return this.decrypt(byArray, 0, byArray.length, bl2);
    }

    public byte[] decrypt(byte[] byArray, int n2, int n3) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.decrypt(byArray, n2, n3, false);
    }

    public abstract byte[] decrypt(byte[] var1, int var2, int var3, boolean var4) throws CipherException;

    public abstract void decrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CipherException;

    @Override
    public final byte[] decodeOp(byte[] byArray) throws CipherException {
        return this.decrypt(byArray);
    }

    public byte[] encrypt(byte[] byArray) throws CipherException {
        return this.encrypt(byArray, 0, byArray.length);
    }

    public byte[] encrypt(byte[] byArray, boolean bl2) throws CipherException {
        return this.encrypt(byArray, 0, byArray.length, bl2);
    }

    public byte[] encrypt(byte[] byArray, int n2, int n3) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.encrypt(byArray, n2, n3, false);
    }

    public abstract byte[] encrypt(byte[] var1, int var2, int var3, boolean var4) throws CipherException;

    public abstract void encrypt(byte[] var1, int var2, int var3, byte[] var4, int var5) throws CipherException;

    @Override
    public final byte[] encodeOp(byte[] byArray) throws CipherException {
        return this.encrypt(byArray);
    }

    public abstract byte[] wrapKey(PrivateKey var1) throws CipherException;

    public abstract byte[] wrapKey(SymmetricKey var1) throws CipherException;

    public abstract PrivateKey unwrapPrivateKey(byte[] var1) throws CipherException;

    public abstract SymmetricKey unwrapSymmetricKey(byte[] var1, AlgorithmIdentifier var2) throws CipherException;

    public void erase() {
        this.e = null;
        this.c();
    }

    public void finalize() {
        this.erase();
    }

    public abstract AlgorithmIdentifier getAlgID();

    public int getMode() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    public Padding.ID getPaddingID() {
        return null;
    }

    @Override
    public abstract int getBlockSize();

    RandomBitsSource b() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.f != null) {
            return this.f;
        }
        return RandomBitsSource.getDefault();
    }

    public byte[] getIV() {
        return null;
    }

    protected final void c() {
        this.a = null;
    }

    protected final void d() throws CipherException {
        if (this.a == oracle.security.crypto.core.Cipher$a.b) {
            return;
        }
        if (this.a == null) {
            this.a = oracle.security.crypto.core.Cipher$a.b;
            return;
        }
        throw new CipherException("A Cipher may not be used in decryption mode after it has been been used in another mode without being re-initialized");
    }

    protected final void e() throws CipherException {
        if (this.a == oracle.security.crypto.core.Cipher$a.a) {
            return;
        }
        if (this.a == null) {
            this.a = oracle.security.crypto.core.Cipher$a.a;
            return;
        }
        throw new CipherException("A Cipher may not be used in encryption mode after it has been been used in another mode without being re-initialized");
    }

    protected final void f() throws CipherException {
        if (this.a == oracle.security.crypto.core.Cipher$a.c) {
            return;
        }
        if (this.a == null) {
            this.a = oracle.security.crypto.core.Cipher$a.c;
            return;
        }
        throw new CipherException("A Cipher may not be used for key-wrap after it has been been used in another mode without being re-initialized");
    }

    protected final void g() throws CipherException {
        if (this.a == oracle.security.crypto.core.Cipher$a.d) {
            return;
        }
        if (this.a == null) {
            this.a = oracle.security.crypto.core.Cipher$a.d;
            return;
        }
        throw new CipherException("A Cipher may not be used for key-unwrap after it has been been used in another mode without being re-initialized");
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }

    private static final class a
    extends IntConstant {
        static final a a = new a(0, "ENCRYPTION");
        static final a b = new a(1, "DECRYPTION");
        static final a c = new a(2, "KEY_WRAP");
        static final a d = new a(3, "KEY_UNWRAP");

        private a(int n2, String string) {
            super(n2, string);
        }
    }
}

