/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import oracle.security.crypto.core.Coder;
import oracle.security.crypto.core.CoderException;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public class CoderInputStream
extends FilterInputStream {
    public static final int DECODE_MODE = 0;
    public static final int ENCODE_MODE = 1;
    protected int a = 0;
    protected Coder b;
    protected byte[] c;
    protected int d;

    public CoderInputStream(InputStream inputStream, Coder coder) {
        super(inputStream);
        this.b = coder;
        this.c = new byte[this.b.getBlockSize()];
        this.d = this.b.getBlockSize();
    }

    public Coder getCoder() {
        return this.b;
    }

    public int getMode() {
        return this.a;
    }

    public void setMode(int n2) {
        this.a = n2;
    }

    @Override
    public synchronized int read() throws IOException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.d < this.b.getBlockSize()) {
            return this.c[this.d++] & 0xFF;
        }
        byte[] byArray = new byte[this.b.getBlockSize()];
        int n2 = this.b.getBlockSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.in.read();
            if (n3 == -1) {
                return -1;
            }
            byArray[i2] = (byte)n3;
        }
        try {
            this.c = this.a == 1 ? this.b.encodeOp(byArray) : this.b.decodeOp(byArray);
            this.d = 0;
        }
        catch (CoderException coderException) {
            throw new IOException(coderException.toString());
        }
        return this.c[this.d++] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        for (n5 = 0; n5 < n3 && (n4 = this.read()) != -1; ++n5) {
            byArray[n2 + n5] = (byte)n4;
        }
        return n5 != 0 ? n5 : -1;
    }

    @Override
    public synchronized int available() throws IOException {
        int n2 = this.b.getBlockSize();
        return n2 - this.d + this.in.available() / n2 * n2;
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

