/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.DHKey;
import oracle.security.crypto.core.DHParams;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.KeyExportException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class DHPrivateKey
extends DHKey
implements javax.crypto.interfaces.DHPrivateKey,
PrivateKey {
    private static final ASN1ObjectID b = AlgID.dh.getOID();
    private BigInt c;
    private boolean d = true;
    private byte[] e;
    private ASN1Integer f;

    public DHPrivateKey() {
    }

    public DHPrivateKey(BigInteger bigInteger, DHParams dHParams) {
        this(BigInt.getInstance(bigInteger), dHParams);
    }

    DHPrivateKey(BigInt bigInt, DHParams dHParams) {
        super(dHParams);
        this.c = bigInt;
    }

    public DHPrivateKey(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public DHPrivateKey(File file) throws IOException {
        this(new FileInputStream(file));
    }

    @Override
    public byte[] getEncoded() {
        this.d();
        return (byte[])this.a().clone();
    }

    byte[] a() {
        FIPS_140_2.assertReadyState();
        if (this.e == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(new ASN1Integer(0L));
            aSN1Sequence.addElement(this.getAlgID());
            aSN1Sequence.addElement(new ASN1OctetString(Utils.toBytes(this.b())));
            this.e = Utils.toBytes(aSN1Sequence);
        }
        return this.e;
    }

    @Override
    public boolean getAllowExport() {
        return this.d;
    }

    public void setAllowExport(boolean bl2) {
        this.d = bl2;
    }

    private void d() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public void erase() {
        this.a = null;
        if (this.c != null) {
            this.c.erase();
            this.c = null;
        }
        this.e();
    }

    private void e() {
        if (this.e != null) {
            Utils.setArray(this.e, (byte)0);
            this.e = null;
        }
        if (this.f != null) {
            this.f.erase();
            this.f = null;
        }
    }

    @Override
    public Object clone() {
        FIPS_140_2.assertReadyState();
        DHPrivateKey dHPrivateKey = new DHPrivateKey();
        try {
            if (this.a != null) {
                dHPrivateKey.a = new DHParams(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing DH key parameters to stream");
        }
        if (this.c != null) {
            dHPrivateKey.c = BigInt.getInstance(this.c);
        }
        dHPrivateKey.d = this.d;
        return dHPrivateKey;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        FIPS_140_2.assertReadyState();
        this.erase();
        if (!b.equals(algorithmIdentifier.getOID())) {
            throw new AlgorithmIdentifierException("Wrong algorithm identifier for Diffier-Hellman key");
        }
        try {
            ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
            if (aSN1Object2 != null) {
                this.a = aSN1Object2 instanceof DHParams ? (DHParams)aSN1Object2 : new DHParams(Utils.toStream((ASN1Sequence)aSN1Object2));
            }
        }
        catch (IOException iOException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters");
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Invalid DH parameters");
        }
        try {
            this.c = ((ASN1Integer)aSN1Object).getBigIntValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException("Contents invalid");
        }
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return new AlgorithmIdentifier(b, this.a);
    }

    @Override
    public ASN1Object getContents() {
        this.d();
        FIPS_140_2.assertReadyState();
        return new ASN1Integer(this.c);
    }

    ASN1Object b() {
        FIPS_140_2.assertReadyState();
        if (this.f == null) {
            this.f = new ASN1Integer(this.c);
        }
        return this.f;
    }

    @Override
    public void setParams(DHParams dHParams) {
        FIPS_140_2.assertReadyState();
        if (dHParams.getP() == null || dHParams.getQ() == null || dHParams.getG() == null) {
            throw new IllegalArgumentException("Missing P, Q or G in DH key parameters");
        }
        this.a = dHParams;
        this.e();
    }

    @Override
    public BigInteger getX() {
        this.d();
        return new BigInteger(this.c().toByteArray());
    }

    BigInt c() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        return "params = {" + this.a + "}, bitLength = " + this.getBitLength() + "}";
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        try {
            ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
            ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
            this.initialize(algorithmIdentifier, aSN1Object);
            ((ASN1Integer)aSN1Object).erase();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidInputException(algorithmIdentifierException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        outputStream.write(this.getEncoded());
    }

    @Override
    public int length() {
        return this.a().length;
    }
}

