/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public final class MD2
extends MessageDigest {
    private a b = new a();
    private byte[] c = new byte[16];
    private boolean d = false;
    private static final byte[] e = new byte[16];
    private static final int[] f = new int[]{41, 46, 67, 201, 162, 216, 124, 1, 61, 54, 84, 161, 236, 240, 6, 19, 98, 167, 5, 243, 192, 199, 115, 140, 152, 147, 43, 217, 188, 76, 130, 202, 30, 155, 87, 60, 253, 212, 224, 22, 103, 66, 111, 24, 138, 23, 229, 18, 190, 78, 196, 214, 218, 158, 222, 73, 160, 251, 245, 142, 187, 47, 238, 122, 169, 104, 121, 145, 21, 178, 7, 63, 148, 194, 16, 137, 11, 34, 95, 33, 128, 127, 93, 154, 90, 144, 50, 39, 53, 62, 204, 231, 191, 247, 151, 3, 255, 25, 48, 179, 72, 165, 181, 209, 215, 94, 146, 42, 172, 86, 170, 198, 79, 184, 56, 210, 150, 164, 125, 182, 118, 252, 107, 226, 156, 116, 4, 241, 69, 157, 112, 89, 100, 113, 135, 32, 134, 91, 207, 101, 230, 45, 168, 2, 27, 96, 37, 173, 174, 176, 185, 246, 28, 70, 97, 105, 52, 64, 126, 15, 85, 71, 163, 35, 221, 81, 175, 58, 195, 92, 249, 206, 186, 197, 234, 38, 44, 83, 13, 110, 133, 40, 132, 9, 211, 223, 205, 244, 65, 129, 77, 82, 106, 220, 55, 200, 108, 193, 171, 250, 36, 225, 123, 8, 12, 189, 177, 74, 120, 136, 149, 139, 227, 99, 232, 109, 233, 203, 213, 254, 59, 0, 29, 57, 242, 239, 183, 14, 102, 88, 208, 228, 166, 119, 114, 248, 235, 117, 75, 10, 49, 68, 80, 180, 143, 237, 31, 26, 219, 153, 141, 51, 159, 17, 131, 20};

    @Override
    public void init() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.b != null) {
            this.b.init();
        }
        this.d = false;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return AlgID.md2;
    }

    @Override
    public int blockSize() {
        return 64;
    }

    @Override
    public int getDigestLength() {
        return 16;
    }

    @Override
    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    @Override
    byte[] a() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    @Override
    public boolean isValid() {
        return this.d;
    }

    @Override
    public void update(byte by2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        int n2 = this.b.d;
        this.b.d = n2 + 1 & 0xF;
        this.b.c[n2] = by2;
        if (this.b.d == 0) {
            this.d();
        }
        this.d = false;
    }

    @Override
    public void computeCurrent() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        a a2 = (a)this.b.clone();
        int n2 = 16 - this.b.d;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.update((byte)n2);
        }
        byte[] byArray = new byte[16];
        System.arraycopy(this.b.b, 0, byArray, 0, 16);
        this.update(byArray);
        System.arraycopy(this.b.a, 0, this.c, 0, 16);
        this.b = a2;
        this.d = true;
    }

    @Override
    public String algName() {
        return "MD2";
    }

    private void d() {
        int n2;
        int n3;
        byte[] byArray = new byte[48];
        System.arraycopy(this.b.a, 0, byArray, 0, 16);
        System.arraycopy(this.b.c, 0, byArray, 16, 16);
        for (n3 = 0; n3 < 16; ++n3) {
            byArray[n3 + 32] = (byte)(this.b.a[n3] ^ this.b.c[n3]);
        }
        n3 = 0;
        for (n2 = 0; n2 < 18; ++n2) {
            for (int i2 = 0; i2 < 48; ++i2) {
                int n4 = i2;
                byArray[n4] = (byte)(byArray[n4] ^ f[n3]);
                n3 = byArray[i2] & 0xFF;
            }
            n3 = n3 + n2 & 0xFF;
        }
        System.arraycopy(byArray, 0, this.b.a, 0, 16);
        n3 = this.b.b[15] & 0xFF;
        for (n2 = 0; n2 < 16; ++n2) {
            int n5 = n2;
            this.b.b[n5] = (byte)(this.b.b[n5] ^ f[this.b.c[n2] & 0xFF ^ n3]);
            n3 = this.b.b[n2] & 0xFF;
        }
    }

    @Override
    public Object clone() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        MD2 mD2 = new MD2();
        mD2.b = (a)this.b.clone();
        System.arraycopy(this.c, 0, mD2.c, 0, this.c.length);
        mD2.d = this.d;
        return mD2;
    }

    @Override
    protected MessageDigest.MDState b() {
        return this.b;
    }

    @Override
    protected void a(MessageDigest.MDState mDState) {
        mDState.copyTo(this.b);
        this.d = false;
    }

    final class a
    extends MessageDigest.MDState {
        byte[] a;
        byte[] b;
        byte[] c;
        int d;

        a() {
            super(MD2.this);
            this.a = new byte[16];
            this.b = new byte[16];
            this.c = new byte[16];
        }

        @Override
        public void init() {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            System.arraycopy(e, 0, this.a, 0, this.a.length);
            System.arraycopy(e, 0, this.b, 0, this.b.length);
            System.arraycopy(e, 0, this.c, 0, this.c.length);
            this.d = 0;
        }

        @Override
        public Object clone() {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            a a2 = new a();
            this.copyTo(a2);
            return a2;
        }

        @Override
        public void copyTo(MessageDigest.MDState mDState) {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD2State required");
            }
            a a2 = (a)mDState;
            a2.d = this.d;
            System.arraycopy(this.a, 0, a2.a, 0, 16);
            System.arraycopy(this.b, 0, a2.b, 0, 16);
            System.arraycopy(this.c, 0, a2.c, 0, 16);
        }
    }
}

