/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public final class MD4
extends MessageDigest {
    private a b = new a();
    private a c = new a();
    private byte[] d = new byte[16];
    private boolean e = false;

    @Override
    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(new ASN1ObjectID(new int[]{1, 2, 840, 113549, 2, 4}));
    }

    @Override
    public int blockSize() {
        return 64;
    }

    @Override
    public void init() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.b != null) {
            this.b.init();
        }
        this.e = false;
    }

    @Override
    public void update(byte by2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        byte[] byArray = this.b.a;
        int[] nArray = this.b.b;
        if (this.b.e == 64) {
            this.a(byArray, nArray);
            this.d();
            this.b.e = 0;
        }
        byArray[this.b.e++] = by2;
        this.b.d += 8L;
        this.e = false;
    }

    @Override
    public void update(byte[] byArray, int n2, int n3) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.e = false;
        byte[] byArray2 = this.b.a;
        int[] nArray = this.b.b;
        this.b.d += (long)(n3 << 3);
        while (n3 > 0) {
            int n4 = 64 - this.b.e;
            if (n3 < n4) {
                System.arraycopy(byArray, n2, byArray2, this.b.e, n3);
                this.b.e += n3;
                n3 = 0;
                continue;
            }
            System.arraycopy(byArray, n2, byArray2, this.b.e, n4);
            n3 -= n4;
            n2 += n4;
            this.a(byArray2, nArray);
            this.d();
            this.b.e = 0;
        }
    }

    @Override
    public void computeCurrent() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.b.copyTo(this.c);
        byte[] byArray = this.b.a;
        int[] nArray = this.b.b;
        this.c();
        this.update((byte)this.c.d);
        this.update((byte)(this.c.d >> 8));
        this.update((byte)(this.c.d >> 16));
        this.update((byte)(this.c.d >> 24));
        this.update((byte)(this.c.d >> 32));
        this.update((byte)(this.c.d >> 40));
        this.update((byte)(this.c.d >> 48));
        this.update((byte)(this.c.d >> 56));
        this.a(byArray, nArray);
        this.d();
        this.a(this.b.c, this.d);
        this.e = true;
        a a2 = this.b;
        this.b = this.c;
        this.c = a2;
    }

    @Override
    public String algName() {
        return "MD4";
    }

    @Override
    public int getDigestLength() {
        return 16;
    }

    @Override
    public byte[] getDigestBits() {
        return (byte[])this.a().clone();
    }

    @Override
    byte[] a() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.d;
    }

    @Override
    public boolean isValid() {
        return this.e;
    }

    @Override
    public Object clone() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        MD4 mD4 = new MD4();
        this.b.copyTo(mD4.b);
        System.arraycopy(this.d, 0, mD4.d, 0, this.d.length);
        mD4.e = this.e;
        return mD4;
    }

    private int a(byte by2, byte by3, byte by4, byte by5) {
        return by2 & 0xFF | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 16 | (by5 & 0xFF) << 24;
    }

    private void a(byte[] byArray, int[] nArray) {
        int n2 = nArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = byArray[n3++] & 0xFF | (byArray[n3++] & 0xFF) << 8 | (byArray[n3++] & 0xFF) << 16 | (byArray[n3++] & 0xFF) << 24;
        }
    }

    private void a(int[] nArray, byte[] byArray) {
        int n2 = nArray.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[n3++] = (byte)nArray[i2];
            byArray[n3++] = (byte)(nArray[i2] >> 8);
            byArray[n3++] = (byte)(nArray[i2] >> 16);
            byArray[n3++] = (byte)(nArray[i2] >> 24);
        }
    }

    private static int a(int n2, int n3) {
        return n2 << n3 | n2 >>> 32 - n3;
    }

    private static int a(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        return MD4.a(n2 + (n3 & n4 | ~n3 & n5) + nArray[n6], n7);
    }

    private static int b(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        return MD4.a(n2 + (n3 & n4 | n3 & n5 | n4 & n5) + nArray[n6] + 1518500249, n7);
    }

    private static int c(int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        return MD4.a(n2 + (n3 ^ n4 ^ n5) + nArray[n6] + 1859775393, n7);
    }

    private void c() {
        this.update((byte)-128);
        if (this.b.e > 56) {
            this.update(new byte[64 - this.b.e + 56]);
        } else if (this.b.e < 56) {
            this.update(new byte[56 - this.b.e]);
        }
    }

    private void d() {
        int n2 = this.b.c[0];
        int n3 = this.b.c[1];
        int n4 = this.b.c[2];
        int n5 = this.b.c[3];
        int[] nArray = this.b.b;
        n2 = MD4.a(n2, n3, n4, n5, nArray, 0, 3);
        n5 = MD4.a(n5, n2, n3, n4, nArray, 1, 7);
        n4 = MD4.a(n4, n5, n2, n3, nArray, 2, 11);
        n3 = MD4.a(n3, n4, n5, n2, nArray, 3, 19);
        n2 = MD4.a(n2, n3, n4, n5, nArray, 4, 3);
        n5 = MD4.a(n5, n2, n3, n4, nArray, 5, 7);
        n4 = MD4.a(n4, n5, n2, n3, nArray, 6, 11);
        n3 = MD4.a(n3, n4, n5, n2, nArray, 7, 19);
        n2 = MD4.a(n2, n3, n4, n5, nArray, 8, 3);
        n5 = MD4.a(n5, n2, n3, n4, nArray, 9, 7);
        n4 = MD4.a(n4, n5, n2, n3, nArray, 10, 11);
        n3 = MD4.a(n3, n4, n5, n2, nArray, 11, 19);
        n2 = MD4.a(n2, n3, n4, n5, nArray, 12, 3);
        n5 = MD4.a(n5, n2, n3, n4, nArray, 13, 7);
        n4 = MD4.a(n4, n5, n2, n3, nArray, 14, 11);
        n3 = MD4.a(n3, n4, n5, n2, nArray, 15, 19);
        n2 = MD4.b(n2, n3, n4, n5, nArray, 0, 3);
        n5 = MD4.b(n5, n2, n3, n4, nArray, 4, 5);
        n4 = MD4.b(n4, n5, n2, n3, nArray, 8, 9);
        n3 = MD4.b(n3, n4, n5, n2, nArray, 12, 13);
        n2 = MD4.b(n2, n3, n4, n5, nArray, 1, 3);
        n5 = MD4.b(n5, n2, n3, n4, nArray, 5, 5);
        n4 = MD4.b(n4, n5, n2, n3, nArray, 9, 9);
        n3 = MD4.b(n3, n4, n5, n2, nArray, 13, 13);
        n2 = MD4.b(n2, n3, n4, n5, nArray, 2, 3);
        n5 = MD4.b(n5, n2, n3, n4, nArray, 6, 5);
        n4 = MD4.b(n4, n5, n2, n3, nArray, 10, 9);
        n3 = MD4.b(n3, n4, n5, n2, nArray, 14, 13);
        n2 = MD4.b(n2, n3, n4, n5, nArray, 3, 3);
        n5 = MD4.b(n5, n2, n3, n4, nArray, 7, 5);
        n4 = MD4.b(n4, n5, n2, n3, nArray, 11, 9);
        n3 = MD4.b(n3, n4, n5, n2, nArray, 15, 13);
        n2 = MD4.c(n2, n3, n4, n5, nArray, 0, 3);
        n5 = MD4.c(n5, n2, n3, n4, nArray, 8, 9);
        n4 = MD4.c(n4, n5, n2, n3, nArray, 4, 11);
        n3 = MD4.c(n3, n4, n5, n2, nArray, 12, 15);
        n2 = MD4.c(n2, n3, n4, n5, nArray, 2, 3);
        n5 = MD4.c(n5, n2, n3, n4, nArray, 10, 9);
        n4 = MD4.c(n4, n5, n2, n3, nArray, 6, 11);
        n3 = MD4.c(n3, n4, n5, n2, nArray, 14, 15);
        n2 = MD4.c(n2, n3, n4, n5, nArray, 1, 3);
        n5 = MD4.c(n5, n2, n3, n4, nArray, 9, 9);
        n4 = MD4.c(n4, n5, n2, n3, nArray, 5, 11);
        n3 = MD4.c(n3, n4, n5, n2, nArray, 13, 15);
        n2 = MD4.c(n2, n3, n4, n5, nArray, 3, 3);
        n5 = MD4.c(n5, n2, n3, n4, nArray, 11, 9);
        n4 = MD4.c(n4, n5, n2, n3, nArray, 7, 11);
        n3 = MD4.c(n3, n4, n5, n2, nArray, 15, 15);
        this.b.c[0] = this.b.c[0] + n2;
        this.b.c[1] = this.b.c[1] + n3;
        this.b.c[2] = this.b.c[2] + n4;
        this.b.c[3] = this.b.c[3] + n5;
    }

    @Override
    protected MessageDigest.MDState b() {
        return this.b;
    }

    @Override
    protected void a(MessageDigest.MDState mDState) {
        mDState.copyTo(this.b);
        this.e = false;
    }

    final class a
    extends MessageDigest.MDState {
        byte[] a;
        int[] b;
        int[] c;
        long d;
        int e;

        a() {
            super(MD4.this);
            this.a = new byte[64];
            this.b = new int[16];
            this.c = new int[4];
            this.init();
        }

        @Override
        public void init() {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            this.c[0] = 1732584193;
            this.c[1] = -271733879;
            this.c[2] = -1732584194;
            this.c[3] = 271733878;
            this.e = 0;
            this.d = 0;
        }

        @Override
        public Object clone() {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            a a2 = new a();
            this.copyTo(a2);
            return a2;
        }

        @Override
        public void copyTo(MessageDigest.MDState mDState) {
            TransitionMode.checkCryptoCoreUseAllowed();
            FIPS_140_2.assertReadyState();
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD4State required");
            }
            a a2 = (a)mDState;
            a2.d = this.d;
            a2.e = this.e;
            System.arraycopy(this.a, 0, a2.a, 0, 64);
            System.arraycopy(this.c, 0, a2.c, 0, 4);
        }
    }
}

