/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.BlockCipher;
import oracle.security.crypto.core.CBCAlgorithmIdentifier;
import oracle.security.crypto.core.Cipher;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.InvalidKeyException;
import oracle.security.crypto.core.MAC;
import oracle.security.crypto.core.MessageDigest;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.Padding;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.RC2AlgorithmIdentifier;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.c;
import oracle.security.crypto.core.math.BigInt;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public final class PKCS12PBE
extends PBE {
    public static final int SHA_128RC4 = 1;
    public static final int SHA_40RC4 = 2;
    public static final int SHA_3_3DES_CBC = 3;
    public static final int SHA_2_3DES_CBC = 4;
    public static final int SHA_128RC2_CBC = 5;
    public static final int SHA_40RC2_CBC = 6;
    private int d;
    private int e = 1;
    private static final long f = 0x100000001L;

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.a = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.a = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
        }
        ASN1ObjectID aSN1ObjectID = this.a.getOID();
        this.b = AlgID.sha_1;
        if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC4)) {
            this.c = AlgID.RC4;
            this.d = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC4)) {
            this.c = AlgID.RC4;
            this.d = 5;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            this.c = AlgID.DES_EDE3_CBC;
            this.d = 24;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            this.c = AlgID.DES_EDE3_CBC;
            this.d = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd128BitRC2_CBC)) {
            this.c = AlgID.RC2_CBC;
            this.d = 16;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.pbeWithSHAAnd40BitRC2_CBC)) {
            this.c = AlgID.RC2_CBC;
            this.d = 5;
        } else if (aSN1ObjectID.equals(PBEAlgorithmIdentifier.id_PBES2)) {
            this.c = this.a.getEncryptionScheme();
            this.d = this.a.getKeyLength();
            this.b = this.a.getPseudorandomFunc();
            this.e = 2;
        } else {
            throw new AlgorithmIdentifierException("Unknown algorithm identifier: " + algorithmIdentifier);
        }
    }

    @Override
    public void initialize(int n2, byte[] byArray, int n3) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n2), byArray, n3));
    }

    @Override
    public void initialize(int n2) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs12PBEids, n2)));
    }

    @Override
    public byte[] encrypt(String string, byte[] byArray) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.e == 1) {
            return this.a(string, byArray, true);
        }
        return this.a(string, byArray);
    }

    private byte[] a(String string, byte[] byArray) throws CipherException {
        byte[] byArray2;
        try {
            byArray2 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = string.getBytes();
        }
        byte[] byArray3 = this.a(byArray2, byArray, true);
        Utils.setArray(byArray2, (byte)0);
        return byArray3;
    }

    @Override
    public byte[] decrypt(String string, byte[] byArray) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (this.e == 1) {
            return this.a(string, byArray, false);
        }
        return this.b(string, byArray);
    }

    private byte[] b(String string, byte[] byArray) throws CipherException {
        byte[] byArray2;
        byte[] byArray3;
        boolean bl2 = false;
        try {
            byArray3 = string.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = string.getBytes();
            bl2 = true;
        }
        try {
            byArray2 = this.a(byArray3, byArray, false);
        }
        catch (Exception exception) {
            if (!bl2) {
                Utils.setArray(byArray3, (byte)0);
                byArray3 = string.getBytes();
                byArray2 = this.a(byArray3, byArray, false);
            }
            if (exception instanceof CipherException) {
                throw (CipherException)exception;
            }
            throw new CipherException(exception.toString());
        }
        Utils.setArray(byArray3, (byte)0);
        return byArray2;
    }

    @Override
    public byte[] encryptPrivateKey(String string, PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot encrypt encrypted key");
        }
        return this.encrypt(string, oracle.security.crypto.core.c.a(privateKey));
    }

    @Override
    public PrivateKey decryptPrivateKey(String string, byte[] byArray) throws CipherException, IOException {
        byte[] byArray2 = this.decrypt(string, byArray);
        PrivateKey privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    @Override
    public byte[] encryptSymmetricKey(String string, SymmetricKey symmetricKey) throws CipherException {
        return this.encrypt(string, symmetricKey.e());
    }

    @Override
    public SymmetricKey decryptSymmetricKey(String string, byte[] byArray) throws CipherException {
        byte[] byArray2 = this.decrypt(string, byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(String string, byte[] byArray, boolean bl2) throws CipherException {
        try {
            byte[] byArray2;
            SymmetricKey symmetricKey = this.a(string);
            Cipher cipher = null;
            try {
                if (!this.c.getOID().equals(AlgID.RC4.getOID())) {
                    cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey, Padding.PKCS5);
                    byArray2 = bl2 ? ((BlockCipher)cipher).encrypt(byArray, 0, byArray.length, true) : ((BlockCipher)cipher).decrypt(byArray, 0, byArray.length, true);
                } else {
                    cipher = Cipher.getInstance(symmetricKey.getAlgID(), symmetricKey);
                    byArray2 = bl2 ? cipher.encrypt(byArray) : cipher.decrypt(byArray);
                }
            }
            finally {
                if (cipher != null) {
                    cipher.erase();
                }
                if (symmetricKey != null) {
                    symmetricKey.erase();
                }
            }
            return byArray2;
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2, boolean bl2) throws CipherException {
        byte[] byArray3;
        SymmetricKey symmetricKey = this.a(byArray);
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance(this.c, symmetricKey, Padding.PKCS5);
            byArray3 = bl2 ? ((BlockCipher)cipher).encrypt(byArray2, 0, byArray2.length, true) : ((BlockCipher)cipher).decrypt(byArray2, 0, byArray2.length, true);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        finally {
            if (cipher != null) {
                cipher.erase();
            }
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        return byArray3;
    }

    private static byte[] a(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, int n2, int n3) throws InvalidKeyException {
        MAC mAC;
        SymmetricKey symmetricKey = new SymmetricKey(byArray);
        try {
            mAC = MAC.getInstance(algorithmIdentifier, symmetricKey);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidKeyException(algorithmIdentifierException.toString());
        }
        finally {
            if (symmetricKey != null) {
                symmetricKey.erase();
            }
        }
        int n4 = mAC.getDigestLength();
        if (((long)n3 & 0xFFFFL) > 0x100000001L * (long)n4) {
            throw new InvalidKeyException("Derived key too long");
        }
        int n5 = (n3 + n4 - 1) / n4;
        byte[] byArray3 = new byte[n3];
        for (int i2 = 1; i2 <= n5; ++i2) {
            PKCS12PBE.a(mAC, byArray2, n2, i2, byArray3, (i2 - 1) * n4);
        }
        return byArray3;
    }

    private static void a(MAC mAC, byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        byte[] byArray3 = new byte[mAC.getDigestLength()];
        mAC.init();
        mAC.update(byArray);
        mAC.update(Utils.wordToBytes(n3));
        mAC.computeCurrent();
        byte[] byArray4 = mAC.getDigestBits();
        System.arraycopy(byArray4, 0, byArray3, 0, byArray4.length);
        for (int i2 = 2; i2 <= n2; ++i2) {
            mAC.init();
            mAC.update(byArray4);
            mAC.computeCurrent();
            byArray4 = mAC.getDigestBits();
            PKCS12PBE.a(byArray3, 0, byArray4, 0, byArray4.length);
        }
        System.arraycopy(byArray3, 0, byArray2, n4, Math.min(byArray3.length, byArray2.length - n4));
    }

    private static void a(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        byte[] byArray3 = new byte[n4];
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray, n2, byArray3, 0, n4);
        System.arraycopy(byArray2, n3, byArray4, 0, n4);
        byte[] byArray5 = new byte[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray5[i2] = (byte)(byArray3[i2] ^ byArray4[i2]);
        }
        System.arraycopy(byArray5, 0, byArray, n2, n4);
    }

    private SymmetricKey a(byte[] byArray) throws CipherException {
        try {
            byte[] byArray2 = PKCS12PBE.a(this.b, byArray, this.a.getSalt(), this.a.getIterationCount(), this.a.getKeyLength());
            SymmetricKey symmetricKey = new SymmetricKey(byArray2, this.c);
            Utils.setArray(byArray2, (byte)0);
            return symmetricKey;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private SymmetricKey a(String string) throws CipherException {
        SymmetricKey symmetricKey;
        byte[] byArray = PKCS12PBE.a(this.b, string, this.a.getSalt(), this.a.getIterationCount(), (byte)1, this.d);
        if (this.c.getOID().equals(AlgID.RC4.getOID())) {
            symmetricKey = new SymmetricKey(byArray, AlgID.RC4);
        } else {
            byte[] byArray2 = PKCS12PBE.a(this.b, string, this.a.getSalt(), this.a.getIterationCount(), (byte)2, 8);
            if (this.c.getOID().equals(AlgID.RC2_CBC.getOID())) {
                symmetricKey = new SymmetricKey(byArray, new RC2AlgorithmIdentifier(byArray2, this.d * 8));
            }
            if (this.a.getOID().equals(PBEAlgorithmIdentifier.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
                byte[] byArray3 = new byte[24];
                System.arraycopy(byArray, 0, byArray3, 0, 16);
                System.arraycopy(byArray, 0, byArray3, 16, 8);
                Utils.setArray(byArray, (byte)0);
                byArray = byArray3;
            }
            symmetricKey = new SymmetricKey(byArray, new CBCAlgorithmIdentifier(this.c.getOID(), byArray2));
        }
        Utils.setArray(byArray, (byte)0);
        return symmetricKey;
    }

    public static byte[] createPKCS12MacKey(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n2, int n3) throws CipherException {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return PKCS12PBE.a(algorithmIdentifier, string, byArray, n2, (byte)3, n3);
    }

    private static byte[] a(AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n2, byte by2, int n3) throws CipherException {
        int n4;
        MessageDigest messageDigest;
        if (string == null) {
            throw new CipherException("Password not set");
        }
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        int n5 = messageDigest.getDigestLength();
        int n6 = messageDigest.blockSize();
        byte[] byArray2 = new byte[n6];
        Utils.setArray(byArray2, by2);
        byte[] byArray3 = Utils.unicodeToBytes(string);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n7 = byArray.length == 0 ? 0 : ((byArray.length - 1) / n6 + 1) * n6;
        int n8 = byArray4.length == 0 ? 0 : ((byArray4.length - 1) / n6 + 1) * n6;
        byte[] byArray5 = new byte[n7 + n8];
        for (n4 = 0; n4 < n7; n4 += byArray.length) {
            System.arraycopy(byArray, 0, byArray5, n4, Math.min(n7 - n4, byArray.length));
        }
        int n9 = byArray5.length;
        for (n4 = n7; n4 < n9; n4 += byArray4.length) {
            System.arraycopy(byArray4, 0, byArray5, n4, Math.min(byArray5.length - n4, byArray4.length));
        }
        Utils.setArray(byArray4, (byte)0);
        Utils.setArray(byArray3, (byte)0);
        byte[] byArray6 = new byte[n3];
        for (n9 = 0; n9 < n3; n9 += n5) {
            messageDigest.init();
            messageDigest.update(byArray2);
            messageDigest.update(byArray5);
            messageDigest.computeCurrent();
            int n10 = n2 - 1;
            for (int i2 = 0; i2 < n10; ++i2) {
                messageDigest.init();
                messageDigest.update(messageDigest.a());
                messageDigest.computeCurrent();
            }
            byte[] byArray7 = new byte[n6];
            for (n10 = 0; n10 < n6; n10 += n5) {
                System.arraycopy(messageDigest.a(), 0, byArray7, n10, Math.min(n6 - n10, n5));
            }
            BigInt bigInt = new BigInt(1, byArray7).add(BigInt.ONE);
            BigInt bigInt2 = BigInt.ONE.shiftLeft(n6 * 8).subtract(BigInt.ONE);
            int n11 = byArray5.length;
            for (int i3 = 0; i3 < n11; i3 += n6) {
                byte[] byArray8 = new byte[n6];
                System.arraycopy(byArray5, i3, byArray8, 0, n6);
                BigInt bigInt3 = new BigInt(1, byArray8).add(bigInt).and(bigInt2);
                Utils.toByteArray(bigInt3, byArray5, i3, n6);
            }
            System.arraycopy(messageDigest.a(), 0, byArray6, n9, Math.min(n3 - n9, n5));
        }
        Utils.setArray(messageDigest.a(), (byte)0);
        return byArray6;
    }
}

