/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PKCS5;
import oracle.security.crypto.core.PKCS5PBE;
import oracle.security.crypto.core.RandomBitsSource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;

public class PasswordProtectedObject
implements Serializable {
    private static final long e = -3191102283599261115L;
    protected PKCS5PBE a;
    protected PKCS5 b;
    protected byte[] c;
    protected transient Serializable d;
    private transient String f;

    public PasswordProtectedObject() {
    }

    public PasswordProtectedObject(PKCS5PBE pKCS5PBE) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.a = pKCS5PBE;
    }

    public PasswordProtectedObject(int n2, RandomBitsSource randomBitsSource) {
        this(new PKCS5PBE());
        try {
            this.a.initialize(n2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
    }

    public PasswordProtectedObject(int n2) {
        this(new PKCS5PBE());
        try {
            this.a.initialize(n2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalStateException(algorithmIdentifierException.toString());
        }
    }

    public PasswordProtectedObject(Serializable serializable, PKCS5PBE pKCS5PBE) {
        this(pKCS5PBE);
        this.d = serializable;
    }

    public PasswordProtectedObject(Serializable serializable, int n2, RandomBitsSource randomBitsSource) {
        this(n2, randomBitsSource);
        this.d = serializable;
    }

    public PasswordProtectedObject(Serializable serializable, int n2) {
        this(serializable, n2, RandomBitsSource.getDefault());
    }

    public PasswordProtectedObject(Serializable serializable, RandomBitsSource randomBitsSource) {
        this(serializable, 10, randomBitsSource);
    }

    public PasswordProtectedObject(Serializable serializable) {
        this(serializable, 10, RandomBitsSource.getDefault());
    }

    public void setPKCS5PBE(PKCS5PBE pKCS5PBE) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.a = pKCS5PBE;
    }

    public PKCS5PBE getPKCS5PBE() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setPassword(String string) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.f = string;
    }

    public void setObject(Serializable serializable) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        this.d = serializable;
    }

    public void encrypt() throws IOException {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(unsyncByteArrayOutputStream);
        objectOutputStream.writeObject(this.d);
        objectOutputStream.close();
        try {
            this.c = this.a.encrypt(this.f, unsyncByteArrayOutputStream.toByteArray());
        }
        catch (CipherException cipherException) {
            throw new IOException(cipherException.toString());
        }
        this.d = null;
    }

    public Object decrypt() throws CipherException, IOException, ClassNotFoundException {
        byte[] byArray = this.a.decrypt(this.f, this.c);
        ObjectInputStream objectInputStream = new ObjectInputStream(new UnsyncByteArrayInputStream(byArray));
        return objectInputStream.readObject();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

