/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import oracle.security.crypto.core.EntropySource;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.provider.TransitionMode;

public class SpinnerEntropySource
extends EntropySource
implements Runnable {
    private int a;
    private boolean b;
    private int c;
    private static final int d = 65;

    public SpinnerEntropySource() {
        this(65);
    }

    public SpinnerEntropySource(int n2) {
        this.setSleepTime(n2);
    }

    public synchronized void setSleepTime(int n2) {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        if (n2 < 1) {
            throw new IllegalArgumentException("sleepTime=" + n2);
        }
        this.c = n2;
    }

    public int getSleepTime() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    @Override
    public synchronized byte generateByte() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return (byte)(this.a() % 256);
    }

    private synchronized int a() {
        Thread thread = new Thread(this);
        this.b = false;
        this.a = 0;
        thread.start();
        try {
            Thread.sleep(this.c);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.b = true;
        do {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (thread.isAlive());
        return this.a;
    }

    @Override
    public void run() {
        while (!this.b) {
            ++this.a;
            Thread.yield();
        }
    }

    @Override
    public void clear() {
    }

    public String toString() {
        TransitionMode.checkCryptoCoreUseAllowed();
        FIPS_140_2.assertReadyState();
        return "{ sleepTime = " + this.c + " }";
    }
}

