/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AlgorithmIdentifierException;
import oracle.security.crypto.core.CipherException;
import oracle.security.crypto.core.PBE;
import oracle.security.crypto.core.PBEAlgorithmIdentifier;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.PrivateKeyPKCS8;
import oracle.security.crypto.core.SymmetricKey;
import oracle.security.crypto.core.c;
import oracle.security.crypto.provider.JCEUtil;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

final class b
extends PBE {
    private boolean d;
    private int e;
    private SecretKeyFactory f;
    private AlgorithmParameterSpec g;
    private Cipher h;

    b() {
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier instanceof PBEAlgorithmIdentifier) {
            this.a = (PBEAlgorithmIdentifier)algorithmIdentifier;
        } else {
            try {
                this.a = new PBEAlgorithmIdentifier(Utils.toStream(algorithmIdentifier));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException);
            }
        }
        try {
            if (this.a.getOID().equals(PBEAlgorithmIdentifier.id_PBES2)) {
                this.d = true;
                this.b();
            } else {
                this.d = false;
                this.a();
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AlgorithmIdentifierException(generalSecurityException);
        }
    }

    @Override
    public void initialize(int n2, byte[] byArray, int n3) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs5, n2), byArray, n3));
    }

    @Override
    public void initialize(int n2) throws AlgorithmIdentifierException {
        this.initialize(new PBEAlgorithmIdentifier(new ASN1ObjectID(PBEAlgorithmIdentifier.pkcs5, n2)));
    }

    @Override
    public byte[] encryptPrivateKey(String string, PrivateKey privateKey) throws CipherException {
        if (privateKey instanceof PrivateKeyPKCS8) {
            throw new CipherException("Cannot encrypt encrypted key");
        }
        return this.encrypt(string, oracle.security.crypto.core.c.a(privateKey));
    }

    @Override
    public PrivateKey decryptPrivateKey(String string, byte[] byArray) throws CipherException, IOException {
        byte[] byArray2 = this.decrypt(string, byArray);
        PrivateKey privateKey = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray2));
        Utils.setArray(byArray2, (byte)0);
        return privateKey;
    }

    @Override
    public byte[] encryptSymmetricKey(String string, SymmetricKey symmetricKey) throws CipherException {
        return this.encrypt(string, symmetricKey.e());
    }

    @Override
    public SymmetricKey decryptSymmetricKey(String string, byte[] byArray) throws CipherException {
        byte[] byArray2 = this.decrypt(string, byArray);
        SymmetricKey symmetricKey = new SymmetricKey(byArray2);
        Utils.setArray(byArray2, (byte)0);
        return symmetricKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encrypt(String string, byte[] byArray) throws CipherException {
        char[] cArray = string.toCharArray();
        try {
            byte[] byArray2 = this.a(1, cArray, byArray);
            return byArray2;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] decrypt(String string, byte[] byArray) throws CipherException {
        char[] cArray = string.toCharArray();
        try {
            byte[] byArray2 = this.a(2, cArray, byArray);
            return byArray2;
        }
        finally {
            Arrays.fill(cArray, '\u0000');
        }
    }

    private void a() throws GeneralSecurityException {
        String string = this.a.getOID().toStringCompact();
        this.f = JCEUtil.getSecretKeyFactoryInstance(string);
        this.g = new PBEParameterSpec(this.a.getSalt(), this.a.getIterationCount());
        this.h = JCEUtil.getCipherInstance(string);
    }

    private void b() throws GeneralSecurityException, AlgorithmIdentifierException {
        String string;
        AlgorithmIdentifier algorithmIdentifier = this.a.getPseudorandomFunc();
        AlgorithmIdentifier algorithmIdentifier2 = this.a.getEncryptionScheme();
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier2.getOID();
        boolean bl2 = JCEUtil.isJsafeJCERegistered();
        if (algorithmIdentifier.equals(AlgID.hmacWithSHA1)) {
            string = "PBKDF2WithHmacSHA1";
        } else if (algorithmIdentifier.equals(AlgID.hmacWithSHA224)) {
            string = bl2 ? "PBKDF2WithSHA224" : "PBKDF2WithHmacSHA224";
        } else if (algorithmIdentifier.equals(AlgID.hmacWithSHA256)) {
            string = bl2 ? "PBKDF2WithSHA256" : "PBKDF2WithHmacSHA256";
        } else if (algorithmIdentifier.equals(AlgID.hmacWithSHA384)) {
            string = bl2 ? "PBKDF2WithSHA384" : "PBKDF2WithHmacSHA384";
        } else if (algorithmIdentifier.equals(AlgID.hmacWithSHA512)) {
            string = bl2 ? "PBKDF2WithSHA512" : "PBKDF2WithHmacSHA512";
        } else {
            throw new AlgorithmIdentifierException("PBES2 KDF not supported: " + algorithmIdentifier);
        }
        if (aSN1ObjectID.equals(AlgID.aes128_CBC.getOID())) {
            this.e = 128;
        } else if (aSN1ObjectID.equals(AlgID.aes192_CBC.getOID())) {
            this.e = 192;
        } else if (aSN1ObjectID.equals(AlgID.aes256_CBC.getOID())) {
            this.e = 256;
        } else {
            throw new AlgorithmIdentifierException("PBES2 Encryption Scheme not supported: " + algorithmIdentifier2);
        }
        this.f = JCEUtil.getSecretKeyFactoryInstance(string);
        try {
            this.g = new IvParameterSpec(CryptoUtils.getIV(algorithmIdentifier2));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new AlgorithmIdentifierException("Invalid ES parameters", algorithmIdentifierException);
        }
        this.h = JCEUtil.getCipherInstance("AES/CBC/PKCS5Padding");
    }

    private byte[] a(int n2, char[] cArray, byte[] byArray) throws CipherException {
        try {
            this.a(n2, cArray);
            return this.h.doFinal(byArray);
        }
        catch (BadPaddingException badPaddingException) {
            throw new CipherException("Invalid padding string (or incorrect password)", badPaddingException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CipherException("JCE PBE failure", generalSecurityException);
        }
    }

    private void a(int n2, char[] cArray) throws GeneralSecurityException {
        if (this.d) {
            this.c(n2, cArray);
        } else {
            this.b(n2, cArray);
        }
    }

    private void b(int n2, char[] cArray) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKey secretKey = this.f.generateSecret(pBEKeySpec);
        this.h.init(n2, (Key)secretKey, this.g);
    }

    private void c(int n2, char[] cArray) throws GeneralSecurityException {
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, this.a.getSalt(), this.a.getIterationCount(), this.e);
        SecretKey secretKey = this.f.generateSecret(pBEKeySpec);
        SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), "AES");
        this.h.init(n2, (Key)secretKeySpec, this.g);
    }
}

