/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Random;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.FileLocker;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleWalletImpl;
import oracle.security.pki.ReentrantReadWriteLockProvider;

class OracleFileWalletImpl
extends OracleWalletImpl {
    protected static int a = 77;

    OracleFileWalletImpl(String string) {
        super(string);
    }

    @Override
    void a(byte[] byArray, char[] cArray, int n2) throws IOException {
        this.a(byArray, cArray, n2, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void a(byte[] byArray, char[] cArray, int n2, byte by2) throws IOException {
        FileLocker fileLocker;
        FileLock fileLock;
        FileChannel fileChannel;
        FileOutputStream fileOutputStream;
        FileLocker fileLocker2;
        FileLock fileLock2;
        FileChannel fileChannel2;
        FileOutputStream fileOutputStream2;
        File file;
        File file2;
        boolean bl2;
        block12: {
            bl2 = false;
            file2 = new File(this.e());
            file = new File(this.e());
            fileOutputStream2 = null;
            fileChannel2 = null;
            fileLock2 = null;
            fileLocker2 = null;
            fileOutputStream = null;
            fileChannel = null;
            fileLock = null;
            fileLocker = null;
            if (!file2.exists() && !file2.mkdir()) {
                throw new IOException(d.getString("PKI-02009") + file2);
            }
            if (file2.isDirectory()) {
                file2 = new File(file2, "ewallet.p12");
                file = new File(file, "cwallet.sso");
            } else {
                file = new File(file.getParentFile(), "cwallet.sso");
            }
            if (!file2.exists()) {
                bl2 = true;
            } else if (!file2.canWrite() || file.exists() && !file.canWrite()) {
                throw new IOException(d.getString("PKI-0723"));
            }
            String string = this.f();
            try {
                ReentrantReadWriteLockProvider.lockForWrite(string);
                fileLocker2 = new FileLocker(file2);
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallets:locking (exclusive) dummy p12 file..");
                if (!fileLocker2.lock(true)) break block12;
                fileOutputStream2 = new FileOutputStream(file2);
                fileChannel2 = fileOutputStream2.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallets:locking (exclusive) ewallet.p12 wallet file..");
                fileLock2 = FileLockProvider.a(file2, fileChannel2, 0L, byArray.length, false);
                if (fileLock2 == null || !fileLock2.isValid()) {
                    throw new IOException(d.getString("PKI-02012") + file2.getCanonicalPath());
                }
                fileLocker = new FileLocker(file);
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallets: locking (exclusive) dummy sso file..");
                if (fileLocker.lock(true)) {
                    fileOutputStream = new FileOutputStream(file);
                    fileChannel = fileOutputStream.getChannel();
                    OraclePKIDebug.a("OracleFileWalletImpl.saveWallets:locking (exclusive) cwallet.sso wallet file..");
                    fileLock = FileLockProvider.a(file, fileChannel, 0L, byArray.length + a, false);
                    if (fileLock == null || !fileLock.isValid()) {
                        throw new IOException(d.getString("PKI-02012") + file.getCanonicalPath());
                    }
                    OracleKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream2, cArray, by2);
                    OracleSSOKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream, cArray, n2, by2);
                }
            }
            catch (Throwable throwable) {
                this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
                this.a(fileLock2, fileChannel2, null, fileOutputStream2, fileLocker2);
                ReentrantReadWriteLockProvider.unlockForWrite(this.f());
                throw throwable;
            }
        }
        this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
        this.a(fileLock2, fileChannel2, null, fileOutputStream2, fileLocker2);
        ReentrantReadWriteLockProvider.unlockForWrite(this.f());
        if (bl2 && file2 != null && file != null) {
            OracleFileWalletImpl.b(file2);
            OracleFileWalletImpl.b(file);
        }
    }

    @Override
    void a(byte[] byArray, char[] cArray) throws IOException {
        this.a(byArray, cArray, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void a(byte[] byArray, char[] cArray, byte by2) throws IOException {
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        FileLocker fileLocker = null;
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel2 = null;
        FileLock fileLock2 = null;
        FileLocker fileLocker2 = null;
        boolean bl2 = false;
        File file = new File(this.e());
        File file2 = new File(this.e());
        if (!file.exists() && !file.mkdir()) {
            throw new IOException(d.getString("PKI-02009") + file);
        }
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
            file2 = new File(file2, "cwallet.sso");
        } else {
            file2 = new File(file2.getParentFile(), "cwallet.sso");
        }
        if (!file.exists()) {
            bl2 = true;
        }
        String string = this.f();
        try {
            ReentrantReadWriteLockProvider.lockForWrite(string);
            fileLocker = new FileLocker(file);
            OraclePKIDebug.a("OracleFileWalletImpl.saveWallet:locking (exclusive) dummy p12 file..");
            if (fileLocker.lock(true)) {
                fileOutputStream = new FileOutputStream(file);
                fileChannel = fileOutputStream.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.saveWallet:locking (exclusive) ewallet.p12 wallet file..");
                fileLock = FileLockProvider.a(file, fileChannel, 0L, byArray.length, false);
                if (fileLock == null || !fileLock.isValid()) {
                    throw new IOException(d.getString("PKI-02012") + file.getCanonicalPath());
                }
                if (file2.exists()) {
                    fileLocker2 = new FileLocker(file2);
                    OraclePKIDebug.a("OracleFileWalletImpl.saveWallet: locking (exclusive) dummy sso file..");
                    if (fileLocker2.lock(true)) {
                        randomAccessFile = new RandomAccessFile(file2, "rw");
                        fileChannel2 = randomAccessFile.getChannel();
                        OraclePKIDebug.a("OracleFileWalletImpl.saveWallet:locking (exclusive) cwallet.sso wallet file..");
                        fileLock2 = FileLockProvider.a(file2, fileChannel2, 0L, byArray.length + a, false);
                        if (fileLock2 == null || !fileLock2.isValid()) {
                            throw new IOException(d.getString("PKI-02012") + file2.getCanonicalPath());
                        }
                    }
                }
                OracleKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream, cArray, by2);
            }
        }
        catch (Throwable throwable) {
            this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
            this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
            ReentrantReadWriteLockProvider.unlockForWrite(string);
            throw throwable;
        }
        this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
        this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
        ReentrantReadWriteLockProvider.unlockForWrite(string);
        if (bl2 && file != null) {
            OracleFileWalletImpl.b(file);
        }
    }

    @Override
    void b(byte[] byArray, char[] cArray, int n2) throws IOException {
        this.b(byArray, cArray, n2, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void b(byte[] byArray, char[] cArray, int n2, byte by2) throws IOException {
        boolean bl2 = false;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        FileLocker fileLocker = null;
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel2 = null;
        FileLock fileLock2 = null;
        FileLocker fileLocker2 = null;
        File file = new File(this.e());
        File file2 = new File(this.e());
        OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet: enter...");
        OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet: System.getProperty(user.name)=" + System.getProperty("user.name"));
        if (!file.exists() && !file.mkdir()) {
            throw new IOException(d.getString("PKI-02009") + file);
        }
        if (file.isFile()) {
            file = file.getParentFile();
            file2 = file2.getParentFile();
        }
        file = new File(file, "cwallet.sso");
        file2 = new File(file2, "ewallet.p12");
        if (!file.exists()) {
            bl2 = true;
        }
        switch (n2) {
            case 1: {
                OraclePKIDebug.a("OracleFileWalletImpl: Storing SSO Wallet");
                break;
            }
            case 2: {
                OraclePKIDebug.a("OracleFileWalletImpl: Storing ESSO Wallet");
                break;
            }
            case 3: {
                OraclePKIDebug.a("OracleFileWalletImpl: Storing LSSO Wallet");
                break;
            }
        }
        String string = this.f();
        try {
            ReentrantReadWriteLockProvider.lockForWrite(string);
            if (file2.exists()) {
                fileLocker2 = new FileLocker(file2);
                OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet:locking (exclusive) dummy p12 file..");
                if (fileLocker2.lock(true)) {
                    randomAccessFile = new RandomAccessFile(file2, "rw");
                    fileChannel2 = randomAccessFile.getChannel();
                    OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet:locking (exclusive) ewallet.p12 wallet file..");
                    fileLock2 = FileLockProvider.a(file2, fileChannel2, 0L, byArray.length, false);
                    if (fileLock2 == null || !fileLock2.isValid()) {
                        throw new IOException(d.getString("PKI-02012") + file2.getCanonicalPath());
                    }
                }
            }
            fileLocker = new FileLocker(file);
            OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet: locking (exclusive) dummy sso file..");
            if (fileLocker.lock(true)) {
                fileOutputStream = new FileOutputStream(file);
                fileChannel = fileOutputStream.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.saveSSOWallet:locking (exclusive) cwallet.sso wallet file..");
                fileLock = FileLockProvider.a(file, fileChannel, 0L, byArray.length + a, false);
                if (fileLock == null || !fileLock.isValid()) {
                    throw new IOException(d.getString("PKI-02012") + file.getCanonicalPath());
                }
                OracleSSOKeyStoreSpi.a(new ByteArrayInputStream(byArray), cArray, fileOutputStream, cArray, n2, by2);
            }
        }
        catch (Throwable throwable) {
            this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
            this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
            ReentrantReadWriteLockProvider.unlockForWrite(string);
            throw throwable;
        }
        this.a(fileLock, fileChannel, null, fileOutputStream, fileLocker);
        this.a(fileLock2, fileChannel2, randomAccessFile, null, fileLocker2);
        ReentrantReadWriteLockProvider.unlockForWrite(string);
        if (bl2 && file != null) {
            OracleFileWalletImpl.b(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    byte[] a() throws IOException, FileNotFoundException {
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        FileLocker fileLocker = null;
        FileInputStream fileInputStream2 = null;
        FileChannel fileChannel2 = null;
        FileLock fileLock2 = null;
        FileLocker fileLocker2 = null;
        File file = new File(this.e());
        File file2 = new File(this.e());
        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: enter...");
        OraclePKIDebug.a("OracleFileWalletImpl: System.getProperty(user.name)=" + System.getProperty("user.name"));
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
            file2 = new File(file2, "cwallet.sso");
        } else {
            file2 = new File(file2.getParentFile(), "cwallet.sso");
        }
        String string = this.f();
        try {
            ReentrantReadWriteLockProvider.lockForRead(string);
            fileLocker = new FileLocker(file);
            OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) dummy p12 file..");
            if (fileLocker.lock(false)) {
                fileInputStream = new FileInputStream(file);
                fileChannel = fileInputStream.getChannel();
                OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) p12 file..");
                fileLock = FileLockProvider.a(file, fileChannel, fileInputStream);
                if (file2.exists()) {
                    fileLocker2 = new FileLocker(file2);
                    OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) dummy sso file..");
                    if (fileLocker2.lock(false)) {
                        fileInputStream2 = new FileInputStream(file2);
                        fileChannel2 = fileInputStream2.getChannel();
                        OraclePKIDebug.a("OracleFileWalletImpl.getWalletData: locking (shared) sso file..");
                        fileLock2 = FileLockProvider.a(file2, fileChannel2, fileInputStream2);
                    }
                }
                byArray = new byte[(int)file.length()];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                fileChannel.read(byteBuffer);
            }
        }
        catch (Throwable throwable) {
            this.a(file2, fileLock2, fileChannel2, fileInputStream2, fileLocker2);
            this.a(file, fileLock, fileChannel, fileInputStream, fileLocker);
            ReentrantReadWriteLockProvider.unlockForRead(string);
            throw throwable;
        }
        this.a(file2, fileLock2, fileChannel2, fileInputStream2, fileLocker2);
        this.a(file, fileLock, fileChannel, fileInputStream, fileLocker);
        ReentrantReadWriteLockProvider.unlockForRead(string);
        return byArray;
    }

    @Override
    void c() throws IOException {
        File file = new File(this.e());
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
        }
        OraclePKIDebug.a("OracleFileWalletImpl: deleting wallet, length " + file.length());
        this.a(file);
        if (!file.delete()) {
            throw new IOException(d.getString("PKI-02005") + file.getPath());
        }
    }

    void a(File file) throws IOException {
        int n2;
        int n3 = -86;
        int n4 = 85;
        int n5 = (int)file.length();
        String string = file.getAbsolutePath();
        OraclePKIDebug.a("OracleFileWalletImpl: wallet is " + string);
        OraclePKIDebug.a("OracleFileWalletImpl: walletFile length is " + n5);
        OraclePKIDebug.a("Pass 1");
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        for (n2 = 0; n2 < n5; ++n2) {
            fileOutputStream.write(n3);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        OraclePKIDebug.a("Pass 2");
        fileOutputStream = new FileOutputStream(file);
        for (n2 = 0; n2 < n5; ++n2) {
            fileOutputStream.write(n4);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        byte[] byArray = new byte[n5];
        Random random = new Random();
        random.nextBytes(byArray);
        OraclePKIDebug.a("Pass 3");
        fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.flush();
        fileOutputStream.close();
        FileInputStream fileInputStream = new FileInputStream(file);
        int n6 = 0;
        while ((long)n6 < file.length()) {
            byte by2 = (byte)fileInputStream.read();
            if (by2 != byArray[n6]) {
                OraclePKIDebug.a("Read = " + by2 + "Expected = " + byArray[n6]);
                throw new IOException("Wipe failed");
            }
            ++n6;
        }
        fileInputStream.close();
    }

    @Override
    void d() throws IOException {
        File file = new File(this.e());
        if (file.isFile()) {
            file = file.getParentFile();
        }
        file = new File(file, "cwallet.sso");
        this.a(file);
        if (!file.delete()) {
            throw new IOException(d.getString("PKI-02005") + file.getPath());
        }
    }

    @Override
    boolean b() {
        File file = new File(this.e());
        if (file.isDirectory()) {
            file = new File(file, "ewallet.p12");
        }
        return file.exists();
    }

    private String g() {
        String string = "cmd /C set USERDOMAIN";
        String string2 = "";
        try {
            OraclePKIDebug.a("OracleFileWalletImpl: Exec " + string);
            Process process = Runtime.getRuntime().exec(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                OraclePKIDebug.a("OracleFileWalletImpl: " + string3);
                if (string3.toUpperCase().startsWith("USERDOMAIN=")) {
                    string2 = string3.toUpperCase().substring(11) + "\\";
                }
                string3 = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            OraclePKIDebug.a("OracleFileWalletImpl: " + exception);
            exception.printStackTrace();
        }
        OraclePKIDebug.a("OracleFileWalletImpl: returning " + string2);
        return string2;
    }

    static void b(File file) {
        try {
            if (!file.exists()) {
                throw new IOException("No such file or directory: " + file.getAbsolutePath());
            }
            String string = System.getProperty("os.name", "DEFAULT");
            String string2 = file.getAbsolutePath();
            if (string.startsWith("Windows")) {
                OracleFileWalletImpl.a(string2);
            } else if (!(file.setReadable(false, false) && file.setExecutable(false, false) && file.setWritable(false, false) && file.setWritable(true, true) && file.setReadable(true, true))) {
                OraclePKIDebug.a("PKI-02011" + string2);
            }
        }
        catch (SecurityException securityException) {
            OraclePKIDebug.a("OracleFileWalletImpl: " + securityException);
        }
        catch (IOException iOException) {
            OraclePKIDebug.a("OracleFileWalletImpl: " + iOException);
        }
    }

    private static void a(String string) {
        try {
            Path path = Paths.get(string, new String[0]);
            AclFileAttributeView aclFileAttributeView = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            UserPrincipalLookupService userPrincipalLookupService = path.getFileSystem().getUserPrincipalLookupService();
            UserPrincipal userPrincipal = userPrincipalLookupService.lookupPrincipalByName(aclFileAttributeView.getOwner().getName());
            AclEntry.Builder builder = AclEntry.newBuilder();
            builder.setPermissions(EnumSet.of(AclEntryPermission.READ_DATA, new AclEntryPermission[]{AclEntryPermission.READ_ACL, AclEntryPermission.READ_ATTRIBUTES, AclEntryPermission.READ_NAMED_ATTRS, AclEntryPermission.WRITE_ACL, AclEntryPermission.DELETE, AclEntryPermission.WRITE_DATA, AclEntryPermission.WRITE_ATTRIBUTES, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.APPEND_DATA, AclEntryPermission.SYNCHRONIZE}));
            builder.setPrincipal(userPrincipal);
            builder.setType(AclEntryType.ALLOW);
            aclFileAttributeView.setAcl(Collections.singletonList(builder.build()));
            OraclePKIDebug.a("owner of file: " + aclFileAttributeView.getOwner().getName());
            OraclePKIDebug.a("permissions on the file placed at location : " + string);
            for (AclEntry aclEntry : aclFileAttributeView.getAcl()) {
                OraclePKIDebug.a(aclEntry.toString());
            }
        }
        catch (IOException iOException) {
            OraclePKIDebug.a("OracleFileWalletImpl: " + iOException);
        }
    }
}

