/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.core.PrivateKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.pki.C041;
import oracle.security.pki.FileLockProvider;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSOKeyStoreSpi$1;
import oracle.security.pki.OracleSecretStoreException;

public class OracleSSOKeyStoreSpi
extends OracleKeyStoreSpi {
    private C041 b = new C041();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleSSOKeyStoreImpl: engineLoad");
        AccessController.doPrivileged(new OracleSSOKeyStoreSpi$1(this));
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        try {
            if (inputStream instanceof FileInputStream) {
                fileChannel = ((FileInputStream)inputStream).getChannel();
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:locking file (shared)..");
                fileLock = FileLockProvider.a(null, fileChannel, 0L, inputStream.available(), true);
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:locked file.");
            }
            char[] cArray2 = null;
            try {
                int n2 = this.b.b(inputStream);
                cArray2 = this.b.a(inputStream);
                if (n2 == 3) {
                    cArray2 = this.b.a(cArray2);
                    OraclePKIDebug.a("OracleSSOKeyStoreImpl: an LSSO wallet");
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            super.engineLoad(inputStream, cArray2);
        }
        finally {
            if (fileLock != null) {
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:releasing lock..");
                fileLock.release();
            }
            if (fileChannel != null) {
                OraclePKIDebug.a("OracleSSOKeyStoreSpi.engineLoad:closing channel..");
                fileChannel.close();
            }
        }
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray) throws IOException, OracleSecretStoreException {
        char[] cArray2 = null;
        int n2 = 0;
        try {
            n2 = this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byte[] byArray = super.a(inputStream, cArray2);
        byte[] byArray2 = null;
        try {
            byArray2 = this.b.a(cArray2, n2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray2.length + byArray.length);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray);
        return byteArrayOutputStream.toByteArray();
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, int n2) throws IOException {
        OracleSSOKeyStoreSpi.a(inputStream, cArray, outputStream, cArray2, n2, (byte)0);
    }

    static void a(InputStream inputStream, char[] cArray, OutputStream outputStream, char[] cArray2, int n2, byte by2) throws IOException {
        char[] cArray3 = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        C041 c041 = new C041();
        try {
            cArray3 = c041.a(byArray);
            byArray2 = c041.a(cArray3, n2);
            if (n2 == 3) {
                cArray3 = c041.a(cArray3);
                OraclePKIDebug.a("OracleSSOKeyStoreImpl: an LSSO wallet");
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        boolean bl2 = true;
        for (int i2 = 0; i2 < byArray2.length && bl2; ++i2) {
            bl2 = byArray2[i2] == byArray[i2];
        }
        outputStream.write(byArray2);
        OracleKeyStoreSpi.a(inputStream, cArray, outputStream, cArray3, by2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, CertificateRequest certificateRequest, PrivateKey privateKey, String string) throws IOException, KeyStoreException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, certificateRequest, privateKey, string);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, boolean bl2) throws IOException, KeyStoreException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2, bl2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, HashMap hashMap, boolean bl2) throws IOException, KeyStoreException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, hashMap, bl2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, x500Principal);
    }

    @Override
    byte[] e(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException, NoSuchAlgorithmException, UnrecoverableKeyException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.e(inputStream, cArray2, string);
    }

    @Override
    byte[] b(InputStream inputStream, char[] cArray, X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.a(inputStream, cArray, x500Principal, null, null);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, x500Principal, string, string2);
    }

    @Override
    byte[] h(InputStream inputStream, char[] cArray, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.h(inputStream, cArray2, string);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, String string, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, string, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        return this.a(inputStream, cArray, x500Principal, null, null, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, X500Principal x500Principal, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, x500Principal, string, string2, hashMap);
    }

    @Override
    byte[] b(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, KeyStoreException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.b(inputStream, cArray2, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, OraclePKIX509CertImpl oraclePKIX509CertImpl, String string, String string2, String string3, HashMap hashMap) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, oraclePKIX509CertImpl, string, string2, string3, hashMap);
    }

    @Override
    public byte[] internalAddPrivateKeyAndCertificateChain(InputStream inputStream, char[] cArray, String string, Key key, Certificate[] certificateArray) throws IOException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            int n2 = this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
            if (n2 == 3) {
                cArray2 = this.b.a(cArray2);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.internalAddPrivateKeyAndCertificateChain(inputStream, cArray2, string, key, certificateArray);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap) throws IOException, SignatureException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            int n2 = this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
            if (n2 == 3) {
                cArray2 = this.b.a(cArray2);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, hashMap);
    }

    @Override
    boolean b(InputStream inputStream, char[] cArray) throws IOException, SignatureException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            int n2 = this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
            if (n2 == 3) {
                cArray2 = this.b.a(cArray2);
            }
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.b(inputStream, cArray2);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, String string, String string2, String string3, String string4, HashMap hashMap) throws IOException, SignatureException, CertificateEncodingException {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, string, string2, string3, string4, hashMap);
    }

    @Override
    byte[] a(InputStream inputStream, char[] cArray, HashMap hashMap, boolean bl2) throws Exception {
        char[] cArray2 = null;
        try {
            this.b.b(inputStream);
            cArray2 = this.b.a(inputStream);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        return super.a(inputStream, cArray2, hashMap, bl2);
    }
}

