/*
 * Decompiled with CFR 0.152.
 */
package oracle.simplefan.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.ons.Notification;
import oracle.simplefan.FanEvent;
import oracle.simplefan.LoadAdvisoryEvent;
import oracle.simplefan.ServiceDownEvent;
import oracle.simplefan.ServiceUpEvent;
import oracle.simplefan.impl.LoadAdvisoryEvent;
import oracle.simplefan.impl.NodeDownEvent;
import oracle.simplefan.impl.NodeUpEvent;
import oracle.simplefan.impl.ServiceDownEvent;
import oracle.simplefan.impl.ServiceUpEvent;

class FanEventFactory {
    static final Logger logger = Logger.getLogger("oracle.simplefan.FanEventFactory");
    static final String EVENT_TYPE_SERVICE_COMPOSITE = "database/event/service";
    static final String EVENT_TYPE_SERVICE_MEMBER = "database/event/servicemember/";
    static final String EVENT_TYPE_NODE = "database/event/host";
    static final String EVENT_TYPE_SERVICE_METRICS = "database/event/servicemetrics/";
    static final String STATUS_DOWN = "down";
    static final String STATUS_UP = "up";
    static final String STATUS_NODE_DOWN = "nodedown";
    static final String STATUS_NODE_UP = "nodeup";
    static final List<FanEvent> emptyList = new ArrayList<FanEvent>(0);

    FanEventFactory() {
    }

    public static void main(String[] stringArray) throws Exception {
        for (String string : stringArray) {
            Body body = FanEventFactory.parseBody(string.getBytes());
            System.out.println(body.toString());
            System.out.println();
        }
    }

    static List<FanEvent> createFanEvents(Object object, Notification notification) {
        String string = notification.type();
        if (string == null) {
            logger.warning("ONS Notification has null type");
        } else {
            logger.finer("type=\"" + string + "\"");
            if (string.startsWith(EVENT_TYPE_SERVICE_METRICS) || notification.get("status") == null) {
                return FanEventFactory.createFanEventsWithParsing(object, notification);
            }
            String string2 = notification.get("status");
            logger.finer("status=\"" + string2 + "\"");
            if (string.equals(EVENT_TYPE_SERVICE_COMPOSITE) || string.startsWith(EVENT_TYPE_SERVICE_MEMBER)) {
                if (STATUS_DOWN.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createServiceDownEvents(object, notification);
                }
                if (STATUS_UP.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createServiceUpEvents(object, notification);
                }
                logger.finer("Unrecognized Service event");
            } else if (string.equals(EVENT_TYPE_NODE)) {
                if (STATUS_NODE_DOWN.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createNodeDownEvents(object, notification);
                }
                if (STATUS_NODE_UP.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createNodeUpEvents(object, notification);
                }
                logger.finer("Unrecognized Node event");
            }
        }
        logger.finer("createFanEvents returning empty list");
        return emptyList;
    }

    static List<FanEvent> createFanEventsWithParsing(Object object, Notification notification) {
        Body body = FanEventFactory.parseBody(notification.body());
        String string = notification.type();
        if (string == null) {
            logger.warning("ONS Notification has null type");
        } else {
            logger.finer("type=\"" + string + "\"");
            if (string.startsWith(EVENT_TYPE_SERVICE_METRICS)) {
                return FanEventFactory.createLoadAdvisoryEvents(object, notification, body);
            }
            if (string.equals(EVENT_TYPE_SERVICE_COMPOSITE) || string.startsWith(EVENT_TYPE_SERVICE_MEMBER)) {
                String string2 = body.getProperty("status");
                logger.finer("status=\"" + string2 + "\"");
                if (STATUS_DOWN.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createServiceDownEvents(object, notification, body);
                }
                if (STATUS_UP.equalsIgnoreCase(string2)) {
                    return FanEventFactory.createServiceUpEvents(object, notification, body);
                }
                logger.finer("Unrecognized Service event");
            } else if (string.equals(EVENT_TYPE_NODE)) {
                if (STATUS_NODE_DOWN.equalsIgnoreCase(body.getProperty("status"))) {
                    return FanEventFactory.createNodeDownEvents(object, notification, body);
                }
                if (STATUS_NODE_UP.equalsIgnoreCase(body.getProperty("status"))) {
                    return FanEventFactory.createNodeUpEvents(object, notification, body);
                }
                logger.finer("Unrecognized Node event");
            }
        }
        logger.finer("createFanEvents returning empty list");
        return emptyList;
    }

    static List<FanEvent> createLoadAdvisoryEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>();
        logger.finer("creating LoadAdvisoryEvents");
        for (List<Body> list : body) {
            for (Body body2 : list) {
                String string = body2.getProperty("percent");
                String string2 = body2.getProperty("quality");
                arrayList.add(new LoadAdvisoryEvent(object, new Date(notification.creationTime()), body.getProperty("service"), body.getProperty("database"), body2.getProperty("instance"), string == null ? -1 : Integer.parseInt(string), string2 == null ? -1 : Integer.parseInt(string2), FanEventFactory.parseLoadStatus(body2.getProperty("status"))));
            }
        }
        return arrayList;
    }

    static List<FanEvent> createServiceDownEvents(Object object, Notification notification) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        String string = notification.get("instance");
        if (notification.type().equals(EVENT_TYPE_SERVICE_MEMBER)) {
            logger.finer("creating member ServiceDownEvent (pre-12c): " + notification.toNiceString());
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime()), notification.get("service"), notification.get("database"), FanEventFactory.parseDownReason(notification.get("reason")), notification.instanceName(), notification.get("host"), 0, false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE) && string != null && !"".equals(string)) {
            logger.finer("creating member ServiceDownEvent (12c): " + notification.toNiceString());
            String string2 = notification.get("drain_timeout");
            int n2 = Integer.parseInt(string2 == null ? "0" : string2);
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime()), notification.get("service"), notification.get("database"), FanEventFactory.parseDownReason(notification.get("reason")), notification.get("instance"), notification.get("host"), n2, false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE)) {
            logger.finer("creating composite ServiceDownEvent: " + notification.toNiceString());
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime()), notification.get("service"), notification.get("database"), FanEventFactory.parseDownReason(notification.get("reason"))));
        } else {
            logger.warning("recevied unknown service event type: \"" + notification.type() + "\"");
            throw new IllegalArgumentException("Unknown service event type: \"" + notification.type() + "\"");
        }
        return arrayList;
    }

    static List<FanEvent> createServiceDownEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        String string = body.getProperty("instance");
        if (notification.type().equals(EVENT_TYPE_SERVICE_MEMBER)) {
            logger.finer("creating member ServiceDownEvent (pre-12c)");
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime()), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseDownReason(body.getProperty("reason")), notification.instanceName(), body.getProperty("host"), 0, false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE) && string != null && !"".equals(string)) {
            logger.finer("creating member ServiceDownEvent: " + body);
            String string2 = body.getProperty("drain_timeout");
            int n2 = Integer.parseInt(string2 == null ? "0" : string2);
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime()), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseDownReason(body.getProperty("reason")), body.getProperty("instance"), body.getProperty("host"), n2, false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE)) {
            logger.finer("creating composite ServiceDownEvent: " + body);
            arrayList.add(new ServiceDownEvent(object, new Date(notification.creationTime()), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseDownReason(body.getProperty("reason"))));
        } else {
            logger.warning("recevied unknown service event type: \"" + notification.type() + "\"");
            throw new IllegalArgumentException("Unknown service event type: \"" + notification.type() + "\"");
        }
        return arrayList;
    }

    static List<FanEvent> createServiceUpEvents(Object object, Notification notification) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        String string = notification.get("instance");
        if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE) && string != null && !"".equals(string)) {
            logger.finer("creating member ServiceUpEvent: " + notification.toNiceString());
            int n2 = 1;
            try {
                n2 = Integer.parseInt(notification.get("card"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList.add(new ServiceUpEvent(object, new Date(notification.creationTime()), notification.get("service"), notification.get("database"), FanEventFactory.parseUpReason(notification.get("reason")), n2, notification.get("instance"), notification.get("host"), false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE)) {
            logger.finer("creating composite ServiceUpEvent: " + notification.toNiceString());
            int n3 = 1;
            try {
                n3 = Integer.parseInt(notification.get("card"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList.add(new ServiceUpEvent(object, new Date(notification.creationTime()), notification.get("service"), notification.get("database"), FanEventFactory.parseUpReason(notification.get("reason")), n3));
        } else {
            logger.warning("recevied unknown service event type: \"" + notification.type() + "\"");
            throw new IllegalArgumentException("Unknown service event type: \"" + notification.type() + "\"");
        }
        return arrayList;
    }

    static List<FanEvent> createServiceUpEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        String string = body.getProperty("instance");
        if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE) && string != null && !"".equals(string)) {
            logger.finer("creating member ServiceUpEvent: " + body);
            int n2 = 1;
            try {
                n2 = Integer.parseInt(body.getProperty("card"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList.add(new ServiceUpEvent(object, new Date(notification.creationTime()), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseUpReason(body.getProperty("reason")), n2, body.getProperty("instance"), body.getProperty("host"), false));
        } else if (notification.type().equals(EVENT_TYPE_SERVICE_COMPOSITE)) {
            logger.finer("creating composite ServiceUpEvent: " + body);
            int n3 = 1;
            try {
                n3 = Integer.parseInt(body.getProperty("card"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            arrayList.add(new ServiceUpEvent(object, new Date(notification.creationTime()), body.getProperty("service"), body.getProperty("database"), FanEventFactory.parseUpReason(body.getProperty("reason")), n3));
        } else {
            logger.warning("recevied unknown service event type: \"" + notification.type() + "\"");
            throw new IllegalArgumentException("Unknown service event type: \"" + notification.type() + "\"");
        }
        return arrayList;
    }

    static List<FanEvent> createNodeDownEvents(Object object, Notification notification) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        logger.finer("creating NodeDownEvent: " + notification.toNiceString());
        String string = notification.get("incarnation");
        arrayList.add(new NodeDownEvent(object, new Date(notification.creationTime()), notification.get("host"), string == null ? -1 : Integer.parseInt(string)));
        return arrayList;
    }

    static List<FanEvent> createNodeDownEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        logger.finer("creating NodeDownEvent");
        String string = body.getProperty("incarnation");
        arrayList.add(new NodeDownEvent(object, new Date(notification.creationTime()), body.getProperty("host"), string == null ? -1 : Integer.parseInt(string)));
        return arrayList;
    }

    private static List<FanEvent> createNodeUpEvents(Object object, Notification notification) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        logger.finer("creating NodeUpEvent: " + notification.toNiceString());
        String string = notification.get("incarnation");
        arrayList.add(new NodeUpEvent(object, new Date(notification.creationTime()), notification.get("host"), string == null ? -1 : Integer.parseInt(string)));
        return arrayList;
    }

    private static List<FanEvent> createNodeUpEvents(Object object, Notification notification, Body body) {
        ArrayList<FanEvent> arrayList = new ArrayList<FanEvent>(1);
        logger.finer("creating NodeUpEvent");
        String string = body.getProperty("incarnation");
        arrayList.add(new NodeUpEvent(object, new Date(notification.creationTime()), body.getProperty("host"), string == null ? -1 : Integer.parseInt(string)));
        return arrayList;
    }

    static Body parseBody(byte[] byArray) {
        Body body = new Body();
        FanEventFactory.parseBody(body, byArray, 0);
        return body;
    }

    static int parseBody(Body body, byte[] byArray, int n2) {
        logger.finer("parseBody: \"" + new String(byArray) + "\", " + n2);
        String string = null;
        String string2 = null;
        int n3 = -1;
        int n4 = n2;
        while (n4 < byArray.length) {
            if (byArray[n4] == 32) {
                ++n4;
                continue;
            }
            if (byArray[n4] == 123) {
                n4 = FanEventFactory.parseBodyList(body, byArray, n4 + 1);
                continue;
            }
            if (byArray[n4] == 125) {
                ++n4;
                break;
            }
            n3 = n4;
            while (byArray[n4] != 61) {
                ++n4;
            }
            string = new String(byArray, n3, n4 - n3);
            n3 = ++n4;
            if (string.equals("timestamp")) {
                n4 += 19;
            } else {
                while (n4 < byArray.length && byArray[n4] != 32 && byArray[n4] != 125) {
                    ++n4;
                }
            }
            string2 = new String(byArray, n3, n4 - n3);
            logger.finest("found in body: \"" + string + "\"=\"" + string2 + "\"");
            body.put(string, string2);
        }
        return n4;
    }

    static int parseBodyList(Body body, byte[] byArray, int n2) {
        logger.finer("parseBodyList: \"" + new String(byArray) + "\", " + n2);
        ArrayList<Body> arrayList = new ArrayList<Body>();
        int n3 = -1;
        int n4 = n2;
        while (n4 < byArray.length) {
            if (byArray[n4] == 32) {
                ++n4;
                continue;
            }
            if (byArray[n4] == 123) {
                Body body2 = new Body();
                n4 = FanEventFactory.parseBody(body2, byArray, n4 + 1);
                arrayList.add(body2);
                continue;
            }
            if (byArray[n4] == 125) {
                ++n4;
                break;
            }
            throw new Error("invalid notification syntax at " + n4);
        }
        body.add(arrayList);
        return n4;
    }

    static LoadAdvisoryEvent.LoadStatus parseLoadStatus(String string) {
        logger.finer("parseLoadStatus: \"" + string + "\"");
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("good")) {
            return LoadAdvisoryEvent.LoadStatus.GOOD;
        }
        if (string.equalsIgnoreCase("violating")) {
            return LoadAdvisoryEvent.LoadStatus.VIOLATING;
        }
        if (string.equalsIgnoreCase("NO_DATA")) {
            return LoadAdvisoryEvent.LoadStatus.NO_DATA;
        }
        if (string.equalsIgnoreCase("UNKNOWN")) {
            return LoadAdvisoryEvent.LoadStatus.UNKNOWN;
        }
        logger.warning("unrecognized load status value: \"" + string + "\"");
        throw new IllegalArgumentException("unrecognized load status value: \"" + string + "\"");
    }

    static ServiceDownEvent.Reason parseDownReason(String string) {
        logger.finer("parseDownReason: \"" + string + "\"");
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("FAILURE")) {
            return ServiceDownEvent.Reason.FAILURE;
        }
        if (string.equalsIgnoreCase("DEPENDENCY")) {
            return ServiceDownEvent.Reason.DEPENDENCY;
        }
        if (string.equalsIgnoreCase("USER")) {
            return ServiceDownEvent.Reason.USER;
        }
        if (string.equalsIgnoreCase("AUTOSTART")) {
            return ServiceDownEvent.Reason.AUTOSTART;
        }
        if (string.equalsIgnoreCase("BOOT")) {
            return ServiceDownEvent.Reason.BOOT;
        }
        logger.warning("unrecognized reason value: \"" + string + "\"");
        throw new IllegalArgumentException("unrecognized reason value: \"" + string + "\"");
    }

    static ServiceUpEvent.Reason parseUpReason(String string) {
        logger.finer("parseUpReason: \"" + string + "\"");
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.equalsIgnoreCase("FAILURE")) {
            return ServiceUpEvent.Reason.FAILURE;
        }
        if (string.equalsIgnoreCase("DEPENDENCY")) {
            return ServiceUpEvent.Reason.DEPENDENCY;
        }
        if (string.equalsIgnoreCase("USER")) {
            return ServiceUpEvent.Reason.USER;
        }
        if (string.equalsIgnoreCase("AUTOSTART")) {
            return ServiceUpEvent.Reason.AUTOSTART;
        }
        if (string.equalsIgnoreCase("BOOT")) {
            return ServiceUpEvent.Reason.BOOT;
        }
        logger.warning("unrecognized reason value: \"" + string + "\"");
        throw new IllegalArgumentException("unrecognized reason value: \"" + string + "\"");
    }

    static class Body
    implements Iterable<List<Body>> {
        private Properties props = new Properties();
        private List<List<Body>> lists = new ArrayList<List<Body>>();

        Body() {
        }

        void put(String string, String string2) {
            this.props.put(string, string2);
        }

        String getProperty(String string) {
            return this.props.getProperty(string);
        }

        void add(List<Body> list) {
            this.lists.add(list);
        }

        @Override
        public Iterator<List<Body>> iterator() {
            return this.lists.iterator();
        }

        public String toString() {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.props.list(printWriter);
            for (List<Body> list : this.lists) {
                printWriter.append("{");
                for (Body body : list) {
                    printWriter.append("{");
                    printWriter.append(body.toString());
                    printWriter.append("}");
                }
                printWriter.append("}");
            }
            return stringWriter.toString();
        }
    }
}

