/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSetUTF;
import oracle.sql.CharacterWalker;

class CharacterSetByte
extends CharacterSet
implements CharacterRepConstants {
    CharacterSetByte(int n2) {
        super(n2);
        this.rep = 1;
    }

    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        return characterSet.rep != 1;
    }

    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        return characterSet.rep <= 1024;
    }

    @DisableTrace
    private String toString(byte[] byArray, int n2, int n3, char c2) throws SQLException {
        try {
            return new String(byArray, n2, n3, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 183).fillInStackTrace();
        }
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] byArray, int n2, int n3) {
        try {
            return this.toString(byArray, n2, n3, '?');
        }
        catch (SQLException sQLException) {
            throw new Error("CharacterSetByte.toString");
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] byArray, int n2, int n3) throws SQLException {
        return this.toString(byArray, n2, n3);
    }

    @Override
    public byte[] convert(String string) throws SQLException {
        int n2 = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n2, cArray, 0);
        return CharacterSetByte.charsToBytes(cArray, (byte)0);
    }

    @Override
    public byte[] convertWithReplacement(String string) {
        int n2 = string.length();
        char[] cArray = new char[string.length()];
        string.getChars(0, n2, cArray, 0);
        try {
            return CharacterSetByte.charsToBytes(cArray, (byte)63);
        }
        catch (SQLException sQLException) {
            return new byte[0];
        }
    }

    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        byte[] byArray2;
        if (characterSet.rep == 1) {
            byArray2 = CharacterSetByte.useOrCopy(byArray, n2, n3);
        } else if (characterSet.rep == 2) {
            char[] cArray = CharacterSetUTF.UTFToJavaChar(byArray, n2, n3);
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        } else {
            String string = characterSet.toString(byArray, n2, n3);
            char[] cArray = string.toCharArray();
            byArray2 = CharacterSetByte.charsToBytes(cArray, (byte)0);
        }
        return byArray2;
    }

    @Override
    int decode(CharacterWalker characterWalker) {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        CharacterSetByte.need(characterBuffer, 1);
        if (n2 < 256) {
            characterBuffer.bytes[characterBuffer.next] = (byte)n2;
            ++characterBuffer.next;
        }
    }

    static byte[] charsToBytes(char[] cArray, byte by2) throws SQLException {
        byte[] byArray = new byte[cArray.length];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] > '\u00ff') {
                byArray[i2] = by2;
                if (by2 != 0) continue;
                CharacterSetByte.failCharacterConversion(CharacterSet.make(31));
                continue;
            }
            byArray[i2] = (byte)cArray[i2];
        }
        return byArray;
    }
}

