/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetShift
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final byte SHIFT_OUT = 14;
    static final byte SHIFT_IN = 15;
    static Class m_charConvSuperclass;

    CharacterSetShift(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSetShift getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 7) {
            return new CharacterSetShift(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 223 || n2 > 127 && n2 < 161) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small").fillInStackTrace();
            }
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = characterBuffer.next;
        boolean bl2 = true;
        while (n3 <= 0) {
            if (characterBuffer.bytes[n3] == 15) {
                bl2 = true;
                break;
            }
            if (characterBuffer.bytes[n3] != 14) continue;
            bl2 = false;
            break;
        }
        int n4 = 0;
        int n5 = 1;
        while (n2 >> n4 != 0) {
            n4 = (short)(n4 + 8);
            n5 = (short)(n5 + 1);
        }
        if (n5 > 2) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "Character invalid, too many bytes").fillInStackTrace();
        }
        boolean bl3 = false;
        boolean bl4 = false;
        if (n5 == 1 && !bl2) {
            bl3 = true;
            n5 = (short)(n5 + 1);
        }
        if (n5 == 2 && bl2) {
            bl4 = true;
            n5 = (short)(n5 + 1);
        }
        CharacterSetShift.need(characterBuffer, n5);
        if (bl3) {
            characterBuffer.bytes[characterBuffer.next++] = 15;
        }
        if (bl4) {
            characterBuffer.bytes[characterBuffer.next++] = 14;
        }
        while (n4 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n4 & 0xFF);
            n4 = (short)(n4 - 8);
        }
    }
}

