/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableBase;

public class ConcreteProxyUtil {
    public static boolean isThinDriverConnection(Object object) {
        return object != null && object instanceof OracleConnection && !(object instanceof T2CConnection);
    }

    public static TxnReplayableBase getTxnReplayableBaseOfConnection(oracle.jdbc.OracleConnection oracleConnection) {
        TxnReplayableBase txnReplayableBase = null;
        if (oracleConnection != null && oracleConnection instanceof ReplayableConnection) {
            try {
                if (oracleConnection instanceof TxnReplayableBase) {
                    txnReplayableBase = (TxnReplayableBase)((Object)oracleConnection);
                } else if (oracleConnection instanceof oracle.jdbc.replay.internal.ReplayableConnection) {
                    oracle.jdbc.internal.OracleConnection oracleConnection2;
                    Object object = ((oracle.jdbc.replay.internal.ReplayableConnection)((Object)oracleConnection)).getProxyObject();
                    if (object != null && object instanceof TxnReplayableBase) {
                        txnReplayableBase = (TxnReplayableBase)object;
                    } else if (oracleConnection instanceof LogicalConnection) {
                        oracle.jdbc.internal.OracleConnection oracleConnection3 = ((LogicalConnection)oracleConnection).getPhysicalConnection();
                        if (oracleConnection3 != null && oracleConnection3 instanceof TxnReplayableBase) {
                            txnReplayableBase = (TxnReplayableBase)((Object)oracleConnection3);
                        }
                    } else if (oracleConnection instanceof oracle.jdbc.OracleConnection && (oracleConnection2 = oracleConnection.physicalConnectionWithin()) != null && oracleConnection2 instanceof TxnReplayableBase) {
                        txnReplayableBase = (TxnReplayableBase)((Object)oracleConnection2);
                    }
                }
            }
            catch (SQLException sQLException) {
                txnReplayableBase = null;
            }
        }
        return txnReplayableBase;
    }

    public static boolean isThinDriverReplayableConnection(oracle.jdbc.OracleConnection oracleConnection) {
        boolean bl2 = false;
        TxnReplayableBase txnReplayableBase = ConcreteProxyUtil.getTxnReplayableBaseOfConnection(oracleConnection);
        if (txnReplayableBase != null) {
            Object object = txnReplayableBase.getDelegateObj();
            bl2 = ConcreteProxyUtil.isThinDriverConnection(object);
        }
        return bl2;
    }

    public static oracle.jdbc.OracleConnection getThinDriverReplayableConnectionDelegate(oracle.jdbc.OracleConnection oracleConnection) {
        boolean bl2 = false;
        Object object = null;
        TxnReplayableBase txnReplayableBase = ConcreteProxyUtil.getTxnReplayableBaseOfConnection(oracleConnection);
        if (txnReplayableBase != null) {
            object = txnReplayableBase.getDelegateObj();
            bl2 = ConcreteProxyUtil.isThinDriverConnection(object);
        }
        return bl2 ? (oracle.jdbc.OracleConnection)object : null;
    }

    public static Object checkAndGetACProxyConnection(oracle.jdbc.OracleConnection oracleConnection) {
        Object object = null;
        if (ConcreteProxyUtil.isThinDriverConnection(oracleConnection)) {
            OracleConnection oracleConnection2 = (OracleConnection)oracleConnection;
            object = oracleConnection2.getACProxy();
            if (object == null || !(object instanceof ReplayableConnection)) {
                object = null;
            }
        } else if (ConcreteProxyUtil.isThinDriverReplayableConnection(oracleConnection)) {
            object = ConcreteProxyUtil.getTxnReplayableBaseOfConnection(oracleConnection);
        }
        return object;
    }

    public static <T> T getProxyObject(oracle.jdbc.OracleConnection oracleConnection, T t2, Class clazz, Object object) {
        Object object2;
        T t3 = null;
        if ((ConcreteProxyUtil.isThinDriverConnection(oracleConnection) || ConcreteProxyUtil.isThinDriverReplayableConnection(oracleConnection)) && (object2 = ConcreteProxyUtil.checkAndGetACProxyConnection(oracleConnection)) != null) {
            ProxyFactory proxyFactory = null;
            proxyFactory = ProxyFactory.createProxyFactory(clazz);
            t3 = proxyFactory.proxyFor(t2, object);
            TxnReplayableBase txnReplayableBase = (TxnReplayableBase)object2;
            TxnReplayableBase txnReplayableBase2 = (TxnReplayableBase)t3;
            txnReplayableBase2.setFailoverManager(txnReplayableBase.getFailoverManager());
        }
        return t3;
    }

    public static oracle.jdbc.OracleConnection unwrapConnectionProxy(oracle.jdbc.OracleConnection oracleConnection) {
        oracle.jdbc.OracleConnection oracleConnection2 = ConcreteProxyUtil.getThinDriverReplayableConnectionDelegate(oracleConnection);
        if (oracleConnection2 != null) {
            oracleConnection = oracleConnection2;
        }
        return oracleConnection;
    }

    public static void checkAndDisableReplay(OracleConcreteProxy oracleConcreteProxy) {
        try {
            TxnReplayableBase txnReplayableBase = oracleConcreteProxy.getConcreteProxy();
            if (txnReplayableBase != null) {
                txnReplayableBase.disableReplay();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

