/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleDate;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;
import oracle.sql.LdxLib;
import oracle.sql.LdxLibThin;
import oracle.sql.NUMBER;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.PRIMITIVE_DATUM})
public class DATE
extends Datum
implements OracleDate {
    static final long serialVersionUID = 5229717576495161269L;
    public static final int BDA = 1;
    public static final int BDAL = 2;
    public static final int BMO = 4;
    public static final int BMOL = 8;
    public static final int BYR = 16;
    public static final int BYRL = 32;
    public static final int BHR = 64;
    public static final int BHRL = 128;
    public static final int BMN = 256;
    public static final int BMNL = 512;
    public static final int BSC = 1024;
    public static final int BSCL = 2048;
    public static final int MSD = 4096;
    public static final int YR0 = 8192;
    public static final int BDT = 32768;
    public static final int HRZER0 = 65536;
    public static final int MIZERO = 131072;
    public static final int SEZERO = 262144;
    private static final byte LDXTCE = 0;
    private static final byte LDXTYE = 1;
    private static final byte LDXTMO = 2;
    private static final byte LDXTDA = 3;
    private static final byte LDXTHO = 4;
    private static final byte LDXTMI = 5;
    private static final byte LDXTSE = 6;
    private static LdxLib _sldxlib;

    public DATE() {
        super(DATE._initDate());
    }

    public DATE(byte[] byArray) {
        super(byArray);
    }

    public DATE(Date date) {
        super(DATE.toBytes(date));
    }

    public DATE(Time time) {
        super(DATE.toBytes(time));
    }

    public DATE(Timestamp timestamp) {
        super(DATE.toBytes(timestamp));
    }

    public DATE(Date date, Calendar calendar) {
        super(DATE.toBytes(date, calendar));
    }

    public DATE(Time time, Calendar calendar) {
        super(DATE.toBytes(time, calendar));
    }

    public DATE(Timestamp timestamp, Calendar calendar) {
        super(DATE.toBytes(timestamp, calendar));
    }

    public DATE(String string) {
        super(DATE.toBytes(string));
    }

    public DATE(String string, boolean bl2) throws ParseException {
        super(DATE.toBytes(string));
        if (!bl2) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setLenient(false);
            java.util.Date date = simpleDateFormat.parse(string);
        }
    }

    public DATE(String string, Calendar calendar) {
        super(DATE.toBytes(string, calendar));
    }

    public DATE(Object object) throws SQLException {
        if (object instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)object));
        } else if (object instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)object));
        } else if (object instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)object));
        } else if (object instanceof String) {
            this.setShareBytes(DATE.toBytes((String)object));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public DATE(Object object, Calendar calendar) throws SQLException {
        if (object instanceof Date) {
            this.setShareBytes(DATE.toBytes((Date)object, calendar));
        } else if (object instanceof Time) {
            this.setShareBytes(DATE.toBytes((Time)object, calendar));
        } else if (object instanceof Timestamp) {
            this.setShareBytes(DATE.toBytes((Timestamp)object, calendar));
        } else if (object instanceof String) {
            this.setShareBytes(DATE.toBytes((String)object, calendar));
        } else {
            throw new SQLException("Initialization failed");
        }
    }

    public static Date toDate(byte[] byArray) {
        return DATE.toDate(byArray, null);
    }

    public static Time toTime(byte[] byArray) {
        return DATE.toTime(byArray, null);
    }

    public static Timestamp toTimestamp(byte[] byArray) {
        return DATE.toTimestamp(byArray, null);
    }

    public static Date toDate(byte[] byArray, Calendar calendar) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.set(1, n2);
        calendar2.set(2, nArray[2] - 1);
        calendar2.set(5, nArray[3]);
        calendar2.set(11, nArray[4] - 1);
        calendar2.set(12, nArray[5] - 1);
        calendar2.set(13, nArray[6] - 1);
        calendar2.set(14, 0);
        Date date = new Date(calendar2.getTime().getTime());
        return date;
    }

    public static Time toTime(byte[] byArray, Calendar calendar) {
        int n2 = byArray[4] & 0xFF;
        int n3 = byArray[5] & 0xFF;
        int n4 = byArray[6] & 0xFF;
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.set(1, 1970);
        calendar2.set(2, 0);
        calendar2.set(5, 1);
        calendar2.set(11, n2 - 1);
        calendar2.set(12, n3 - 1);
        calendar2.set(13, n4 - 1);
        calendar2.set(14, 0);
        return new Time(calendar2.getTime().getTime());
    }

    public static Timestamp toTimestamp(byte[] byArray, Calendar calendar) {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] & 0xFF;
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.set(1, n2);
        calendar2.set(2, nArray[2] - 1);
        calendar2.set(5, nArray[3]);
        calendar2.set(11, nArray[4] - 1);
        calendar2.set(12, nArray[5] - 1);
        calendar2.set(13, nArray[6] - 1);
        calendar2.set(14, 0);
        Timestamp timestamp = new Timestamp(calendar2.getTime().getTime());
        return timestamp;
    }

    @DisableTrace
    public static String toString(byte[] byArray) {
        int n2;
        if (byArray == null || byArray.length == 0) {
            return new String();
        }
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = byArray[n2] < 0 ? byArray[n2] + 256 : byArray[n2];
        }
        n2 = TIMESTAMP.getJavaYear(nArray[0], nArray[1]);
        int n3 = nArray[2];
        int n4 = nArray[3];
        int n5 = nArray[4] - 1;
        int n6 = nArray[5] - 1;
        int n7 = nArray[6] - 1;
        int n8 = -1;
        String string = TIMESTAMPTZ.toString(n2, n3, n4, n5, n6, n7, -1, null);
        return string;
    }

    @Override
    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Date date) {
        return DATE.toBytes(date, null);
    }

    public static byte[] toBytes(Time time) {
        return DATE.toBytes(time, null);
    }

    public static byte[] toBytes(Timestamp timestamp) {
        return DATE.toBytes(timestamp, null);
    }

    public static byte[] toBytes(Date date, Calendar calendar) {
        if (date == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.setTime(date);
        byte[] byArray = new byte[7];
        int n2 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        if (!OracleDriver.getSystemPropertyDateZeroTime()) {
            byArray[4] = (byte)(calendar2.get(11) + 1);
            byArray[5] = (byte)(calendar2.get(12) + 1);
            byArray[6] = (byte)(calendar2.get(13) + 1);
        } else {
            byArray[4] = 1;
            byArray[5] = 1;
            byArray[6] = 1;
        }
        return byArray;
    }

    public static byte[] toBytes(Time time, Calendar calendar) {
        if (time == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.setTime(time);
        byte[] byArray = new byte[]{119, -86, 1, 1, (byte)(calendar2.get(11) + 1), (byte)(calendar2.get(12) + 1), (byte)(calendar2.get(13) + 1)};
        return byArray;
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar calendar) {
        if (timestamp == null) {
            return null;
        }
        Calendar calendar2 = calendar == null ? Calendar.getInstance() : Calendar.getInstance(calendar.getTimeZone());
        calendar2.clear();
        calendar2.setTime(timestamp);
        byte[] byArray = new byte[7];
        int n2 = TIMESTAMP.getOracleYear(calendar2);
        byArray[0] = (byte)(n2 / 100 + 100);
        byArray[1] = (byte)(n2 % 100 + 100);
        byArray[2] = (byte)(calendar2.get(2) + 1);
        byArray[3] = (byte)calendar2.get(5);
        byArray[4] = (byte)(calendar2.get(11) + 1);
        byArray[5] = (byte)(calendar2.get(12) + 1);
        byArray[6] = (byte)(calendar2.get(13) + 1);
        return byArray;
    }

    public static byte[] toBytes(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = DATE.toBytes(Timestamp.valueOf(string));
        return byArray;
    }

    @DisableTrace
    public static byte[] toBytes(String string, Calendar calendar) {
        return DATE.toBytes(Timestamp.valueOf(string), calendar);
    }

    @Override
    @DisableTrace
    public Date dateValue() {
        return DATE.toDate(this.getBytes());
    }

    @Override
    @DisableTrace
    public Time timeValue() {
        return DATE.toTime(this.getBytes());
    }

    @Override
    public Timestamp timestampValue() {
        return DATE.toTimestamp(this.getBytes());
    }

    @DisableTrace
    public Date dateValue(Calendar calendar) {
        return DATE.toDate(this.getBytes(), calendar);
    }

    @Override
    @DisableTrace
    public Time timeValue(Calendar calendar) {
        return DATE.toTime(this.getBytes(), calendar);
    }

    @Override
    @DisableTrace
    public Timestamp timestampValue(Calendar calendar) {
        return DATE.toTimestamp(this.getBytes(), calendar);
    }

    @Override
    @DisableTrace
    public String stringValue() {
        return DATE.toString(this.getBytes());
    }

    @DisableTrace
    public String toString() {
        return this.stringValue();
    }

    @Override
    public Object toJdbc() {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int n2) {
        Timestamp[] timestampArray = new Timestamp[n2];
        return timestampArray;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return clazz.getName().compareTo("java.sql.Date") == 0 || clazz.getName().compareTo("java.sql.Time") == 0 || clazz.getName().compareTo("java.sql.Timestamp") == 0 || clazz.getName().compareTo("java.lang.String") == 0;
    }

    public DATE addJulianDays(int n2, int n3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxads(this.shareBytes(), n2, n3));
    }

    public DATE addMonths(int n2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxadm(this.shareBytes(), n2));
    }

    public DATE zeroTime() throws SQLException {
        byte[] byArray = this.toBytes();
        byArray[4] = 1;
        byArray[5] = 1;
        byArray[6] = 1;
        return new DATE(byArray);
    }

    public void diffInJulianDays(DATE dATE, int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxsub(this.shareBytes(), dATE.shareBytes(), nArray, nArray2);
    }

    public NUMBER diffInMonths(DATE dATE) throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxsbm(this.shareBytes(), dATE.shareBytes()));
    }

    public static DATE getCurrentDate() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxgdt());
    }

    public static int checkValidity(byte[] byArray) throws SQLException {
        return DATE._getLdxLib().ldxchk(byArray);
    }

    public static DATE fromJulianDays(int n2, int n3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxdfd(n2, n3));
    }

    public static DATE fromText(String string, String string2, String string3) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxstd(string, string2, string3));
    }

    public DATE lastDayOfMonth() throws SQLException {
        return new DATE(DATE._getLdxLib().ldxldd(this.shareBytes()));
    }

    public static void numberToJulianDays(NUMBER nUMBER, int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxftd(nUMBER.toBytes(), nArray, nArray2);
    }

    public DATE round(String string) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxrnd(this.shareBytes(), string));
    }

    public DATE setDayOfWeek(int n2) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxnxd(this.shareBytes(), n2));
    }

    public void toJulianDays(int[] nArray, int[] nArray2) throws SQLException {
        DATE._getLdxLib().ldxdtd(this.shareBytes(), nArray, nArray2);
    }

    public NUMBER toNumber() throws SQLException {
        return new NUMBER(DATE._getLdxLib().ldxdyf(this.shareBytes()));
    }

    public String toText(String string, String string2) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), string, string2);
    }

    public String toText(byte[] byArray, String string) throws SQLException {
        return DATE._getLdxLib().ldxdts(this.shareBytes(), byArray, string);
    }

    public static byte[] parseFormat(String string, String string2) throws SQLException {
        return DATE._getLdxLib().ldxsto(string, string2);
    }

    public DATE truncate(String string) throws SQLException {
        return new DATE(DATE._getLdxLib().ldxtrn(this.shareBytes(), string));
    }

    public int compareTo(DATE dATE) {
        return DATE.compareBytes(this.shareBytes(), dATE.shareBytes());
    }

    private static byte[] _initDate() {
        byte[] byArray = new byte[]{119, -86, 1, 1, 1, 1, 1};
        return byArray;
    }

    private static LdxLib _getLdxLib() {
        if (_sldxlib == null) {
            _sldxlib = new LdxLibThin();
        }
        return _sldxlib;
    }

    private static void _printBytes(byte[] byArray) {
        System.out.println(DATE.toString(byArray));
    }
}

