/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.internal.OracleBfile;
import oracle.jdbc.internal.OracleBlob;
import oracle.jdbc.internal.OracleClob;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleDatumWithConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.LOB_HELPER})
public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;

    public static long hasPattern(BLOB bLOB, byte[] byArray, long l2) throws SQLException {
        return LobPlsqlUtil.hasPattern(bLOB, (Datum)bLOB, byArray, l2);
    }

    public static long hasPattern(OracleBlob oracleBlob, Datum datum, byte[] byArray, long l2) throws SQLException {
        return LobPlsqlUtil.hasPattern(oracleBlob.getInternalConnection(), datum, 2004, byArray, l2);
    }

    public static long isSubLob(BLOB bLOB, BLOB bLOB2, long l2) throws SQLException {
        return LobPlsqlUtil.isSubLob(bLOB, (Datum)bLOB, (Datum)bLOB2, l2);
    }

    public static long isSubLob(OracleBlob oracleBlob, Datum datum, Datum datum2, long l2) throws SQLException {
        return LobPlsqlUtil.isSubLob(oracleBlob.getInternalConnection(), datum, 2004, datum2, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(OracleClob oracleClob, char[] cArray, long l2) throws SQLException {
        if (cArray == null || l2 <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = oracleClob.getInternalConnection();
        long l3 = cArray.length;
        long l4 = LobPlsqlUtil.length(oracleConnection, oracleClob, 2005, oracleClob.isNCLOB());
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            Statement statement = null;
            try {
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := sys.dbms_lob.instr(:2, :3, :4); end;");
                statement.registerOutParameter(1, 2);
                if (oracleClob.isNCLOB()) {
                    statement.setFormOfUse(2, (short)2);
                    statement.setFormOfUse(3, (short)2);
                }
                statement.setClob(2, oracleClob);
                statement.setString(3, new String(cArray));
                statement.setLong(4, l2);
                statement.execute();
                long l5 = statement.getLong(1);
                return l5;
            }
            finally {
                statement.close();
                statement = null;
            }
        }
        int n2 = 0;
        long l6 = l2;
        boolean bl2 = false;
        long l7 = 0L;
        while (!bl2) {
            if (l3 > l4 - l6 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            long l8 = LobPlsqlUtil.hasPattern(oracleClob, cArray2, l6);
            if (l8 == 0L) {
                return 0L;
            }
            l7 = l8;
            n2 += n3;
            l6 = l8 + (long)n3;
            boolean bl3 = true;
            while (bl3) {
                n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
                cArray2 = new char[n3];
                System.arraycopy(cArray, n2, cArray2, 0, n3);
                l8 = LobPlsqlUtil.hasPattern(oracleClob, cArray2, l6);
                if (l8 == l6) {
                    l6 += (long)n3;
                    if ((long)(n2 += n3) != l3) continue;
                    bl3 = false;
                    bl2 = true;
                    continue;
                }
                if (l8 == 0L) {
                    return 0L;
                }
                l6 = l8 - (long)n2;
                bl3 = false;
            }
        }
        return l7;
    }

    public static long isSubLob(OracleClob oracleClob, OracleClob oracleClob2, long l2) throws SQLException {
        if (oracleClob2 == null || l2 <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = oracleClob.getInternalConnection();
        long l3 = LobPlsqlUtil.length(oracleConnection, oracleClob2, 2005, oracleClob2.isNCLOB());
        long l4 = LobPlsqlUtil.length(oracleConnection, oracleClob, 2005, oracleClob.isNCLOB());
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            char[] cArray = new char[(int)l3];
            oracleClob2.getChars(1L, (int)l3, cArray);
            return LobPlsqlUtil.hasPattern(oracleClob, cArray, l2);
        }
        int n2 = 0;
        long l5 = l2;
        boolean bl2 = false;
        long l6 = 0L;
        while (!bl2) {
            if (l3 > l4 - l5 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
            char[] cArray = new char[n3];
            oracleClob2.getChars(n2 + 1, n3, cArray);
            long l7 = LobPlsqlUtil.hasPattern(oracleClob, cArray, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n2 += n3;
            l5 = l7 + (long)n3;
            boolean bl3 = true;
            while (bl3) {
                n3 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l3 - (long)n2);
                cArray = new char[n3];
                oracleClob2.getChars(n2 + 1, n3, cArray);
                l7 = LobPlsqlUtil.hasPattern(oracleClob, cArray, l5);
                if (l7 == l5) {
                    l5 += (long)n3;
                    if ((long)(n2 += n3) != l3) continue;
                    bl3 = false;
                    bl2 = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n2;
                bl3 = false;
            }
        }
        return l6;
    }

    public static long hasPattern(BFILE bFILE, byte[] byArray, long l2) throws SQLException {
        return LobPlsqlUtil.hasPattern(bFILE, (Datum)bFILE, byArray, l2);
    }

    public static long hasPattern(OracleBfile oracleBfile, Datum datum, byte[] byArray, long l2) throws SQLException {
        return LobPlsqlUtil.hasPattern(oracleBfile.getInternalConnection(), datum, -13, byArray, l2);
    }

    public static long isSubLob(BFILE bFILE, BFILE bFILE2, long l2) throws SQLException {
        return LobPlsqlUtil.isSubLob(bFILE, (Datum)bFILE, (Datum)bFILE2, l2);
    }

    public static long isSubLob(OracleBfile oracleBfile, Datum datum, Datum datum2, long l2) throws SQLException {
        return LobPlsqlUtil.isSubLob(oracleBfile.getInternalConnection(), datum, -13, datum2, l2);
    }

    public static String fileGetName(OracleBfile oracleBfile) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleBfile.getInternalConnection().prepareCall("begin sys.dbms_lob.fileGetName(:1, :2, :3); end; ");
            oracleCallableStatement.setObject(1, (Object)oracleBfile);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(3);
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
        }
        return string;
    }

    public static String fileGetDirAlias(OracleBfile oracleBfile) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleBfile.getInternalConnection().prepareCall("begin sys.dbms_lob.fileGetName(:1, :2, :3); end; ");
            oracleCallableStatement.setObject(1, (Object)oracleBfile);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2);
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
        }
        return string;
    }

    private static int getPlsqlMaxInstrSize(OracleConnection oracleConnection) throws SQLException {
        boolean bl2 = oracleConnection.isCharSetMultibyte(oracleConnection.getDriverCharSet());
        int n2 = oracleConnection.getMaxCharbyteSize();
        int n3 = 32512;
        if (bl2) {
            n3 = 32512 / (oracleConnection.getC2SNlsRatio() * n2);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long read(OracleConnection oracleConnection, Datum datum, int n2, long l2, long l3, byte[] byArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n3 = 0;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin sys.dbms_lob.read (:1, :2, :3, :4); end;");
            int n4 = 0;
            int n5 = 0;
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
                oracleCallableStatement.setFormOfUse(4, (short)2);
            }
            oracleCallableStatement.setObject(1, (Object)datum, n2);
            oracleCallableStatement.registerOutParameter(2, 2);
            oracleCallableStatement.registerOutParameter(4, -3);
            while ((long)n3 < l3) {
                n5 = Math.min((int)l3, 32512);
                oracleCallableStatement.setInt(2, n5);
                oracleCallableStatement.setInt(3, (int)l2 + n3);
                oracleCallableStatement.execute();
                n4 = oracleCallableStatement.getInt(2);
                byte[] byArray2 = oracleCallableStatement.getBytes(4);
                n4 = Math.min(n4, byArray2.length);
                System.arraycopy(byArray2, 0, byArray, n3, n4);
                n3 += n4;
                l3 -= (long)n4;
            }
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() != 1403) {
                throw sQLException;
            }
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long length(OracleConnection oracleConnection, OracleDatumWithConnection oracleDatumWithConnection, int n2, boolean bl2) throws SQLException {
        long l2 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := sys.dbms_lob.getLength (:2); end;");
            if (bl2) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setObject(2, (Object)oracleDatumWithConnection, n2);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l2 = oracleCallableStatement.getLong(1);
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long length(OracleConnection oracleConnection, Datum datum, int n2) throws SQLException {
        long l2 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := sys.dbms_lob.getLength (:2); end;");
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setObject(2, (Object)datum, n2);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l2 = oracleCallableStatement.getLong(1);
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long hasPattern(OracleConnection oracleConnection, Datum datum, int n2, byte[] byArray, long l2) throws SQLException {
        if (byArray == null || l2 <= 0L) {
            return 0L;
        }
        long l3 = byArray.length;
        long l4 = LobPlsqlUtil.length(oracleConnection, datum, n2);
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= 32512L) {
            Statement statement = null;
            try {
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := sys.dbms_lob.instr(:2, :3, :4); end;");
                statement.registerOutParameter(1, 2);
                statement.setObject(2, datum, n2);
                statement.setBytes(3, byArray);
                statement.setLong(4, l2);
                statement.execute();
                long l5 = statement.getLong(1);
                return l5;
            }
            finally {
                statement.close();
                statement = null;
            }
        }
        int n3 = 0;
        long l6 = l2;
        boolean bl2 = false;
        long l7 = 0L;
        while (!bl2) {
            if (l3 > l4 - l6 + 1L) {
                return 0L;
            }
            n3 = 0;
            int n4 = (int)Math.min(32512L, l3 - (long)n3);
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            long l8 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n2, byArray2, l6);
            if (l8 == 0L) {
                return 0L;
            }
            l7 = l8;
            n3 += n4;
            l6 = l8 + (long)n4;
            boolean bl3 = true;
            while (bl3) {
                n4 = (int)Math.min(32512L, l3 - (long)n3);
                byArray2 = new byte[n4];
                System.arraycopy(byArray, n3, byArray2, 0, n4);
                l8 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n2, byArray2, l6);
                if (l8 == l6) {
                    l6 += (long)n4;
                    if ((long)(n3 += n4) != l3) continue;
                    bl3 = false;
                    bl2 = true;
                    continue;
                }
                if (l8 == 0L) {
                    return 0L;
                }
                l6 = l8 - (long)n3;
                bl3 = false;
            }
        }
        return l7;
    }

    public static long isSubLob(OracleConnection oracleConnection, Datum datum, int n2, Datum datum2, long l2) throws SQLException {
        if (datum2 == null || l2 <= 0L) {
            return 0L;
        }
        long l3 = LobPlsqlUtil.length(oracleConnection, datum2, n2);
        long l4 = LobPlsqlUtil.length(oracleConnection, datum, n2);
        if (l3 == 0L || l3 > l4 - l2 + 1L || l2 > l4) {
            return 0L;
        }
        if (l3 <= 32512L) {
            byte[] byArray = new byte[(int)l3];
            LobPlsqlUtil.read(oracleConnection, datum2, n2, 1L, l3, byArray);
            return LobPlsqlUtil.hasPattern(oracleConnection, datum, n2, byArray, l2);
        }
        int n3 = 0;
        long l5 = l2;
        boolean bl2 = false;
        long l6 = 0L;
        while (!bl2) {
            if (l3 > l4 - l5 + 1L) {
                return 0L;
            }
            n3 = 0;
            int n4 = (int)Math.min(32512L, l3 - (long)n3);
            byte[] byArray = new byte[n4];
            LobPlsqlUtil.read(oracleConnection, datum2, n2, n3 + 1, n4, byArray);
            long l7 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n2, byArray, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n3 += n4;
            l5 = l7 + (long)n4;
            boolean bl3 = true;
            while (bl3) {
                n4 = (int)Math.min(32512L, l3 - (long)n3);
                byArray = new byte[n4];
                LobPlsqlUtil.read(oracleConnection, datum2, n2, n3 + 1, n4, byArray);
                l7 = LobPlsqlUtil.hasPattern(oracleConnection, datum, n2, byArray, l5);
                if (l7 == l5) {
                    l5 += (long)n4;
                    if ((long)(n3 += n4) != l3) continue;
                    bl3 = false;
                    bl2 = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n3;
                bl3 = false;
            }
        }
        return l6;
    }

    private static boolean isNCLOB(Datum datum) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (!clazz.isInstance(datum)) {
            return false;
        }
        CLOB cLOB = (CLOB)datum;
        return cLOB.isNCLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Datum createTemporaryLob(Connection connection, boolean bl2, int n2, int n3, short s2) throws SQLException {
        Statement statement = null;
        Datum datum = null;
        try {
            statement = (OracleCallableStatement)connection.prepareCall("begin sys.dbms_lob.createTemporary (:1," + (bl2 ? "TRUE" : "FALSE") + ", :2); end;");
            statement.registerOutParameter(1, n3);
            statement.setFormOfUse(1, s2);
            statement.setInt(2, n2);
            statement.execute();
            datum = statement.getOracleObject(1);
        }
        finally {
            if (statement != null) {
                statement.close();
                statement = null;
            }
        }
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTemporaryLob(Connection connection, Datum datum, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin sys.dbms_lob.freeTemporary (:1); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            Datum datum2 = oracleCallableStatement.getOracleObject(1);
            byte[] byArray = datum2.shareBytes();
            datum.setShareBytes(byArray);
        }
        finally {
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
        }
    }
}

