/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.AttributeDescriptor;
import oracle.sql.ConcreteProxyUtil;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.OBJECT_METADATA})
public class StructDescriptor
extends TypeDescriptor
implements Serializable,
OracleTypeMetaData.Struct {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(string, connection, false, false);
    }

    private static boolean isValidObject(String string, Connection connection) throws SQLException {
        oracle.jdbc.OracleConnection oracleConnection = (oracle.jdbc.OracleConnection)connection;
        while (oracleConnection.unwrap() != null) {
            oracleConnection = oracleConnection.unwrap();
        }
        TypeDescriptor typeDescriptor = TypeDescriptor.getTypeDescriptor(string, oracleConnection = ConcreteProxyUtil.unwrapConnectionProxy(oracleConnection));
        return typeDescriptor.getTypeCode() == 2002 || typeDescriptor.getTypeCode() == 2008;
    }

    public static StructDescriptor createDescriptor(String string, Connection connection, boolean bl2, boolean bl3) throws SQLException {
        if (string == null || string.length() == 0 || connection == null || !StructDescriptor.isValidObject(string, connection)) {
            throw (SQLException)DatabaseError.createSqlException(60, "Invalid arguments").fillInStackTrace();
        }
        connection = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)connection);
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        String string2 = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl3 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string2)) == null) {
            short s2 = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().getVersionNumber();
            structDescriptor = s2 >= 12000 ? new StructDescriptor(string, connection) : new StructDescriptor(sQLName, connection);
            if (bl2) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string2, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl2, boolean bl3) throws SQLException {
        connection = ConcreteProxyUtil.unwrapConnectionProxy((oracle.jdbc.OracleConnection)connection);
        String string = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl3 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string)) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            if (bl2) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT oracleTypeADT) throws SQLException {
        String string = oracleTypeADT.getFullName();
        oracle.jdbc.OracleConnection oracleConnection = oracleTypeADT.getConnection();
        StructDescriptor structDescriptor = (StructDescriptor)(oracleConnection = ConcreteProxyUtil.unwrapConnectionProxy(oracleConnection)).getDescriptor(string);
        if (structDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getSchemaName(), oracleTypeADT.getSimpleName(), oracleTypeADT.getConnection());
            structDescriptor = new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
            oracleConnection.putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n2, byte[] byArray2, OracleConnection oracleConnection) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n2, byArray2, oracleConnection);
        return new StructDescriptor(sQLName, oracleTypeADT, (Connection)oracleConnection);
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, oracleTypeADT, connection);
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super((short)108, string, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super((short)108, sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super((short)108, sQLName, oracleTypeADT, connection);
        this.toid = oracleTypeADT.getTOID();
    }

    StructDescriptor(byte[] byArray, int n2, Connection connection) throws SQLException {
        super((short)108);
        this.toid = byArray;
        this.toidVersion = n2;
        this.setPhysicalConnectionOf(connection);
        this.initPickler();
    }

    StructDescriptor(AttributeDescriptor[] attributeDescriptorArray, Connection connection) throws SQLException {
        super((short)108);
        this.attributesDescriptor = attributeDescriptorArray;
        this.setPhysicalConnectionOf(connection);
        this.isTransient = true;
        this.initPickler();
        this.isInstanciable = Boolean.TRUE;
    }

    private void initPickler() throws SQLException {
        String string = null;
        try {
            if (this.isTransient) {
                string = this.getName();
                this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
            } else {
                string = this.typeNameByUser == null ? this.getName() : this.typeNameByUser;
                this.pickler = new OracleTypeADT(string, (Connection)this.connection);
                ((OracleTypeADT)this.pickler).init(this.connection);
                this.toid = ((OracleTypeADT)this.pickler).getTOID();
            }
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + string + "\"").fillInStackTrace();
        }
    }

    @Override
    public OracleTypeMetaData.Kind getKind() {
        return OracleTypeMetaData.Kind.STRUCT;
    }

    @Override
    public int getTypeCode() throws SQLException {
        int n2 = this.getOracleTypeADT().getTypeCode();
        return n2;
    }

    @Override
    public int getTypeVersion() throws SQLException {
        int n2 = this.getOracleTypeADT().getTypeVersion();
        return n2;
    }

    void setAttributesDescriptor(AttributeDescriptor[] attributeDescriptorArray) {
        this.attributesDescriptor = attributeDescriptorArray;
    }

    public AttributeDescriptor[] getAttributesDescriptor() {
        return this.attributesDescriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toBytes(OracleStruct oracleStruct, Datum datum, boolean bl2) throws SQLException {
        byte[] byArray = oracleStruct.shareBytes();
        if (byArray == null) {
            if (oracleStruct.getDatumArray() != null) {
                byArray = this.pickler.linearize(datum);
                if (bl2) return byArray;
                oracleStruct.setShareBytes(null);
                return byArray;
            } else {
                if (oracleStruct.getObjectArray() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                Datum[] datumArray = this.toOracleArray(oracleStruct.getObjectArray());
                if (datumArray == null) {
                    oracleStruct.setNullDatumArray();
                } else {
                    oracleStruct.setDatumArray(datumArray);
                }
                byArray = this.pickler.linearize(datum);
                if (bl2) return byArray;
                oracleStruct.setNullDatumArray();
                oracleStruct.setShareBytes(null);
            }
            return byArray;
        } else {
            if (oracleStruct.getImageLength() == 0L) return byArray;
            if (oracleStruct.getImageOffset() == 0L) {
                if (oracleStruct.getImageLength() == (long)byArray.length) return byArray;
            }
            byte[] byArray2 = new byte[(int)oracleStruct.getImageLength()];
            System.arraycopy(byArray, (int)oracleStruct.getImageOffset(), byArray2, 0, (int)oracleStruct.getImageLength());
            oracleStruct.setImage(byArray2, 0L, 0L);
            return byArray2;
        }
    }

    public Datum[] toOracleArray(OracleStruct oracleStruct, Datum datum, boolean bl2) throws SQLException {
        Datum[] datumArray = oracleStruct.getDatumArray();
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (oracleStruct.getObjectArray() != null) {
                datumArray = this.toOracleArray(oracleStruct.getObjectArray());
            } else if (oracleStruct.shareBytes() != null) {
                if ((oracleStruct.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(oracleStruct.shareBytes(), oracleStruct.getImageOffset(), datum, 1, null);
                datumArray = oracleStruct.getDatumArray();
                if (!bl2) {
                    oracleStruct.setNullDatumArray();
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        if (bl2) {
            if (datumArray == null) {
                oracleStruct.setNullDatumArray();
            } else {
                oracleStruct.setDatumArray(datumArray);
            }
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] toArray(OracleStruct oracleStruct, Datum datum, Map map, boolean bl2) throws SQLException {
        Object[] objectArray = null;
        if (oracleStruct.getObjectArray() != null) return (Object[])oracleStruct.getObjectArray().clone();
        if (oracleStruct.getDatumArray() != null) {
            Datum[] datumArray = oracleStruct.getDatumArray();
            objectArray = new Object[datumArray.length];
            int n2 = 0;
            while (n2 < datumArray.length) {
                if (datumArray[n2] != null) {
                    objectArray[n2] = datumArray[n2] instanceof STRUCT ? ((STRUCT)datumArray[n2]).toJdbc(map) : datumArray[n2].toJdbc();
                }
                ++n2;
            }
            return objectArray;
        }
        if (oracleStruct.shareBytes() == null) throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
        if ((oracleStruct.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
            this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
        }
        this.pickler.unlinearize(oracleStruct.shareBytes(), oracleStruct.getImageOffset(), datum, 2, map);
        objectArray = oracleStruct.getObjectArray();
        oracleStruct.setNullObjectArray();
        return objectArray;
    }

    @Override
    public int getLength() throws SQLException {
        return this.getFieldTypes().length;
    }

    public OracleTypeADT getOracleTypeADT() throws SQLException {
        if (this.pickler == null) {
            this.initPickler();
        }
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.pickler;
        return oracleTypeADT;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        return ((OracleTypeADT)this.pickler).getAttrTypes();
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        return this.toJdbc2SQLInput(sTRUCT, sTRUCT, map);
    }

    public SQLInput toJdbc2SQLInput(OracleStruct oracleStruct, Datum datum, Map map) throws SQLException {
        return new OracleJdbc2SQLInput(this.toOracleArray(oracleStruct, datum, false), map, this.connection);
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        return new OracleSQLOutput(this, this.connection);
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n2 = oracleTypeArray.length;
            if (objectArray.length > n2) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, null).fillInStackTrace();
            }
            datumArray = new Datum[objectArray.length];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                datumArray[i2] = oracleTypeArray[i2].toDatumInternal(objectArray[i2], oracleConnection);
            }
        }
        return datumArray;
    }

    public Datum[] toOracleArray(Map map) throws SQLException {
        Datum[] datumArray = null;
        int n2 = 0;
        if (map != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n3 = oracleTypeArray.length;
            int n4 = map.size();
            datumArray = new Datum[n3];
            OracleConnection oracleConnection = this.connection;
            for (int i2 = 0; i2 < n3; ++i2) {
                Object v2 = map.get(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1));
                datumArray[i2] = oracleTypeArray[i2].toDatum(v2, oracleConnection);
                if (v2 == null && !map.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i2 + 1))) continue;
                ++n2;
            }
            if (n2 < n4) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
            }
        }
        return datumArray;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.connection.newStructMetaData(this);
    }

    @Override
    public boolean isFinalType() throws SQLException {
        return this.getOracleTypeADT().isFinalType();
    }

    @Override
    public boolean isSubtype() throws SQLException {
        return this.getOracleTypeADT().isSubType();
    }

    @Override
    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl2 = false;
        if (string.equals(string2)) {
            bl2 = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl2 = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl2 = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, (Connection)this.connection);
            }
        }
        return bl2;
    }

    @Override
    public boolean isInstantiable() throws SQLException {
        if (this.isInstanciable == null) {
            this.isInstanciable = this.getOracleTypeADT().isInstanciable();
        }
        return this.isInstanciable;
    }

    public boolean isJavaObject() throws SQLException {
        return this.getOracleTypeADT().isJavaObject();
    }

    @Override
    public String getSupertypeName() throws SQLException {
        String string = null;
        if (this.isSubtype()) {
            if (this.supertype == null) {
                this.supertype = this.getOracleTypeADT().getSuperTypeName();
            }
            string = this.supertype;
        }
        return string;
    }

    @Override
    public int getLocalAttributeCount() throws SQLException {
        int n2;
        if (!this.isSubtype()) {
            n2 = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.numLocalAttrs == -1) {
                this.numLocalAttrs = this.getOracleTypeADT().getNumberOfLocalAttributes();
            }
            n2 = this.numLocalAttrs;
        }
        return n2;
    }

    @Override
    public String[] getSubtypeNames() throws SQLException {
        if (this.subtypes == null) {
            this.subtypes = this.getOracleTypeADT().getSubtypeNames();
        }
        return this.subtypes;
    }

    public String getJavaClassName() throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            string = StructDescriptor.getJavaObjectClassName(this.connection, this);
        }
        return string;
    }

    public String getAttributeJavaName(int n2) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.attrJavaNames[n2];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getLanguage() throws SQLException {
        String string = null;
        string = this.isJavaObject() ? "JAVA" : "SQL";
        return string;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        return StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        String string3;
        block9: {
            PreparedStatement preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
            oracleConnection.beginNonRequestCalls();
            if (((oracle.jdbc.OracleConnection)connection).isProxySession()) {
                string = TypeDescriptor.convToUpperCase(string);
            }
            try {
                preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, string2);
                resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    string3 = resultSet.getString(1);
                    break block9;
                }
                throw (SQLException)DatabaseError.createSqlException(100).fillInStackTrace();
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                oracleConnection.endNonRequestCalls();
            }
        }
        return string3;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n2) throws SQLException {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            TypeDescriptor typeDescriptor;
            int n4 = resultSetMetaData.getColumnType(i3 + 1);
            if (n4 == 2002 || n4 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            if (n4 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i3 + 1), (Connection)this.connection);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n2 + 1);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(resultSetMetaData.getColumnTypeName(i3 + 1));
            stringBuffer.append("\n");
        }
        return stringBuffer.substring(0);
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (byte[])null, this.connection);
        sTRUCT.setDatumArray(datumArray);
        return this.pickler.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.connection);
        return this.toOracleArray(sTRUCT, sTRUCT, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            if (this.attrJavaNames == null) {
                this.connection.beginNonRequestCalls();
                String[] stringArray = null;
                PreparedStatement preparedStatement = null;
                ResultSet resultSet = null;
                try {
                    preparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME, ATTR_NO from all_sqlj_type_attrs where owner = :1 and type_name = :2 order by ATTR_NO");
                    preparedStatement.setString(1, this.getSchemaName());
                    preparedStatement.setString(2, this.getTypeName());
                    resultSet = preparedStatement.executeQuery();
                    stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                    int n2 = 0;
                    while (resultSet.next()) {
                        stringArray[resultSet.getInt((int)2) - 1] = resultSet.getString(1);
                        ++n2;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.connection.endNonRequestCalls();
                }
                this.attrJavaNames = stringArray;
            }
        }
    }

    @Override
    String tagName() {
        return "StructDescriptor";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

