/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import oracle.sql.OffsetDST;
import oracle.sql.TRANSDUMP;

public class TIMEZONETAB {
    private static int OFFSET_HOUR = 20;
    private static int OFFSET_MINUTE = 60;
    private static int HOUR_MILLISECOND = 3600000;
    private static int MINUTE_MILLISECOND = 60000;
    private static int BYTE_SIZE = 10;
    private final Hashtable zonetab = new Hashtable();
    private static Map<Integer, TIMEZONETAB> instanceCache = new ConcurrentHashMap<Integer, TIMEZONETAB>(5);
    private int instanceCount = 0;
    private int versionNumber = 0;

    private TIMEZONETAB(int n2) {
        this.versionNumber = n2;
    }

    public static TIMEZONETAB getInstance(int n2) throws SQLException {
        TIMEZONETAB tIMEZONETAB = instanceCache.computeIfAbsent(n2, TIMEZONETAB::new);
        return tIMEZONETAB.returnInstance();
    }

    private synchronized TIMEZONETAB returnInstance() {
        ++this.instanceCount;
        instanceCache.put(this.versionNumber, this);
        return this;
    }

    public synchronized void freeInstance() throws SQLException {
        --this.instanceCount;
        if (this.instanceCount < 1) {
            instanceCache.remove(this.versionNumber);
        }
    }

    public void addTrans(byte[] byArray, int n2) {
        int[] nArray = new int[BYTE_SIZE];
        int n3 = byArray[0] & 0xFF;
        OffsetDST[] offsetDSTArray = new OffsetDST[n3];
        int n4 = 0;
        for (int i2 = 1; i2 < n3 * BYTE_SIZE; i2 += BYTE_SIZE) {
            int n5;
            for (n5 = 0; n5 < BYTE_SIZE; ++n5) {
                nArray[n5] = byArray[n5 + i2] & 0xFF;
            }
            n5 = (nArray[0] - 100) * 100 + (nArray[1] - 100);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            calendar.set(1, n5);
            calendar.set(2, nArray[2] - 1);
            calendar.set(5, nArray[3]);
            calendar.set(11, nArray[4] - 1);
            calendar.set(12, nArray[5] - 1);
            calendar.set(13, nArray[6] - 1);
            calendar.set(14, 0);
            long l2 = calendar.getTime().getTime();
            int n6 = (nArray[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (nArray[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
            byte by2 = (byte)nArray[9];
            offsetDSTArray[n4++] = new OffsetDST(new Timestamp(l2), n6, by2);
        }
        this.zonetab.put(n2 & 0x1FF, offsetDSTArray);
    }

    public byte getLocalOffset(Calendar calendar, int n2, OffsetDST offsetDST) throws SQLException {
        byte by2;
        block13: {
            byte by3;
            byte by4;
            boolean bl2 = false;
            boolean bl3 = false;
            by2 = 0;
            Calendar calendar2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar calendar3 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            Calendar calendar4 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            calendar4.set(1, calendar.get(1));
            calendar4.set(2, calendar.get(2));
            calendar4.set(5, calendar.get(5));
            calendar4.set(11, calendar.get(11));
            calendar4.set(12, calendar.get(12));
            calendar4.set(13, calendar.get(13));
            calendar4.set(14, calendar.get(14));
            Calendar calendar5 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
            calendar5.set(1, calendar4.get(1));
            calendar5.set(2, calendar4.get(2));
            calendar5.set(5, 1);
            calendar5.set(11, 0);
            calendar5.set(12, 0);
            calendar5.set(13, 0);
            calendar5.set(14, 0);
            OffsetDST[] offsetDSTArray = (OffsetDST[])this.zonetab.get(n2 & 0x1FF);
            int n3 = this.findCloseMatch(offsetDSTArray, calendar5.getTimeInMillis());
            while (true) {
                calendar2.setTime(offsetDSTArray[n3].getTimestamp());
                int n4 = offsetDSTArray[n3].getOFFSET();
                calendar2.add(10, n4 / HOUR_MILLISECOND);
                calendar2.add(12, n4 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                by4 = offsetDSTArray[n3].getDSTFLAG();
                if (calendar4.equals(calendar2)) {
                    offsetDST.setOFFSET(offsetDSTArray[n3].getOFFSET());
                    offsetDST.setDSTFLAG(offsetDSTArray[n3].getDSTFLAG());
                    by2 = 0;
                    if (n3 > 0) {
                        by3 = offsetDSTArray[n3 - 1].getDSTFLAG();
                        if (by4 == 0 && by3 == 1) {
                            by2 = 1;
                        }
                    }
                    break block13;
                }
                if (calendar4.before(calendar2)) {
                    if (n3 == 0) {
                        offsetDST.setOFFSET(0);
                        offsetDST.setDSTFLAG((byte)0);
                        by2 = 0;
                        if (by4 == 1) {
                            calendar2.add(10, -1);
                            if (!calendar4.before(calendar2)) {
                                throw new SQLException("Illegal local time.");
                            }
                        }
                        break block13;
                    }
                    if (--n3 < 0) continue;
                    by3 = offsetDSTArray[n3].getDSTFLAG();
                    if (by4 != 1 || by3 != 0) continue;
                    calendar2.add(10, -1);
                    if (calendar4.before(calendar2)) continue;
                    throw new SQLException("Illegal local time.");
                }
                if (n3 == offsetDSTArray.length - 1) break;
                calendar3.setTime(offsetDSTArray[n3 + 1].getTimestamp());
                int n5 = offsetDSTArray[n3 + 1].getOFFSET();
                calendar3.add(10, n5 / HOUR_MILLISECOND);
                calendar3.add(12, n5 % HOUR_MILLISECOND / MINUTE_MILLISECOND);
                if (calendar4.before(calendar3)) break;
                ++n3;
            }
            offsetDST.setOFFSET(offsetDSTArray[n3].getOFFSET());
            offsetDST.setDSTFLAG(offsetDSTArray[n3].getDSTFLAG());
            by2 = 0;
            if (by4 == 0) {
                if (n3 > 0 && (by3 = offsetDSTArray[n3 - 1].getDSTFLAG()) == 1) {
                    calendar2.add(10, 1);
                    if (calendar4.before(calendar2)) {
                        by2 = 1;
                    }
                }
                if (n3 != offsetDSTArray.length - 1 && (by3 = offsetDSTArray[n3 + 1].getDSTFLAG()) == 1) {
                    calendar3.add(10, -1);
                    if (!calendar4.before(calendar3)) {
                        throw new SQLException("Illegal local time.");
                    }
                }
            }
        }
        return by2;
    }

    public int getOffset(Calendar calendar, int n2) throws SQLException {
        OffsetDST[] offsetDSTArray = (OffsetDST[])this.zonetab.get(n2 & 0x1FF);
        return this.getOffset(calendar, offsetDSTArray);
    }

    public int getOffset(long l2, int n2) throws SQLException {
        OffsetDST[] offsetDSTArray = (OffsetDST[])this.zonetab.get(n2 & 0x1FF);
        int n3 = this.findCloseMatch(offsetDSTArray, l2);
        return offsetDSTArray[n3].getOFFSET();
    }

    public int getOffset(Calendar calendar, OffsetDST[] offsetDSTArray) throws SQLException {
        boolean bl2 = false;
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        int n2 = this.findCloseMatch(offsetDSTArray, timestamp.getTime());
        return offsetDSTArray[n2].getOFFSET();
    }

    public boolean isDST(Calendar calendar, OffsetDST[] offsetDSTArray) throws SQLException {
        boolean bl2 = false;
        Timestamp timestamp = new Timestamp(calendar.getTime().getTime());
        int n2 = this.findCloseMatch(offsetDSTArray, timestamp.getTime());
        return offsetDSTArray[n2].getDSTFLAG() == 1;
    }

    public OffsetDST[] getOffsetDST(int n2) {
        OffsetDST[] offsetDSTArray = (OffsetDST[])this.zonetab.get(n2 & 0x1FF);
        return offsetDSTArray;
    }

    final int findCloseMatch(OffsetDST[] offsetDSTArray, long l2) {
        int n2;
        int n3 = offsetDSTArray.length;
        int n4 = 0;
        int n5 = n2 = n3 / 2;
        if (l2 < offsetDSTArray[n4].getTime()) {
            int n6;
            for (n6 = 0; offsetDSTArray[n6].getDSTFLAG() == 1 && n6 < offsetDSTArray.length; ++n6) {
            }
            return n6 < offsetDSTArray.length ? n6 : 0;
        }
        while (n2 > 0) {
            if (l2 > offsetDSTArray[n2].getTime()) {
                n4 = n2;
            } else if (l2 < offsetDSTArray[n2].getTime()) {
                n3 = n2;
            } else if (n2 == n4) break;
            n2 = n4 + (n3 - n4) / 2;
            if (n5 == n2) break;
            n5 = n2;
        }
        return n2;
    }

    public void displayTable(int n2) {
        OffsetDST[] offsetDSTArray = (OffsetDST[])this.zonetab.get(n2 & 0x1FF);
        if (offsetDSTArray == null) {
            return;
        }
        for (OffsetDST offsetDST : offsetDSTArray) {
            System.out.print(offsetDST.getTimestamp().toString());
            System.out.print("    " + offsetDST.getOFFSET());
            System.out.println("    " + offsetDST.getDSTFLAG());
        }
    }

    public boolean checkID(int n2) {
        return this.zonetab.get(n2 & 0x1FF) == null;
    }

    public void updateTable(Connection connection, int n2) throws SQLException, NullPointerException {
        byte[] byArray = TRANSDUMP.getTransitions(connection, n2);
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.addTrans(byArray, n2);
    }
}

