/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.actors;

import java.lang.reflect.Executable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.logging.Logger;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Chain;
import oracle.ucp.util.ListChain;
import oracle.ucp.util.Pair;

public class InterruptableActor<R, D, E extends Throwable> {
    private static final int DEFAULT_AWAIT_TIMEOUT = 10;
    private static final int DEFAULT_POLL_COUNT = 10;
    private static final int DEFAULT_POLL_TIMEOUT = 1;
    private final int awaitTimeout;
    private final int pollCount;
    private final int pollTimeout;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ListChain<Pair<Action<R, D, E>, Thread>> chain = new ListChain();
    private final AtomicReference<Predicate<Pair<Action<R, D, E>, Thread>>> predicate = new AtomicReference<Predicate<Pair>>(pair -> false);
    private final Thread controlThread;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;

    private Thread buildControlThread() {
        return new Thread(() -> {
            block7: while (true) {
                try {
                    this.lock.lock();
                    this.condition.await(this.awaitTimeout, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
                }
                finally {
                    this.lock.unlock();
                }
                int n2 = 0;
                while (true) {
                    if (n2 >= this.pollCount) continue block7;
                    this.interruptAllAppropriateActions();
                    try {
                        Thread.sleep((long)this.pollTimeout * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
                    }
                    ++n2;
                }
                break;
            }
        }, InterruptableActor.class.getName() + "-control");
    }

    private void interruptAllAppropriateActions() {
        this.chain.forEach(pair -> {
            if (this.predicate.get().test((Pair<Action<R, D, E>, Thread>)pair)) {
                ClioSupport.ilogFinest(null, null, null, null, "about to interrupt:" + pair.get2nd());
                ((Thread)pair.get2nd()).interrupt();
            }
        });
    }

    public InterruptableActor(int n2, int n3, int n4) {
        this.awaitTimeout = n2;
        this.pollCount = n3;
        this.pollTimeout = n4;
        this.controlThread = this.buildControlThread();
        this.controlThread.setDaemon(true);
        this.controlThread.start();
    }

    public InterruptableActor() {
        this(10, 10, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R doAction(Action<R, D, E> action) throws E {
        Chain.Atom atom = this.chain.add((Object)new Pair<Action<R, D, E>, Thread>(action, Thread.currentThread()));
        try {
            R r2 = action.exec();
            return r2;
        }
        catch (InterruptedException interruptedException) {
            ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
            R r3 = null;
            return r3;
        }
        finally {
            ((ListChain.Atom)atom).remove();
        }
    }

    public void registerPredicate(Predicate<Pair<Action<R, D, E>, Thread>> predicate) {
        this.predicate.set(predicate);
    }

    public void triggerInterrupts() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    static {
        try {
            $$$methodRef$$$9 = InterruptableActor.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = InterruptableActor.class.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = InterruptableActor.class.getDeclaredMethod("lambda$new$0", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = InterruptableActor.class.getDeclaredMethod("lambda$buildControlThread$1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = InterruptableActor.class.getDeclaredMethod("lambda$interruptAllAppropriateActions$2", Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = InterruptableActor.class.getDeclaredMethod("triggerInterrupts", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = InterruptableActor.class.getDeclaredMethod("registerPredicate", Predicate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = InterruptableActor.class.getDeclaredMethod("doAction", Action.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = InterruptableActor.class.getDeclaredMethod("interruptAllAppropriateActions", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = InterruptableActor.class.getDeclaredMethod("buildControlThread", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }

    public static interface Action<R, D, E extends Throwable> {
        public R exec() throws InterruptedException, E;

        default public D getDescriptor() {
            return null;
        }
    }
}

