/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.admin;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dms.console.DMSConsole;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.State;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.admin.MetricsUpdateTimerTask;
import oracle.ucp.admin.UniversalConnectionPoolManager;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPoolStatistics;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskManagerImpl;
import oracle.ucp.util.UCPTimerManagerImpl;
import oracle.ucp.util.UniqueIdentifier;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

@DefaultLogger(value="oracle.ucp.admin")
@Supports(value={Feature.ADMIN})
public abstract class UniversalConnectionPoolManagerBase
implements UniversalConnectionPoolManager {
    private static final boolean DEFAULT_IS_JMX_ENABLED = true;
    private static final boolean DEFAULT_LOCAL_METRIC_CONSOLE = true;
    private static final int DEFAULT_METRIC_UPDATE_INTERVAL = 60;
    private boolean m_jmxFlag = true;
    private boolean m_localMetricConsole = true;
    private int m_metricInterval = 60;
    private static final String UCP_METRIC_NAME = "/UCP_METRIC";
    private static final String MGR_PREFIX;
    private DMSConsole m_metricConsole = null;
    private TimerHandle m_updateMetricTimer = null;
    private boolean m_metricsPostingThread = false;
    protected final Map<String, UniversalConnectionPool> m_connPool = Collections.synchronizedMap(new HashMap());
    protected final Map<String, String> m_mappedPoolNames = new HashMap<String, String>();
    private static final Map<UCPMetric, String> m_ucpMetrics;
    private final Hashtable<String, NounIntf> m_parentNouns = new Hashtable();
    private final ArrayList<String> m_metricPools = new ArrayList();
    static final String TOTAL_CONN_NAME = "TotalConnectionsCount";
    static final String TOTAL_CONN_UNITS = "ConnectionsCount";
    static final String TOTAL_CONN_DESC = "Total number of connections in the pool";
    static final String AVAILABLE_CONN_NAME = "AvailableConnectionsCount";
    static final String AVAILABLE_CONN_UNITS = "ConnectionsCount";
    static final String AVAILABLE_CONN_DESC = "Total number of available connections in the pool";
    static final String BORROWED_CONN_NAME = "BorrowedConnectionsCount";
    static final String BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String BORROWED_CONN_DESC = "Total number of borrowed connections in the pool";
    static final String AVERAGE_BORROWED_CONN_NAME = "AverageBorrowedConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_UNITS = "ConnectionsCount";
    static final String AVERAGE_BORROWED_CONN_DESC = "Average count for borrowed connections in the pool";
    static final String PEAK_CONN_NAME = "PeakConnectionsCount";
    static final String PEAK_CONN_UNITS = "ConnectionsCount";
    static final String PEAK_CONN_DESC = "Peak connections count in the pool";
    static final String REMAINING_CONN_NAME = "RemainingPoolCapacityCount";
    static final String REMAINING_CONN_UNITS = "ConnectionsCount";
    static final String REMAINING_CONN_DESC = "Remaining pool capacity count for the pool";
    static final String LABELED_CONN_NAME = "LabeledConnectionsCount";
    static final String LABELED_CONN_UNITS = "ConnectionsCount";
    static final String LABELED_CONN_DESC = "Total number of labeled connections in the pool";
    static final String CREATED_CONN_NAME = "ConnectionsCreatedCount";
    static final String CREATED_CONN_UNITS = "ConnectionsCount";
    static final String CREATED_CONN_DESC = "Total number of connections created in the pool";
    static final String CLOSED_CONN_NAME = "ConnectionsClosedCount";
    static final String CLOSED_CONN_UNITS = "ConnectionsCount";
    static final String CLOSED_CONN_DESC = "Total number of closed connections in the pool";
    static final String AVG_CONN_WAIT_NAME = "AverageConnectionWaitTime";
    static final String AVG_CONN_WAIT_UNITS = "Seconds";
    static final String AVG_CONN_WAIT_DESC = "Average connection wait time in the pool";
    static final String PEAK_CONN_WAIT_NAME = "PeakConnectionWaitTime";
    static final String PEAK_CONN_WAIT_UNITS = "Seconds";
    static final String PEAK_CONN_WAIT_DESC = "Peak Connection wait time in the pool";
    static final String ABANDONED_CONN_NAME = "AbandonedConnectionsCount";
    static final String ABANDONED_CONN_UNITS = "ConnectionsCount";
    static final String ABANDONED_CONN_DESC = "Total number of abandoned connections in the pool";
    static final String PENDING_REQUEST_NAME = "PendingRequestsCount";
    static final String PENDING_REQUEST_UNITS = "ConnectionsCount";
    static final String PENDING_REQUEST_DESC = "Total number of pending requests count in the pool";
    static final String CUMULATIVE_CONN_WAIT_NAME = "CumulativeConnectionWaitTime";
    static final String CUMULATIVE_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_WAIT_DESC = "Cumulative connection wait time for the pool";
    static final String CUMULATIVE_CONN_BORROWED_NAME = "CumulativeConnectionBorrowedCount";
    static final String CUMULATIVE_CONN_BORROWED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_BORROWED_DESC = "Cumulative connection borrowed count for the pool";
    static final String CUMULATIVE_CONN_USE_NAME = "CumulativeConnectionUseTime";
    static final String CUMULATIVE_CONN_USE_UNITS = "Seconds";
    static final String CUMULATIVE_CONN_USE_DESC = "Cumulative connection use time for the pool";
    static final String CUMULATIVE_CONN_RETURNED_NAME = "CumulativeConnectionReturnedCount";
    static final String CUMULATIVE_CONN_RETURNED_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_CONN_RETURNED_DESC = "Cumulative connection returned count in the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_NAME = "CumulativeSuccessfulConnectionWaitTime";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_DESC = "Cumulative successful connection wait time for the pool";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME = "CumulativeSuccessfulConnectionWaitCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC = "Cumulative successful connection wait count for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_NAME = "CumulativeFailedConnectionWaitTime";
    static final String CUMULATIVE_FAILED_CONN_WAIT_UNITS = "Seconds";
    static final String CUMULATIVE_FAILED_CONN_WAIT_DESC = "Cumulative failed connection wait time for the pool";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME = "CumulativeFailedConnectionWaitCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_UNITS = "ConnectionsCount";
    static final String CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC = "Cumulative failed connection wait count for the pool";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME = "SuccessfulAffinityBasedBorrowCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded with matching affinity contexts.";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_NAME = "FailedAffinityBasedBorrowCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_AFFINITYBASED_BORROW_COUNT_DESC = "Number of borrow requests that returned connections not matching the affinity contexts.";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME = "SuccessfulRCLBBasedBorrowCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests succeeded using Runtime Connection Load-Balancing (RCLB) algorithms.";
    static final String FAILED_RCLBBASED_BORROW_COUNT_NAME = "FailedRCLBBasedBorrowCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_UNITS = "ConnectionsCount";
    static final String FAILED_RCLBBASED_BORROW_COUNT_DESC = "Number of borrow requests failed using Runtime Connection Load-Balancing (RCLB) algorithms.";
    private static TimerManager m_timerManager;
    private static TaskManager m_taskManager;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;

    @Override
    public void startConnectionPool(String string) throws UniversalConnectionPoolException {
        UniversalConnectionPool universalConnectionPool;
        String string2 = this.getManagerPoolID(string);
        UniversalConnectionPool universalConnectionPool2 = universalConnectionPool = string2 != null ? this.m_connPool.get(string2) : null;
        if (universalConnectionPool != null) {
            universalConnectionPool.start();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void stopConnectionPool(String string) throws UniversalConnectionPoolException {
        UniversalConnectionPool universalConnectionPool;
        String string2 = this.getManagerPoolID(string);
        UniversalConnectionPool universalConnectionPool2 = universalConnectionPool = string2 != null ? this.m_connPool.get(string2) : null;
        if (universalConnectionPool != null) {
            universalConnectionPool.stop();
            if (this.m_metricPools.contains(string2)) {
                this.stopMetricsCollection(string);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void refreshConnectionPool(String string) throws UniversalConnectionPoolException {
        UniversalConnectionPool universalConnectionPool;
        String string2 = this.getManagerPoolID(string);
        UniversalConnectionPool universalConnectionPool2 = universalConnectionPool = string2 != null ? this.m_connPool.get(string2) : null;
        if (universalConnectionPool != null) {
            universalConnectionPool.refresh();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void recycleConnectionPool(String string) throws UniversalConnectionPoolException {
        UniversalConnectionPool universalConnectionPool;
        String string2 = this.getManagerPoolID(string);
        UniversalConnectionPool universalConnectionPool2 = universalConnectionPool = string2 != null ? this.m_connPool.get(string2) : null;
        if (universalConnectionPool != null) {
            universalConnectionPool.recycle();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    @Override
    public void purgeConnectionPool(String string) throws UniversalConnectionPoolException {
        UniversalConnectionPool universalConnectionPool;
        String string2 = this.getManagerPoolID(string);
        UniversalConnectionPool universalConnectionPool2 = universalConnectionPool = string2 != null ? this.m_connPool.get(string2) : null;
        if (universalConnectionPool != null) {
            universalConnectionPool.purge();
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyConnectionPool(String string) throws UniversalConnectionPoolException {
        if (string == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        try {
            this.stopConnectionPool(string);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
        }
        this.m_connPool.remove(this.getManagerPoolID(string));
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            this.m_mappedPoolNames.remove(string);
        }
    }

    @Override
    public void reconfigureConnectionPool(String string, Properties properties) throws UniversalConnectionPoolException {
        String string2 = this.getManagerPoolID(string);
        try {
            this.applyConfiguration(string2, properties);
        }
        catch (Exception exception) {
            UCPErrorHandler.throwUniversalConnectionPoolException(388, exception);
        }
    }

    private void applyConfiguration(String string, Properties properties) throws Exception {
        UniversalConnectionPoolBase universalConnectionPoolBase;
        UniversalConnectionPoolBase universalConnectionPoolBase2 = universalConnectionPoolBase = string != null ? (UniversalConnectionPoolBase)this.m_connPool.get(string) : null;
        if (universalConnectionPoolBase != null) {
            String string2 = null;
            try {
                block77: for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    switch (string2 = (String)entry.getKey()) {
                        case "user": 
                        case "password": 
                        case "url": 
                        case "connectionFactoryClassName": 
                        case "connectionFactoryProperties": 
                        case "connectionProperties": {
                            break;
                        }
                        case "initialPoolSize": {
                            universalConnectionPoolBase.setInitialPoolSize(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "minPoolSize": {
                            universalConnectionPoolBase.setMinPoolSize(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "maxPoolSize": {
                            universalConnectionPoolBase.setMaxPoolSize(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "maxConnectionReuseCount": {
                            universalConnectionPoolBase.setMaxConnectionReuseCount(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "maxConnectionReuseTime": {
                            universalConnectionPoolBase.setMaxConnectionReuseTime(Long.parseLong((String)entry.getValue()));
                            break;
                        }
                        case "fastConnectionFailoverEnabled": {
                            universalConnectionPoolBase.setFailoverEnabled(Boolean.parseBoolean((String)entry.getValue()));
                            break;
                        }
                        case "abandonedConnectionTimeout": {
                            universalConnectionPoolBase.setAbandonedConnectionTimeout(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "connectionHarvestMaxCount": {
                            universalConnectionPoolBase.setConnectionHarvestMaxCount(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "connectionHarvestTriggerCount": {
                            universalConnectionPoolBase.setConnectionHarvestTriggerCount(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "inactiveConnectionTimeout": {
                            universalConnectionPoolBase.setInactiveConnectionTimeout(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "connectionWaitTimeout": {
                            universalConnectionPoolBase.setConnectionWaitTimeout(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "validateConnectionOnBorrow": {
                            universalConnectionPoolBase.setValidateConnectionOnBorrow(Boolean.parseBoolean((String)entry.getValue()));
                            break;
                        }
                        case "timeoutCheckInterval": {
                            universalConnectionPoolBase.setTimeoutCheckInterval(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "propertyCycle": {
                            universalConnectionPoolBase.setTimeoutCheckInterval(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "timeToLiveConnectionTimeout": {
                            universalConnectionPoolBase.setTimeToLiveConnectionTimeout(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "highCostConnectionReuseThreshold": {
                            universalConnectionPoolBase.setHighCostConnectionReuseThreshold(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "connectionLabelingHighCost": {
                            universalConnectionPoolBase.setConnectionLabelingHighCost(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "onsConfiguration": {
                            universalConnectionPoolBase.setONSConfiguration((String)entry.getValue());
                            break;
                        }
                        case "maxIdleTime": {
                            universalConnectionPoolBase.setInactiveConnectionTimeout(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "maxStatements": {
                            if (!(universalConnectionPoolBase instanceof JDBCConnectionPool)) continue block77;
                            ((JDBCConnectionPool)universalConnectionPoolBase).setMaxStatements(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "sqlForValidateConnection": {
                            if (!(universalConnectionPoolBase instanceof JDBCConnectionPool)) continue block77;
                            ((JDBCConnectionPool)universalConnectionPoolBase).setSQLForValidateConnection((String)entry.getValue());
                            break;
                        }
                        case "connectionInitializationCallback": {
                            Object object;
                            Object object2;
                            Object object3;
                            if (!(universalConnectionPoolBase instanceof JDBCConnectionPool)) continue block77;
                            try {
                                ((JDBCConnectionPool)universalConnectionPoolBase).unregisterConnectionInitializationCallback();
                                object3 = (String)entry.getValue();
                                if (object3 == null || "".equals(object3)) continue block77;
                                object2 = Class.forName((String)object3);
                                object = (ConnectionInitializationCallback)((Class)object2).newInstance();
                                ((JDBCConnectionPool)universalConnectionPoolBase).registerConnectionInitializationCallback((ConnectionInitializationCallback)object);
                                break;
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException("Invalid property value " + string2);
                            }
                        }
                        case "connectionLabelingCallback": {
                            Object object;
                            Object object2;
                            Object object3;
                            try {
                                universalConnectionPoolBase.removeConnectionLabelingCallback();
                                object2 = (String)entry.getValue();
                                if (object2 == null || "".equals(object2)) continue block77;
                                object3 = Class.forName((String)object2);
                                object = (ConnectionLabelingCallback)((Class)object3).newInstance();
                                universalConnectionPoolBase.registerConnectionLabelingCallback((ConnectionLabelingCallback)object);
                                break;
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException("Invalid property value " + string2);
                            }
                        }
                        case "connectionAffinityCallback": {
                            Object object;
                            Object object2;
                            try {
                                universalConnectionPoolBase.removeConnectionAffinityCallback();
                                object = (String)entry.getValue();
                                if (object == null || "".equals(object)) continue block77;
                                object2 = Class.forName((String)object);
                                ConnectionAffinityCallback connectionAffinityCallback = (ConnectionAffinityCallback)((Class)object2).newInstance();
                                universalConnectionPoolBase.registerConnectionAffinityCallback(connectionAffinityCallback);
                                break;
                            }
                            catch (Exception exception) {
                                throw new IllegalArgumentException("Invalid property value " + string2);
                            }
                        }
                        case "loginTimeout": {
                            universalConnectionPoolBase.setLoginTimeout(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "secondsToTrustIdleConnection": {
                            break;
                        }
                        case "connectionRepurposeThreshold": {
                            universalConnectionPoolBase.setConnectionRepurposeThreshold(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "maxConnectionsPerService": {
                            universalConnectionPoolBase.setMaxConnectionsPerService(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        case "maxConnectionsPerShard": {
                            universalConnectionPoolBase.setMaxConnectionsPerShard(Integer.parseInt((String)entry.getValue()));
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Invalid property name " + string2);
                        }
                    }
                }
                if (properties.containsKey("secondsToTrustIdleConnection")) {
                    universalConnectionPoolBase.setSecondsToTrustIdleConnection(Integer.parseInt((String)properties.get("secondsToTrustIdleConnection")));
                }
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("invalid type set");
            }
        }
    }

    @Override
    public void createConnectionPool(UniversalConnectionPoolAdapter universalConnectionPoolAdapter) throws UniversalConnectionPoolException {
        if (universalConnectionPoolAdapter == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(383);
        }
        try {
            UniversalConnectionPool universalConnectionPool = universalConnectionPoolAdapter.createUniversalConnectionPool();
            assert (universalConnectionPool != null);
            this.setConnectionPool(universalConnectionPool);
        }
        catch (Exception exception) {
            UCPErrorHandler.throwUniversalConnectionPoolException(385, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setConnectionPool(UniversalConnectionPool universalConnectionPool) throws UniversalConnectionPoolException {
        if (universalConnectionPool != null) {
            String string;
            String string2 = universalConnectionPool.getName();
            Map<String, String> map = this.m_mappedPoolNames;
            synchronized (map) {
                if (this.m_mappedPoolNames.containsKey(string2)) {
                    if (Util.isDestroyOnReloadEnabled()) {
                        this.destroyConnectionPool(string2);
                    } else {
                        UCPErrorHandler.throwUniversalConnectionPoolException(350);
                    }
                }
                string = new UniqueIdentifier(MGR_PREFIX).toString();
                this.m_mappedPoolNames.put(string2, string);
            }
            this.m_connPool.put(string, universalConnectionPool);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
    }

    @Override
    public UniversalConnectionPool getConnectionPool(String string) throws UniversalConnectionPoolException {
        UniversalConnectionPool universalConnectionPool;
        String string2 = this.getManagerPoolID(string);
        UniversalConnectionPool universalConnectionPool2 = universalConnectionPool = string2 != null ? this.m_connPool.get(string2) : null;
        if (null == universalConnectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        return universalConnectionPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getConnectionPoolNames() throws UniversalConnectionPoolException {
        String[] stringArray;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            stringArray = this.m_mappedPoolNames.keySet().toArray(new String[this.m_mappedPoolNames.size()]);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setManagerPoolID(String string, String string2) throws UniversalConnectionPoolException {
        String string3;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            String string4 = string3 = string != null ? this.m_mappedPoolNames.get(string) : null;
            if (null == string3) {
                UCPErrorHandler.throwUniversalConnectionPoolException(351);
            }
            this.m_mappedPoolNames.remove(string);
            this.m_mappedPoolNames.put(string2, string3);
        }
        ClioSupport.ilogFinest(null, null, null, null, string2 + " returns " + string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getManagerPoolID(String string) throws UniversalConnectionPoolException {
        String string2;
        Map<String, String> map = this.m_mappedPoolNames;
        synchronized (map) {
            string2 = string != null ? this.m_mappedPoolNames.get(string) : null;
        }
        if (null == string2) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        return string2;
    }

    private String[] getMetricPoolNames() throws UniversalConnectionPoolException {
        String[] stringArray = this.m_metricPools.toArray(new String[this.m_metricPools.size()]);
        return stringArray;
    }

    @Override
    public synchronized void startMetricsCollection(String string) throws UniversalConnectionPoolException {
        if (string == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        if (this.isMetricConsoleAvailable()) {
            try {
                UniversalConnectionPool universalConnectionPool = this.getConnectionPool(string);
                this.createMetricSensors(universalConnectionPool);
                if (!this.m_metricsPostingThread) {
                    this.initupdateMetricTimer();
                }
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
            }
        }
    }

    private void createMetricSensors(UniversalConnectionPool universalConnectionPool) throws UniversalConnectionPoolException {
        if (null == universalConnectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        NounIntf nounIntf = null;
        String string = universalConnectionPool.getName();
        String string2 = this.getManagerPoolID(string);
        nounIntf = !this.m_localMetricConsole ? (string != null ? this.m_parentNouns.get(string) : null) : this.m_metricConsole.getNounFactory().create("/UCP_METRIC/" + string);
        if (!this.m_metricPools.contains(string2)) {
            this.m_metricPools.add(string2);
        }
        UniversalConnectionPoolStatistics universalConnectionPoolStatistics = universalConnectionPool.getStatistics();
        StateIntf stateIntf = this.m_metricConsole.getStateFactory().create(nounIntf, TOTAL_CONN_NAME, (byte)3, "ConnectionsCount", TOTAL_CONN_DESC);
        stateIntf.deriveMetric(511);
        stateIntf.update(universalConnectionPoolStatistics.getTotalConnectionsCount());
        StateIntf stateIntf2 = this.m_metricConsole.getStateFactory().create(nounIntf, AVAILABLE_CONN_NAME, (byte)3, "ConnectionsCount", AVAILABLE_CONN_DESC);
        stateIntf2.deriveMetric(511);
        stateIntf.update(universalConnectionPoolStatistics.getAvailableConnectionsCount());
        StateIntf stateIntf3 = this.m_metricConsole.getStateFactory().create(nounIntf, BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", BORROWED_CONN_DESC);
        stateIntf3.deriveMetric(8);
        stateIntf3.update(universalConnectionPoolStatistics.getBorrowedConnectionsCount());
        StateIntf stateIntf4 = this.m_metricConsole.getStateFactory().create(nounIntf, AVERAGE_BORROWED_CONN_NAME, (byte)3, "ConnectionsCount", AVERAGE_BORROWED_CONN_DESC);
        stateIntf4.update(universalConnectionPoolStatistics.getAverageBorrowedConnectionsCount());
        StateIntf stateIntf5 = this.m_metricConsole.getStateFactory().create(nounIntf, PEAK_CONN_NAME, (byte)3, "ConnectionsCount", PEAK_CONN_DESC);
        stateIntf5.update(universalConnectionPoolStatistics.getPeakConnectionsCount());
        StateIntf stateIntf6 = this.m_metricConsole.getStateFactory().create(nounIntf, REMAINING_CONN_NAME, (byte)3, "ConnectionsCount", REMAINING_CONN_DESC);
        stateIntf6.deriveMetric(511);
        stateIntf6.update(universalConnectionPoolStatistics.getRemainingPoolCapacityCount());
        StateIntf stateIntf7 = this.m_metricConsole.getStateFactory().create(nounIntf, LABELED_CONN_NAME, (byte)3, "ConnectionsCount", LABELED_CONN_DESC);
        stateIntf7.deriveMetric(511);
        stateIntf7.update(universalConnectionPoolStatistics.getLabeledConnectionsCount());
        StateIntf stateIntf8 = this.m_metricConsole.getStateFactory().create(nounIntf, CREATED_CONN_NAME, (byte)3, "ConnectionsCount", CREATED_CONN_DESC);
        stateIntf8.deriveMetric(511);
        stateIntf8.update(universalConnectionPoolStatistics.getConnectionsCreatedCount());
        StateIntf stateIntf9 = this.m_metricConsole.getStateFactory().create(nounIntf, CLOSED_CONN_NAME, (byte)3, "ConnectionsCount", CLOSED_CONN_DESC);
        stateIntf9.deriveMetric(511);
        stateIntf9.update(universalConnectionPoolStatistics.getConnectionsClosedCount());
        StateIntf stateIntf10 = this.m_metricConsole.getStateFactory().create(nounIntf, AVG_CONN_WAIT_NAME, (byte)2, "Seconds", AVG_CONN_WAIT_DESC);
        stateIntf10.update(universalConnectionPoolStatistics.getAverageConnectionWaitTime());
        StateIntf stateIntf11 = this.m_metricConsole.getStateFactory().create(nounIntf, PEAK_CONN_WAIT_NAME, (byte)2, "Seconds", PEAK_CONN_WAIT_DESC);
        stateIntf11.update(universalConnectionPoolStatistics.getPeakConnectionWaitTime());
        StateIntf stateIntf12 = this.m_metricConsole.getStateFactory().create(nounIntf, ABANDONED_CONN_NAME, (byte)3, "ConnectionsCount", ABANDONED_CONN_DESC);
        stateIntf12.deriveMetric(511);
        stateIntf12.update(universalConnectionPoolStatistics.getAbandonedConnectionsCount());
        StateIntf stateIntf13 = this.m_metricConsole.getStateFactory().create(nounIntf, PENDING_REQUEST_NAME, (byte)3, "ConnectionsCount", PENDING_REQUEST_DESC);
        stateIntf13.deriveMetric(511);
        stateIntf13.update(universalConnectionPoolStatistics.getPendingRequestsCount());
        StateIntf stateIntf14 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_WAIT_DESC);
        stateIntf14.deriveMetric(511);
        stateIntf14.update(universalConnectionPoolStatistics.getCumulativeConnectionWaitTime());
        StateIntf stateIntf15 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_CONN_BORROWED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_BORROWED_DESC);
        stateIntf15.deriveMetric(511);
        stateIntf15.update(universalConnectionPoolStatistics.getCumulativeConnectionBorrowedCount());
        StateIntf stateIntf16 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_CONN_USE_NAME, (byte)2, "Seconds", CUMULATIVE_CONN_USE_DESC);
        stateIntf16.deriveMetric(511);
        stateIntf16.update(universalConnectionPoolStatistics.getCumulativeConnectionUseTime());
        StateIntf stateIntf17 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_CONN_RETURNED_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_CONN_RETURNED_DESC);
        stateIntf17.deriveMetric(511);
        stateIntf17.update(universalConnectionPoolStatistics.getCumulativeConnectionReturnedCount());
        StateIntf stateIntf18 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_SUCCESS_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_SUCCESS_CONN_WAIT_DESC);
        stateIntf18.deriveMetric(511);
        stateIntf18.update(universalConnectionPoolStatistics.getCumulativeSuccessfulConnectionWaitTime());
        StateIntf stateIntf19 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_DESC);
        stateIntf19.deriveMetric(511);
        stateIntf19.update(universalConnectionPoolStatistics.getCumulativeSuccessfulConnectionWaitCount());
        StateIntf stateIntf20 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_FAILED_CONN_WAIT_NAME, (byte)2, "Seconds", CUMULATIVE_FAILED_CONN_WAIT_DESC);
        stateIntf20.deriveMetric(511);
        stateIntf20.update(universalConnectionPoolStatistics.getCumulativeFailedConnectionWaitTime());
        StateIntf stateIntf21 = this.m_metricConsole.getStateFactory().create(nounIntf, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME, (byte)2, "ConnectionsCount", CUMULATIVE_FAILED_CONN_WAIT_COUNT_DESC);
        stateIntf21.deriveMetric(511);
        stateIntf21.update(universalConnectionPoolStatistics.getCumulativeFailedConnectionWaitCount());
        if (universalConnectionPool instanceof OracleJDBCConnectionPool) {
            OracleJDBCConnectionPoolStatistics oracleJDBCConnectionPoolStatistics = (OracleJDBCConnectionPoolStatistics)universalConnectionPoolStatistics;
            StateIntf stateIntf22 = this.m_metricConsole.getStateFactory().create(nounIntf, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_DESC);
            stateIntf22.deriveMetric(511);
            stateIntf22.update(oracleJDBCConnectionPoolStatistics.getSuccessfulAffinityBasedBorrowCount());
            StateIntf stateIntf23 = this.m_metricConsole.getStateFactory().create(nounIntf, FAILED_AFFINITYBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_AFFINITYBASED_BORROW_COUNT_DESC);
            stateIntf23.deriveMetric(511);
            stateIntf23.update(oracleJDBCConnectionPoolStatistics.getFailedAffinityBasedBorrowCount());
            StateIntf stateIntf24 = this.m_metricConsole.getStateFactory().create(nounIntf, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", SUCCESSFUL_RCLBBASED_BORROW_COUNT_DESC);
            stateIntf24.deriveMetric(511);
            stateIntf24.update(oracleJDBCConnectionPoolStatistics.getSuccessfulRCLBBasedBorrowCount());
            StateIntf stateIntf25 = this.m_metricConsole.getStateFactory().create(nounIntf, FAILED_RCLBBASED_BORROW_COUNT_NAME, (byte)2, "ConnectionsCount", FAILED_RCLBBASED_BORROW_COUNT_DESC);
            stateIntf25.deriveMetric(511);
            stateIntf25.update(oracleJDBCConnectionPoolStatistics.getFailedRCLBBasedBorrowCount());
        }
    }

    void updateMetricSensors() throws UniversalConnectionPoolException {
        if (this.isMetricConsoleAvailable()) {
            try {
                String[] stringArray = this.getMetricPoolNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    UniversalConnectionPool universalConnectionPool = stringArray[i2] != null ? this.m_connPool.get(stringArray[i2]) : null;
                    this.updateMetricSensors(universalConnectionPool);
                }
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                UCPErrorHandler.throwUniversalConnectionPoolException(377, universalConnectionPoolException);
            }
        }
    }

    private synchronized void updateMetricSensors(UniversalConnectionPool universalConnectionPool) throws UniversalConnectionPoolException {
        Object object;
        if (null == universalConnectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(351);
        }
        String string = universalConnectionPool.getName();
        NounIntf nounIntf = null;
        if (!this.m_localMetricConsole) {
            nounIntf = string != null ? this.m_parentNouns.get(string) : null;
        } else if (null != this.m_metricConsole && null != (object = this.m_metricConsole.getNounFactory())) {
            nounIntf = object.get("/UCP_METRIC/" + string);
        }
        if (null != nounIntf) {
            object = universalConnectionPool.getStatistics();
            assert (object != null);
            ((State)nounIntf.getSensor(TOTAL_CONN_NAME)).update(object.getTotalConnectionsCount());
            ((State)nounIntf.getSensor(AVAILABLE_CONN_NAME)).update(object.getAvailableConnectionsCount());
            ((State)nounIntf.getSensor(BORROWED_CONN_NAME)).update(object.getBorrowedConnectionsCount());
            ((State)nounIntf.getSensor(AVERAGE_BORROWED_CONN_NAME)).update(object.getAverageBorrowedConnectionsCount());
            ((State)nounIntf.getSensor(PEAK_CONN_NAME)).update(object.getPeakConnectionsCount());
            ((State)nounIntf.getSensor(REMAINING_CONN_NAME)).update(object.getRemainingPoolCapacityCount());
            ((State)nounIntf.getSensor(LABELED_CONN_NAME)).update(object.getLabeledConnectionsCount());
            ((State)nounIntf.getSensor(CREATED_CONN_NAME)).update(object.getConnectionsCreatedCount());
            ((State)nounIntf.getSensor(CLOSED_CONN_NAME)).update(object.getConnectionsClosedCount());
            ((State)nounIntf.getSensor(AVG_CONN_WAIT_NAME)).update(object.getAverageConnectionWaitTime());
            ((State)nounIntf.getSensor(PEAK_CONN_WAIT_NAME)).update(object.getPeakConnectionWaitTime());
            ((State)nounIntf.getSensor(ABANDONED_CONN_NAME)).update(object.getAbandonedConnectionsCount());
            ((State)nounIntf.getSensor(PENDING_REQUEST_NAME)).update(object.getPendingRequestsCount());
            ((State)nounIntf.getSensor(CUMULATIVE_CONN_WAIT_NAME)).update(object.getCumulativeConnectionWaitTime());
            ((State)nounIntf.getSensor(CUMULATIVE_CONN_BORROWED_NAME)).update(object.getCumulativeConnectionBorrowedCount());
            ((State)nounIntf.getSensor(CUMULATIVE_CONN_USE_NAME)).update(object.getCumulativeConnectionUseTime());
            ((State)nounIntf.getSensor(CUMULATIVE_CONN_RETURNED_NAME)).update(object.getCumulativeConnectionReturnedCount());
            ((State)nounIntf.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_NAME)).update(object.getCumulativeSuccessfulConnectionWaitTime());
            ((State)nounIntf.getSensor(CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME)).update(object.getCumulativeSuccessfulConnectionWaitCount());
            ((State)nounIntf.getSensor(CUMULATIVE_FAILED_CONN_WAIT_NAME)).update(object.getCumulativeFailedConnectionWaitTime());
            ((State)nounIntf.getSensor(CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME)).update(object.getCumulativeFailedConnectionWaitCount());
            if (universalConnectionPool instanceof OracleJDBCConnectionPool) {
                OracleJDBCConnectionPoolStatistics oracleJDBCConnectionPoolStatistics = (OracleJDBCConnectionPoolStatistics)object;
                ((State)nounIntf.getSensor(SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleJDBCConnectionPoolStatistics.getSuccessfulAffinityBasedBorrowCount());
                ((State)nounIntf.getSensor(FAILED_AFFINITYBASED_BORROW_COUNT_NAME)).update(oracleJDBCConnectionPoolStatistics.getFailedAffinityBasedBorrowCount());
                ((State)nounIntf.getSensor(SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME)).update(oracleJDBCConnectionPoolStatistics.getSuccessfulRCLBBasedBorrowCount());
                ((State)nounIntf.getSensor(FAILED_RCLBBASED_BORROW_COUNT_NAME)).update(oracleJDBCConnectionPoolStatistics.getFailedRCLBBasedBorrowCount());
            }
        }
    }

    private boolean isMetricConsoleAvailable() {
        boolean bl2 = false;
        if (this.m_metricConsole != null) {
            bl2 = true;
        } else {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class.forName("oracle.dms.instrument.DMSConsole", true, classLoader);
                this.m_metricConsole = DMSConsole.getConsole();
                this.m_metricConsole.init(UCP_METRIC_NAME);
                bl2 = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ClioSupport.ilogThrowing(null, null, null, null, classNotFoundException);
            }
            catch (SecurityException securityException) {
                ClioSupport.ilogThrowing(null, null, null, null, securityException);
            }
            catch (RuntimeException runtimeException) {
                ClioSupport.ilogThrowing(null, null, null, null, runtimeException);
            }
            catch (Exception exception) {
                ClioSupport.ilogThrowing(null, null, null, null, exception);
            }
        }
        return bl2;
    }

    @Override
    public synchronized void stopMetricsCollection(String string) throws UniversalConnectionPoolException {
        if (string == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(54);
        }
        if (this.isMetricConsoleAvailable()) {
            try {
                if (this.isMetricConsoleAvailable()) {
                    String string2;
                    NounIntf nounIntf = null;
                    nounIntf = !this.m_localMetricConsole ? (string != null ? this.m_parentNouns.get(string) : null) : this.m_metricConsole.getNounFactory().get("/UCP_METRIC/" + string);
                    if (nounIntf != null) {
                        nounIntf.destroy();
                    }
                    if (this.m_metricPools.contains(string2 = this.getManagerPoolID(string))) {
                        this.m_metricPools.remove(string2);
                    }
                    if (this.m_parentNouns.contains(string)) {
                        this.m_parentNouns.remove(string);
                    }
                    if (this.m_metricPools.size() == 0) {
                        this.disableupdateMetricTimer();
                        if (this.m_localMetricConsole) {
                            this.m_metricConsole.exit();
                        }
                        this.m_metricConsole = null;
                        this.m_localMetricConsole = true;
                    }
                }
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                UCPErrorHandler.throwUniversalConnectionPoolException(375, universalConnectionPoolException);
            }
        }
    }

    @Override
    public synchronized void setMetricUpdateInterval(int n2) throws UniversalConnectionPoolException {
        if (n2 < 0) {
            UCPErrorHandler.throwUniversalConnectionPoolException(6);
        }
        if (this.m_metricInterval != n2) {
            this.disableupdateMetricTimer();
            this.m_metricInterval = n2;
            if (this.m_metricConsole != null && this.m_metricInterval > 0) {
                this.initupdateMetricTimer();
            }
        }
    }

    @Override
    public int getMetricUpdateInterval() {
        return this.m_metricInterval;
    }

    @Override
    public synchronized void setJmxEnabled(boolean bl2) throws UniversalConnectionPoolException {
        this.m_jmxFlag = bl2;
    }

    @Override
    public boolean isJmxEnabled() {
        return this.m_jmxFlag;
    }

    private void initupdateMetricTimer() throws UniversalConnectionPoolException {
        if (this.m_metricInterval > 0) {
            try {
                this.m_updateMetricTimer = UniversalConnectionPoolManagerBase.getTimerManager().schedule(new MetricsUpdateTimerTask(), 0L, this.m_metricInterval * 1000);
                this.m_metricsPostingThread = true;
            }
            catch (Exception exception) {
                UCPErrorHandler.throwUniversalConnectionPoolException(376, exception);
            }
        } else {
            this.m_updateMetricTimer = null;
        }
    }

    private void disableupdateMetricTimer() throws UniversalConnectionPoolException {
        if (this.m_updateMetricTimer != null) {
            this.m_updateMetricTimer.cancel();
            this.m_metricsPostingThread = false;
            this.m_updateMetricTimer = null;
        }
    }

    @Override
    public void setLogLevel(Level level) {
        UCPLoggerFactory.setLogLevel(level);
    }

    @Override
    @DisableTrace
    public Level getLogLevel() {
        return UCPLoggerFactory.getLogLevel();
    }

    protected void setMetricConsole(DMSConsole dMSConsole) {
        this.m_metricConsole = dMSConsole;
        this.m_localMetricConsole = false;
    }

    protected void setMetricParentNoun(String string, NounIntf nounIntf) {
        this.m_parentNouns.put(string, nounIntf);
    }

    protected StateIntf getStateMetric(String string, UCPMetric uCPMetric) {
        NounIntf nounIntf;
        StateIntf stateIntf = null;
        NounIntf nounIntf2 = nounIntf = string != null ? this.m_parentNouns.get(string) : null;
        if (nounIntf != null) {
            stateIntf = (StateIntf)nounIntf.getSensor(m_ucpMetrics.get((Object)uCPMetric));
        }
        return stateIntf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerManager getTimerManager() {
        TimerManager timerManager = m_timerManager;
        synchronized (timerManager) {
            return m_timerManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTimerManager(TimerManager timerManager) {
        TimerManager timerManager2;
        TimerManager timerManager3 = timerManager2 = m_timerManager;
        synchronized (timerManager3) {
            TimerManager timerManager4 = timerManager;
            synchronized (timerManager4) {
                if (timerManager2.isRunning()) {
                    return false;
                }
                m_timerManager = timerManager;
                return true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskManager getTaskManager() {
        TaskManager taskManager = m_taskManager;
        synchronized (taskManager) {
            return m_taskManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean setTaskManager(TaskManager taskManager) {
        TaskManager taskManager2;
        TaskManager taskManager3 = taskManager2 = m_taskManager;
        synchronized (taskManager3) {
            TaskManager taskManager4 = taskManager;
            synchronized (taskManager4) {
                if (taskManager2.isRunning()) {
                    return false;
                }
                m_taskManager = taskManager;
                return true;
            }
        }
    }

    static {
        try {
            $$$methodRef$$$35 = UniversalConnectionPoolManagerBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$34 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setTaskManager", TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$33 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$32 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setTimerManager", TimerManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$31 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getTimerManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getStateMetric", String.class, UCPMetric.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setMetricParentNoun", String.class, NounIntf.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setMetricConsole", DMSConsole.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setLogLevel", Level.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("disableupdateMetricTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("initupdateMetricTimer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("isJmxEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setJmxEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getMetricUpdateInterval", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setMetricUpdateInterval", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("stopMetricsCollection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("isMetricConsoleAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("updateMetricSensors", UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("updateMetricSensors", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("createMetricSensors", UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("startMetricsCollection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getMetricPoolNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getManagerPoolID", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setManagerPoolID", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getConnectionPoolNames", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("getConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("setConnectionPool", UniversalConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("createConnectionPool", UniversalConnectionPoolAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("applyConfiguration", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("reconfigureConnectionPool", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("destroyConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("purgeConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("recycleConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("refreshConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("stopConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolManagerBase.class.getDeclaredMethod("startConnectionPool", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.admin");
        MGR_PREFIX = "UniversalConnectionPoolManager(" + UniversalConnectionPoolManagerBase.class.hashCode() + ")-";
        m_ucpMetrics = Collections.synchronizedMap(new HashMap());
        m_timerManager = new UCPTimerManagerImpl();
        m_taskManager = new UCPTaskManagerImpl();
        m_ucpMetrics.put(UCPMetric.TOTALCONNECTIONSCOUNT, TOTAL_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVAILABLECONNECTIONSCOUNT, AVAILABLE_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.BORROWEDCONNECTIONSCOUNT, BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGEBORROWEDCONNECTIONSCOUNT, AVERAGE_BORROWED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONSCOUNT, PEAK_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.REMAININGPOOLCAPACITYCOUNT, REMAINING_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.LABELEDCONNECTIONSCOUNT, LABELED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCREATEDCOUNT, CREATED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.CONNECTIONSCLOSEDCOUNT, CLOSED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.AVERAGECONNECTIONWAITTIME, AVG_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.PEAKCONNECTIONWAITTIME, PEAK_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.ABANDONEDCONNECTIONSCOUNT, ABANDONED_CONN_NAME);
        m_ucpMetrics.put(UCPMetric.PENDINGREQUESTSCOUNT, PENDING_REQUEST_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONWAITTIME, CUMULATIVE_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONBORROWEDCOUNT, CUMULATIVE_CONN_BORROWED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONUSETIME, CUMULATIVE_CONN_USE_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVECONNECTIONRETURNEDCOUNT, CUMULATIVE_CONN_RETURNED_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITTIME, CUMULATIVE_SUCCESS_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT, CUMULATIVE_SUCCESS_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITTIME, CUMULATIVE_FAILED_CONN_WAIT_NAME);
        m_ucpMetrics.put(UCPMetric.CUMULATIVEFAILEDCONNECTIONWAITCOUNT, CUMULATIVE_FAILED_CONN_WAIT_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULAFFINITYBASEDBORROWCOUNT, SUCCESSFUL_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDAFFINITYBASEDBORROWCOUNT, FAILED_AFFINITYBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.SUCCESSFULRCLBBASEDBORROWCOUNT, SUCCESSFUL_RCLBBASED_BORROW_COUNT_NAME);
        m_ucpMetrics.put(UCPMetric.FAILEDRCLBBASEDBORROWCOUNT, FAILED_RCLBBASED_BORROW_COUNT_NAME);
    }

    public static final class UCPMetric
    extends Enum<UCPMetric> {
        public static final /* enum */ UCPMetric TOTALCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric AVAILABLECONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric BORROWEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric AVERAGEBORROWEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric PEAKCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric REMAININGPOOLCAPACITYCOUNT;
        public static final /* enum */ UCPMetric LABELEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric CONNECTIONSCREATEDCOUNT;
        public static final /* enum */ UCPMetric CONNECTIONSCLOSEDCOUNT;
        public static final /* enum */ UCPMetric AVERAGECONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric PEAKCONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric ABANDONEDCONNECTIONSCOUNT;
        public static final /* enum */ UCPMetric PENDINGREQUESTSCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONBORROWEDCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONUSETIME;
        public static final /* enum */ UCPMetric CUMULATIVECONNECTIONRETURNEDCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVESUCCESSFULCONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT;
        public static final /* enum */ UCPMetric CUMULATIVEFAILEDCONNECTIONWAITTIME;
        public static final /* enum */ UCPMetric CUMULATIVEFAILEDCONNECTIONWAITCOUNT;
        public static final /* enum */ UCPMetric SUCCESSFULAFFINITYBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric FAILEDAFFINITYBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric SUCCESSFULRCLBBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric FAILEDRCLBBASEDBORROWCOUNT;
        public static final /* enum */ UCPMetric FCFDOWNEVENTPROCESSINGINFO;
        private static final /* synthetic */ UCPMetric[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static UCPMetric[] values() {
            return (UCPMetric[])$VALUES.clone();
        }

        public static UCPMetric valueOf(String string) {
            return Enum.valueOf(UCPMetric.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = UCPMetric.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = UCPMetric.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UCPMetric.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            TOTALCONNECTIONSCOUNT = new UCPMetric();
            AVAILABLECONNECTIONSCOUNT = new UCPMetric();
            BORROWEDCONNECTIONSCOUNT = new UCPMetric();
            AVERAGEBORROWEDCONNECTIONSCOUNT = new UCPMetric();
            PEAKCONNECTIONSCOUNT = new UCPMetric();
            REMAININGPOOLCAPACITYCOUNT = new UCPMetric();
            LABELEDCONNECTIONSCOUNT = new UCPMetric();
            CONNECTIONSCREATEDCOUNT = new UCPMetric();
            CONNECTIONSCLOSEDCOUNT = new UCPMetric();
            AVERAGECONNECTIONWAITTIME = new UCPMetric();
            PEAKCONNECTIONWAITTIME = new UCPMetric();
            ABANDONEDCONNECTIONSCOUNT = new UCPMetric();
            PENDINGREQUESTSCOUNT = new UCPMetric();
            CUMULATIVECONNECTIONWAITTIME = new UCPMetric();
            CUMULATIVECONNECTIONBORROWEDCOUNT = new UCPMetric();
            CUMULATIVECONNECTIONUSETIME = new UCPMetric();
            CUMULATIVECONNECTIONRETURNEDCOUNT = new UCPMetric();
            CUMULATIVESUCCESSFULCONNECTIONWAITTIME = new UCPMetric();
            CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT = new UCPMetric();
            CUMULATIVEFAILEDCONNECTIONWAITTIME = new UCPMetric();
            CUMULATIVEFAILEDCONNECTIONWAITCOUNT = new UCPMetric();
            SUCCESSFULAFFINITYBASEDBORROWCOUNT = new UCPMetric();
            FAILEDAFFINITYBASEDBORROWCOUNT = new UCPMetric();
            SUCCESSFULRCLBBASEDBORROWCOUNT = new UCPMetric();
            FAILEDRCLBBASEDBORROWCOUNT = new UCPMetric();
            FCFDOWNEVENTPROCESSINGINFO = new UCPMetric();
            $VALUES = new UCPMetric[]{TOTALCONNECTIONSCOUNT, AVAILABLECONNECTIONSCOUNT, BORROWEDCONNECTIONSCOUNT, AVERAGEBORROWEDCONNECTIONSCOUNT, PEAKCONNECTIONSCOUNT, REMAININGPOOLCAPACITYCOUNT, LABELEDCONNECTIONSCOUNT, CONNECTIONSCREATEDCOUNT, CONNECTIONSCLOSEDCOUNT, AVERAGECONNECTIONWAITTIME, PEAKCONNECTIONWAITTIME, ABANDONEDCONNECTIONSCOUNT, PENDINGREQUESTSCOUNT, CUMULATIVECONNECTIONWAITTIME, CUMULATIVECONNECTIONBORROWEDCOUNT, CUMULATIVECONNECTIONUSETIME, CUMULATIVECONNECTIONRETURNEDCOUNT, CUMULATIVESUCCESSFULCONNECTIONWAITTIME, CUMULATIVESUCCESSFULCONNECTIONWAITCOUNT, CUMULATIVEFAILEDCONNECTIONWAITTIME, CUMULATIVEFAILEDCONNECTIONWAITCOUNT, SUCCESSFULAFFINITYBASEDBORROWCOUNT, FAILEDAFFINITYBASEDBORROWCOUNT, SUCCESSFULRCLBBASEDBORROWCOUNT, FAILEDRCLBBASEDBORROWCOUNT, FCFDOWNEVENTPROCESSINGINFO};
        }
    }
}

