/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.io.Serializable;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.jdbc.oracle.RACAffinityContext;

@DisableTrace
public class AffinityContext
implements Serializable,
Cloneable,
RACAffinityContext {
    private static final long serialVersionUID = 1554319099870773354L;
    private final String service;
    private final String database;
    private final String instance;
    private final RACAffinityContext.AffinityType affinityType;

    public AffinityContext(String string, String string2, String string3, RACAffinityContext.AffinityType affinityType) {
        this.service = string;
        this.database = string2;
        this.instance = string3;
        this.affinityType = affinityType;
    }

    public AffinityContext(String string, String string2, String string3, ConnectionAffinityCallback.AffinityPolicy affinityPolicy) {
        this(string, string2, string3, AffinityContext.toAffinityType(affinityPolicy));
    }

    private static RACAffinityContext.AffinityType toAffinityType(ConnectionAffinityCallback.AffinityPolicy affinityPolicy) {
        switch (affinityPolicy) {
            case WEBSESSION_BASED_AFFINITY: {
                return RACAffinityContext.AffinityType.WEBSESSION_BASED_AFFINITY;
            }
            case TRANSACTION_BASED_AFFINITY: {
                return RACAffinityContext.AffinityType.TRANSACTION_BASED_AFFINITY;
            }
        }
        throw new IllegalStateException("wrong policy");
    }

    @Override
    public String getVersionNumber() {
        return "1.0";
    }

    @Override
    public String getServiceName() {
        return this.service;
    }

    @Override
    public String getDatabaseUniqueName() {
        return this.database;
    }

    @Override
    public String getInstanceName() {
        return this.instance;
    }

    @Override
    public RACAffinityContext.AffinityType getAffinityType() {
        return this.affinityType;
    }

    public String toString() {
        return "service=" + this.service + ", db=" + this.database + ", instance=" + this.instance + ", affinityType=" + (Object)((Object)this.affinityType);
    }
}

