/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLRecoverableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Applicator;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.Instantiator;
import oracle.ucp.common.Limits;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.Policies;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.waitfreepool.Factory;
import oracle.ucp.common.waitfreepool.Pool;
import oracle.ucp.common.waitfreepool.PoolIterator;
import oracle.ucp.common.waitfreepool.SkipList;
import oracle.ucp.common.waitfreepool.SkipListTuple;
import oracle.ucp.common.waitfreepool.kdtree.KDTree;
import oracle.ucp.common.waitfreepool.kdtree.Point;
import oracle.ucp.common.waitfreepool.kdtree.Range;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public final class Core {
    private final Pool<CoreConnection> waitFreePool = Factory.create();
    private Instantiator instantiator = new Instantiator(this.waitFreePool);
    private final AtomicReference<WFPTree> wfpTree = new AtomicReference<WFPTree>(WFPTree.seed());
    private static final boolean isAffinityStrict;
    private final Map<DRange, Boolean> skipListBuilds = new ConcurrentHashMap<DRange, Boolean>();
    private final Semaphore skipListBuildsSemaphore = new Semaphore(3);
    private Set<String> knownServices = ConcurrentHashMap.newKeySet();
    private AtomicReference<ConnectionSource> connectionSource = new AtomicReference<ConnectionSource>(ConnectionSource.IDLE);
    private AtomicReference<Limits> limits = new AtomicReference<Limits>(Limits.DEFAULT);
    private AtomicReference<Policies> policies = new AtomicReference<1>(new Policies(){
        private final IllegalStateException err = new IllegalStateException("policies are not set up yet");
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        public ConnectionRetrievalInfo getMostPopularCri() {
            throw this.err;
        }

        @Override
        public boolean isCriUnpopular(ConnectionRetrievalInfo connectionRetrievalInfo) {
            throw this.err;
        }

        static {
            try {
                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(Core.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = 1.class.getDeclaredMethod("isCriUnpopular", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = 1.class.getDeclaredMethod("getMostPopularCri", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    });
    private final AtomicLong emptyBorrows = new AtomicLong(0L);
    private final AtomicLong totalBorrows = new AtomicLong(0L);
    private AtomicInteger pendingAvailableGrows = new AtomicInteger();
    private AtomicInteger pendingBorrowedGrows = new AtomicInteger();
    private AtomicBoolean noMoreGrows = new AtomicBoolean(false);
    private ReentrantLock stoppingLock = new ReentrantLock();
    private Condition stoppingCondition = this.stoppingLock.newCondition();
    private AtomicLong repurposeCount = new AtomicLong(0L);
    private ReentrantLock handlersLock = new ReentrantLock();
    private static final Selector markedAlready;
    private static final long MAKE_ROOM_POSTPONEMENT = 120L;
    private volatile long notAvailTS = Clock.clock();
    private AtomicBoolean cleanUselessInProgress = new AtomicBoolean(false);
    private static final long INITIALIZE_TIMEOUT = 1000L;
    private final AtomicBoolean adjusterEnabled = new AtomicBoolean(false);
    private final AtomicBoolean adjusterBusy = new AtomicBoolean(false);
    private static final int HARVESTING_ATTEMPTS = 5;
    AtomicBoolean keepOverMinimum = new AtomicBoolean(false);
    private PeakIntegerCounter peakConnectionsCount = new PeakIntegerCounter();
    public static final int ADJUST_MIN_LIMIT_ATTEMPTS = 10;
    public static final int BEST_INSTANCE_CREATION_ATTEMPTS = 3;
    public static final long ADJUST_MIN_LIMIT_DELAY = 2000L;
    private static final Collection<Core> coreInstances;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;
    private static Executable $$$methodRef$$$61;
    private static Logger $$$loggerRef$$$61;
    private static Executable $$$methodRef$$$62;
    private static Logger $$$loggerRef$$$62;
    private static Executable $$$methodRef$$$63;
    private static Logger $$$loggerRef$$$63;
    private static Executable $$$methodRef$$$64;
    private static Logger $$$loggerRef$$$64;
    private static Executable $$$methodRef$$$65;
    private static Logger $$$loggerRef$$$65;
    private static Executable $$$methodRef$$$66;
    private static Logger $$$loggerRef$$$66;
    private static Executable $$$methodRef$$$67;
    private static Logger $$$loggerRef$$$67;
    private static Executable $$$methodRef$$$68;
    private static Logger $$$loggerRef$$$68;
    private static Executable $$$methodRef$$$69;
    private static Logger $$$loggerRef$$$69;
    private static Executable $$$methodRef$$$70;
    private static Logger $$$loggerRef$$$70;
    private static Executable $$$methodRef$$$71;
    private static Logger $$$loggerRef$$$71;
    private static Executable $$$methodRef$$$72;
    private static Logger $$$loggerRef$$$72;
    private static Executable $$$methodRef$$$73;
    private static Logger $$$loggerRef$$$73;
    private static Executable $$$methodRef$$$74;
    private static Logger $$$loggerRef$$$74;
    private static Executable $$$methodRef$$$75;
    private static Logger $$$loggerRef$$$75;
    private static Executable $$$methodRef$$$76;
    private static Logger $$$loggerRef$$$76;
    private static Executable $$$methodRef$$$77;
    private static Logger $$$loggerRef$$$77;
    private static Executable $$$methodRef$$$78;
    private static Logger $$$loggerRef$$$78;
    private static Executable $$$methodRef$$$79;
    private static Logger $$$loggerRef$$$79;
    private static Executable $$$methodRef$$$80;
    private static Logger $$$loggerRef$$$80;
    private static Executable $$$methodRef$$$81;
    private static Logger $$$loggerRef$$$81;
    private static Executable $$$methodRef$$$82;
    private static Logger $$$loggerRef$$$82;
    private static Executable $$$methodRef$$$83;
    private static Logger $$$loggerRef$$$83;
    private static Executable $$$methodRef$$$84;
    private static Logger $$$loggerRef$$$84;
    private static Executable $$$methodRef$$$85;
    private static Logger $$$loggerRef$$$85;
    private static Executable $$$methodRef$$$86;
    private static Logger $$$loggerRef$$$86;
    private static Executable $$$methodRef$$$87;
    private static Logger $$$loggerRef$$$87;
    private static Executable $$$methodRef$$$88;
    private static Logger $$$loggerRef$$$88;
    private static Executable $$$methodRef$$$89;
    private static Logger $$$loggerRef$$$89;
    private static Executable $$$methodRef$$$90;
    private static Logger $$$loggerRef$$$90;
    private static Executable $$$methodRef$$$91;
    private static Logger $$$loggerRef$$$91;
    private static Executable $$$methodRef$$$92;
    private static Logger $$$loggerRef$$$92;
    private static Executable $$$methodRef$$$93;
    private static Logger $$$loggerRef$$$93;
    private static Executable $$$methodRef$$$94;
    private static Logger $$$loggerRef$$$94;
    private static Executable $$$methodRef$$$95;
    private static Logger $$$loggerRef$$$95;
    private static Executable $$$methodRef$$$96;
    private static Logger $$$loggerRef$$$96;
    private static Executable $$$methodRef$$$97;
    private static Logger $$$loggerRef$$$97;
    private static Executable $$$methodRef$$$98;
    private static Logger $$$loggerRef$$$98;
    private static Executable $$$methodRef$$$99;
    private static Logger $$$loggerRef$$$99;
    private static Executable $$$methodRef$$$100;
    private static Logger $$$loggerRef$$$100;
    private static Executable $$$methodRef$$$101;
    private static Logger $$$loggerRef$$$101;
    private static Executable $$$methodRef$$$102;
    private static Logger $$$loggerRef$$$102;
    private static Executable $$$methodRef$$$103;
    private static Logger $$$loggerRef$$$103;
    private static Executable $$$methodRef$$$104;
    private static Logger $$$loggerRef$$$104;
    private static Executable $$$methodRef$$$105;
    private static Logger $$$loggerRef$$$105;
    private static Executable $$$methodRef$$$106;
    private static Logger $$$loggerRef$$$106;
    private static Executable $$$methodRef$$$107;
    private static Logger $$$loggerRef$$$107;
    private static Executable $$$methodRef$$$108;
    private static Logger $$$loggerRef$$$108;
    private static Executable $$$methodRef$$$109;
    private static Logger $$$loggerRef$$$109;
    private static Executable $$$methodRef$$$110;
    private static Logger $$$loggerRef$$$110;
    private static Executable $$$methodRef$$$111;
    private static Logger $$$loggerRef$$$111;
    private static Executable $$$methodRef$$$112;
    private static Logger $$$loggerRef$$$112;
    private static Executable $$$methodRef$$$113;
    private static Logger $$$loggerRef$$$113;
    private static Executable $$$methodRef$$$114;
    private static Logger $$$loggerRef$$$114;
    private static Executable $$$methodRef$$$115;
    private static Logger $$$loggerRef$$$115;
    private static Executable $$$methodRef$$$116;
    private static Logger $$$loggerRef$$$116;
    private static Executable $$$methodRef$$$117;
    private static Logger $$$loggerRef$$$117;
    private static Executable $$$methodRef$$$118;
    private static Logger $$$loggerRef$$$118;
    private static Executable $$$methodRef$$$119;
    private static Logger $$$loggerRef$$$119;
    private static Executable $$$methodRef$$$120;
    private static Logger $$$loggerRef$$$120;
    private static Executable $$$methodRef$$$121;
    private static Logger $$$loggerRef$$$121;
    private static Executable $$$methodRef$$$122;
    private static Logger $$$loggerRef$$$122;

    void clearWFPTree() {
        this.wfpTree.set(WFPTree.seed());
        this.skipListBuilds.clear();
    }

    Core() {
        coreInstances.add(this);
        ClioSupport.ilogFinest(null, null, null, null, this.toString() + " core object to watch pending grows added");
    }

    private void put(CoreConnection coreConnection) {
        this.waitFreePool.put(((Instantiator.Connection)coreConnection).register());
        this.clearWFPTree();
        coreConnection.serviceMember().serviceRef.buildDistributionTable();
        Properties properties = coreConnection.cri().getLabels();
        if (null != properties && !properties.isEmpty()) {
            this.connectionSource().labeledCount().incrementAndGet();
        }
        int n2 = this.totalCount().get();
        this.peakConnectionsCount.update(n2);
        if (n2 + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() >= this.limits().getMin()) {
            this.keepOverMinimum.set(true);
        }
    }

    void forEach(Applicator applicator) {
        this.forSome(Selectors.EVERY, applicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CoreConnection> split(Selector selector) {
        ArrayList<CoreConnection> arrayList = new ArrayList<CoreConnection>();
        PoolIterator<CoreConnection> poolIterator = this.waitFreePool.poolIterator(true);
        try {
            while (poolIterator.hasNext()) {
                CoreConnection coreConnection = (CoreConnection)poolIterator.next();
                if (!selector.selected(coreConnection)) continue;
                poolIterator.remove();
                ((Instantiator.Connection)coreConnection).unregister();
                this.clearWFPTree();
                coreConnection.serviceMember().serviceRef.buildDistributionTable();
                arrayList.add(coreConnection);
            }
        }
        finally {
            poolIterator.release();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forSome(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>>[] supplierArray) {
        for (Supplier<PoolIterator<CoreConnection>> supplier : supplierArray) {
            PoolIterator<CoreConnection> poolIterator = supplier.get();
            try {
                while (poolIterator.hasNext()) {
                    CoreConnection coreConnection = (CoreConnection)poolIterator.next();
                    if (!selector.selected(coreConnection)) continue;
                    applicator.apply(coreConnection);
                }
            }
            finally {
                poolIterator.release();
            }
        }
    }

    private void forSome(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>> supplier) {
        this.forSome(selector, applicator, new Supplier[]{supplier});
    }

    private void forSome(Selector selector, Applicator applicator) {
        this.forSome(selector, applicator, () -> this.waitFreePool.poolIterator(true));
    }

    private static Range[] searchCriteria(String string) {
        return Core.searchCriteria(string, null, 0, 0);
    }

    private static Range[] searchCriteria(String string, Properties properties, int n2, int n3) {
        return new Range[]{new Range((Comparable)((Object)string)), new Range((Comparable)((Object)(null == properties ? "" : properties.toString()))), new Range(Integer.valueOf(n2), Integer.valueOf(n3))};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkipList<CoreConnection> prepareSkipList(String string) {
        Range[] rangeArray = Core.searchCriteria(string);
        List list = this.wfpTree.get().search(rangeArray);
        if (list.size() > 0) {
            return (SkipList)list.get(0).getData();
        }
        if (null == this.skipListBuilds.putIfAbsent(new DRange(rangeArray), Boolean.TRUE)) {
            KDTree[] kDTreeArray = new KDTree[]{null};
            try {
                this.skipListBuildsSemaphore.acquire();
                this.waitFreePool.buildSkipLists(new SkipListTuple<CoreConnection>(coreConnection -> coreConnection.serviceName().equals(string), skipList -> {
                    kDTreeArray[0] = new WFPTree((SkipList)skipList, string, "", 0);
                    this.wfpTree.get().merge(kDTreeArray[0]);
                }));
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.skipListBuildsSemaphore.release();
            }
            return (SkipList)kDTreeArray[0].getData();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkipList<CoreConnection> preparePerfectCostSkipList(String string, Properties properties) {
        if (null == properties) {
            return this.prepareSkipList(string);
        }
        Range[] rangeArray = Core.searchCriteria(string, properties, 0, 0);
        List list = this.wfpTree.get().search(rangeArray);
        if (list.size() > 0) {
            return (SkipList)list.get(0).getData();
        }
        if (null == this.skipListBuilds.putIfAbsent(new DRange(rangeArray), Boolean.TRUE)) {
            KDTree[] kDTreeArray = new KDTree[]{null};
            try {
                this.skipListBuildsSemaphore.acquire();
                this.waitFreePool.buildSkipLists(new SkipListTuple<CoreConnection>(coreConnection -> coreConnection.serviceName().equals(string) && 0 == coreConnection.labelingCost(properties), skipList -> {
                    kDTreeArray[0] = new WFPTree((SkipList)skipList, string, properties.toString(), 0);
                    this.wfpTree.get().merge(kDTreeArray[0]);
                }));
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.skipListBuildsSemaphore.release();
            }
            return (SkipList)kDTreeArray[0].getData();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SkipList<CoreConnection> prepareAcceptableCostSkipList(String string, Properties properties) {
        if (null == properties) {
            return this.prepareSkipList(string);
        }
        Range[] rangeArray = Core.searchCriteria(string, properties, 1, 0x7FFFFFFE);
        List list = this.wfpTree.get().search(rangeArray);
        if (list.size() > 0) {
            return (SkipList)list.get(0).getData();
        }
        if (null == this.skipListBuilds.putIfAbsent(new DRange(rangeArray), Boolean.TRUE)) {
            KDTree[] kDTreeArray = new KDTree[]{null};
            try {
                this.skipListBuildsSemaphore.acquire();
                this.waitFreePool.buildSkipLists(new SkipListTuple<CoreConnection>(coreConnection -> {
                    int n2 = coreConnection.labelingCost(properties);
                    return coreConnection.serviceName().equals(string) && n2 > 0 && n2 < Integer.MAX_VALUE;
                }, skipList -> {
                    kDTreeArray[0] = new WFPTree((SkipList)skipList, string, properties.toString(), 1);
                    this.wfpTree.get().merge(kDTreeArray[0]);
                }));
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.skipListBuildsSemaphore.release();
            }
            return (SkipList)kDTreeArray[0].getData();
        }
        return null;
    }

    private Supplier<SkipList<CoreConnection>>[] costSuppliers(String string, Properties properties) {
        return new Supplier[]{() -> this.preparePerfectCostSkipList(string, properties), () -> this.prepareAcceptableCostSkipList(string, properties)};
    }

    private Supplier<SkipList<CoreConnection>>[] serviceSuppliers(String string) {
        return new Supplier[]{() -> this.prepareSkipList(string)};
    }

    private Supplier<PoolIterator<CoreConnection>>[] poolIterators(Supplier<SkipList<CoreConnection>>[] supplierArray, boolean bl2) {
        Supplier[] supplierArray2 = new Supplier[supplierArray.length];
        for (int i2 = 0; i2 < supplierArray2.length; ++i2) {
            Supplier<SkipList<CoreConnection>> supplier = supplierArray[i2];
            supplierArray2[i2] = () -> {
                SkipList skipList = (SkipList)supplier.get();
                return null == skipList ? this.waitFreePool.poolIterator(bl2) : skipList.poolIterator(bl2);
            };
        }
        return supplierArray2;
    }

    private Supplier<PoolIterator<CoreConnection>> servicePoolIterator(String string, boolean bl2) {
        return this.poolIterators(this.serviceSuppliers(string), bl2)[0];
    }

    private Supplier<PoolIterator<CoreConnection>>[] costPoolIterators(String string, Properties properties, boolean bl2) {
        return this.poolIterators(this.costSuppliers(string, properties), bl2);
    }

    private static Selector serviceSelector(String string) {
        return coreConnection -> coreConnection.serviceName().equals(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forFirst(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>>[] supplierArray) {
        for (Supplier<PoolIterator<CoreConnection>> supplier : supplierArray) {
            PoolIterator<CoreConnection> poolIterator = supplier.get();
            try {
                while (poolIterator.hasNext()) {
                    CoreConnection coreConnection = (CoreConnection)poolIterator.next();
                    if (!selector.selected(coreConnection)) continue;
                    applicator.apply(coreConnection);
                    return;
                }
            }
            finally {
                poolIterator.release();
            }
        }
    }

    private void forFirst(Selector selector, Applicator applicator, Supplier<PoolIterator<CoreConnection>> supplier) {
        this.forFirst(selector, applicator, new Supplier[]{supplier});
    }

    private void forFirst(Selector selector, Applicator applicator) {
        this.forFirst(selector, applicator, () -> this.waitFreePool.poolIterator(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection retrieveFirst(Selector selector) {
        CoreConnection coreConnection = null;
        PoolIterator<CoreConnection> poolIterator = this.waitFreePool.poolIterator(true);
        try {
            while (poolIterator.hasNext()) {
                CoreConnection coreConnection2 = (CoreConnection)poolIterator.next();
                if (!selector.selected(coreConnection2)) continue;
                poolIterator.remove();
                ((Instantiator.Connection)coreConnection2).unregister();
                this.clearWFPTree();
                coreConnection2.serviceMember().serviceRef.buildDistributionTable();
                Properties properties = coreConnection2.cri().getLabels();
                if (null != properties && !properties.isEmpty()) {
                    this.connectionSource().labeledCount().decrementAndGet();
                }
                coreConnection = coreConnection2;
                break;
            }
        }
        finally {
            poolIterator.release();
        }
        return coreConnection;
    }

    private void registerService(String string) {
        this.knownServices.add(string);
        ConnectionSource.FailoverCallback failoverCallback = this.prepareFailoverHandler(string);
        ConnectionSource.RebalanceCallback rebalanceCallback = this.prepareRebalanceHandler(string);
        this.connectionSource().registerService(this.instantiator, string, failoverCallback, rebalanceCallback);
    }

    final void plugConnectionSource(ConnectionSource connectionSource) {
        if (connectionSource == null) {
            throw new IllegalArgumentException("null connectionSource");
        }
        this.connectionSource.set(connectionSource);
    }

    public ConnectionSource connectionSource() {
        return this.connectionSource.get();
    }

    final void plugLimits(Limits limits) {
        if (limits == null) {
            throw new IllegalArgumentException("null limits");
        }
        this.limits.set(limits);
    }

    private Limits limits() {
        return this.limits.get();
    }

    final void plugPolicies(Policies policies) {
        if (policies == null) {
            throw new IllegalArgumentException("null policies");
        }
        this.policies.set(policies);
    }

    private Policies policies() {
        return this.policies.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Supports(value={Feature.CHECK_OUT})
    final CoreConnection borrow(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, long l2) throws UniversalConnectionPoolException {
        CoreConnection coreConnection = null;
        try {
            coreConnection = this.helpBorrow(connectionRetrievalInfo, connectionAffinityCallback, l2);
        }
        finally {
            this.totalBorrows.incrementAndGet();
            if (coreConnection != null) {
                coreConnection.onBorrow(connectionRetrievalInfo);
            } else {
                this.emptyBorrows.incrementAndGet();
                if (0L == this.emptyBorrows.get() % 1000L) {
                    ClioSupport.ilogFinest(null, null, null, null, "permits=" + this.connectionSource().getBorrowSemaphore(connectionRetrievalInfo).availablePermits() + ", borrows: empty/total= " + (float)this.emptyBorrows.get() / (float)this.totalBorrows.get() * 100.0f + "%");
                }
            }
        }
        return coreConnection;
    }

    @Supports(value={Feature.CHECK_OUT})
    private CoreConnection helpBorrow(final ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, final long l2) {
        boolean[] blArray = new boolean[]{false};
        CoreConnection[] coreConnectionArray = new CoreConnection[]{null};
        final CoreConnection[] coreConnectionArray2 = new CoreConnection[]{null};
        ConnectionSource connectionSource = this.connectionSource();
        String string = connectionSource.serviceName(connectionRetrievalInfo);
        Properties properties = connectionRetrievalInfo.getLabels();
        Comparator<CoreConnection> comparator = connectionSource.costComparator(properties);
        Selector selector = connectionSource.perfectCostSelector(properties);
        Selector selector2 = connectionSource.wrongCostSelector(properties);
        Selector selector3 = Selectors.or(connectionSource.routingKeyBasedBorrowSelector(connectionRetrievalInfo, true), connectionSource.routingKeyBasedBorrowSelector(connectionRetrievalInfo, false));
        Selector selector4 = coreConnection -> {
            if (coreConnection.closed() || coreConnection.bad()) {
                this.cleanUselessAsynch();
                return false;
            }
            if (!coreConnection.available()) {
                return false;
            }
            if (!coreConnection.cri().equalsIncludingPassword(connectionRetrievalInfo)) {
                return false;
            }
            boolean bl2 = connectionSource.loadBalancedBorrowSelector(connectionRetrievalInfo, connectionAffinityCallback).selected(coreConnection);
            if (selector2.selected(coreConnection)) {
                return false;
            }
            if (selector.selected(coreConnection)) {
                blArray[0] = bl2;
                return blArray[0];
            }
            CoreConnection coreConnection2 = coreConnectionArray[0];
            return bl2 && (null == coreConnection2 || comparator.compare(coreConnection, coreConnection2) < 0);
        };
        Selector selector5 = coreConnection -> {
            if (coreConnection.closed() || coreConnection.bad()) {
                this.cleanUselessAsynch();
                return false;
            }
            if (!coreConnection.available()) {
                return false;
            }
            if (!coreConnection.cri().equalsIncludingPassword(connectionRetrievalInfo)) {
                return false;
            }
            if (selector2.selected(coreConnection)) {
                return false;
            }
            if (selector.selected(coreConnection)) {
                blArray[0] = true;
                return true;
            }
            CoreConnection coreConnection2 = coreConnectionArray[0];
            return null == coreConnection2 || comparator.compare(coreConnection, coreConnection2) < 0;
        };
        final Core core = this;
        final class ForFirstCaller {
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            ForFirstCaller() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void forFirst(Selector selector, Supplier<PoolIterator<CoreConnection>>[] supplierArray) {
                CoreConnection[] coreConnectionArray = new CoreConnection[]{null};
                try {
                    Core.this.connectionSource().getBorrowSemaphore(connectionRetrievalInfo).tryAcquire(l2, TimeUnit.MILLISECONDS);
                    core.forFirst(selector, coreConnection -> {
                        coreConnection.makeUnavailable();
                        coreConnectionArray[0] = coreConnection;
                    }, supplierArray);
                }
                catch (InterruptedException interruptedException) {
                    ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
                }
                finally {
                    if (null != coreConnectionArray[0]) {
                        coreConnectionArray2[0] = coreConnectionArray[0];
                    }
                }
            }

            static {
                try {
                    $$$methodRef$$$3 = ForFirstCaller.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class, Long.TYPE, Core.class, CoreConnection[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = ForFirstCaller.class.getDeclaredMethod("access$100", ForFirstCaller.class, Selector.class, Supplier[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = ForFirstCaller.class.getDeclaredMethod("lambda$forFirst$0", CoreConnection[].class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = ForFirstCaller.class.getDeclaredMethod("forFirst", Selector.class, Supplier[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }
        ForFirstCaller forFirstCaller = new ForFirstCaller();
        do {
            Object object;
            boolean bl2;
            coreConnectionArray2[0] = null;
            Selector selector6 = connectionSource.isShardedDatabase() || connectionSource.isRacDataAffinityEnabled() ? Selectors.and(selector4, Core.serviceSelector(string), selector3) : Selectors.and(selector4, Core.serviceSelector(string));
            Selector selector7 = connectionSource.isShardedDatabase() || connectionSource.isRacDataAffinityEnabled() ? Selectors.and(selector5, Core.serviceSelector(string), selector3) : Selectors.and(selector5, Core.serviceSelector(string));
            boolean bl3 = bl2 = null != connectionAffinityCallback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == connectionAffinityCallback.getAffinityPolicy();
            if (connectionSource.failoverEnabled() || bl2) {
                forFirstCaller.forFirst(selector6, this.costPoolIterators(string, properties, false));
                if (null == coreConnectionArray2[0]) {
                    if (connectionSource.isRacDataAffinityEnabled()) {
                        forFirstCaller.forFirst(selector7, this.costPoolIterators(string, properties, false));
                        if (null == coreConnectionArray2[0] && !isAffinityStrict) {
                            forFirstCaller.forFirst(Selectors.and(selector4, Core.serviceSelector(string)), this.costPoolIterators(string, properties, false));
                        }
                    } else if (!bl2 || !isAffinityStrict) {
                        forFirstCaller.forFirst(selector7, this.costPoolIterators(string, properties, false));
                    }
                } else if (null != connectionAffinityCallback) {
                    object = connectionAffinityCallback.getAffinityPolicy();
                    if (connectionAffinityCallback.getConnectionAffinityContext() == null) {
                        ServiceMember serviceMember = coreConnectionArray2[0].serviceMember();
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == object && serviceMember.affined() || ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == object) {
                            ClioSupport.ilogFinest(null, null, null, null, String.format("Updating affinity context with instance %s", serviceMember.name()));
                            connectionAffinityCallback.setConnectionAffinityContext(new AffinityContext(serviceMember.service(), serviceMember.database(), serviceMember.name(), (ConnectionAffinityCallback.AffinityPolicy)((Object)object)));
                        }
                    }
                }
            } else {
                forFirstCaller.forFirst(selector7, this.costPoolIterators(string, properties, false));
            }
            if (null == coreConnectionArray2[0]) {
                if (connectionSource.failoverEnabled() && coreConnectionArray[0] != null) {
                    this.updateRLBStats(coreConnectionArray[0].serviceMember());
                }
                return coreConnectionArray[0];
            }
            object = coreConnectionArray[0];
            coreConnectionArray[0] = coreConnectionArray2[0];
            if (null == object) continue;
            object.makeAvailable();
        } while (!blArray[0]);
        if (connectionSource.failoverEnabled() && coreConnectionArray2[0] != null) {
            this.updateRLBStats(coreConnectionArray2[0].serviceMember());
        }
        return coreConnectionArray2[0];
    }

    @Supports(value={Feature.POOL_STATISTICS})
    private void updateRLBStats(ServiceMember serviceMember) {
        if (serviceMember.violatingRLBAdvisory()) {
            serviceMember.lbStats.onFailedLbBorrowed();
            serviceMember.serviceRef.lbStats.onFailedLbBorrowed();
        } else {
            serviceMember.lbStats.onSuccessfulLbBorrowed();
            serviceMember.serviceRef.lbStats.onSuccessfulLbBorrowed();
        }
    }

    @Supports(value={Feature.CHECK_IN})
    final void reclaim(CoreConnection coreConnection) throws UniversalConnectionPoolException {
        if (coreConnection.available()) {
            return;
        }
        boolean bl2 = false;
        if (coreConnection.normal()) {
            if (coreConnection.reusable()) {
                coreConnection.onReturn();
                coreConnection.makeAvailable();
                return;
            }
            if (!coreConnection.markedCloseOnReturn()) {
                bl2 = true;
            }
        } else if (coreConnection.markedToReplace()) {
            bl2 = true;
        }
        this.retrieve(coreConnection);
        coreConnection.abort();
        coreConnection.close();
        if (bl2) {
            this.growAvailableAsynch(coreConnection.cri());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final CoreConnection growBorrowed(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, long l2) throws UniversalConnectionPoolException {
        CoreConnection coreConnection = null;
        int n2 = this.totalCount().get() + this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.incrementAndGet();
        try {
            int n3 = 5;
            String string = this.connectionSource().serviceName(connectionRetrievalInfo);
            for (int i2 = 0; i2 < 5; ++i2) {
                if (this.noMoreGrows.get()) {
                    CoreConnection coreConnection2 = null;
                    return coreConnection2;
                }
                if (this.connectionSource().isMultitenantDatabase() && n2 > this.limits().getMin() && n2 > this.limits().getRepurposeThreshold() && (coreConnection = this.tryRepurpose(connectionRetrievalInfo)) != null) {
                    this.repurposeCount.getAndIncrement();
                } else {
                    if (!this.connectionSource().isServiceRegistered(string)) {
                        this.registerService(string);
                    }
                    if (n2 > this.limits().getMax()) {
                        if (this.makeRoom(connectionRetrievalInfo)) {
                            coreConnection = this.connectionSource().create(connectionRetrievalInfo, connectionAffinityCallback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), l2);
                            if (coreConnection == null) continue;
                        }
                    } else {
                        coreConnection = this.connectionSource().create(connectionRetrievalInfo, connectionAffinityCallback, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), l2);
                    }
                }
                break;
            }
        }
        finally {
            if (null != coreConnection) {
                coreConnection.onBorrow(connectionRetrievalInfo);
                coreConnection.makeUnavailable();
                this.put(coreConnection);
            }
            this.pendingBorrowedGrows.getAndDecrement();
            if (this.noMoreGrows.get() && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
        }
        if (null != coreConnection) {
            ClioSupport.ilogFinest(null, null, null, null, "connection=" + coreConnection);
        }
        return coreConnection;
    }

    @Supports(value={Feature.HIGH_AVAILABILITY})
    private ConnectionSource.FailoverCallback prepareFailoverHandler(final String string) {
        return new ConnectionSource.FailoverCallback(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ConnectionSource.FailoverCallback.Result handle(Selector selector, Selector selector2, boolean bl2, boolean bl3) {
                Core.this.handlersLock.lock();
                try {
                    ConnectionSource.FailoverCallback.Result result = this.handleHelper(selector, selector2, bl2, bl3);
                    return result;
                }
                finally {
                    Core.this.handlersLock.unlock();
                }
            }

            private ConnectionSource.FailoverCallback.Result handleHelper(Selector selector, Selector selector2, boolean bl2, boolean bl3) {
                Object object;
                int n2 = 0;
                ConnectionSource.FailoverCallback.Result.ResultType resultType = ConnectionSource.FailoverCallback.Result.ResultType.FAILURE;
                int n3 = Core.this.availableCount();
                int n4 = Core.this.borrowedCount();
                int n5 = 0;
                int n6 = 0;
                int[] nArray = new int[]{0};
                int[] nArray2 = new int[]{0};
                int[] nArray3 = new int[]{0};
                while (null != (object = Core.this.retrieveFirst(Selectors.and(Core.serviceSelector(string), selector)))) {
                    if (Core.this.connectionSource().isReplayable() && !object.available()) {
                        object.markReconnecting();
                        Core.this.put((CoreConnection)object);
                    } else {
                        object.abort();
                        object.close();
                        if (bl3) {
                            try {
                                Core.this.growAvailable(object.cri());
                                nArray3[0] = nArray3[0] + 1;
                            }
                            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                            }
                        }
                    }
                    if (object.available()) {
                        nArray[0] = nArray[0] + 1;
                    } else {
                        nArray2[0] = nArray2[0] + 1;
                    }
                    ++n2;
                }
                if (n2 > 0) {
                    ClioSupport.ilogFinest(null, null, null, null, String.format("FF: cleaned up %d connections", n2));
                }
                n2 = 0;
                while (true) {
                    object = new boolean[]{false};
                    boolean[] blArray = new boolean[]{false};
                    Core.this.forFirst(Selectors.and(Selectors.not(markedAlready), Core.serviceSelector(string), selector2), arg_0 -> 2.lambda$handleHelper$0(bl2, (boolean[])object, blArray, arg_0), Core.this.servicePoolIterator(string, true));
                    if (object[0] == false) break;
                    ++n2;
                    if (blArray[0]) {
                        ++n5;
                        continue;
                    }
                    ++n6;
                    nArray2[0] = nArray2[0] + 1;
                }
                if (n2 > 0) {
                    ClioSupport.ilogFinest(null, null, null, null, String.format("FF: marked to-replace %d connections", n2));
                }
                int n7 = Core.this.availableCount();
                int n8 = Core.this.borrowedCount();
                ConnectionSource.FailoverCallback.Result result = new ConnectionSource.FailoverCallback.Result();
                result.type = ConnectionSource.FailoverCallback.Result.ResultType.SUCCESS;
                result.availConns = Core.this.availableCount();
                result.borrowedConns = Core.this.borrowedCount();
                result.availOpened = nArray3[0] + Core.this.availableCount() > n7 ? Core.this.availableCount() - n7 : 0;
                result.availClosed = nArray[0] + (n7 > Core.this.availableCount() ? n7 - Core.this.availableCount() : 0);
                result.borrowedClosed = nArray2[0] + (n8 > Core.this.borrowedCount() ? n8 - Core.this.borrowedCount() : 0);
                Core.this.kickAdjuster();
                return result;
            }

            private static /* synthetic */ void lambda$handleHelper$0(boolean bl2, boolean[] blArray, boolean[] blArray2, CoreConnection coreConnection) {
                if (bl2) {
                    coreConnection.markCloseOnReturn();
                } else {
                    coreConnection.markToReplace();
                }
                blArray[0] = true;
                blArray2[0] = coreConnection.available();
            }

            static {
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredConstructor(Core.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("lambda$handleHelper$0", Boolean.TYPE, boolean[].class, boolean[].class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("handleHelper", Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("handle", Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Supports(value={Feature.LOAD_BALANCING})
    private ConnectionSource.RebalanceCallback prepareRebalanceHandler(final String string) {
        return new ConnectionSource.RebalanceCallback(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public ConnectionSource.RebalanceCallback.Result handle(final Selector selector, final Selector selector2) {
                final ConnectionSource.RebalanceCallback.Result result = new ConnectionSource.RebalanceCallback.Result();
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;
                    private static Executable $$$methodRef$$$3;
                    private static Logger $$$loggerRef$$$3;
                    private static Executable $$$methodRef$$$4;
                    private static Logger $$$loggerRef$$$4;
                    private static Executable $$$methodRef$$$5;
                    private static Logger $$$loggerRef$$$5;

                    @Override
                    public void run() {
                        if (!Core.this.handlersLock.tryLock()) {
                            return;
                        }
                        try {
                            this.runHelper();
                        }
                        finally {
                            Core.this.handlersLock.unlock();
                        }
                    }

                    private void runHelper() {
                        int n2 = Math.max(1, (Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get()) * 15 / 100);
                        int[] nArray = new int[]{0};
                        while (nArray[0] < n2) {
                            if (result.terminate.get()) {
                                return;
                            }
                            CoreConnection coreConnection2 = Core.this.retrieveFirst(Selectors.and(Core.serviceSelector(string), coreConnection -> {
                                boolean bl2;
                                block1: {
                                    bl2 = false;
                                    if (!selector.selected(coreConnection)) break block1;
                                    ServiceMember serviceMember = coreConnection.serviceMember();
                                    int n2 = serviceMember.connsToRebalance.get();
                                    if (n2 < 0 && serviceMember.connsToRebalance.compareAndSet(n2, n2 + 1)) {
                                        bl2 = true;
                                    }
                                }
                                return bl2;
                            }));
                            if (null == coreConnection2) break;
                            coreConnection2.abort();
                            coreConnection2.close();
                            try {
                                Core.this.growAvailable(coreConnection2.cri());
                            }
                            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                            }
                            nArray[0] = nArray[0] + 1;
                        }
                        Core.this.forSome(Selectors.and(Core.serviceSelector(string), coreConnection -> {
                            boolean bl2;
                            block3: {
                                if (nArray[0] >= n2) {
                                    return false;
                                }
                                if (result2.terminate.get()) {
                                    return false;
                                }
                                bl2 = false;
                                if (!selector2.selected(coreConnection)) break block3;
                                ServiceMember serviceMember = coreConnection.serviceMember();
                                int n3 = serviceMember.connsToRebalance.get();
                                if (n3 < 0 && serviceMember.connsToRebalance.compareAndSet(n3, n3 + 1)) {
                                    bl2 = true;
                                }
                            }
                            return bl2;
                        }), coreConnection -> {
                            coreConnection.markToReplace();
                            nArray[0] = nArray[0] + 1;
                        }, Core.this.servicePoolIterator(string, true));
                        if (nArray[0] > 0) {
                            ClioSupport.ilogFine(null, null, null, null, String.format("rebalanced %d connection(s)", nArray[0]));
                        }
                        for (int i2 = Core.this.totalCount().get() + Core.this.pendingBorrowedGrows.get() + Core.this.pendingAvailableGrows.get(); i2 < Core.this.getEffectiveMinPoolSize(); ++i2) {
                            if (result.terminate.get()) {
                                return;
                            }
                            try {
                                Core.this.growAvailable(Core.this.policies().getMostPopularCri(), true);
                                ClioSupport.ilogFinest(null, null, null, null, "grew up one connection to reach the minimum");
                                continue;
                            }
                            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                                break;
                            }
                        }
                        if (result.terminate.get()) {
                            return;
                        }
                        Core.this.adjustMaxLimit();
                    }

                    static {
                        try {
                            $$$methodRef$$$5 = 1.class.getDeclaredConstructor(3.class, ConnectionSource.RebalanceCallback.Result.class, Selector.class, Selector.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$4 = 1.class.getDeclaredMethod("lambda$runHelper$0", Selector.class, CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$3 = 1.class.getDeclaredMethod("lambda$runHelper$1", int[].class, Integer.TYPE, ConnectionSource.RebalanceCallback.Result.class, Selector.class, CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredMethod("lambda$runHelper$2", int[].class, CoreConnection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("runHelper", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                return result;
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Core.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("handle", Selector.class, Selector.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private CoreConnection tryRepurpose(ConnectionRetrievalInfo connectionRetrievalInfo) {
        String string = this.connectionSource().serviceName(connectionRetrievalInfo);
        if (!this.connectionSource().isServiceRegistered(string)) {
            return null;
        }
        if (this.knownServices.size() > 0) {
            CoreConnection coreConnection;
            for (String string2 : this.knownServices) {
                if (string != null && string.equals(string2) || (coreConnection = this.retrieveFirst(Selectors.and(Core.serviceSelector(string2), this.connectionSource().serviceBasedRepurposeSelector(connectionRetrievalInfo, true)))) == null) continue;
                if (coreConnection.repurpose(connectionRetrievalInfo)) {
                    return coreConnection;
                }
                coreConnection.abort();
                coreConnection.close();
                return null;
            }
            for (String string2 : this.knownServices) {
                if (string != null && string.equals(string2) || (coreConnection = this.retrieveFirst(Selectors.and(Core.serviceSelector(string2), this.connectionSource().serviceBasedRepurposeSelector(connectionRetrievalInfo, false)))) == null) continue;
                if (coreConnection.repurpose(connectionRetrievalInfo)) {
                    return coreConnection;
                }
                coreConnection.abort();
                coreConnection.close();
                return null;
            }
        }
        return null;
    }

    private boolean holdOverMakingRoom() {
        if (this.availableCount() == 0) {
            this.notAvailTS = Clock.clock();
            return true;
        }
        return Clock.clock() - this.notAvailTS < 120L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeRoom(ConnectionRetrievalInfo connectionRetrievalInfo) {
        this.adjusterEnabled.set(false);
        try {
            if (this.holdOverMakingRoom()) {
                boolean bl2 = false;
                return bl2;
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to do an expensive make room traversal");
            CoreConnection coreConnection2 = this.retrieveFirst(coreConnection -> {
                if (!coreConnection.available()) {
                    return false;
                }
                if (coreConnection.closed() || coreConnection.bad()) {
                    return true;
                }
                return this.policies().isCriUnpopular(coreConnection.cri());
            });
            if (coreConnection2 != null) {
                coreConnection2.abort();
                coreConnection2.close();
                ClioSupport.ilogFinest(null, null, null, null, "connection closed");
                boolean bl3 = true;
                return bl3;
            }
            if (this.holdOverMakingRoom()) {
                boolean bl4 = false;
                return bl4;
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to do an expensive make room traversal");
            CoreConnection coreConnection3 = this.retrieveFirst(Selectors.and(this.connectionSource().availableConnectionsSelector(), Selectors.or(Selectors.not(this.connectionSource().matchingCriSelector(connectionRetrievalInfo)), Selectors.not(this.connectionSource().routingKeyBasedBorrowSelector(connectionRetrievalInfo, false)), this.connectionSource().wrongCostSelector(connectionRetrievalInfo.getLabels()))));
            if (null != coreConnection3) {
                coreConnection3.abort();
                coreConnection3.close();
                ClioSupport.ilogFinest(null, null, null, null, "connection closed");
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    boolean uselessConnsCleanerInProgress() {
        return this.cleanUselessInProgress.get();
    }

    private void cleanUselessAsynch() {
        if (this.cleanUselessInProgress.compareAndSet(false, true)) {
            try {
                UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        Core.this.cleanUseless();
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 4.class.getDeclaredConstructor(Core.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 4.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
            }
            catch (RuntimeException runtimeException) {
                this.cleanUselessInProgress.set(false);
            }
        }
    }

    private void cleanUseless() {
        try {
            for (CoreConnection coreConnection2 : this.split(coreConnection -> coreConnection.available() && (coreConnection.closed() || coreConnection.bad()))) {
                if (!coreConnection2.bad()) continue;
                coreConnection2.abort();
                coreConnection2.close();
            }
        }
        finally {
            this.cleanUselessInProgress.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void growAvailable(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl2) throws UniversalConnectionPoolException {
        CoreConnection coreConnection = null;
        int n2 = this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.incrementAndGet();
        try {
            if (n2 > this.limits().getMax()) {
                return;
            }
            if (this.noMoreGrows.get()) {
                return;
            }
            coreConnection = this.connectionSource().create(connectionRetrievalInfo, null, bl2 ? EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE) : EnumSet.noneOf(ConnectionSource.CreateMode.class), 0L);
            if (coreConnection == null) {
                return;
            }
            coreConnection.makeAvailable();
            ClioSupport.ilogFinest(null, null, null, null, "conn=" + coreConnection);
            this.put(coreConnection);
        }
        finally {
            this.pendingAvailableGrows.getAndDecrement();
            if (this.noMoreGrows.get() && this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() == 0) {
                try {
                    this.stoppingLock.lock();
                    this.stoppingCondition.signal();
                }
                finally {
                    this.stoppingLock.unlock();
                }
            }
        }
    }

    private void growAvailable(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        this.growAvailable(connectionRetrievalInfo, true);
    }

    final void growAvailableAsynch(final ConnectionRetrievalInfo connectionRetrievalInfo) {
        UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void run() {
                try {
                    Core.this.growAvailable(connectionRetrievalInfo);
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
            }

            static {
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void initialize() throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        final boolean[] blArray = new boolean[]{true};
        final Throwable[] throwableArray = new Throwable[]{null};
        try {
            int n2 = Math.min(Math.min(this.limits().getInitial(), this.limits().getMax()), this.limits().getMaxPerService());
            final AtomicInteger atomicInteger = new AtomicInteger();
            UCPTaskBase<Boolean> uCPTaskBase = new UCPTaskBase<Boolean>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;

                @Override
                public Boolean call() {
                    ClioSupport.ilogFinest(null, null, null, null, "launching init thread");
                    while (atomicInteger.getAndDecrement() > 0) {
                        try {
                            CoreConnection coreConnection;
                            ConnectionRetrievalInfo connectionRetrievalInfo = Core.this.connectionSource().defaultCri();
                            String string = Core.this.connectionSource().serviceName(connectionRetrievalInfo);
                            if (!Core.this.connectionSource().isServiceRegistered(string)) {
                                Core.this.registerService(string);
                            }
                            if (null != (coreConnection = Core.this.connectionSource().create(Core.this.policies().getMostPopularCri(), null, EnumSet.of(ConnectionSource.CreateMode.USE_BEST_INSTANCE), 1000L))) {
                                coreConnection.makeAvailable();
                                Core.this.put(coreConnection);
                                ClioSupport.ilogFinest(null, null, null, null, String.format("connection %s successfully created", coreConnection.toString()));
                                continue;
                            }
                            ClioSupport.ilogWarning(null, null, null, null, "connection not created");
                        }
                        catch (UniversalConnectionPoolException universalConnectionPoolException) {
                            ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                            if (universalConnectionPoolException.getCause() instanceof SQLRecoverableException) continue;
                            ClioSupport.ilogFinest(null, null, null, null, "failure");
                            blArray[0] = false;
                            throwableArray[0] = universalConnectionPoolException;
                            break;
                        }
                    }
                    return blArray[0];
                }

                static {
                    try {
                        $$$methodRef$$$2 = 6.class.getDeclaredConstructor(Core.class, AtomicInteger.class, boolean[].class, Throwable[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("call", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
            try {
                atomicInteger.set(n2 > 0 ? 1 : 0);
                if (!((Boolean)uCPTaskBase.call()).booleanValue()) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(66, new IllegalStateException("unable to start connection creation task", throwableArray[0]));
                }
                int n3 = Util.getMaxInitThreads();
                int n4 = Math.min(Math.max(0, n3), Math.max(0, n2));
                ClioSupport.ilogFinest(null, null, null, null, String.format("initPoolSize=%d, maxInitThreads=%d, initThreads=%d", n2, n3, n4));
                atomicInteger.set(n2 - 1);
                TaskHandle[] taskHandleArray = new TaskHandle[n4];
                for (int i2 = 0; i2 < taskHandleArray.length; ++i2) {
                    taskHandleArray[i2] = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(uCPTaskBase);
                }
                for (TaskHandle taskHandle : taskHandleArray) {
                    blArray[0] = blArray[0] && (Boolean)taskHandle.get(0L) != false;
                }
            }
            catch (Exception exception) {
                ClioSupport.ilogThrowing(null, null, null, null, exception);
                UCPErrorHandler.throwUniversalConnectionPoolException(66, exception);
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
        if (blArray[0]) {
            return;
        }
        UCPErrorHandler.throwUniversalConnectionPoolException(66, throwableArray[0].getCause());
    }

    final void closeAvailableInactive(long l2) {
        if (l2 == 0L) {
            return;
        }
        for (CoreConnection coreConnection2 : this.split(Selectors.and(this.connectionSource().inactiveConnectionsSelector(l2), coreConnection -> !this.idle() || this.totalCount().get() > this.limits().getMin()))) {
            coreConnection2.abort();
            coreConnection2.close();
        }
        this.kickAdjuster();
    }

    final void reduce(ConnectionRetrievalInfo connectionRetrievalInfo) {
        CoreConnection coreConnection2 = this.retrieveFirst(coreConnection -> coreConnection.available() && this.totalCount().get() > this.limits().getMin());
        if (null != coreConnection2) {
            coreConnection2.close();
        }
        this.kickAdjuster();
    }

    private boolean idle() {
        return this.borrowedCount() == 0 || this.pendingGrowsCount() == 0;
    }

    final void replaceNonReusable() {
        this.adjusterEnabled.set(false);
        try {
            this.split(coreConnection -> {
                if (!(coreConnection.reusable() || this.idle() && this.totalCount().get() <= this.limits().getMin())) {
                    if (coreConnection.available()) {
                        coreConnection.abort();
                        coreConnection.close();
                        return true;
                    }
                    coreConnection.markToReplace();
                    return false;
                }
                return false;
            });
        }
        finally {
            this.adjusterEnabled.set(true);
            this.kickAdjuster();
        }
    }

    final void replaceAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(false);
    }

    final void replaceInvalidAvailable() throws UniversalConnectionPoolException {
        this.replaceAvailable(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvailable(final boolean bl2) throws UniversalConnectionPoolException {
        this.adjusterEnabled.set(false);
        try {
            List<CoreConnection> list = this.split(new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection coreConnection) {
                    if (!coreConnection.available()) {
                        coreConnection.markToReplace();
                        return false;
                    }
                    if (bl2 && coreConnection.valid()) {
                        return false;
                    }
                    coreConnection.abort();
                    coreConnection.close();
                    return true;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Core.class, Boolean.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
            for (CoreConnection coreConnection : list) {
                this.growAvailable(coreConnection.cri());
            }
        }
        finally {
            this.adjusterEnabled.set(true);
        }
    }

    void kickAdjuster() {
        if (!this.adjusterEnabled.get()) {
            return;
        }
        if (this.adjusterBusy.compareAndSet(false, true)) {
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    try {
                        Core.this.adjustLimits();
                    }
                    finally {
                        Core.this.adjusterBusy.set(false);
                    }
                }

                static {
                    try {
                        $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Core.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 8.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    int pendingAvailableGrows() {
        return this.pendingAvailableGrows.get();
    }

    @Supports(value={Feature.ABANDONED_CONN_TIMEOUT})
    final void returnAbandoned(int n2) {
        this.forSome(this.connectionSource().abandonedConnectionsSelector(n2), new Applicator(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void apply(CoreConnection coreConnection) {
                coreConnection.handleTimeout();
                coreConnection.makeAvailable();
            }

            static {
                try {
                    $$$methodRef$$$1 = 9.class.getDeclaredConstructor(Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 9.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    @Supports(value={Feature.TTL_CONN_TIMEOUT})
    final void returnTTLed(int n2) {
        this.forSome(this.connectionSource().ttlConnectionsSelector(n2), new Applicator(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void apply(CoreConnection coreConnection) {
                coreConnection.handleTimeout();
                coreConnection.makeAvailable();
            }

            static {
                try {
                    $$$methodRef$$$1 = 10.class.getDeclaredConstructor(Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 10.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    @Supports(value={Feature.CONN_HARVESTING})
    final void harvest(int n2, int n3) {
        if (n2 >= 0 && n2 < Integer.MAX_VALUE && this.availableCount() <= n2) {
            final int[] nArray = new int[]{n3};
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;
                private static Executable $$$methodRef$$$2;
                private static Logger $$$loggerRef$$$2;
                private static Executable $$$methodRef$$$3;
                private static Logger $$$loggerRef$$$3;

                @Override
                public void run() {
                    block0: for (int i2 = 0; i2 < 5 * nArray[0] && nArray[0] > 0; ++i2) {
                        final long[] lArray = new long[]{Clock.clock()};
                        final boolean[] blArray = new boolean[]{true};
                        Core.this.forSome(Selectors.and(Selectors.not(Core.this.connectionSource().availableConnectionsSelector()), Core.this.connectionSource().harvestableConnectionSelector()), new Applicator(){
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            @Override
                            public void apply(CoreConnection coreConnection) {
                                long l2 = coreConnection.lastAccessedTime();
                                if (l2 < lArray[0]) {
                                    lArray[0] = l2;
                                    blArray[0] = false;
                                }
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(11.class, long[].class, boolean[].class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                try {
                                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("apply", CoreConnection.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            }
                        });
                        if (blArray[0]) break;
                        for (String string : Core.this.knownServices) {
                            if (nArray[0] <= 0) continue block0;
                            Core.this.forSome(Selectors.and(Core.serviceSelector(string), Selectors.not(Core.this.connectionSource().availableConnectionsSelector()), Core.this.connectionSource().harvestableConnectionSelector(), coreConnection -> nArray[0] > 0), coreConnection -> {
                                if (coreConnection.lastAccessedTime() <= lArray[0]) {
                                    coreConnection.cleanupToHarvest();
                                    coreConnection.makeAvailable();
                                    nArray2[0] = nArray[0] - 1;
                                }
                            }, Core.this.servicePoolIterator(string, true));
                        }
                    }
                }

                static {
                    try {
                        $$$methodRef$$$3 = 11.class.getDeclaredConstructor(Core.class, int[].class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$2 = 11.class.getDeclaredMethod("lambda$run$0", int[].class, CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$1 = 11.class.getDeclaredMethod("lambda$run$1", long[].class, int[].class, CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 11.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    final boolean retrieve(CoreConnection coreConnection) {
        return null != this.retrieveFirst(Selectors.and(Core.serviceSelector(coreConnection.serviceName()), coreConnection2 -> {
            if (coreConnection.available()) {
                return false;
            }
            return coreConnection == coreConnection2;
        }));
    }

    final CoreConnection findSpecificConnection(Object object) {
        final CoreConnection[] coreConnectionArray = new CoreConnection[]{null};
        Selector selector = Selectors.not(this.connectionSource().availableConnectionsSelector());
        Selector selector2 = this.connectionSource().physicalConnectionSelector(object);
        this.forFirst(Selectors.and(selector, selector2), new Applicator(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public void apply(CoreConnection coreConnection) {
                coreConnectionArray[0] = coreConnection;
            }

            static {
                try {
                    $$$methodRef$$$1 = 12.class.getDeclaredConstructor(Core.class, CoreConnection[].class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 12.class.getDeclaredMethod("apply", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        return coreConnectionArray[0];
    }

    private void waitForPendingGrowsToFinish() {
        this.noMoreGrows.set(true);
        while (this.pendingAvailableGrows.get() + this.pendingBorrowedGrows.get() > 0) {
            try {
                this.stoppingLock.lock();
                this.stoppingCondition.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                ClioSupport.ilogWarning(null, null, null, null, "interrupted while waiting for pending grows to finish");
                break;
            }
            finally {
                this.stoppingLock.unlock();
            }
        }
    }

    private void enablePendingGrows() {
        this.noMoreGrows.set(false);
    }

    final void closeAll() {
        this.keepOverMinimum.set(false);
        this.peakConnectionsCount.reset();
        this.split(new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                coreConnection.abort();
                coreConnection.close();
                return true;
            }

            static {
                try {
                    $$$methodRef$$$1 = 13.class.getDeclaredConstructor(Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 13.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void adjustLimits() {
        this.adjustMinLimit(10);
        this.adjustMaxLimit();
    }

    private int getEffectiveMinPoolSize() {
        return this.keepOverMinimum.get() ? this.limits().getMin() : this.peakConnectionsCount.get();
    }

    void adjustMinLimit(final int n2) {
        Policies policies = this.policies();
        while (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < this.getEffectiveMinPoolSize()) {
            try {
                ClioSupport.ilogFine(null, null, null, null, "growing...");
                this.growAvailable(policies.getMostPopularCri(), n2 < 3);
                ClioSupport.ilogFine(null, null, null, null, "grew up 1 connection to reach the minimum");
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                break;
            }
        }
        if (this.totalCount().get() + this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get() < this.getEffectiveMinPoolSize() && n2 > 0) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
            }
            UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public void run() {
                    Core.this.adjustMinLimit(n2 - 1);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 14.class.getDeclaredConstructor(Core.class, Integer.TYPE);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 14.class.getDeclaredMethod("run", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            });
        }
    }

    void adjustMaxLimit() {
        final Limits limits = this.limits();
        for (CoreConnection coreConnection : this.split(new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                if (!coreConnection.available()) {
                    return false;
                }
                return Core.this.totalCount().get() > limits.getMax();
            }

            static {
                try {
                    $$$methodRef$$$1 = 15.class.getDeclaredConstructor(Core.class, Limits.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 15.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        })) {
            coreConnection.abort();
            coreConnection.close();
            ClioSupport.ilogFine(null, null, null, null, "closed one connection to stay under max limit");
        }
    }

    private Counter totalCount() {
        return this.connectionSource().totalCount();
    }

    private int borrowedCount() {
        return this.connectionSource().borrowedCount().get();
    }

    int availableCount() {
        return this.totalCount().get() - this.borrowedCount();
    }

    public long repurposeCount() {
        return this.repurposeCount.get();
    }

    void start(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        this.enablePendingGrows();
        ConnectionSource connectionSource = this.connectionSource();
        connectionSource.start(connectionRetrievalInfo);
        final ConnectionRetrievalInfo connectionRetrievalInfo2 = connectionSource.defaultCri();
        this.plugPolicies(new Policies(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public ConnectionRetrievalInfo getMostPopularCri() {
                return connectionRetrievalInfo2;
            }

            @Override
            public boolean isCriUnpopular(ConnectionRetrievalInfo connectionRetrievalInfo) {
                return !connectionRetrievalInfo2.equalsIncludingPassword(connectionRetrievalInfo);
            }

            static {
                try {
                    $$$methodRef$$$2 = 16.class.getDeclaredConstructor(Core.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 16.class.getDeclaredMethod("isCriUnpopular", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 16.class.getDeclaredMethod("getMostPopularCri", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void stop() {
        this.waitForPendingGrowsToFinish();
        this.closeAll();
        this.connectionSource().stop();
        this.knownServices.clear();
    }

    boolean available(ConnectionRetrievalInfo connectionRetrievalInfo) {
        ConnectionSource connectionSource = this.connectionSource();
        if (!connectionSource.validateCri(connectionRetrievalInfo)) {
            return false;
        }
        return connectionSource.available(connectionRetrievalInfo);
    }

    int pendingGrowsCount() {
        return this.pendingBorrowedGrows.get() + this.pendingAvailableGrows.get();
    }

    boolean noMoreGrows() {
        return this.noMoreGrows.get();
    }

    static {
        try {
            $$$methodRef$$$122 = Core.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$122 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$121 = Core.class.getDeclaredMethod("access$2400", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$121 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$120 = Core.class.getDeclaredMethod("access$2300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$120 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$119 = Core.class.getDeclaredMethod("access$2200", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$119 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$118 = Core.class.getDeclaredMethod("access$2100", Core.class, Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$118 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$117 = Core.class.getDeclaredMethod("access$2000", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$117 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$116 = Core.class.getDeclaredMethod("access$1900", Core.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$116 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$115 = Core.class.getDeclaredMethod("access$1800", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$115 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$114 = Core.class.getDeclaredMethod("access$1700", Core.class, ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$114 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$113 = Core.class.getDeclaredMethod("access$1600", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$113 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$112 = Core.class.getDeclaredMethod("access$1500", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$112 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$111 = Core.class.getDeclaredMethod("access$1400", Core.class, Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$111 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$110 = Core.class.getDeclaredMethod("access$1300", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$110 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$109 = Core.class.getDeclaredMethod("access$1200", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$109 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$108 = Core.class.getDeclaredMethod("access$1100", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$108 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$107 = Core.class.getDeclaredMethod("access$1000", Core.class, Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$107 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$106 = Core.class.getDeclaredMethod("access$900", Core.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$106 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$105 = Core.class.getDeclaredMethod("access$800", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$105 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$104 = Core.class.getDeclaredMethod("access$700", Core.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$104 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$103 = Core.class.getDeclaredMethod("access$600", Core.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$103 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$102 = Core.class.getDeclaredMethod("access$500", Core.class, Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$102 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$101 = Core.class.getDeclaredMethod("access$400", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$101 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$100 = Core.class.getDeclaredMethod("access$300", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$100 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$99 = Core.class.getDeclaredMethod("access$200", Core.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$99 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$98 = Core.class.getDeclaredMethod("access$000", Core.class, Selector.class, Applicator.class, Supplier[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$98 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$97 = Core.class.getDeclaredMethod("lambda$forSome$0", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$97 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$96 = Core.class.getDeclaredMethod("lambda$prepareSkipList$1", String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$96 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$95 = Core.class.getDeclaredMethod("lambda$prepareSkipList$2", KDTree[].class, String.class, SkipList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$95 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$94 = Core.class.getDeclaredMethod("lambda$preparePerfectCostSkipList$3", String.class, Properties.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$94 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$93 = Core.class.getDeclaredMethod("lambda$preparePerfectCostSkipList$4", KDTree[].class, String.class, Properties.class, SkipList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$93 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$92 = Core.class.getDeclaredMethod("lambda$prepareAcceptableCostSkipList$5", Properties.class, String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$92 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$91 = Core.class.getDeclaredMethod("lambda$prepareAcceptableCostSkipList$6", KDTree[].class, String.class, Properties.class, SkipList.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$91 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$90 = Core.class.getDeclaredMethod("lambda$costSuppliers$7", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$90 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$89 = Core.class.getDeclaredMethod("lambda$costSuppliers$8", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$89 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$88 = Core.class.getDeclaredMethod("lambda$serviceSuppliers$9", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$88 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$87 = Core.class.getDeclaredMethod("lambda$poolIterators$10", Supplier.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$87 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$86 = Core.class.getDeclaredMethod("lambda$serviceSelector$11", String.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$86 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$85 = Core.class.getDeclaredMethod("lambda$forFirst$12", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$85 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$84 = Core.class.getDeclaredMethod("lambda$helpBorrow$13", ConnectionRetrievalInfo.class, ConnectionSource.class, ConnectionAffinityCallback.class, Selector.class, Selector.class, boolean[].class, CoreConnection[].class, Comparator.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$84 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$83 = Core.class.getDeclaredMethod("lambda$helpBorrow$14", ConnectionRetrievalInfo.class, Selector.class, Selector.class, boolean[].class, CoreConnection[].class, Comparator.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$83 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$82 = Core.class.getDeclaredMethod("lambda$static$15", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$82 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$81 = Core.class.getDeclaredMethod("lambda$makeRoom$16", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$81 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$80 = Core.class.getDeclaredMethod("lambda$cleanUseless$17", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$80 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$79 = Core.class.getDeclaredMethod("lambda$closeAvailableInactive$18", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$79 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$78 = Core.class.getDeclaredMethod("lambda$reduce$19", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$78 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$77 = Core.class.getDeclaredMethod("lambda$replaceNonReusable$20", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$77 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$76 = Core.class.getDeclaredMethod("lambda$retrieve$21", CoreConnection.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$76 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$75 = Core.class.getDeclaredMethod("noMoreGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$75 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$74 = Core.class.getDeclaredMethod("pendingGrowsCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$74 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$73 = Core.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$73 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$72 = Core.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$72 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$71 = Core.class.getDeclaredMethod("start", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$71 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$70 = Core.class.getDeclaredMethod("repurposeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$70 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$69 = Core.class.getDeclaredMethod("availableCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$69 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$68 = Core.class.getDeclaredMethod("borrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$68 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$67 = Core.class.getDeclaredMethod("totalCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$67 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$66 = Core.class.getDeclaredMethod("adjustMaxLimit", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$66 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$65 = Core.class.getDeclaredMethod("adjustMinLimit", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$65 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$64 = Core.class.getDeclaredMethod("getEffectiveMinPoolSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$64 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$63 = Core.class.getDeclaredMethod("adjustLimits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$63 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$62 = Core.class.getDeclaredMethod("closeAll", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$62 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$61 = Core.class.getDeclaredMethod("enablePendingGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$61 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$60 = Core.class.getDeclaredMethod("waitForPendingGrowsToFinish", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$59 = Core.class.getDeclaredMethod("findSpecificConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$58 = Core.class.getDeclaredMethod("retrieve", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$57 = Core.class.getDeclaredMethod("harvest", Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = Core.class.getDeclaredMethod("returnTTLed", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = Core.class.getDeclaredMethod("returnAbandoned", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = Core.class.getDeclaredMethod("pendingAvailableGrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = Core.class.getDeclaredMethod("kickAdjuster", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = Core.class.getDeclaredMethod("replaceAvailable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = Core.class.getDeclaredMethod("replaceInvalidAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = Core.class.getDeclaredMethod("replaceAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = Core.class.getDeclaredMethod("replaceNonReusable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = Core.class.getDeclaredMethod("idle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = Core.class.getDeclaredMethod("reduce", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = Core.class.getDeclaredMethod("closeAvailableInactive", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = Core.class.getDeclaredMethod("initialize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = Core.class.getDeclaredMethod("growAvailableAsynch", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = Core.class.getDeclaredMethod("growAvailable", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = Core.class.getDeclaredMethod("growAvailable", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = Core.class.getDeclaredMethod("cleanUseless", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = Core.class.getDeclaredMethod("cleanUselessAsynch", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = Core.class.getDeclaredMethod("uselessConnsCleanerInProgress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = Core.class.getDeclaredMethod("makeRoom", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = Core.class.getDeclaredMethod("holdOverMakingRoom", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = Core.class.getDeclaredMethod("tryRepurpose", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = Core.class.getDeclaredMethod("prepareRebalanceHandler", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Core.class.getDeclaredMethod("prepareFailoverHandler", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Core.class.getDeclaredMethod("growBorrowed", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Core.class.getDeclaredMethod("reclaim", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Core.class.getDeclaredMethod("updateRLBStats", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Core.class.getDeclaredMethod("helpBorrow", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Core.class.getDeclaredMethod("borrow", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Core.class.getDeclaredMethod("policies", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Core.class.getDeclaredMethod("plugPolicies", Policies.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Core.class.getDeclaredMethod("limits", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Core.class.getDeclaredMethod("plugLimits", Limits.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Core.class.getDeclaredMethod("connectionSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Core.class.getDeclaredMethod("plugConnectionSource", ConnectionSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Core.class.getDeclaredMethod("registerService", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Core.class.getDeclaredMethod("retrieveFirst", Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Core.class.getDeclaredMethod("forFirst", Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Core.class.getDeclaredMethod("forFirst", Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Core.class.getDeclaredMethod("forFirst", Selector.class, Applicator.class, Supplier[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Core.class.getDeclaredMethod("serviceSelector", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Core.class.getDeclaredMethod("costPoolIterators", String.class, Properties.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Core.class.getDeclaredMethod("servicePoolIterator", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Core.class.getDeclaredMethod("poolIterators", Supplier[].class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Core.class.getDeclaredMethod("serviceSuppliers", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Core.class.getDeclaredMethod("costSuppliers", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Core.class.getDeclaredMethod("prepareAcceptableCostSkipList", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Core.class.getDeclaredMethod("preparePerfectCostSkipList", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Core.class.getDeclaredMethod("prepareSkipList", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Core.class.getDeclaredMethod("searchCriteria", String.class, Properties.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Core.class.getDeclaredMethod("searchCriteria", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Core.class.getDeclaredMethod("forSome", Selector.class, Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Core.class.getDeclaredMethod("forSome", Selector.class, Applicator.class, Supplier.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Core.class.getDeclaredMethod("forSome", Selector.class, Applicator.class, Supplier[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Core.class.getDeclaredMethod("split", Selector.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Core.class.getDeclaredMethod("forEach", Applicator.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Core.class.getDeclaredMethod("put", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Core.class.getDeclaredMethod("clearWFPTree", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        isAffinityStrict = Util.isAffinityStrict();
        markedAlready = coreConnection -> coreConnection.markedCloseOnReturn() || coreConnection.markedToReplace();
        coreInstances = new ConcurrentLinkedQueue<Core>();
        Runtime.getRuntime().addShutdownHook(new Thread(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public void run() {
                coreInstances.forEach(core -> {
                    ((Core)core).waitForPendingGrowsToFinish();
                    ClioSupport.ilogFinest(null, null, null, null, core.toString() + ": pending grows finished gracefully");
                });
                ClioSupport.ilogFinest(null, null, null, null, "control thread stopped");
            }

            static {
                try {
                    $$$methodRef$$$2 = 17.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 17.class.getDeclaredMethod("lambda$run$0", Core.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 17.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    private static class DRange {
        private final Range[] range;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        DRange(Range[] rangeArray) {
            this.range = rangeArray;
        }

        public boolean equals(Object object) {
            if (object instanceof DRange) {
                return Arrays.deepEquals(this.range, ((DRange)object).range);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.deepHashCode(this.range);
        }

        static {
            try {
                $$$methodRef$$$2 = DRange.class.getDeclaredConstructor(Range[].class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = DRange.class.getDeclaredMethod("hashCode", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = DRange.class.getDeclaredMethod("equals", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    private static class WFPTree
    extends KDTree<SkipList<CoreConnection>> {
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        WFPTree(SkipList skipList, String string, String string2, int n2) {
            this(skipList, new Point(new Comparable[]{string, string2, Integer.valueOf(n2)}));
        }

        WFPTree(SkipList skipList, Point point) {
            super(skipList, point);
        }

        static WFPTree seed() {
            return new WFPTree(null, "", "", Integer.MAX_VALUE);
        }

        static {
            try {
                $$$methodRef$$$2 = WFPTree.class.getDeclaredConstructor(SkipList.class, Point.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = WFPTree.class.getDeclaredConstructor(SkipList.class, String.class, String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = WFPTree.class.getDeclaredMethod("seed", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

