/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.LABELING, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.CONN_HARVESTING, Feature.TTL_CONN_TIMEOUT, Feature.ABANDONED_CONN_TIMEOUT})
abstract class Database
implements ConnectionSource {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;

    Database() {
    }

    protected abstract ConnectionFactoryAdapter getConnectionFactoryAdapter();

    protected abstract AtomicInteger connectionsCreated();

    protected abstract AtomicInteger connectionsClosed();

    @Override
    public Comparator<CoreConnection> costComparator(final Properties properties) {
        return new Comparator<CoreConnection>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public int compare(CoreConnection coreConnection, CoreConnection coreConnection2) {
                if (null == coreConnection) {
                    throw new IllegalArgumentException("conn1 is null");
                }
                if (null == coreConnection2) {
                    throw new IllegalArgumentException("conn2 is null");
                }
                UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)coreConnection.getDelegate();
                UniversalPooledConnection universalPooledConnection2 = (UniversalPooledConnection)coreConnection2.getDelegate();
                return universalPooledConnection.labelingCost(properties) - universalPooledConnection2.labelingCost(properties);
            }

            @Override
            public boolean equals(Object object) {
                if (!(object instanceof Comparator)) {
                    return false;
                }
                return this == object;
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(Database.class, Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("compare", Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("equals", Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("compare", CoreConnection.class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector perfectCostSelector(final Properties properties) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                int n2 = ((UniversalPooledConnection)coreConnection.getDelegate()).labelingCost(properties);
                return 0 == n2;
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(Database.class, Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector physicalConnectionSelector(final Object object) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)coreConnection.getDelegate();
                return object == universalPooledConnection.getPhysicalConnection();
            }

            static {
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredConstructor(Database.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector wrongCostSelector(final Properties properties) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                int n2 = ((UniversalPooledConnection)coreConnection.getDelegate()).labelingCost(properties);
                return Integer.MAX_VALUE == n2;
            }

            static {
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredConstructor(Database.class, Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector matchingCriSelector(final ConnectionRetrievalInfo connectionRetrievalInfo) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                return coreConnection.cri().equalsIncludingPassword(connectionRetrievalInfo);
            }

            static {
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredConstructor(Database.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector availableConnectionsSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                return coreConnection.available();
            }

            static {
                try {
                    $$$methodRef$$$1 = 6.class.getDeclaredConstructor(Database.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 6.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector harvestableConnectionSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                return ((UniversalPooledConnection)coreConnection.getDelegate()).isConnectionHarvestable();
            }

            static {
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Database.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector inactiveConnectionsSelector(final long l2) {
        Selector selector = new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)coreConnection.getDelegate();
                return Clock.clock() - l2 >= universalPooledConnection.getAvailableStartTime();
            }

            static {
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Database.class, Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        return Selectors.and(this.availableConnectionsSelector(), selector);
    }

    @Override
    public Selector abandonedConnectionsSelector(final long l2) {
        Selector selector = new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                AbandonedConnectionTimeoutCallback abandonedConnectionTimeoutCallback;
                long l22 = Clock.clock();
                UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)coreConnection.getDelegate();
                if (universalPooledConnection.getAvailableStartTime() > l22 || universalPooledConnection.getBorrowedStartTime() > l22) {
                    return false;
                }
                if (universalPooledConnection.getLastAccessedTime() > l22 - l2 || universalPooledConnection.isSqlWithQueryTimeoutInProgress()) {
                    return false;
                }
                try {
                    abandonedConnectionTimeoutCallback = universalPooledConnection.getAbandonedConnectionTimeoutCallback();
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                    return false;
                }
                return abandonedConnectionTimeoutCallback == null || abandonedConnectionTimeoutCallback != null && !abandonedConnectionTimeoutCallback.handleTimedOutConnection();
            }

            static {
                try {
                    $$$methodRef$$$1 = 9.class.getDeclaredConstructor(Database.class, Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 9.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        return Selectors.and(Selectors.not(this.availableConnectionsSelector()), this.harvestableConnectionSelector(), selector);
    }

    @Override
    public Selector ttlConnectionsSelector(final long l2) {
        Selector selector = new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                TimeToLiveConnectionTimeoutCallback timeToLiveConnectionTimeoutCallback;
                long l22 = Clock.clock();
                UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)coreConnection.getDelegate();
                if (universalPooledConnection.getAvailableStartTime() > l22 || universalPooledConnection.getBorrowedStartTime() > l22) {
                    return false;
                }
                if (universalPooledConnection.getBorrowedStartTime() > l22 - l2) {
                    return false;
                }
                try {
                    timeToLiveConnectionTimeoutCallback = universalPooledConnection.getTimeToLiveConnectionTimeoutCallback();
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                    return false;
                }
                return timeToLiveConnectionTimeoutCallback == null || timeToLiveConnectionTimeoutCallback != null && !timeToLiveConnectionTimeoutCallback.handleTimedOutConnection();
            }

            static {
                try {
                    $$$methodRef$$$1 = 10.class.getDeclaredConstructor(Database.class, Long.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 10.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        return Selectors.and(Selectors.not(this.availableConnectionsSelector()), this.harvestableConnectionSelector(), selector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniversalPooledConnection createPooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (connectionRetrievalInfo == null) {
            ClioSupport.ilogWarning(null, null, null, null, "CRI is not defined");
            return null;
        }
        Object object = null;
        UniversalPooledConnection universalPooledConnection = null;
        try {
            object = this.getConnectionFactoryAdapter().createConnection(connectionRetrievalInfo);
            if (null == object) {
                UCPErrorHandler.throwUniversalConnectionPoolException(100);
            }
            universalPooledConnection = this.getConnectionFactoryAdapter().createPooledConnection(object, connectionRetrievalInfo.getCopyWithNoLabels());
            this.connectionsCreated().incrementAndGet();
        }
        finally {
            if (null != object && null == universalPooledConnection) {
                try {
                    this.getConnectionFactoryAdapter().closeConnection(object);
                    this.connectionsClosed().incrementAndGet();
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
            }
        }
        return universalPooledConnection;
    }

    static {
        try {
            $$$methodRef$$$11 = Database.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Database.class.getDeclaredMethod("createPooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Database.class.getDeclaredMethod("ttlConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Database.class.getDeclaredMethod("abandonedConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Database.class.getDeclaredMethod("inactiveConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Database.class.getDeclaredMethod("harvestableConnectionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Database.class.getDeclaredMethod("availableConnectionsSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Database.class.getDeclaredMethod("matchingCriSelector", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Database.class.getDeclaredMethod("wrongCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Database.class.getDeclaredMethod("physicalConnectionSelector", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Database.class.getDeclaredMethod("perfectCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Database.class.getDeclaredMethod("costComparator", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }
}

