/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.RingBuffer;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.UCPTimerTaskImpl;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.HIGH_AVAILABILITY})
public abstract class FailoverDriver {
    private final TaskManager taskManager;
    private AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final LinkedList<Event> recentHAEvents = new LinkedList();
    private static final long EVENT_AGE_OUT_PERIOD = 120000L;
    private UCPTimerTaskImpl delayedPlannedDownTimerTask = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private static final String FAN_STATUS_FIELD = "status";
    private static final Pattern ff_pg1;
    private static final Pattern ff_pg2;
    private static final Pattern ff_pg3;
    private static final Pattern ff_pg4;
    private static final Pattern ff_pg5;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public FailoverDriver() {
        this(UniversalConnectionPoolManagerBase.getTaskManager());
    }

    public FailoverDriver(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    protected abstract ConnectionSource.FailoverCallback.Result onEvent(Event var1, Selector var2, Selector var3, boolean var4, boolean var5);

    protected abstract Service service();

    private Task<Object> prepareTask(final ONSDriver oNSDriver) {
        return new UCPTaskBase<Object>(){
            Subscriber subscriber = null;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            @Override
            public boolean isCritical() {
                return true;
            }

            @Override
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.HIGH_AVAILABILITY})
            public void run() {
                try {
                    this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        private static Executable $$$methodRef$$$2;
                        private static Logger $$$loggerRef$$$2;

                        @Override
                        public Subscriber run() throws UniversalConnectionPoolException {
                            try {
                                return oNSDriver.createSubscriber("((%\"eventType=database/event/service\")&($%'service=" + FailoverDriver.this.service().name() + "'))|(%\"eventType=database/event/host\")");
                            }
                            catch (Exception exception) {
                                ClioSupport.ilogThrowing(null, null, null, null, exception);
                                throw new UniversalConnectionPoolException(exception);
                            }
                        }

                        static {
                            try {
                                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(1.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (null == this.subscriber) {
                        return;
                    }
                    this.handleNotifications();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    ClioSupport.ilogThrowing(null, null, null, null, privilegedActionException);
                }
                finally {
                    if (null != this.subscriber) {
                        this.subscriber.close();
                        this.subscriber = null;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.HIGH_AVAILABILITY})
            private void handleNotifications() {
                FailoverDriver.this.terminate.set(false);
                while (true) {
                    if (Thread.currentThread().isInterrupted() || FailoverDriver.this.terminate.get()) {
                        ClioSupport.ilogFine(null, null, null, null, "terminated");
                        return;
                    }
                    try {
                        abstract class XSelector
                        implements Selector {
                            final /* synthetic */ Event.EventType val$eventType;
                            final /* synthetic */ String val$instname;
                            final /* synthetic */ String val$service;
                            final /* synthetic */ String val$hostname;
                            final /* synthetic */ String val$database;
                            private static Executable $$$methodRef$$$0;
                            private static Logger $$$loggerRef$$$0;
                            private static Executable $$$methodRef$$$1;
                            private static Logger $$$loggerRef$$$1;

                            XSelector() {
                                this.val$eventType = eventType;
                                this.val$instname = string;
                                this.val$service = string2;
                                this.val$hostname = string3;
                                this.val$database = string4;
                            }

                            protected boolean toHandle(CoreConnection coreConnection) {
                                ServiceMember serviceMember = coreConnection.serviceMember();
                                if (null == serviceMember) {
                                    return false;
                                }
                                if (Event.EventType.INSTANCE == this.val$eventType || Event.EventType.SERVICEMEMBER == this.val$eventType) {
                                    return serviceMember.name().equals(this.val$instname) && serviceMember.service().equals(this.val$service) && serviceMember.host().equals(this.val$hostname) && serviceMember.database().equals(this.val$database);
                                }
                                if (Event.EventType.SERVICE == this.val$eventType) {
                                    return serviceMember.service().equals(this.val$service) && serviceMember.database().equals(this.val$database);
                                }
                                if (Event.EventType.NODE == this.val$eventType) {
                                    return serviceMember.host().equals(this.val$hostname);
                                }
                                return false;
                            }

                            static {
                                try {
                                    $$$methodRef$$$1 = XSelector.class.getDeclaredConstructor(1.class, Event.EventType.class, String.class, String.class, String.class, String.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                try {
                                    $$$methodRef$$$0 = XSelector.class.getDeclaredMethod("toHandle", CoreConnection.class);
                                }
                                catch (Throwable throwable) {}
                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            }
                        }
                        int n2;
                        int n3;
                        ServiceMember serviceMember2;
                        Notification notification = this.subscriber.receive(true);
                        FailoverDriver.this.service().fdStats.currentEvent.set(null);
                        if (notification == null) {
                            ClioSupport.ilogFine(null, null, null, null, "empty notification");
                            continue;
                        }
                        String string = notification.type();
                        ClioSupport.ilogFinest(null, null, null, null, string.toString());
                        String string2 = new String(notification.body());
                        ClioSupport.ilogFinest(null, null, null, null, string2.toString());
                        final Event event = notification.get(FailoverDriver.FAN_STATUS_FIELD) != null ? FailoverDriver.this.createEvent(notification) : FailoverDriver.this.parseNotification(string.toLowerCase(), string2.toLowerCase());
                        final String string3 = event.serviceName();
                        final String string4 = event.database();
                        final String string5 = event.host();
                        final Event.EventType eventType = event.event_type();
                        FailoverDriver.this.service().fdStats.currentEvent.set(event);
                        if ((Event.EventType.INSTANCE == eventType || Event.EventType.SERVICEMEMBER == eventType || Event.EventType.SERVICE == eventType) && (null == string3 || string3.equals("") || null == string4 || string4.equals(""))) {
                            ClioSupport.ilogFinest(null, null, null, null, "invalid service event: not processed");
                            FailoverDriver.this.service().fdStats.update(Stats.INVALID_EVENT_PROC_RESULT);
                            continue;
                        }
                        if (Event.EventType.NODE == eventType && (null == string5 || string5.equals(""))) {
                            ClioSupport.ilogFinest(null, null, null, null, "invalid host down event: not processed");
                            FailoverDriver.this.service().fdStats.update(Stats.INVALID_EVENT_PROC_RESULT);
                            continue;
                        }
                        if (FailoverDriver.this.filtered(event)) continue;
                        FailoverDriver.this.recentEvent = event;
                        FailoverDriver.this.service().markup(event);
                        ClioSupport.ilogFinest(null, null, null, null, event.toString());
                        Event.Status status = event.status();
                        final boolean bl2 = event.isPlanned();
                        final String string6 = event.instance();
                        ServiceMember serviceMember3 = serviceMember2 = Event.EventType.SERVICEMEMBER == eventType || Event.EventType.INSTANCE == eventType ? FailoverDriver.this.service().getMember(string6, event.database(), event.host(), event.serviceName()) : null;
                        if (Event.Status.DOWN == status || Event.Status.NOT_RESTARTING == status || Event.Status.RESTART_FAILED == status) {
                            int n4;
                            n3 = FailoverDriver.this.service().activeCount() + FailoverDriver.this.service().borrowedCount();
                            n2 = event.drain_timeout() > 0 ? event.drain_timeout() : (n3 <= 5 ? 0 : Util.getPlannedDrainingPeriod());
                            FailoverDriver.this.service().setLastDrainTimeout(n2);
                            boolean bl3 = FailoverDriver.this.service().activeMembersCount() == 0;
                            TimerManager timerManager = UniversalConnectionPoolManagerBase.getTimerManager();
                            int n5 = bl3 ? FailoverDriver.this.service().activeCount() : (n4 = null == serviceMember2 ? 0 : serviceMember2.activeCount.get());
                            if (bl2 && n2 > 0 && timerManager.isRunning()) {
                                final UCPTimerTaskImpl uCPTimerTaskImpl = new UCPTimerTaskImpl(){
                                    final int drainIntervals;
                                    final int countToDrainPerInterval;
                                    int countDrainedThisInterval;
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;
                                    {
                                        this.drainIntervals = (n2 + Util.PLANNED_DRAINING_INTERVAL - 1) / Util.PLANNED_DRAINING_INTERVAL;
                                        this.countToDrainPerInterval = (n4 + this.drainIntervals - 1) / this.drainIntervals;
                                        this.countDrainedThisInterval = 0;
                                    }

                                    @Override
                                    @DefaultLogger(value="oracle.ucp.common")
                                    @Supports(value={Feature.HIGH_AVAILABILITY})
                                    public void run() {
                                        this.countDrainedThisInterval = 0;
                                        FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                            private static Executable $$$methodRef$$$0;
                                            private static Logger $$$loggerRef$$$0;
                                            private static Executable $$$methodRef$$$1;
                                            private static Logger $$$loggerRef$$$1;
                                            {
                                                super(this, eventType2, string42, string32, string2, string);
                                            }

                                            @Override
                                            public boolean selected(CoreConnection coreConnection) {
                                                if (!coreConnection.available()) {
                                                    return false;
                                                }
                                                if (countDrainedThisInterval >= countToDrainPerInterval) {
                                                    return false;
                                                }
                                                boolean bl2 = this.toHandle(coreConnection);
                                                if (bl2) {
                                                    ++countDrainedThisInterval;
                                                }
                                                return bl2;
                                            }

                                            static {
                                                try {
                                                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(2.class, String.class, String.class, String.class, String.class, Event.EventType.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                                try {
                                                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                            }
                                        }, new XSelector(){
                                            private static Executable $$$methodRef$$$0;
                                            private static Logger $$$loggerRef$$$0;
                                            private static Executable $$$methodRef$$$1;
                                            private static Logger $$$loggerRef$$$1;
                                            {
                                                super(this, eventType2, string42, string32, string2, string);
                                            }

                                            @Override
                                            public boolean selected(CoreConnection coreConnection) {
                                                if (coreConnection.available()) {
                                                    return false;
                                                }
                                                if (countDrainedThisInterval >= countToDrainPerInterval) {
                                                    return false;
                                                }
                                                if (!coreConnection.normal()) {
                                                    return false;
                                                }
                                                boolean bl2 = this.toHandle(coreConnection);
                                                if (bl2) {
                                                    ++countDrainedThisInterval;
                                                }
                                                return bl2;
                                            }

                                            static {
                                                try {
                                                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(2.class, String.class, String.class, String.class, String.class, Event.EventType.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                                try {
                                                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                                                }
                                                catch (Throwable throwable) {}
                                                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                            }
                                        }, true, false));
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 2.class.getDeclaredConstructor(1.class, Integer.TYPE, Integer.TYPE, Event.class, String.class, String.class, String.class, String.class, Event.EventType.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 2.class.getDeclaredMethod("run", new Class[0]);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                                    }
                                };
                                if (bl3) {
                                    FailoverDriver.this.delayedPlannedDownTimerTask = uCPTimerTaskImpl;
                                } else {
                                    UniversalConnectionPoolManagerBase.getTimerManager().schedule(uCPTimerTaskImpl, 0L, (long)Util.PLANNED_DRAINING_INTERVAL * 1000L);
                                    UniversalConnectionPoolManagerBase.getTimerManager().schedule(new UCPTimerTaskImpl(){
                                        private static Executable $$$methodRef$$$0;
                                        private static Logger $$$loggerRef$$$0;
                                        private static Executable $$$methodRef$$$1;
                                        private static Logger $$$loggerRef$$$1;

                                        @Override
                                        public void run() {
                                            uCPTimerTaskImpl.cancel();
                                            if (FailoverDriver.this.isGDS()) {
                                                FailoverDriver.this.agingOutEvents();
                                            }
                                        }

                                        static {
                                            try {
                                                $$$methodRef$$$1 = 3.class.getDeclaredConstructor(1.class, UCPTimerTaskImpl.class);
                                            }
                                            catch (Throwable throwable) {}
                                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                            try {
                                                $$$methodRef$$$0 = 3.class.getDeclaredMethod("run", new Class[0]);
                                            }
                                            catch (Throwable throwable) {}
                                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        }
                                    }, n2 * 1000 + 100, 0L);
                                }
                            } else {
                                FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;
                                    {
                                        super(this, eventType2, string42, string32, string2, string);
                                    }

                                    @Override
                                    public boolean selected(CoreConnection coreConnection) {
                                        if (bl2 && !coreConnection.available()) {
                                            return false;
                                        }
                                        if (!bl2 && coreConnection.reconnecting()) {
                                            return false;
                                        }
                                        return this.toHandle(coreConnection);
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 4.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 4.class.getDeclaredMethod("selected", CoreConnection.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                }, new XSelector(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;
                                    {
                                        super(this, eventType2, string42, string32, string2, string);
                                    }

                                    @Override
                                    public boolean selected(CoreConnection coreConnection) {
                                        if (!bl2 || coreConnection.available()) {
                                            return false;
                                        }
                                        if (!coreConnection.normal()) {
                                            return false;
                                        }
                                        return this.toHandle(coreConnection);
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 5.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 5.class.getDeclaredMethod("selected", CoreConnection.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                }, false, false));
                            }
                        } else if (Event.Status.UP == status) {
                            if (0 == FailoverDriver.this.service().activeMembersCount()) continue;
                            n3 = FailoverDriver.this.service().getLastDrainTimeout();
                            if (FailoverDriver.this.delayedPlannedDownTimerTask != null) {
                                UniversalConnectionPoolManagerBase.getTimerManager().schedule(FailoverDriver.this.delayedPlannedDownTimerTask, 0L, (long)Util.PLANNED_DRAINING_INTERVAL * 1000L);
                                UniversalConnectionPoolManagerBase.getTimerManager().schedule(new UCPTimerTaskImpl(){
                                    private static Executable $$$methodRef$$$0;
                                    private static Logger $$$loggerRef$$$0;
                                    private static Executable $$$methodRef$$$1;
                                    private static Logger $$$loggerRef$$$1;

                                    @Override
                                    public void run() {
                                        FailoverDriver.this.delayedPlannedDownTimerTask.cancel();
                                        if (FailoverDriver.this.isGDS()) {
                                            FailoverDriver.this.agingOutEvents();
                                        }
                                    }

                                    static {
                                        try {
                                            $$$methodRef$$$1 = 6.class.getDeclaredConstructor(1.class);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                        try {
                                            $$$methodRef$$$0 = 6.class.getDeclaredMethod("run", new Class[0]);
                                        }
                                        catch (Throwable throwable) {}
                                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    }
                                }, n3 * 1000 + 100, 0L);
                                continue;
                            }
                            n2 = FailoverDriver.this.service().activeCount() / FailoverDriver.this.service().activeMembersCount();
                            final int[] nArray = new int[]{0};
                            FailoverDriver.this.service().getAllMembers().forEach(serviceMember -> {
                                if (serviceMember.activeCount.get() > n2) {
                                    nArray[0] = nArray[0] + (serviceMember.activeCount.get() - n2);
                                }
                            });
                            FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string42, string32, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection coreConnection) {
                                    if (!coreConnection.available()) {
                                        return false;
                                    }
                                    if (!this.toHandle(coreConnection) && coreConnection.serviceMember().activeCount.get() > n2) {
                                        int n22 = nArray[0];
                                        nArray[0] = n22 - 1;
                                        return n22 > 0;
                                    }
                                    return false;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 7.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Integer.TYPE, int[].class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 7.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string42, string32, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection coreConnection) {
                                    if (coreConnection.available()) {
                                        return false;
                                    }
                                    if (!this.toHandle(coreConnection) && coreConnection.serviceMember().activeCount.get() > n2) {
                                        int n22 = nArray[0];
                                        nArray[0] = n22 - 1;
                                        return n22 > 0;
                                    }
                                    return false;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 8.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Integer.TYPE, int[].class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 8.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, false, true));
                        } else if (Event.Status.NODEDOWN == status) {
                            FailoverDriver.this.service().fdStats.update(FailoverDriver.this.onEventX(event, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string42, string32, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection coreConnection) {
                                    if (bl2 && !coreConnection.available()) {
                                        return false;
                                    }
                                    if (!bl2 && coreConnection.reconnecting()) {
                                        return false;
                                    }
                                    return this.toHandle(coreConnection);
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 9.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 9.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, new XSelector(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;
                                {
                                    super(this, eventType2, string42, string32, string2, string);
                                }

                                @Override
                                public boolean selected(CoreConnection coreConnection) {
                                    if (!bl2 || coreConnection.available()) {
                                        return false;
                                    }
                                    if (!coreConnection.normal()) {
                                        return false;
                                    }
                                    return this.toHandle(coreConnection);
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 10.class.getDeclaredConstructor(1.class, String.class, String.class, String.class, String.class, Event.EventType.class, Boolean.TYPE);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                    try {
                                        $$$methodRef$$$0 = 10.class.getDeclaredMethod("selected", CoreConnection.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                                }
                            }, false, false));
                        } else {
                            ClioSupport.ilogFinest(null, null, null, null, "invalid event");
                        }
                        if (!FailoverDriver.this.isGDS()) continue;
                        FailoverDriver.this.agingOutEvents();
                        continue;
                    }
                    catch (Throwable throwable) {
                        ClioSupport.ilogFine(null, null, null, null, throwable.toString());
                        ClioSupport.ilogThrowing(null, null, null, null, throwable);
                        continue;
                    }
                    finally {
                        ClioSupport.ilogFine(null, null, null, null, "event processed, snapshot:" + FailoverDriver.this.service().getAllMembers().toString());
                        continue;
                    }
                    break;
                }
            }

            static {
                try {
                    $$$methodRef$$$4 = 1.class.getDeclaredConstructor(FailoverDriver.class, ONSDriver.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredMethod("lambda$handleNotifications$0", Integer.TYPE, int[].class, ServiceMember.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("handleNotifications", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("isCritical", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private ConnectionSource.FailoverCallback.Result onEventX(Event event, Selector selector, Selector selector2, boolean bl2, boolean bl3) {
        this.service().pendingRebalance.getAndSet(new ConnectionSource.RebalanceCallback.Result()).terminate();
        return this.onEvent(event, selector, selector2, bl2, bl3);
    }

    Event createEvent(Notification notification) {
        return new EventImpl(notification);
    }

    Event parseNotification(String string, String string2) {
        Matcher matcher;
        Properties properties = new Properties();
        Matcher matcher2 = ff_pg1.matcher(string2);
        while (matcher2.find()) {
            properties.setProperty(matcher2.group(1), matcher2.group(2));
        }
        Matcher matcher3 = ff_pg2.matcher(string2);
        if (matcher3.find()) {
            if (ff_pg4.matcher(matcher3.group(2)).find()) {
                properties.setProperty(matcher3.group(1), matcher3.group(2));
            } else {
                throw new IllegalStateException("unaccepted timezone format: " + matcher3.group(2));
            }
        }
        if ((matcher = ff_pg3.matcher(string2)).find()) {
            if (ff_pg5.matcher(matcher.group(2)).find()) {
                properties.setProperty(matcher.group(1), matcher.group(2));
            } else {
                throw new IllegalStateException("unaccepted timezone format: " + matcher.group(2));
            }
        }
        return new EventImpl(properties, string);
    }

    public ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo connectionRetrievalInfo) {
        Event event = this.recentEvent;
        if (null == event) {
            return null;
        }
        ServiceMember serviceMember = null;
        int n2 = 0;
        for (ServiceMember serviceMember2 : this.service().getAllMembers(connectionRetrievalInfo, true)) {
            int n3;
            int n4;
            int n5;
            if (!serviceMember2.active() || (n5 = serviceMember2.activeCount.get()) >= (n4 = this.service().activeCount() / this.service().activeMembersCount()) || (n3 = n4 - n5) <= n2) continue;
            n2 = n3;
            serviceMember = serviceMember2;
        }
        return serviceMember;
    }

    public boolean start(ONSDriver oNSDriver) {
        if (this.task.compareAndSet(null, this.prepareTask(oNSDriver))) {
            this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
            ClioSupport.ilogFinest(null, null, null, null, "started");
        }
        return true;
    }

    public void stop() {
        Task task = this.task.getAndSet(null);
        if (null != task) {
            block4: {
                task.release();
                this.terminate.set(true);
                try {
                    TaskHandle taskHandle = this.taskHandle.getAndSet(null);
                    if (null != taskHandle) {
                        taskHandle.get(100000L);
                    }
                }
                catch (TaskManagerException taskManagerException) {
                    if (taskManagerException.getCause() instanceof CancellationException) break block4;
                    ClioSupport.ilogThrowing(null, null, null, null, taskManagerException);
                }
            }
            ClioSupport.ilogFinest(null, null, null, null, "stopped");
        }
    }

    public Event recentEvent() {
        return this.recentEvent;
    }

    private boolean filtered(Event event) {
        if (this.recentEvent != null && event.timestamp().before(this.recentEvent.timestamp())) {
            ClioSupport.ilogWarning(null, null, null, null, "Out-of-order HA event received and ignored");
            this.service().fdStats.update(Stats.OUTOFORDER_EVENT_PROC_RESULT);
            return true;
        }
        if (event.event_type() != Event.EventType.NODE && event.event_type() != Event.EventType.UNKNOWN && !event.serviceName().equals(this.service().name())) {
            ClioSupport.ilogWarning(null, null, null, null, "Non-Applicable HA event received and ignored: different service name");
            return true;
        }
        if (!this.isGDS()) {
            return false;
        }
        Iterator<Event> iterator = this.recentHAEvents.descendingIterator();
        boolean bl2 = false;
        Event.EventType eventType = event.event_type();
        String string = event.serviceName();
        String string2 = event.instance();
        String string3 = event.database();
        String string4 = event.host();
        Event.Status status = event.status();
        if (Event.EventType.INSTANCE == eventType || Event.EventType.SERVICEMEMBER == eventType || Event.EventType.SERVICE == eventType) {
            String string5 = null;
            while (iterator.hasNext()) {
                Event event2 = iterator.next();
                string5 = event2.instance();
                if (status == null || !status.equals((Object)event2.status()) || string == null || !string.equals(event2.serviceName()) || string3 == null || !string3.equals(event2.database()) || string4 == null || !string4.equals(event2.host()) || !(string2 == null && string5 == null || string2 == null && string5 != null && (status == Event.Status.DOWN && this.service().activeMembersCount() < 1 || status == Event.Status.UP && this.service().activeMembersCount() <= 1)) && (string2 == null || string5 != null && !string2.equals(string5))) continue;
                bl2 = true;
                ClioSupport.ilogWarning(null, null, null, null, "Redundant HA service event received and ignored: the event with the same set of instance, database, host and service has already arrived in less than 120000 milliseconds");
                break;
            }
        } else if (Event.EventType.NODE == eventType) {
            while (iterator.hasNext()) {
                Event event3 = iterator.next();
                if (string4 == null || !string4.equals(event3.host())) continue;
                bl2 = true;
                ClioSupport.ilogFinest(null, null, null, null, "Redundant HA host event received and ignored");
                break;
            }
        }
        if (!bl2) {
            this.recentHAEvents.addLast(event);
        } else {
            this.service().fdStats.update(Stats.REDUNDANT_EVENT_PROC_RESULT);
        }
        return bl2;
    }

    private boolean isGDS() {
        Service service = this.service();
        if (null == service) {
            return false;
        }
        String string = service.name();
        if (null == string) {
            return false;
        }
        return string.contains("%");
    }

    private void agingOutEvents() {
        if (this.recentEvent != null) {
            Event event;
            long l2 = this.recentEvent.timestamp().getTime();
            while ((event = this.recentHAEvents.peekFirst()) != null && l2 > event.timestamp().getTime() + 120000L) {
                this.recentHAEvents.removeFirst();
            }
        }
    }

    static {
        try {
            $$$methodRef$$$21 = FailoverDriver.class.getDeclaredConstructor(TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = FailoverDriver.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = FailoverDriver.class.getDeclaredMethod("access$400", FailoverDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = FailoverDriver.class.getDeclaredMethod("access$600", FailoverDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = FailoverDriver.class.getDeclaredMethod("access$500", FailoverDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = FailoverDriver.class.getDeclaredMethod("access$402", FailoverDriver.class, UCPTimerTaskImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = FailoverDriver.class.getDeclaredMethod("access$300", FailoverDriver.class, Event.class, Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = FailoverDriver.class.getDeclaredMethod("access$202", FailoverDriver.class, Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = FailoverDriver.class.getDeclaredMethod("access$100", FailoverDriver.class, Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = FailoverDriver.class.getDeclaredMethod("access$000", FailoverDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = FailoverDriver.class.getDeclaredMethod("agingOutEvents", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = FailoverDriver.class.getDeclaredMethod("isGDS", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = FailoverDriver.class.getDeclaredMethod("filtered", Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = FailoverDriver.class.getDeclaredMethod("recentEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = FailoverDriver.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = FailoverDriver.class.getDeclaredMethod("start", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = FailoverDriver.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = FailoverDriver.class.getDeclaredMethod("underloadedInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = FailoverDriver.class.getDeclaredMethod("parseNotification", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = FailoverDriver.class.getDeclaredMethod("createEvent", Notification.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = FailoverDriver.class.getDeclaredMethod("onEventX", Event.class, Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = FailoverDriver.class.getDeclaredMethod("prepareTask", ONSDriver.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        ff_pg1 = Pattern.compile("(version|event_type|service|instance|database|db_domain|host|status|reason|card|drain_timeout)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
        ff_pg2 = Pattern.compile("(timestamp)=\\s*(\\S+\\s\\S+)");
        ff_pg3 = Pattern.compile("(timezone)=(.*)");
        ff_pg4 = Pattern.compile("\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2}");
        ff_pg5 = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");
    }

    @DisableTrace
    public static class Stats
    extends RingBuffer<StatsOne> {
        final AtomicReference<Event> currentEvent = new AtomicReference<Object>(null);
        static final ConnectionSource.FailoverCallback.Result INVALID_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.INVALID_NOT_PROCESSED);
        static final ConnectionSource.FailoverCallback.Result REDUNDANT_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.REDUNDANT_NOT_PROCESSED);
        static final ConnectionSource.FailoverCallback.Result OUTOFORDER_EVENT_PROC_RESULT = new ConnectionSource.FailoverCallback.Result(ConnectionSource.FailoverCallback.Result.ResultType.OUTOFORDER_NOT_PROCESSED);

        void update(ConnectionSource.FailoverCallback.Result result) {
            Event event = this.currentEvent.get();
            if (event != null && result != null) {
                this.addItem(new StatsOne(event, result));
            }
        }

        public String toStringProcessedOnly() {
            StringBuilder stringBuilder = new StringBuilder();
            List<StatsOne> list = this.getAsList();
            list.forEach(statsOne -> {
                ConnectionSource.FailoverCallback.Result result = ((StatsOne)statsOne).getResult();
                if (ConnectionSource.FailoverCallback.Result.ResultType.INVALID_NOT_PROCESSED != result.type && ConnectionSource.FailoverCallback.Result.ResultType.REDUNDANT_NOT_PROCESSED != result.type && ConnectionSource.FailoverCallback.Result.ResultType.OUTOFORDER_NOT_PROCESSED != result.type) {
                    stringBuilder.append(statsOne.toString());
                }
            });
            return stringBuilder.toString();
        }
    }

    @DisableTrace
    static class StatsOne {
        Event eventToProcess = null;
        ConnectionSource.FailoverCallback.Result procResult = null;

        StatsOne(Event event, ConnectionSource.FailoverCallback.Result result) {
            this.eventToProcess = event;
            this.procResult = result;
        }

        private Event getEvent() {
            if (null == this.eventToProcess) {
                throw new IllegalStateException();
            }
            return this.eventToProcess;
        }

        private ConnectionSource.FailoverCallback.Result getResult() {
            if (null == this.procResult) {
                throw new IllegalStateException();
            }
            return this.procResult;
        }

        private String reason() {
            Event.EventType eventType;
            Event event = this.getEvent();
            String string = event.reason();
            if (!("".equals(string) || Event.Status.DOWN != event.status() || (eventType = event.event_type()) != Event.EventType.SERVICE && eventType != Event.EventType.SERVICEMEMBER && eventType != Event.EventType.NODE && eventType != Event.EventType.INSTANCE)) {
                return " <Reason:" + string + ">";
            }
            return "";
        }

        private String targets() {
            Event event = this.getEvent();
            Event.Status status = event.status();
            return Event.EventType.NODE == event.event_type() && (Event.Status.NODEDOWN == status || Event.Status.NODEUP == status) ? " <Host:\"" + event.host() + "\">" : " <Service:\"" + event.serviceName() + "\">" + " <Instance:\"" + event.instance() + "\">" + " <Db:\"" + event.database() + "\">";
        }

        private String counts() {
            ConnectionSource.FailoverCallback.Result result = this.getResult();
            return " Connections:" + "(Available=" + result.availConns + " Opened=" + result.availOpened + " FailedToProcess=" + result.availFailedToProcess + " MarkedDown=" + result.availMarkedDown + " Closed=" + result.availClosed + ")" + "(Borrowed=" + result.borrowedConns + " FailedToProcess=" + result.borrowedFailedToProcess + " MarkedDown=" + result.borrowedMarkedDown + " Closed=" + result.borrowedClosed + ")";
        }

        private String type() {
            Event event = this.getEvent();
            Event.EventType eventType = event.event_type();
            Event.Status status = event.status();
            String string = Event.EventType.SERVICE == eventType || Event.EventType.SERVICEMEMBER == eventType ? (Event.Status.DOWN == status ? "SERVICE_DOWN" : "SERVICE_UP") : (Event.EventType.NODE == eventType ? (Event.Status.NODEDOWN == status ? "HOST_DOWN" : "HOST_UP") : (Event.EventType.INSTANCE == eventType ? (Event.Status.DOWN == status ? "INSTANCE_DOWN" : "INSTANCE_UP") : eventType.toString() + '_' + status.toString()));
            return " <Type:" + string + ">";
        }

        @DisableTrace
        public String toString() {
            Event event = this.getEvent();
            ConnectionSource.FailoverCallback.Result result = this.getResult();
            switch (result.type) {
                case INVALID_NOT_PROCESSED: 
                case REDUNDANT_NOT_PROCESSED: 
                case OUTOFORDER_NOT_PROCESSED: {
                    return DateFormat.getDateTimeInstance(2, 3).format(event.timestamp()) + " " + (Object)((Object)result.type) + this.reason() + this.type() + this.targets();
                }
            }
            return "{" + DateFormat.getDateTimeInstance(2, 3).format(event.timestamp()) + " " + (Object)((Object)result.type) + this.reason() + this.type() + this.targets() + this.counts() + "}\n";
        }
    }

    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.HIGH_AVAILABILITY})
    static class EventImpl
    implements Event {
        private final String version;
        private final String service;
        private Event.EventType event_type;
        private final String database;
        private final String instance;
        private final String host;
        private final String db_domain;
        private final String reason;
        private final Event.Status status;
        private final boolean isPlanned;
        private final boolean isTypeHost;
        private final boolean isTypeService;
        private final int cardinality;
        private final int drain_timeout;
        private Date timestamp;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;

        EventImpl(Notification notification) {
            this.version = notification.get("version");
            this.service = EventImpl.toLowerCase(notification.get("service"));
            String string = EventImpl.toLowerCase(notification.get("event_type"));
            this.event_type = Event.EventType.parse(string == null ? "UNKNOWN" : string);
            this.database = EventImpl.toLowerCase(notification.get("database"));
            this.instance = EventImpl.toLowerCase(notification.get("instance"));
            this.host = EventImpl.toLowerCase(notification.get("host"));
            this.db_domain = EventImpl.toLowerCase(notification.get("db_domain"));
            String string2 = EventImpl.toLowerCase(notification.get("reason"));
            this.reason = string2 == null ? "" : string2;
            String string3 = EventImpl.toLowerCase(notification.get(FailoverDriver.FAN_STATUS_FIELD));
            this.status = Event.Status.parse(string3 == null ? "down" : string3);
            String string4 = EventImpl.toLowerCase(notification.type());
            this.isPlanned = "user".equalsIgnoreCase(this.reason);
            this.isTypeHost = "database/event/host".equals(string4);
            this.isTypeService = "database/event/service".equals(string4);
            String string5 = notification.get("card");
            this.cardinality = Integer.parseInt(string5 == null ? "0" : string5);
            String string6 = notification.get("drain_timeout");
            this.drain_timeout = Integer.parseInt(string6 == null ? "0" : string6);
            this.checkEventType();
            String string7 = notification.get("timestamp");
            String string8 = string7 == null ? "" : string7;
            String string9 = notification.get("timezone");
            String string10 = string9 == null ? "" : string9;
            this.initializeTimestamp(string8, string10);
        }

        EventImpl(Properties properties, String string) {
            this.version = properties.getProperty("version");
            this.service = properties.getProperty("service");
            this.event_type = Event.EventType.parse(properties.getProperty("event_type", "UNKNOWN"));
            this.database = properties.getProperty("database");
            this.instance = properties.getProperty("instance");
            this.host = properties.getProperty("host");
            this.db_domain = properties.getProperty("db_domain");
            this.reason = properties.getProperty("reason", "");
            this.status = Event.Status.parse(properties.getProperty(FailoverDriver.FAN_STATUS_FIELD, "down"));
            this.isPlanned = "user".equals(this.reason);
            this.isTypeHost = "database/event/host".equals(string);
            this.isTypeService = "database/event/service".equals(string);
            this.cardinality = Integer.parseInt(properties.getProperty("card", "0"));
            this.drain_timeout = Integer.parseInt(properties.getProperty("drain_timeout", "0"));
            this.checkEventType();
            String string2 = properties.getProperty("timestamp", "");
            String string3 = properties.getProperty("timezone", "");
            this.initializeTimestamp(string2, string3);
        }

        private void checkEventType() {
            if (this.event_type == Event.EventType.UNKNOWN) {
                if (this.isTypeHost) {
                    this.event_type = Event.EventType.NODE;
                } else if (this.isTypeService) {
                    this.event_type = null == this.instance ? Event.EventType.SERVICE : Event.EventType.SERVICEMEMBER;
                }
                ClioSupport.ilogFinest(null, null, null, null, "derived event type is " + (Object)((Object)this.event_type));
            }
            if (!(this.event_type != Event.EventType.SERVICEMEMBER && this.event_type != Event.EventType.INSTANCE || null != this.version && null != this.service && null != this.host && null != this.database && null != this.instance)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
            if (this.event_type == Event.EventType.SERVICE && (null == this.version || null == this.service || null == this.host || null == this.database)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
            if (this.event_type == Event.EventType.NODE && (null == this.version || null == this.host)) {
                throw new IllegalArgumentException("wrong FCF notification format");
            }
        }

        private void initializeTimestamp(String string, String string2) {
            if ("".equals(string) && !"".equals(string2)) {
                throw new IllegalStateException("single timezone (without timestamp) is not allowed");
            }
            if ("".equals(string)) {
                this.timestamp = new Date();
            } else {
                try {
                    this.timestamp = "".equals(string2) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse(string + " GMT" + string2);
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException(parseException);
                }
            }
        }

        private static String toLowerCase(String string) {
            return null == string ? null : string.toLowerCase();
        }

        @DisableTrace
        public String toString() {
            return "isTypeService=" + this.isTypeService + ", version=" + this.version() + ", service=" + this.serviceName() + ", event_type=" + (Object)((Object)this.event_type()) + ", db_domain=" + this.db_domain() + ", instance=" + this.instance() + ", host=" + this.host() + ", database=" + this.database() + ", status=" + (Object)((Object)this.status()) + ", isPlanned=" + this.isPlanned() + ", cardinality=" + this.cardinality() + ", drain_timeout=" + this.drain_timeout() + ", timestamp=" + this.timestamp();
        }

        @Override
        @DisableTrace
        public String version() {
            return this.version;
        }

        @Override
        @DisableTrace
        public String serviceName() {
            return this.service;
        }

        @Override
        @DisableTrace
        public Event.EventType event_type() {
            return this.event_type;
        }

        @Override
        @DisableTrace
        public String database() {
            return this.database;
        }

        @Override
        @DisableTrace
        public String instance() {
            return this.instance;
        }

        @Override
        @DisableTrace
        public String host() {
            return this.host;
        }

        @Override
        @DisableTrace
        public String db_domain() {
            return this.db_domain;
        }

        @Override
        @DisableTrace
        public String reason() {
            return this.reason;
        }

        @Override
        @DisableTrace
        public Event.Status status() {
            return this.status;
        }

        @Override
        @DisableTrace
        public boolean isPlanned() {
            return this.isPlanned;
        }

        @Override
        @DisableTrace
        public int cardinality() {
            return this.cardinality;
        }

        @Override
        @DisableTrace
        public Date timestamp() {
            return this.timestamp;
        }

        @Override
        @DisableTrace
        public int drain_timeout() {
            return this.drain_timeout;
        }

        static {
            try {
                $$$methodRef$$$4 = EventImpl.class.getDeclaredConstructor(Properties.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
            try {
                $$$methodRef$$$3 = EventImpl.class.getDeclaredConstructor(Notification.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
            try {
                $$$methodRef$$$2 = EventImpl.class.getDeclaredMethod("toLowerCase", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
            try {
                $$$methodRef$$$1 = EventImpl.class.getDeclaredMethod("initializeTimestamp", String.class, String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
            try {
                $$$methodRef$$$0 = EventImpl.class.getDeclaredMethod("checkEventType", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        }
    }

    public static interface Event {
        public static final String NTYPE_SERVICE = "database/event/service";
        public static final String NTYPE_HOST = "database/event/host";

        public String version();

        public String database();

        public String serviceName();

        public EventType event_type();

        public String instance();

        public String host();

        public String db_domain();

        public Status status();

        public boolean isPlanned();

        public String reason();

        public int cardinality();

        public Date timestamp();

        public int drain_timeout();

        public static final class Status
        extends Enum<Status> {
            public static final /* enum */ Status DOWN;
            public static final /* enum */ Status NOT_RESTARTING;
            public static final /* enum */ Status RESTART_FAILED;
            public static final /* enum */ Status UP;
            public static final /* enum */ Status NODEDOWN;
            public static final /* enum */ Status NODEUP;
            private static final /* synthetic */ Status[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static Status[] values() {
                return (Status[])$VALUES.clone();
            }

            public static Status valueOf(String string) {
                return Enum.valueOf(Status.class, string);
            }

            static Status parse(String string) {
                for (Status status : Status.values()) {
                    if (!status.toString().toLowerCase().equals(string)) continue;
                    return status;
                }
                throw new IllegalStateException("unknown status " + string);
            }

            static {
                try {
                    $$$methodRef$$$3 = Status.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Status.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Status.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Status.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                DOWN = new Status();
                NOT_RESTARTING = new Status();
                RESTART_FAILED = new Status();
                UP = new Status();
                NODEDOWN = new Status();
                NODEUP = new Status();
                $VALUES = new Status[]{DOWN, NOT_RESTARTING, RESTART_FAILED, UP, NODEDOWN, NODEUP};
            }
        }

        public static final class EventType
        extends Enum<EventType> {
            public static final /* enum */ EventType DATABASE;
            public static final /* enum */ EventType INSTANCE;
            public static final /* enum */ EventType SERVICE;
            public static final /* enum */ EventType SERVICEMEMBER;
            public static final /* enum */ EventType NODE;
            public static final /* enum */ EventType UNKNOWN;
            private static final /* synthetic */ EventType[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static EventType[] values() {
                return (EventType[])$VALUES.clone();
            }

            public static EventType valueOf(String string) {
                return Enum.valueOf(EventType.class, string);
            }

            static EventType parse(String string) {
                for (EventType eventType : EventType.values()) {
                    if (!eventType.toString().toLowerCase().equals(string)) continue;
                    return eventType;
                }
                return UNKNOWN;
            }

            static {
                try {
                    $$$methodRef$$$3 = EventType.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = EventType.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = EventType.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = EventType.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                DATABASE = new EventType();
                INSTANCE = new EventType();
                SERVICE = new EventType();
                SERVICEMEMBER = new EventType();
                NODE = new EventType();
                UNKNOWN = new EventType();
                $VALUES = new EventType[]{DATABASE, INSTANCE, SERVICE, SERVICEMEMBER, NODE, UNKNOWN};
            }
        }
    }
}

