/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ons.Subscriber;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.PeakIntegerCounter;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.jdbc.oracle.DataBasedConnectionAffinityCallback;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.Task;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPTaskBase;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.LOAD_BALANCING})
public abstract class LoadBalancer {
    public static final int REBALANCE_LIMIT = 15;
    private static final boolean isAffinityStrict;
    private final TaskManager taskManager;
    private AtomicReference<Task<Object>> task = new AtomicReference<Object>(null);
    private AtomicReference<TaskHandle<Object>> taskHandle = new AtomicReference<Object>(null);
    private Event recentEvent = null;
    private final AtomicBoolean terminate = new AtomicBoolean(false);
    private static final Pattern lb_ptop;
    private static final Pattern lb_pg1;
    private static final Pattern lb_pg2;
    private static final Pattern lb_pg3;
    private static final Pattern lb_pg4;
    private static final Pattern lb_pg5;
    private static MixTable mixTable;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    public LoadBalancer() {
        this(UniversalConnectionPoolManagerBase.getTaskManager());
    }

    public LoadBalancer(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    protected abstract ConnectionSource.RebalanceCallback.Result onEvent(Event var1, Selector var2, Selector var3);

    protected abstract Service service();

    private Task<Object> prepareTask(final ONSDriver oNSDriver, final String string) {
        return new UCPTaskBase<Object>(){
            Subscriber subscriber = null;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public boolean isCritical() {
                return true;
            }

            @Override
            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.LOAD_BALANCING})
            public void run() {
                try {
                    this.subscriber = AccessController.doPrivileged(new PrivilegedExceptionAction<Subscriber>(){
                        private static Executable $$$methodRef$$$0;
                        private static Logger $$$loggerRef$$$0;
                        private static Executable $$$methodRef$$$1;
                        private static Logger $$$loggerRef$$$1;
                        private static Executable $$$methodRef$$$2;
                        private static Logger $$$loggerRef$$$2;

                        @Override
                        public Subscriber run() throws UniversalConnectionPoolException {
                            try {
                                return oNSDriver.createSubscriber("%\"eventType=database/event/servicemetrics/" + string + "\"");
                            }
                            catch (Exception exception) {
                                throw new UniversalConnectionPoolException(exception);
                            }
                        }

                        static {
                            try {
                                $$$methodRef$$$2 = 1.class.getDeclaredConstructor(1.class);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                            try {
                                $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                            }
                            catch (Throwable throwable) {}
                            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        }
                    });
                    if (null == this.subscriber) {
                        return;
                    }
                    this.handleNotifications();
                }
                catch (PrivilegedActionException privilegedActionException) {
                    ClioSupport.ilogThrowing(null, null, null, null, privilegedActionException);
                }
                finally {
                    if (null != this.subscriber) {
                        this.subscriber.close();
                        this.subscriber = null;
                    }
                }
            }

            @DefaultLogger(value="oracle.ucp.common")
            @Supports(value={Feature.LOAD_BALANCING})
            private void handleNotifications() {
                LoadBalancer.this.terminate.set(false);
                while (!Thread.currentThread().isInterrupted() && !LoadBalancer.this.terminate.get()) {
                    try {
                        Notification notification = this.subscriber.receive(true);
                        if (notification == null) {
                            ClioSupport.ilogFine(null, null, null, null, "empty notification");
                            continue;
                        }
                        String string3 = notification.type();
                        ClioSupport.ilogFinest(null, null, null, null, string3);
                        ClioSupport.ilogFinest(null, null, null, null, new String(notification.body()));
                        Event event = LoadBalancer.this.parseNotification(string3.toLowerCase(), new String(notification.body()).toLowerCase());
                        if (event.wrongFormat()) {
                            ClioSupport.ilogFine(null, null, null, null, "wrong notification format");
                            continue;
                        }
                        LoadBalancer.this.service().markup(event);
                        ClioSupport.ilogFinest(null, null, null, null, event.toString());
                        long l2 = LoadBalancer.this.service().lbStats.lbBorrows.successful.delta();
                        BigInteger bigInteger = LoadBalancer.this.service().lbStats.lbBorrows.successful.total();
                        long l3 = LoadBalancer.this.service().lbStats.lbBorrows.failed.delta();
                        BigInteger bigInteger2 = LoadBalancer.this.service().lbStats.lbBorrows.failed.total();
                        ClioSupport.ilogFinest(null, null, null, null, String.format("successfulBorrows=%d(%s), failedLbBorrows=%d(%s)", l2, bigInteger.toString(), l3, bigInteger2.toString()));
                        long l4 = LoadBalancer.this.service().lbStats.borrowTimes.totalDelta();
                        LoadBalancer.this.service().lbStats.accumulate();
                        boolean bl2 = false;
                        for (ServiceMember serviceMember : LoadBalancer.this.service().getAllMembers()) {
                            serviceMember.saveAdvisedLoad(event.normalizedPercent(serviceMember.name()));
                            serviceMember.savePeakBorrows();
                            if (serviceMember.peaked()) {
                                bl2 = true;
                            }
                            Object object = serviceMember.lbStats;
                            int n2 = LoadBalancer.this.service().activeCount() - LoadBalancer.this.service().pendingCloseCount.get();
                            int n3 = serviceMember.activeCount.get() - serviceMember.pendingCloseCount.get();
                            float f2 = 0 != n2 ? (float)n3 / (float)n2 * 100.0f : 0.0f;
                            int n4 = (int)Math.ceil((double)n2 * (double)serviceMember.averageAdvisedLoad() / 100.0) - n3;
                            serviceMember.connsToRebalance.set(n4);
                            long l5 = ((Stats)object).returns.delta();
                            BigInteger bigInteger3 = ((Stats)object).returns.total();
                            long l6 = ((Stats)object).peakBorrows.delta();
                            long l7 = ((Stats)object).peakBorrows.total();
                            long l8 = ((Stats)object).borrowTimes.minDelta();
                            long l9 = ((Stats)object).borrowTimes.minTotal();
                            long l10 = ((Stats)object).borrowTimes.maxDelta();
                            long l11 = ((Stats)object).borrowTimes.maxTotal();
                            long l12 = ((Stats)object).borrowTimes.totalDelta();
                            BigInteger bigInteger4 = ((Stats)object).borrowTimes.total();
                            String string2 = serviceMember.name();
                            float f3 = 0L != l4 ? (float)l12 / (float)l4 * 100.0f : 0.0f;
                            ClioSupport.ilogFinest(null, null, null, null, string2 + ":active=" + serviceMember.activeCount + (n4 < 0 ? (char)'-' : '+') + Math.abs(n4) + "(" + String.format("%.2f", Float.valueOf(f2)) + "%)" + ",load=" + String.format("%.2f", Float.valueOf(f3)) + "%" + ",advised=" + String.format("%.2f", Float.valueOf(event.percent(string2))) + "%" + ",normalized=" + String.format("%.2f", Float.valueOf(event.normalizedPercent(string2))) + "%" + ",average=" + String.format("%.2f", Float.valueOf(serviceMember.averageAdvisedLoad())) + "%" + " (opened=" + ((Stats)object).opens.delta() + "(" + ((Stats)object).opens.total() + ")" + ",closed=" + ((Stats)object).closes.successful.delta() + "(" + ((Stats)object).closes.successful.total() + ")" + ",aborted=" + ((Stats)object).closes.aborted.delta() + "(" + ((Stats)object).closes.aborted.total() + ")" + ",returned=" + l5 + "(" + bigInteger3 + ")" + ",borrowed:peak=" + l6 + "(" + l7 + ")" + ",minTime=" + l8 + "(" + l9 + ")" + ",maxTime=" + l10 + "(" + l11 + ")" + ",totalTime=" + l12 + "(" + bigInteger4 + "))");
                            serviceMember.lbStats.accumulate();
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("pendingCloseCount: all=").append(LoadBalancer.this.service().pendingCloseCount.get());
                        for (Object object : LoadBalancer.this.service().getAllMembers()) {
                            stringBuilder.append(", inst(" + ((ServiceMember)object).name() + ")=" + ((ServiceMember)object).pendingCloseCount.get());
                        }
                        ClioSupport.ilogFinest(null, null, null, null, stringBuilder.toString());
                        ClioSupport.ilogFinest(null, null, null, null, "peaked=" + bl2);
                        LoadBalancer.this.recentEvent = event;
                        LoadBalancer.this.service().pendingRebalance.getAndSet(LoadBalancer.this.onEvent(event, bl2 ? LoadBalancer.this.gravitationSelector(true) : Selectors.NONE, bl2 ? LoadBalancer.this.gravitationSelector(false) : Selectors.NONE)).terminate();
                        continue;
                    }
                    catch (Throwable throwable) {
                        ClioSupport.ilogFine(null, null, null, null, throwable.toString());
                        ClioSupport.ilogThrowing(null, null, null, null, throwable);
                        continue;
                    }
                    break;
                }
                return;
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(LoadBalancer.class, ONSDriver.class, String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("handleNotifications", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("isCritical", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @DisableTrace
    public Selector gravitationSelector(final boolean bl2) {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                if (bl2 ^ coreConnection.available()) {
                    return false;
                }
                if (coreConnection.markedCloseOnReturn() || coreConnection.markedToReplace()) {
                    return false;
                }
                return coreConnection.serviceMember().active();
            }

            static {
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredConstructor(LoadBalancer.class, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.LOAD_BALANCING})
    Event parseNotification(String string, final String string2) {
        final Properties properties = new Properties();
        final boolean[] blArray = new boolean[]{false};
        final HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        Matcher matcher = lb_ptop.matcher(string2);
        if (matcher.find()) {
            Matcher matcher2 = lb_pg1.matcher(matcher.group(1));
            Matcher matcher3 = lb_pg2.matcher(matcher.group(2));
            Matcher matcher4 = lb_pg3.matcher(matcher.group(3));
            Matcher matcher5 = lb_pg4.matcher(matcher.group(3));
            while (matcher2.find()) {
                properties.setProperty(matcher2.group(1), matcher2.group(2));
            }
            while (matcher3.find()) {
                Matcher matcher6 = lb_pg1.matcher(matcher3.group(1));
                Properties properties2 = new Properties();
                while (matcher6.find()) {
                    properties2.setProperty(matcher6.group(1), matcher6.group(2));
                }
                hashMap.put(properties2.getProperty("instance", "***noname***"), properties2);
            }
            if (0 == hashMap.size()) {
                blArray[0] = true;
            }
            if (matcher4.find()) {
                properties.put(matcher4.group(1), matcher4.group(2));
            }
            if (matcher5.find()) {
                if (lb_pg5.matcher(matcher5.group(2)).find()) {
                    properties.put(matcher5.group(1), matcher5.group(2));
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "unaccepted timezone format: " + matcher5.group(2));
                    blArray[0] = true;
                }
            }
        }
        return new Event(){
            private final String version;
            private final String service;
            private final String database;
            private final String host;
            private Date timestamp;
            private final Map<String, Float> instAdvisories;
            private final Map<String, Float> instNormalizedAdvisories;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            {
                Object object;
                this.version = properties.getProperty("version");
                this.service = properties.getProperty("service");
                this.database = properties.getProperty("database");
                this.host = properties.getProperty("host");
                this.timestamp = new Date();
                if (null == this.version) {
                    ClioSupport.ilogFinest(null, null, null, null, "no version");
                    blArray[0] = true;
                }
                String string22 = properties.getProperty("timestamp", "");
                String object22 = properties.getProperty("timezone", "");
                if ("".equals(string22) && !"".equals(object22)) {
                    ClioSupport.ilogFinest(null, null, null, null, "single timezone (without timestamp) is not allowed");
                    blArray[0] = true;
                }
                if ("".equals(string22)) {
                    this.timestamp = new Date();
                } else {
                    try {
                        this.timestamp = "".equals(object22) ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(string22) : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").parse((String)string22 + " GMT" + object22);
                    }
                    catch (ParseException parseException) {
                        ClioSupport.ilogThrowing(null, null, null, null, parseException);
                        blArray[0] = true;
                    }
                }
                this.instAdvisories = new HashMap<String, Float>();
                for (String string3 : this.instances()) {
                    Map.Entry<String, Float> entry = this.instanceAttrs(string3).getProperty("percentf");
                    if (null != entry) {
                        try {
                            this.instAdvisories.put(string3, Float.valueOf(Float.parseFloat((String)((Object)entry))));
                            continue;
                        }
                        catch (Exception exception) {
                            ClioSupport.ilogThrowing(null, null, null, null, exception);
                            blArray[0] = true;
                        }
                    }
                    if (null != (object = this.instanceAttrs(string3).getProperty("percent"))) {
                        try {
                            this.instAdvisories.put(string3, Float.valueOf(Integer.parseInt(object)));
                            continue;
                        }
                        catch (Exception exception) {
                            ClioSupport.ilogThrowing(null, null, null, null, exception);
                            blArray[0] = true;
                        }
                    }
                    ClioSupport.ilogFinest(null, null, null, null, "no advisory percent in the load balancing event");
                    blArray[0] = true;
                }
                this.instNormalizedAdvisories = new HashMap<String, Float>();
                if (!blArray[0]) {
                    float f2 = 0.0f;
                    for (Map.Entry<String, Float> entry : this.instAdvisories.entrySet()) {
                        object = this.flag((String)entry.getKey());
                        if (Event.Flag.BLOCKED == object || Event.Flag.NO_DATA == object) continue;
                        f2 += ((Float)entry.getValue()).floatValue();
                    }
                    ClioSupport.ilogFinest(null, null, null, null, "alivePercent=" + f2);
                    if (0.0f == f2) {
                        blArray[0] = true;
                    }
                    for (Map.Entry<String, Float> entry : this.instAdvisories.entrySet()) {
                        Event.Flag flag = this.flag((String)(object = entry.getKey()));
                        this.instNormalizedAdvisories.put((String)object, Float.valueOf(Event.Flag.BLOCKED != flag && Event.Flag.NO_DATA != flag ? entry.getValue().floatValue() / f2 * 100.0f : 0.0f));
                    }
                    ClioSupport.ilogFinest(null, null, null, null, "instNormalizedAdvisories=" + this.instNormalizedAdvisories.toString());
                }
            }

            @Override
            public byte[] body() {
                return string2.getBytes();
            }

            @Override
            public String version() {
                return this.version;
            }

            @Override
            public String service() {
                return this.service;
            }

            @Override
            public String database() {
                return this.database;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public Date timestamp() {
                return this.timestamp;
            }

            @Override
            public Set<String> instances() {
                return hashMap.keySet();
            }

            @Override
            public float percent(String string) {
                Float f2 = this.instAdvisories.get(string);
                return null != f2 ? f2.floatValue() : 0.0f;
            }

            @Override
            public float normalizedPercent(String string) {
                Float f2 = this.instNormalizedAdvisories.get(string);
                return null != f2 ? f2.floatValue() : 0.0f;
            }

            @Override
            public boolean affinity(String string) {
                return "true".equals(this.instanceAttrs(string).getProperty("aff", "false").toLowerCase().trim());
            }

            @Override
            public Event.Flag flag(String string) {
                return Event.Flag.parse(this.instanceAttrs(string).getProperty("flag", "good"));
            }

            private Properties instanceAttrs(String string) {
                Properties properties2 = (Properties)hashMap.get(string);
                return null != properties2 ? properties2 : new Properties();
            }

            @Override
            public boolean wrongFormat() {
                return blArray[0];
            }

            @DisableTrace
            public String toString() {
                return "" + hashMap + properties;
            }

            static {
                try {
                    $$$methodRef$$$13 = 3.class.getDeclaredConstructor(LoadBalancer.class, Properties.class, boolean[].class, String.class, Map.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 3.class.getDeclaredMethod("wrongFormat", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 3.class.getDeclaredMethod("instanceAttrs", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredMethod("flag", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("affinity", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("normalizedPercent", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("percent", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("instances", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("timestamp", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("host", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("database", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("version", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("body", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.LOAD_BALANCING})
    public Selector borrowSelector(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback) {
        return this.borrowSelector(connectionRetrievalInfo, connectionAffinityCallback, this.service().getAllMembers(connectionRetrievalInfo));
    }

    @DefaultLogger(value="oracle.ucp.common")
    @Supports(value={Feature.LOAD_BALANCING})
    public Selector borrowSelector(final ConnectionRetrievalInfo connectionRetrievalInfo, final ConnectionAffinityCallback connectionAffinityCallback, final Collection<ServiceMember> collection) {
        abstract class AffinitySelector
        implements Selector {
            final /* synthetic */ ConnectionAffinityCallback val$callback;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            AffinitySelector() {
                this.val$callback = connectionAffinityCallback;
            }

            private void successfulAffBorrowed(CoreConnection coreConnection) {
                LoadBalancer.this.service().lbStats.onSuccessfulAffBorrowed();
                coreConnection.serviceMember().lbStats.onSuccessfulAffBorrowed();
            }

            private void failedAffBorrowed(CoreConnection coreConnection) {
                LoadBalancer.this.service().lbStats.onFailedAffBorrowed();
                coreConnection.serviceMember().lbStats.onFailedAffBorrowed();
            }

            protected boolean affined(CoreConnection coreConnection) {
                if (null == this.val$callback) {
                    throw new IllegalArgumentException("callback is null");
                }
                Object object = this.val$callback.getConnectionAffinityContext();
                if (object instanceof AffinityContext) {
                    AffinityContext affinityContext = (AffinityContext)object;
                    String string = affinityContext.getInstanceName();
                    if (null == string) {
                        ClioSupport.ilogWarning(null, null, null, null, "no instance name in affinity context");
                        this.failedAffBorrowed(coreConnection);
                        return coreConnection.serviceMember().active();
                    }
                    ServiceMember serviceMember = LoadBalancer.this.service().getMember(string, affinityContext.getDatabaseUniqueName(), affinityContext.getServiceName());
                    if (null == serviceMember) {
                        ClioSupport.ilogWarning(null, null, null, null, String.format("unknown %s in affinity context", string));
                        this.failedAffBorrowed(coreConnection);
                        return coreConnection.serviceMember().active();
                    }
                    if (!serviceMember.active() || serviceMember.violating()) {
                        ClioSupport.ilogFine(null, null, null, null, serviceMember.name() + " is unavailable");
                        this.failedAffBorrowed(coreConnection);
                        return coreConnection.serviceMember().active();
                    }
                    ConnectionAffinityCallback.AffinityPolicy affinityPolicy = this.val$callback.getAffinityPolicy();
                    if (coreConnection.serviceMember().name().equals(serviceMember.name())) {
                        if (ConnectionAffinityCallback.AffinityPolicy.WEBSESSION_BASED_AFFINITY == affinityPolicy) {
                            if (coreConnection.serviceMember().affined()) {
                                this.successfulAffBorrowed(coreConnection);
                                return true;
                            }
                        } else {
                            if (ConnectionAffinityCallback.AffinityPolicy.TRANSACTION_BASED_AFFINITY == affinityPolicy) {
                                this.successfulAffBorrowed(coreConnection);
                                return true;
                            }
                            throw new IllegalStateException("wrong affinity policy");
                        }
                    }
                    return false;
                }
                throw new IllegalStateException("wrong affinity context type or null");
            }

            protected boolean dbAffined(CoreConnection coreConnection) {
                DataBasedConnectionAffinityCallback dataBasedConnectionAffinityCallback = (DataBasedConnectionAffinityCallback)this.val$callback;
                if (0 == LoadBalancer.this.service().getAllMembers().size()) {
                    throw new IllegalStateException("data affinity: list of instances is empty");
                }
                int n2 = LoadBalancer.this.service().activeMembersCount();
                if (0 == n2) {
                    return false;
                }
                int n3 = 0;
                ServiceMember serviceMember = null;
                int n4 = dataBasedConnectionAffinityCallback.getPartitionId();
                block0: while (n3++ < mixTable.size()) {
                    int n5 = n4 % n2;
                    for (ServiceMember serviceMember2 : LoadBalancer.this.service().getAllMembers()) {
                        serviceMember = serviceMember2;
                        int n6 = serviceMember.id() % n2;
                        if (n5 != n6) continue;
                        if (isAffinityStrict) {
                            if (serviceMember.active() && !serviceMember.violating()) break block0;
                            this.failedAffBorrowed(coreConnection);
                            return false;
                        }
                        if (serviceMember.affined() && serviceMember.active() && !serviceMember.violating()) break block0;
                        this.failedAffBorrowed(coreConnection);
                        return coreConnection.serviceMember().active();
                    }
                    n4 = mixTable.nextPartition(n4);
                }
                if (null == serviceMember) {
                    return false;
                }
                n4 = coreConnection.serviceMember().name().equals(serviceMember.name()) ? 1 : 0;
                if (n4 != 0) {
                    this.successfulAffBorrowed(coreConnection);
                }
                return n4 != 0;
            }

            static {
                try {
                    $$$methodRef$$$4 = AffinitySelector.class.getDeclaredConstructor(LoadBalancer.class, ConnectionAffinityCallback.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = AffinitySelector.class.getDeclaredMethod("dbAffined", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = AffinitySelector.class.getDeclaredMethod("affined", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = AffinitySelector.class.getDeclaredMethod("failedAffBorrowed", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = AffinitySelector.class.getDeclaredMethod("successfulAffBorrowed", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }
        return new AffinitySelector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            {
                super(LoadBalancer.this, connectionAffinityCallback2);
            }

            @Override
            public boolean selected(CoreConnection coreConnection) {
                if (!coreConnection.available()) {
                    return false;
                }
                boolean bl2 = coreConnection.serviceMember().active();
                if (null != connectionAffinityCallback && ConnectionAffinityCallback.AffinityPolicy.DATA_BASED_AFFINITY == connectionAffinityCallback.getAffinityPolicy()) {
                    return bl2 && this.dbAffined(coreConnection);
                }
                if (null != connectionAffinityCallback && connectionAffinityCallback.getConnectionAffinityContext() != null) {
                    return bl2 && this.affined(coreConnection);
                }
                if (coreConnection.serviceMember().isRLBHistoryClean()) {
                    int n2 = coreConnection.serviceMember().borrowedCount.get();
                    int n3 = LoadBalancer.this.service().borrowedCount();
                    float f2 = 0 == n3 ? 0.0f : (float)n2 / (float)n3 * 100.0f;
                    int n4 = LoadBalancer.this.service().activeMembersCount();
                    float f3 = 0 == n4 ? 100.0f : 100.0f / (float)n4;
                    return f2 <= f3;
                }
                if (null == LoadBalancer.this.recentEvent) {
                    return coreConnection.serviceMember().serviceRef.proportionalDistributionSelector().selected(coreConnection);
                }
                if (!bl2) {
                    return false;
                }
                ServiceMember serviceMember = coreConnection.serviceMember();
                float f4 = serviceMember.active() ? serviceMember.averageAdvisedLoad(connectionRetrievalInfo, collection) : 0.0f;
                long l2 = serviceMember.lbStats.borrowTimes.totalDelta();
                long l3 = LoadBalancer.this.service().totalBorrowTimes(connectionRetrievalInfo, collection);
                float f5 = 0L != l3 ? (float)l2 / (float)l3 * 100.0f : 0.0f;
                return f5 <= f4;
            }

            static {
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredConstructor(LoadBalancer.class, ConnectionAffinityCallback.class, ConnectionRetrievalInfo.class, Collection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo connectionRetrievalInfo) {
        int n2;
        ServiceMember serviceMember;
        Event event = this.recentEvent;
        if (null == event) {
            return null;
        }
        do {
            serviceMember = null;
            n2 = Integer.MIN_VALUE;
            for (ServiceMember serviceMember2 : this.service().getAllMembers(connectionRetrievalInfo, true)) {
                int n3;
                if (!serviceMember2.active() || (n3 = serviceMember2.connsToRebalance.get()) <= 0 || n3 <= n2) continue;
                n2 = n3;
                serviceMember = serviceMember2;
            }
        } while (null != serviceMember && !serviceMember.connsToRebalance.compareAndSet(n2, n2 - 1));
        return serviceMember;
    }

    public boolean start(ONSDriver oNSDriver, String string) {
        if (this.task.compareAndSet(null, this.prepareTask(oNSDriver, string))) {
            this.taskHandle.set(this.taskManager.submitTask(this.task.get()));
            ClioSupport.ilogFinest(null, null, null, null, "started");
        }
        return true;
    }

    public void stop() {
        Task task = this.task.getAndSet(null);
        if (null != task) {
            block4: {
                task.release();
                this.terminate.set(true);
                try {
                    TaskHandle taskHandle = this.taskHandle.getAndSet(null);
                    if (null != taskHandle) {
                        taskHandle.get(100000L);
                    }
                }
                catch (TaskManagerException taskManagerException) {
                    if (taskManagerException.getCause() instanceof CancellationException) break block4;
                    ClioSupport.ilogThrowing(null, null, null, null, taskManagerException);
                }
            }
            ClioSupport.ilogFinest(null, null, null, null, "stopped");
        }
    }

    public Event recentEvent() {
        return this.recentEvent;
    }

    static {
        try {
            $$$methodRef$$$15 = LoadBalancer.class.getDeclaredConstructor(TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = LoadBalancer.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = LoadBalancer.class.getDeclaredMethod("access$100", LoadBalancer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = LoadBalancer.class.getDeclaredMethod("access$300", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = LoadBalancer.class.getDeclaredMethod("access$200", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = LoadBalancer.class.getDeclaredMethod("access$102", LoadBalancer.class, Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = LoadBalancer.class.getDeclaredMethod("access$000", LoadBalancer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = LoadBalancer.class.getDeclaredMethod("recentEvent", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = LoadBalancer.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = LoadBalancer.class.getDeclaredMethod("start", ONSDriver.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = LoadBalancer.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = LoadBalancer.class.getDeclaredMethod("underloadedInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = LoadBalancer.class.getDeclaredMethod("borrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = LoadBalancer.class.getDeclaredMethod("borrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = LoadBalancer.class.getDeclaredMethod("parseNotification", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = LoadBalancer.class.getDeclaredMethod("prepareTask", ONSDriver.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        isAffinityStrict = Util.isAffinityStrict();
        lb_ptop = Pattern.compile("([^{]*)\\{(.*)\\}(.*)");
        lb_pg1 = Pattern.compile("(\\w+)=([a-zA-Z_0-9\\.\\-\\:\\%]+)");
        lb_pg2 = Pattern.compile("\\{([^{]*)\\}");
        lb_pg3 = Pattern.compile("(timestamp)=(\\d{4}\\-\\d{2}\\-\\d{2} \\d{2}\\:\\d{2}\\:\\d{2})");
        lb_pg4 = Pattern.compile("(timezone)=(.*)");
        lb_pg5 = Pattern.compile("[\\+\\-]\\d{2}:\\d{2}");
        mixTable = new MixTable();
    }

    @DisableTrace
    public static class Stats {
        public final Counter returns = new Counter();
        public final Counter opens = new Counter();
        public final CloseResultsCounter closes = new CloseResultsCounter();
        public final BorrowResultsCounter lbBorrows = new BorrowResultsCounter();
        public final BorrowResultsCounter affBorrows = new BorrowResultsCounter();
        public final PeakBorrowed peakBorrows = new PeakBorrowed();
        public final Times borrowTimes = new Times();

        void onBorrowed(int n2) {
            this.peakBorrows.update(n2);
        }

        void onReturned(long l2) {
            this.borrowTimes.update(l2);
            this.returns.increment();
        }

        void onOpened() {
            this.opens.increment();
        }

        public void onClosed() {
            this.closes.successful.increment();
        }

        void onAborted() {
            this.closes.aborted.increment();
        }

        void onSuccessfulLbBorrowed() {
            this.lbBorrows.successful.increment();
        }

        void onFailedLbBorrowed() {
            this.lbBorrows.failed.increment();
        }

        void onSuccessfulAffBorrowed() {
            this.affBorrows.successful.increment();
        }

        void onFailedAffBorrowed() {
            this.affBorrows.failed.increment();
        }

        void accumulate() {
            this.returns.accumulate();
            this.opens.accumulate();
            this.closes.accumulate();
            this.lbBorrows.accumulate();
            this.affBorrows.accumulate();
            this.peakBorrows.accumulate();
            this.borrowTimes.accumulate();
        }

        @DisableTrace
        static class Times {
            private final AtomicLong minAccumulator = new AtomicLong(Long.MAX_VALUE);
            private final AtomicLong minDelta = new AtomicLong(Long.MAX_VALUE);
            private final AtomicLong maxAccumulator = new AtomicLong(Long.MIN_VALUE);
            private final AtomicLong maxDelta = new AtomicLong(Long.MIN_VALUE);
            private final AtomicReference<BigInteger> totalAccumulator = new AtomicReference<BigInteger>(BigInteger.ZERO);
            private final AtomicLong totalDelta = new AtomicLong(0L);

            Times() {
            }

            private void update(long l2) {
                long l3;
                this.totalDelta.addAndGet(l2);
                while (!this.minDelta.compareAndSet(l3 = this.minDelta.get(), Math.min(l2, l3))) {
                }
                while (!this.maxDelta.compareAndSet(l3 = this.maxDelta.get(), Math.max(l2, l3))) {
                }
            }

            private void accumulate() {
                long l2;
                this.totalAccumulator.set(this.totalAccumulator.get().add(BigInteger.valueOf(this.totalDelta.getAndSet(0L))));
                long l3 = this.minDelta.getAndSet(0L);
                while (!this.minAccumulator.compareAndSet(l2 = this.minAccumulator.get(), Math.min(l3, l2))) {
                }
                l3 = this.maxDelta.getAndSet(0L);
                while (!this.maxAccumulator.compareAndSet(l2 = this.maxAccumulator.get(), Math.max(l3, l2))) {
                }
            }

            public long minDelta() {
                long l2 = this.minDelta.get();
                return l2 < Long.MAX_VALUE ? l2 : 0L;
            }

            public long maxDelta() {
                long l2 = this.maxDelta.get();
                return l2 > Long.MIN_VALUE ? l2 : 0L;
            }

            public long totalDelta() {
                return this.totalDelta.get();
            }

            public long minTotal() {
                long l2 = Math.min(this.minAccumulator.get(), this.minDelta.get());
                return l2 < Long.MAX_VALUE ? l2 : 0L;
            }

            public long maxTotal() {
                long l2 = Math.max(this.maxAccumulator.get(), this.maxDelta.get());
                return l2 > Long.MIN_VALUE ? l2 : 0L;
            }

            public BigInteger total() {
                return this.totalAccumulator.get().add(BigInteger.valueOf(this.totalDelta.get()));
            }
        }

        @DisableTrace
        public static class PeakBorrowed {
            private final PeakIntegerCounter accumulator = new PeakIntegerCounter(0);
            private final PeakIntegerCounter delta = new PeakIntegerCounter(0);

            private void update(int n2) {
                this.delta.update(n2);
            }

            private void accumulate() {
                this.accumulator.update(this.delta.getAndSet(0));
            }

            public int delta() {
                return this.delta.get();
            }

            public int total() {
                PeakIntegerCounter peakIntegerCounter = new PeakIntegerCounter(0);
                peakIntegerCounter.update(this.accumulator.get());
                peakIntegerCounter.update(this.delta.get());
                return peakIntegerCounter.get();
            }
        }

        @DisableTrace
        public static class BorrowResultsCounter {
            public final Counter successful = new Counter();
            public final Counter failed = new Counter();

            private void accumulate() {
                this.successful.accumulate();
                this.failed.accumulate();
            }
        }

        @DisableTrace
        public static class CloseResultsCounter {
            public final Counter successful = new Counter();
            public final Counter aborted = new Counter();

            private void accumulate() {
                this.successful.accumulate();
                this.aborted.accumulate();
            }
        }

        public static class Counter {
            private final AtomicReference<BigInteger> accumulator = new AtomicReference<BigInteger>(BigInteger.ZERO);
            private final AtomicLong delta = new AtomicLong(0L);
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;

            private void increment() {
                this.delta.incrementAndGet();
            }

            private void accumulate() {
                this.accumulator.set(this.accumulator.get().add(BigInteger.valueOf(this.delta.getAndSet(0L))));
            }

            public long delta() {
                return this.delta.get();
            }

            public BigInteger total() {
                return this.accumulator.get().add(BigInteger.valueOf(this.delta.get()));
            }

            static {
                try {
                    $$$methodRef$$$6 = Counter.class.getDeclaredConstructor(new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = Counter.class.getDeclaredMethod("access$700", Counter.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = Counter.class.getDeclaredMethod("access$400", Counter.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = Counter.class.getDeclaredMethod("total", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Counter.class.getDeclaredMethod("delta", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Counter.class.getDeclaredMethod("accumulate", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Counter.class.getDeclaredMethod("increment", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        }
    }

    @DisableTrace
    private static class MixTable {
        private int[] mixTable;
        private static final int MIX_TABLE_SIZE = 4096;
        private static final int IRREDUCIBLE_POLYNOMIAL = 4105;
        private static final int MIX_TABLE_GENERATOR = 3;

        MixTable() {
            this.generateMixTable();
        }

        int nextPartition(int n2) {
            return this.mixTable[n2 % this.mixTable.length];
        }

        int size() {
            return this.mixTable.length;
        }

        private void generateMixTable() {
            if (this.mixTable != null) {
                return;
            }
            int[] nArray = new int[4096];
            nArray[0] = 1;
            for (int i2 = 1; i2 < 4096; ++i2) {
                nArray[i2] = nArray[i2 - 1] << 1 ^ nArray[i2 - 1];
                if ((nArray[i2] & 0x1000) == 0) continue;
                int n2 = i2;
                nArray[n2] = nArray[n2] ^ 0x1009;
            }
            int[] nArray2 = new int[4096];
            for (int i3 = 0; i3 < 4096; ++i3) {
                nArray2[nArray[i3]] = i3;
            }
            nArray2[0] = 4096;
            int[] nArray3 = new int[4096];
            for (int i4 = 1; i4 < 4096; ++i4) {
                nArray3[nArray2[i4 - 1] - 1] = nArray2[i4] - 1;
            }
            nArray3[nArray2[4095] - 1] = nArray2[0] - 1;
            this.mixTable = nArray3;
        }
    }

    public static interface Event {
        public String version();

        public String database();

        public String host();

        public String service();

        public Set<String> instances();

        public float percent(String var1);

        public float normalizedPercent(String var1);

        public boolean wrongFormat();

        public boolean affinity(String var1);

        public Flag flag(String var1);

        public Date timestamp();

        public byte[] body();

        public static final class Flag
        extends Enum<Flag> {
            public static final /* enum */ Flag GOOD;
            public static final /* enum */ Flag VIOLATING;
            public static final /* enum */ Flag NO_DATA;
            public static final /* enum */ Flag UNKNOWN;
            public static final /* enum */ Flag BLOCKED;
            private static final /* synthetic */ Flag[] $VALUES;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            public static Flag[] values() {
                return (Flag[])$VALUES.clone();
            }

            public static Flag valueOf(String string) {
                return Enum.valueOf(Flag.class, string);
            }

            static Flag parse(String string) {
                for (Flag flag : Flag.values()) {
                    if (!flag.toString().toLowerCase().equals(string)) continue;
                    return flag;
                }
                throw new IllegalStateException("unknown flag " + string);
            }

            static {
                try {
                    $$$methodRef$$$3 = Flag.class.getDeclaredConstructor(String.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = Flag.class.getDeclaredMethod("parse", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = Flag.class.getDeclaredMethod("valueOf", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = Flag.class.getDeclaredMethod("values", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                GOOD = new Flag();
                VIOLATING = new Flag();
                NO_DATA = new Flag();
                UNKNOWN = new Flag();
                BLOCKED = new Flag();
                $VALUES = new Flag[]{GOOD, VIOLATING, NO_DATA, UNKNOWN, BLOCKED};
            }
        }
    }
}

