/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.actors.InterruptableActor;
import oracle.ucp.common.AffinityContext;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.Instantiator;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.Topology;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.RACDataAffinityRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.Pair;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class Service {
    private String name;
    private final Set<String> placement = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Topology connectionSource;
    private final AtomicReference<ConnectionSource.FailoverCallback> failoverHandler = new AtomicReference<Object>(null);
    private final AtomicReference<ConnectionSource.RebalanceCallback> rebalanceHandler = new AtomicReference<Object>(null);
    private final FailoverDriver failoverDriver = this.prepareFailoverDriver();
    private final LoadBalancer loadBalancer = this.prepareLoadBalancer();
    private final AtomicInteger activeCount = new AtomicInteger(0);
    private final AtomicInteger borrowedCount = new AtomicInteger(0);
    private final AtomicInteger pendingCreateCount = new AtomicInteger(0);
    private final ConcurrentMap<ServiceMember.Key, ServiceMember> serviceMembers = new ConcurrentHashMap<ServiceMember.Key, ServiceMember>();
    final AtomicInteger activeMembers = new AtomicInteger(0);
    final AtomicInteger idCount = new AtomicInteger(0);
    public final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    public final FailoverDriver.Stats fdStats = new FailoverDriver.Stats();
    final AtomicReference<ConnectionSource.RebalanceCallback.Result> pendingRebalance = new AtomicReference<ConnectionSource.RebalanceCallback.Result>(new ConnectionSource.RebalanceCallback.Result());
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private String containerName = null;
    final AtomicInteger lastDrainTimeout = new AtomicInteger(0);
    private volatile CountDownLatch registered = null;
    private final AtomicReference<DataDependentRoutingCache> routingCache = new AtomicReference<Object>(null);
    private final Instantiator instantiator;
    private String hostName = null;
    private AtomicReference<String[]> distributionTable = new AtomicReference<String[]>(new String[0]);
    private static Random rand;
    private final AtomicReference<Object> mostRecentONSEvent = new AtomicReference<Object>(null);
    private static final InterruptableActor<UniversalPooledConnection, String, UniversalConnectionPoolException> interruptableActor;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;
    private static Executable $$$methodRef$$$57;
    private static Logger $$$loggerRef$$$57;
    private static Executable $$$methodRef$$$58;
    private static Logger $$$loggerRef$$$58;
    private static Executable $$$methodRef$$$59;
    private static Logger $$$loggerRef$$$59;
    private static Executable $$$methodRef$$$60;
    private static Logger $$$loggerRef$$$60;

    Service(Instantiator instantiator, Topology topology, String string) {
        this.instantiator = instantiator;
        this.connectionSource = topology;
        this.name = string;
    }

    private void onRegister() {
        if (this.registered != null) {
            this.registered.countDown();
        }
    }

    private void awaitRegister() {
        try {
            if (this.registered == null) {
                return;
            }
            this.registered.await();
        }
        catch (InterruptedException interruptedException) {
            ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
        }
    }

    private void checkAndRegister() {
        if (this.registered == null) {
            this.registered = new CountDownLatch(1);
        }
    }

    public int activeMembersCount() {
        return this.activeMembers.get();
    }

    public void setName(String string) {
        this.name = string;
    }

    String containerName() {
        return this.containerName;
    }

    void setContainerName(String string) {
        this.containerName = string;
    }

    public ServiceMember insertMember(ServiceMember serviceMember) {
        String string;
        if (this.name == null) {
            this.name = serviceMember.service();
        }
        if (null == this.hostName) {
            this.hostName = serviceMember.host();
        }
        String string2 = null == (string = serviceMember.host()) || "".equals(string) ? this.hostName : string;
        ServiceMember serviceMember2 = this.getMember(serviceMember.name(), serviceMember.database(), serviceMember.service());
        if (null != serviceMember2) {
            if (!serviceMember2.host().equals("")) {
                return serviceMember2;
            }
            if (!serviceMember.host().equals("")) {
                this.serviceMembers.remove(serviceMember2.key());
                this.serviceMembers.putIfAbsent(serviceMember.key(), serviceMember);
                return serviceMember;
            }
            return serviceMember2;
        }
        if (null == this.serviceMembers.putIfAbsent(serviceMember.key(), serviceMember)) {
            serviceMember.initId();
            this.activeMembers.incrementAndGet();
        }
        return serviceMember;
    }

    public ServiceMember getMember(String string, String string2, String string3, String string4) {
        return (ServiceMember)this.serviceMembers.get(new ServiceMember.Key(string, string2, string3, string4));
    }

    public ServiceMember getMember(String string, String string2, String string3) {
        for (ServiceMember serviceMember : this.getAllMembers()) {
            if (!serviceMember.name().equals(string) || !serviceMember.database().equals(string2) || !serviceMember.service().equals(string3)) continue;
            return serviceMember;
        }
        return null;
    }

    public Collection<ServiceMember> getAllMembers() {
        return this.serviceMembers.values();
    }

    public Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.getAllMembers(connectionRetrievalInfo, false);
    }

    public Collection<ServiceMember> getAllMembers(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl2) {
        if (!this.connectionSource().isDataDependentRoutingEnabled() || connectionRetrievalInfo == null || this.routingCache() == null) {
            return this.getAllMembers();
        }
        if (bl2) {
            return this.routingCache().instancesToGrow(connectionRetrievalInfo);
        }
        return this.routingCache().allInstances(connectionRetrievalInfo);
    }

    public void markup(FailoverDriver.Event event) {
        FailoverDriver.Event.Status status = event.status();
        String string = event.instance();
        String string2 = event.host();
        String string3 = event.serviceName();
        String string4 = event.database();
        FailoverDriver.Event.EventType eventType = event.event_type();
        ClioSupport.ilogFinest(null, null, null, null, "FF markup:" + " event=" + event.toString());
        if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && null != string) {
            this.insertMember(new ServiceMember(string, string4, string2, string3, this));
        }
        for (ServiceMember serviceMember : this.serviceMembers.values()) {
            serviceMember.clearRLBHistory();
            if ((FailoverDriver.Event.EventType.INSTANCE == eventType || FailoverDriver.Event.EventType.SERVICEMEMBER == eventType) && string.equals(serviceMember.name()) && string4.equals(serviceMember.database()) && string3.equals(serviceMember.service())) {
                serviceMember.markActive(FailoverDriver.Event.Status.UP == status);
                continue;
            }
            if (FailoverDriver.Event.EventType.SERVICE == eventType && string4.equals(serviceMember.database()) && string3.equals(serviceMember.service())) {
                serviceMember.markActive(FailoverDriver.Event.Status.UP == status);
                continue;
            }
            if (FailoverDriver.Event.EventType.NODE != eventType || !string2.equals(serviceMember.host())) continue;
            serviceMember.markActive(FailoverDriver.Event.Status.UP == status);
        }
    }

    public void markup(LoadBalancer.Event event) {
        ClioSupport.ilogFinest(null, null, null, null, "load balancer markup:" + " event=" + event.toString());
        for (String string : event.instances()) {
            if (null == string) {
                ClioSupport.ilogWarning(null, null, null, null, "instaname is null, skipping");
                continue;
            }
            ServiceMember serviceMember = this.insertMember(new ServiceMember(string, event.database(), event.host(), event.service(), this));
            serviceMember.markAffined(event.affinity(string));
            ClioSupport.ilogFinest(null, null, null, null, " instance " + serviceMember.toString() + " marked as affined");
            LoadBalancer.Event.Flag flag = event.flag(string);
            serviceMember.markActive(LoadBalancer.Event.Flag.NO_DATA != flag && LoadBalancer.Event.Flag.BLOCKED != flag);
            serviceMember.markViolating(LoadBalancer.Event.Flag.VIOLATING == flag);
        }
    }

    public int activeCount() {
        return this.activeCount.get();
    }

    public int borrowedCount() {
        return this.borrowedCount.get();
    }

    private static int gcd(Integer ... integerArray) {
        switch (integerArray.length) {
            case 0: {
                return 1;
            }
            case 1: {
                return integerArray[0];
            }
            case 2: {
                return 0 == integerArray[1] ? integerArray[0] : Service.gcd(integerArray[1], integerArray[0] % integerArray[1]);
            }
        }
        Integer[] integerArray2 = new Integer[integerArray.length - 1];
        integerArray2[0] = Service.gcd(integerArray[0], integerArray[1]);
        System.arraycopy(integerArray, 2, integerArray2, 1, integerArray2.length - 1);
        return Service.gcd(integerArray2);
    }

    void buildDistributionTable() {
        int n2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (ServiceMember stringArray2 : this.getAllMembers()) {
            n2 = stringArray2.activeCount.get();
            if (n2 <= 0) continue;
            arrayList2.add(n2);
            arrayList.add(stringArray2.name());
        }
        Integer[] integerArray = arrayList2.toArray(new Integer[0]);
        String[] stringArray = arrayList.toArray(new String[0]);
        n2 = Service.gcd(integerArray);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            arrayList3.addAll(Collections.nCopies(integerArray[i2] / n2, stringArray[i2]));
        }
        this.distributionTable.set(arrayList3.toArray(new String[0]));
    }

    Selector proportionalDistributionSelector() {
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                String[] stringArray = (String[])Service.this.distributionTable.get();
                return 0 == stringArray.length ? true : coreConnection.serviceMember().name().equals(stringArray[rand.nextInt(stringArray.length)]);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public Topology connectionSource() {
        return this.connectionSource;
    }

    DataDependentRoutingCache routingCache() {
        if (this.routingCache.get() != null) {
            return this.routingCache.get();
        }
        this.routingCache.compareAndSet(null, this.prepareRoutingCache());
        return this.routingCache.get();
    }

    public String name() {
        return this.name;
    }

    public CoreConnection create(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, EnumSet<ConnectionSource.CreateMode> enumSet, long l2) throws UniversalConnectionPoolException {
        long l3 = 100L;
        long l4 = Clock.clock() + Math.max(0L, l2);
        UniversalConnectionPoolException universalConnectionPoolException = null;
        do {
            this.pendingCreateCount.incrementAndGet();
            try {
                CoreConnection coreConnection;
                if (this.activeCount.get() + this.pendingCreateCount.get() > this.connectionSource().limits().getMaxPerService()) {
                    ClioSupport.ilogFinest(null, null, null, null, "Cannot create new connections, max connections per service limit reached");
                    coreConnection = null;
                    return coreConnection;
                }
                coreConnection = this.create(connectionRetrievalInfo, connectionAffinityCallback, enumSet);
                if (null != coreConnection) {
                    ClioSupport.ilogFinest(null, null, null, null, coreConnection + " created");
                    CoreConnection coreConnection2 = coreConnection;
                    return coreConnection2;
                }
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException2) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException2);
                universalConnectionPoolException = universalConnectionPoolException2;
                if (universalConnectionPoolException2.getCause() instanceof SQLRecoverableException || Service.isUnableToCreateConnection(universalConnectionPoolException2)) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!Service.isUnableToCreateConnection(universalConnectionPoolException2)) continue;
                    enumSet = EnumSet.noneOf(ConnectionSource.CreateMode.class);
                    ClioSupport.ilogFinest(null, null, null, null, " unable to connect to specific instance, setting createModes = EnumSet.noneOf(CreateMode.class)");
                    continue;
                }
                throw universalConnectionPoolException2;
            }
            finally {
                this.pendingCreateCount.decrementAndGet();
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (Clock.clock() <= l4);
        if (universalConnectionPoolException != null) {
            throw universalConnectionPoolException;
        }
        ClioSupport.ilogFinest(null, null, null, null, "gave up to create a connection");
        return null;
    }

    private static boolean isUnableToCreateConnection(UniversalConnectionPoolException universalConnectionPoolException) {
        return universalConnectionPoolException.getErrorCode() == 45067;
    }

    private UniversalPooledConnection createConnectionInterruptably(final ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return interruptableActor.doAction(new InterruptableActor.Action<UniversalPooledConnection, String, UniversalConnectionPoolException>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;

            @Override
            public UniversalPooledConnection exec() throws UniversalConnectionPoolException {
                return Service.this.connectionSource().createPooledConnection(connectionRetrievalInfo);
            }

            @Override
            public String getDescriptor() {
                return ((OracleJDBCConnectionRetrievalInfo)connectionRetrievalInfo).getInstanceName();
            }

            static {
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredConstructor(Service.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("exec", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("getDescriptor", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("getDescriptor", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("exec", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
    }

    void interruptPendingCreations() {
        Map<String, ServiceMember> map = this.getAllMembers().stream().collect(Collectors.toMap(ServiceMember::name, serviceMember -> serviceMember));
        ClioSupport.ilogFinest(null, null, null, null, "memberMap: " + map.toString());
        interruptableActor.registerPredicate(pair -> {
            String string = (String)((InterruptableActor.Action)pair.get1st()).getDescriptor();
            if (null == string) {
                return false;
            }
            ServiceMember serviceMember = (ServiceMember)map.get(string);
            return null == serviceMember ? false : !serviceMember.active();
        });
        interruptableActor.triggerInterrupts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreConnection create(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, EnumSet<ConnectionSource.CreateMode> enumSet) throws UniversalConnectionPoolException {
        Object object;
        Object object2;
        AffinityContext affinityContext;
        Object object3;
        Set<Object> set;
        final ServiceMember[] serviceMemberArray = new ServiceMember[]{null};
        boolean bl2 = this.connectionSource().isDataDependentRoutingEnabled();
        if (bl2 && !this.routingCache().hasInstanceToGrow(connectionRetrievalInfo)) {
            return null;
        }
        Set<Object> set2 = set = bl2 ? this.routingCache().instancesToGrow(connectionRetrievalInfo) : new HashSet();
        if (bl2 && set.size() == 0) {
            enumSet = EnumSet.noneOf(ConnectionSource.CreateMode.class);
        }
        if (enumSet.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null != connectionAffinityCallback && null != (object3 = connectionAffinityCallback.getConnectionAffinityContext()) && object3 instanceof AffinityContext) {
            affinityContext = (AffinityContext)object3;
            object2 = affinityContext.getInstanceName();
            if (null != object2) {
                int n2;
                Object object4 = this.mostRecentONSEvent.get();
                if (null == object4 || object4 instanceof FailoverDriver.Event) {
                    n2 = this.connectionSource().limits().getMax();
                } else if (object4 instanceof LoadBalancer.Event) {
                    int n3 = this.connectionSource().limits().getMax();
                    if (n3 < Integer.MAX_VALUE) {
                        switch (connectionAffinityCallback.getAffinityPolicy()) {
                            case WEBSESSION_BASED_AFFINITY: 
                            case DATA_BASED_AFFINITY: {
                                LoadBalancer.Event event = (LoadBalancer.Event)object4;
                                n2 = (int)((float)n3 * event.normalizedPercent((String)object2) / 100.0f);
                                break;
                            }
                            case TRANSACTION_BASED_AFFINITY: {
                                n2 = n3;
                                break;
                            }
                            default: {
                                ClioSupport.ilogWarning(null, null, null, null, "unknown affinity policy");
                                n2 = n3;
                                break;
                            }
                        }
                    } else {
                        n2 = Integer.MAX_VALUE;
                    }
                } else {
                    throw new IllegalStateException("wrong ONS event object");
                }
                object = this.getMember((String)object2, affinityContext.getDatabaseUniqueName(), affinityContext.getServiceName());
                if (null != object && ((ServiceMember)object).activeCount.get() < n2) {
                    if (!set.stream().anyMatch(arg_0 -> Service.lambda$create$2((String)object2, arg_0))) {
                        this.lbStats.onFailedAffBorrowed();
                        ((ServiceMember)object).lbStats.onFailedAffBorrowed();
                        connectionAffinityCallback.setConnectionAffinityContext(null);
                    } else {
                        serviceMemberArray[0] = object;
                        this.lbStats.onSuccessfulAffBorrowed();
                        ((ServiceMember)object).lbStats.onSuccessfulAffBorrowed();
                    }
                } else {
                    this.lbStats.onFailedAffBorrowed();
                    ((ServiceMember)object).lbStats.onFailedAffBorrowed();
                    connectionAffinityCallback.setConnectionAffinityContext(null);
                }
            } else {
                connectionAffinityCallback.setConnectionAffinityContext(null);
                throw new IllegalStateException("wrong affinity context (missing instance name)");
            }
        }
        if (enumSet.contains((Object)ConnectionSource.CreateMode.USE_BEST_INSTANCE) && null == serviceMemberArray[0]) {
            serviceMemberArray[0] = this.underloadedInstance(connectionRetrievalInfo);
        }
        try {
            if (serviceMemberArray[0] == null && bl2) {
                serviceMemberArray[0] = this.routingCache().getBestInstanceToGrow(connectionRetrievalInfo);
                if (serviceMemberArray[0] != null) {
                    this.routingCache().onConnectionRequest(serviceMemberArray[0]);
                }
            }
            affinityContext = serviceMemberArray[0] != null ? serviceMemberArray[0].name() : null;
            ClioSupport.ilogFinest(null, null, null, null, "targetInst=" + (String)((Object)affinityContext));
            ClioSupport.ilogFinest(null, null, null, null, "instances=" + this.serviceMembers.values().toString());
            object2 = connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo ? new OracleJDBCConnectionRetrievalInfo((JDBCConnectionRetrievalInfo)connectionRetrievalInfo, (String)((Object)affinityContext)) : connectionRetrievalInfo;
            ClioSupport.ilogFinest(null, null, null, null, "about to make an attempt to create a connection");
            UniversalPooledConnection universalPooledConnection = null;
            try {
                universalPooledConnection = this.createConnectionInterruptably((ConnectionRetrievalInfo)object2);
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                object = universalConnectionPoolException.getCause();
                if (null == object) {
                    throw universalConnectionPoolException;
                }
                int n4 = ((SQLException)object).getErrorCode();
                ClioSupport.ilogFinest(null, null, null, null, "errorCode=" + n4);
                if (object instanceof SQLException && 12521 == n4) {
                    ClioSupport.ilogFinest(null, null, null, null, "caught ORA-12521, TNS:listener does not currently know of instance requested in connect descriptor");
                    UCPErrorHandler.throwUniversalConnectionPoolException(67);
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "caught e.getCause.getErrorCode()= " + ((SQLException)object).getErrorCode());
                }
                throw universalConnectionPoolException;
            }
            object3 = universalPooledConnection;
        }
        finally {
            if (bl2 && serviceMemberArray[0] != null) {
                this.routingCache().onConnectionRequestComplete(serviceMemberArray[0]);
            }
        }
        if (null == object3) {
            ClioSupport.ilogFine(null, null, null, null, "unable to create a connection");
            return null;
        }
        this.checkAndRegister();
        Instantiator instantiator = this.instantiator;
        instantiator.getClass();
        object3.plugDelegator(new Instantiator.Connection(instantiator, (UniversalPooledConnection)object3, connectionRetrievalInfo){
            private final Object physicalConn = this.getPhysicalConnection();
            private final Properties props = Service.access$200(Service.this, this);
            private String onsConfig = Service.this.connectionSource().getONSConfig();
            private ServiceMember serviceMember = new ServiceMember(this.props, Service.this);
            private boolean replayable = false;
            private String connContainerName = this.fetchContainerName();
            private AtomicBoolean pendingClose;
            private final Semaphore acSemaphore;
            final /* synthetic */ UniversalPooledConnection val$upc;
            final /* synthetic */ ConnectionRetrievalInfo val$cri;
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            private static Executable $$$methodRef$$$14;
            private static Logger $$$loggerRef$$$14;
            private static Executable $$$methodRef$$$15;
            private static Logger $$$loggerRef$$$15;
            private static Executable $$$methodRef$$$16;
            private static Logger $$$loggerRef$$$16;
            private static Executable $$$methodRef$$$17;
            private static Logger $$$loggerRef$$$17;
            private static Executable $$$methodRef$$$18;
            private static Logger $$$loggerRef$$$18;
            private static Executable $$$methodRef$$$19;
            private static Logger $$$loggerRef$$$19;
            private static Executable $$$methodRef$$$20;
            private static Logger $$$loggerRef$$$20;
            private static Executable $$$methodRef$$$21;
            private static Logger $$$loggerRef$$$21;
            private static Executable $$$methodRef$$$22;
            private static Logger $$$loggerRef$$$22;
            private static Executable $$$methodRef$$$23;
            private static Logger $$$loggerRef$$$23;
            private static Executable $$$methodRef$$$24;
            private static Logger $$$loggerRef$$$24;
            private static Executable $$$methodRef$$$25;
            private static Logger $$$loggerRef$$$25;
            private static Executable $$$methodRef$$$26;
            private static Logger $$$loggerRef$$$26;
            private static Executable $$$methodRef$$$27;
            private static Logger $$$loggerRef$$$27;
            private static Executable $$$methodRef$$$28;
            private static Logger $$$loggerRef$$$28;
            private static Executable $$$methodRef$$$29;
            private static Logger $$$loggerRef$$$29;
            private static Executable $$$methodRef$$$30;
            private static Logger $$$loggerRef$$$30;
            private static Executable $$$methodRef$$$31;
            private static Logger $$$loggerRef$$$31;
            private static Executable $$$methodRef$$$32;
            private static Logger $$$loggerRef$$$32;
            private static Executable $$$methodRef$$$33;
            private static Logger $$$loggerRef$$$33;
            private static Executable $$$methodRef$$$34;
            private static Logger $$$loggerRef$$$34;
            private static Executable $$$methodRef$$$35;
            private static Logger $$$loggerRef$$$35;
            private static Executable $$$methodRef$$$36;
            private static Logger $$$loggerRef$$$36;
            private static Executable $$$methodRef$$$37;
            private static Logger $$$loggerRef$$$37;
            {
                ONSDriver oNSDriver;
                this.val$upc = universalPooledConnection;
                this.val$cri = connectionRetrievalInfo;
                Service.this.setName(this.serviceMember.service());
                Service.this.setContainerName(this.connContainerName);
                Service.this.placement.addAll(this.fetchServicePlacement());
                if (null != serviceMemberArray[0] && !this.serviceMember.name().equals(serviceMemberArray[0].name())) {
                    ClioSupport.ilogFinest(null, null, null, null, "per-instance connections distribution has changed and the " + this.serviceMember.name() + "is now the best instance");
                }
                if (null == this.onsConfig || "".equals(this.onsConfig)) {
                    this.onsConfig = this.props.getProperty("AUTH_ONS_CONFIG");
                }
                if (Service.this.connectionSource().failoverEnabled() && (oNSDriver = Service.this.connectionSource().onsDriver(this.onsConfig)) != null) {
                    Service.this.failoverDriver.start(oNSDriver);
                    String string = this.serviceMember.service();
                    if (null != string) {
                        Service.this.loadBalancer.start(oNSDriver, string);
                    }
                }
                this.serviceMember = Service.this.insertMember(this.serviceMember);
                this.serviceMember.activeCount.incrementAndGet();
                this.serviceMember.serviceRef.lbStats.onOpened();
                this.serviceMember.lbStats.onOpened();
                Service.this.connectionSource().totalCount().incrementAndGet();
                this.serviceMember.serviceRef.activeCount.incrementAndGet();
                Service.this.connectionSource().totalCount(this.val$upc.getConnectionRetrievalInfo()).incrementAndGet();
                if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                    oNSDriver = Service.this.connectionSource().onsDriver(this.onsConfig);
                    Service.this.routingCache().startEventHandler(oNSDriver);
                    Service.this.routingCache().onConnectionCreation((Connection)this.physicalConn, this.val$cri);
                }
                Service.this.onRegister();
                this.pendingClose = new AtomicBoolean(false);
                this.acSemaphore = new Semaphore(1);
            }

            @Override
            public ServiceMember serviceMember() {
                if (null == this.serviceMember || null == this.serviceMember.name()) {
                    throw new IllegalStateException();
                }
                return this.serviceMember;
            }

            @Override
            public Object getDelegate() {
                return this.val$upc;
            }

            @Override
            public long lastAccessedTime() {
                return this.val$upc.getLastAccessedTime();
            }

            @Override
            public boolean reusable() {
                return this.val$upc.isReusable();
            }

            @Override
            public boolean valid() {
                return this.val$upc.isValid();
            }

            @Override
            public boolean closed() {
                return UniversalPooledConnectionStatus.STATUS_CLOSED.equals(this.val$upc.getStatus());
            }

            @Override
            public boolean normal() {
                return UniversalPooledConnectionStatus.STATUS_NORMAL.equals(this.val$upc.getStatus());
            }

            @Override
            public boolean bad() {
                return UniversalPooledConnectionStatus.STATUS_BAD.equals(this.val$upc.getStatus());
            }

            @Override
            public boolean markedToReplace() {
                return UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN.equals(this.val$upc.getStatus());
            }

            @Override
            public void markToReplace() {
                try {
                    this.val$upc.setStatus(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN);
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
                if (this.pendingClose.compareAndSet(false, true)) {
                    this.serviceMember.pendingCloseCount.incrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
                }
            }

            @Override
            public boolean markedCloseOnReturn() {
                return UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN.equals(this.val$upc.getStatus());
            }

            @Override
            public void markCloseOnReturn() {
                try {
                    this.val$upc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
                if (this.pendingClose.compareAndSet(false, true)) {
                    this.serviceMember.pendingCloseCount.incrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.incrementAndGet();
                }
            }

            @Override
            public void cleanupToHarvest() {
                try {
                    ConnectionHarvestingCallback connectionHarvestingCallback = this.val$upc.getConnectionHarvestingCallback();
                    if (connectionHarvestingCallback != null) {
                        connectionHarvestingCallback.cleanup();
                    }
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
            }

            @Override
            public ConnectionRetrievalInfo cri() {
                return this.val$upc.getConnectionRetrievalInfo();
            }

            @Override
            public void abort() {
                this.val$upc.abort();
                this.serviceMember.serviceRef.lbStats.onAborted();
                this.serviceMember.lbStats.onAborted();
            }

            @Override
            public void handleTimeout() {
                this.val$upc.handleTimeout();
            }

            @Override
            public void close() {
                boolean bl2;
                block7: {
                    UniversalPooledConnectionStatus universalPooledConnectionStatus;
                    do {
                        if (UniversalPooledConnectionStatus.STATUS_CLOSED.equals(universalPooledConnectionStatus = ((UniversalPooledConnectionImpl)this.val$upc).m_status.get()) && ((UniversalPooledConnectionImpl)this.val$upc).m_status.compareAndSet(universalPooledConnectionStatus, UniversalPooledConnectionStatus.STATUS_CLOSED)) {
                            return;
                        }
                        if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(universalPooledConnectionStatus) || !((UniversalPooledConnectionImpl)this.val$upc).m_status.compareAndSet(universalPooledConnectionStatus, UniversalPooledConnectionStatus.STATUS_RECONNECTING)) continue;
                        bl2 = true;
                        break block7;
                    } while (!((UniversalPooledConnectionImpl)this.val$upc).m_status.compareAndSet(universalPooledConnectionStatus, UniversalPooledConnectionStatus.STATUS_CLOSED));
                    bl2 = false;
                }
                if (!this.available()) {
                    long l2 = Clock.clock() - this.val$upc.getBorrowedStartTime();
                    this.serviceMember.serviceRef.lbStats.onReturned(l2);
                    this.serviceMember.lbStats.onReturned(l2);
                    this.serviceMember.borrowedCount.decrementAndGet();
                    this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                    if (!bl2) {
                        Service.this.connectionSource().borrowedCount().decrementAndGet();
                        Service.this.connectionSource().borrowedCount(this.val$upc.getConnectionRetrievalInfo()).decrementAndGet();
                    }
                    Service.this.connectionSource().cumulativeConnectionUseTime().addAndGet(l2);
                }
                Service.this.connectionSource().connectionsClosed().incrementAndGet();
                this.serviceMember.activeCount.decrementAndGet();
                this.serviceMember.serviceRef.activeCount.decrementAndGet();
                this.serviceMember.serviceRef.lbStats.onClosed();
                this.serviceMember.lbStats.onClosed();
                if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                    Service.this.routingCache().onConnectionClosure((Connection)this.physicalConn);
                }
                if (!bl2) {
                    Service.this.connectionSource().totalCount().decrementAndGet();
                    Service.this.connectionSource().totalCount(this.val$upc.getConnectionRetrievalInfo()).decrementAndGet();
                }
                if (this.pendingClose.compareAndSet(true, false)) {
                    this.serviceMember.pendingCloseCount.decrementAndGet();
                    this.serviceMember.serviceRef.pendingCloseCount.decrementAndGet();
                }
                ((UniversalPooledConnectionImpl)this.val$upc).closeNoStatsUpdate();
            }

            @Override
            public boolean available() {
                return this.val$upc.isAvailable();
            }

            @Override
            public void makeAvailable() {
                this.val$upc.heartbeat();
                this.val$upc.setAvailableStartTime();
                try {
                    this.val$upc.removeConnectionHarvestingCallback();
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                }
                if (this.val$upc.setAvailable()) {
                    long l2 = Clock.clock() - this.val$upc.getBorrowedStartTime();
                    this.serviceMember.serviceRef.lbStats.onReturned(l2);
                    this.serviceMember.lbStats.onReturned(l2);
                    this.serviceMember.borrowedCount.decrementAndGet();
                    Service.this.connectionSource().borrowedCount().decrementAndGet();
                    this.serviceMember.serviceRef.borrowedCount.decrementAndGet();
                    Service.this.connectionSource().cumulativeConnectionUseTime().addAndGet(l2);
                    Service.this.connectionSource().borrowedCount(this.val$upc.getConnectionRetrievalInfo()).decrementAndGet();
                }
            }

            @Override
            public void makeUnavailable() {
                this.val$upc.heartbeat();
                this.val$upc.setBorrowedStartTime();
                if (this.val$upc.setBorrowed()) {
                    this.serviceMember.lbStats.onBorrowed(this.serviceMember.borrowedCount.incrementAndGet());
                    this.serviceMember.serviceRef.lbStats.onBorrowed(Service.this.connectionSource().borrowedCount().incrementAndGet());
                    this.serviceMember.serviceRef.borrowedCount.incrementAndGet();
                    Service.this.connectionSource().borrowedCount(this.val$upc.getConnectionRetrievalInfo()).incrementAndGet();
                }
            }

            @Override
            public int labelingCost(Properties properties) {
                return this.val$upc.labelingCost(properties);
            }

            @Override
            public void onBorrow(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
                try {
                    if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                        Service.this.routingCache().onConnectionBorrow((Connection)this.physicalConn, connectionRetrievalInfo);
                    }
                    if (Service.this.connectionSource().isMultitenantDatabase() && this.val$upc instanceof OracleUniversalPooledConnection) {
                        ((OracleUniversalPooledConnection)this.val$upc).initPdbSession(connectionRetrievalInfo);
                    }
                    this.openProxySession(connectionRetrievalInfo);
                }
                catch (SQLException sQLException) {
                    throw new UniversalConnectionPoolException(sQLException.getMessage(), sQLException);
                }
            }

            @Override
            public void onReturn() throws UniversalConnectionPoolException {
                try {
                    this.closeProxySession();
                }
                catch (SQLException sQLException) {
                    throw new UniversalConnectionPoolException(sQLException.getMessage(), sQLException);
                }
            }

            @Override
            public boolean reconnecting() {
                return UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.val$upc.getStatus());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markReconnecting() {
                block11: {
                    if (this.normal()) {
                        String string = this.serviceMember().name();
                        try {
                            this.acSemaphore.acquire();
                            if (string == null || !string.equals(this.serviceMember().name())) break block11;
                            try {
                                this.val$upc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                            }
                            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                                ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                            }
                            finally {
                                this.abort();
                                this.close();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
                        }
                        finally {
                            this.acSemaphore.release();
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reinitialize() {
                try {
                    this.acSemaphore.acquire();
                    ServiceMember serviceMember = this.serviceMember();
                    Properties properties = Service.this.getProperties(this);
                    this.serviceMember = new ServiceMember(properties, Service.this);
                    this.serviceMember = Service.this.insertMember(this.serviceMember);
                    this.serviceMember.activeCount.incrementAndGet();
                    this.serviceMember.lbStats.onOpened();
                    this.serviceMember.serviceRef.lbStats.onOpened();
                    serviceMember.activeCount.decrementAndGet();
                    serviceMember.lbStats.onClosed();
                    serviceMember.serviceRef.lbStats.onClosed();
                    try {
                        this.val$upc.setStatus(UniversalPooledConnectionStatus.STATUS_NORMAL);
                    }
                    catch (UniversalConnectionPoolException universalConnectionPoolException) {
                        ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                    }
                }
                catch (InterruptedException interruptedException) {
                    ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
                }
                finally {
                    this.acSemaphore.release();
                }
            }

            @Override
            public boolean isReplayable() {
                return this.replayable;
            }

            @Override
            public void setReplayable(boolean bl2) {
                this.replayable = bl2;
            }

            @Override
            public String serviceName() {
                return this.serviceMember.service();
            }

            Set<String> fetchServicePlacement() {
                if (!this.val$upc.isOracle()) {
                    return new HashSet<String>();
                }
                OracleConnection oracleConnection = (OracleConnection)this.physicalConn;
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(this.serviceMember().name());
                if (!Service.this.connectionSource().isMultitenantDatabase()) {
                    return hashSet;
                }
                if (oracleConnection == null) {
                    return hashSet;
                }
                try {
                    if (oracleConnection.getVersionNumber() < 12200) {
                        return hashSet;
                    }
                    String string = "select dbms_service_prvt.get_topology('" + this.serviceName() + "') from dual";
                    try (Statement statement = oracleConnection.createStatement();
                         ResultSet resultSet = statement.executeQuery(string);){
                        String string2 = "";
                        if (resultSet.next()) {
                            string2 = resultSet.getString(1);
                        }
                        if (string2 != null && string2.length() > 0) {
                            for (String string3 : string2.split(",")) {
                                hashSet.add(string3);
                            }
                        }
                    }
                }
                catch (SQLException sQLException) {
                    ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                }
                return hashSet;
            }

            public String containerName() {
                return this.connContainerName;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String fetchContainerName() {
                if (!Service.this.connectionSource().isMultitenantDatabase()) {
                    return "";
                }
                OracleConnection oracleConnection = (OracleConnection)this.physicalConn;
                if (oracleConnection == null) {
                    return "";
                }
                Statement statement = null;
                ResultSet resultSet = null;
                try {
                    statement = oracleConnection.createStatement();
                    String string = "select sys_context('userenv','con_name') from dual";
                    resultSet = statement.executeQuery("select sys_context('userenv','con_name') from dual");
                    if (resultSet.next()) {
                        String string2 = resultSet.getString(1);
                        return string2;
                    }
                }
                catch (SQLException sQLException) {
                    ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                }
                finally {
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (statement != null) {
                            statement.close();
                        }
                    }
                    catch (SQLException sQLException) {
                        ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                    }
                }
                return "";
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean repurpose(ConnectionRetrievalInfo connectionRetrievalInfo) {
                if (!(this.val$cri instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (!(this.cri() instanceof JDBCConnectionRetrievalInfo)) {
                    return false;
                }
                if (this.closed()) return false;
                if (!this.valid()) {
                    return false;
                }
                OracleConnection oracleConnection = (OracleConnection)this.physicalConn;
                if (oracleConnection == null) {
                    return false;
                }
                JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo2 = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
                String string3 = jDBCConnectionRetrievalInfo2.getServiceName();
                JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)this.cri();
                if (!jDBCConnectionRetrievalInfo2.equals(jDBCConnectionRetrievalInfo.getCopyWithService(string3))) {
                    return false;
                }
                try (Statement statement = oracleConnection.createStatement();){
                    Service service = Service.this.connectionSource().service(string3);
                    String string4 = "alter session set container=" + service.containerName() + " service=\"" + service.name() + "\"";
                    statement.execute(string4);
                    String string2 = this.fetchContainerName();
                    Properties properties = Service.this.getProperties(this);
                    String string = properties.getProperty("SERVICE_NAME");
                    if (!service.name().equalsIgnoreCase(string) && !service.containerName().equalsIgnoreCase(string2)) {
                        ClioSupport.ilogWarning(null, null, null, null, "Repurposing connection from service " + this.serviceName() + "to service " + service.name() + "failed");
                        boolean bl3 = false;
                        return bl3;
                    }
                    ClioSupport.ilogFinest(null, null, null, null, "Repurposed connection from service " + this.serviceName() + "to service " + service.name());
                    if (this.getDelegate() instanceof OracleUniversalPooledConnection) {
                        OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)this.getDelegate();
                        oracleUniversalPooledConnection.setPdbSessionInitialized(false);
                        Service.this.connectionSource().totalCount(jDBCConnectionRetrievalInfo).decrementAndGet();
                        ConnectionRetrievalInfo connectionRetrievalInfo2 = jDBCConnectionRetrievalInfo2.getCopyWithService(string).getCopyWithNoLabels();
                        oracleUniversalPooledConnection.setConnectionRetrievalInfo(connectionRetrievalInfo2);
                        Service.this.connectionSource().totalCount(connectionRetrievalInfo2).incrementAndGet();
                    }
                    this.serviceMember.activeCount.decrementAndGet();
                    this.serviceMember.lbStats.onClosed();
                    this.serviceMember.serviceRef.activeCount.decrementAndGet();
                    this.serviceMember.serviceRef.lbStats.onClosed();
                    this.serviceMember = new ServiceMember(properties, service);
                    this.connContainerName = string2;
                    this.serviceMember = service.insertMember(this.serviceMember);
                    this.serviceMember.activeCount.incrementAndGet();
                    service.lbStats.onOpened();
                    this.serviceMember.lbStats.onOpened();
                    service.activeCount.incrementAndGet();
                    boolean bl2 = true;
                    return bl2;
                }
                catch (SQLException sQLException) {
                    ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                    return false;
                }
            }

            @Override
            public void onError() {
                UniversalPooledConnectionImpl universalPooledConnectionImpl = (UniversalPooledConnectionImpl)this.getDelegate();
                Service.this.routingCache().onError(universalPooledConnectionImpl.getBorrowCRI(), this.serviceMember());
            }

            @Override
            public Object getPhysicalConnection() {
                block6: {
                    if (!(this.getDelegate() instanceof UniversalPooledConnection)) {
                        return null;
                    }
                    try {
                        UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)this.getDelegate();
                        Object object = universalPooledConnection.getPhysicalConnection();
                        if (universalPooledConnection.isOracle()) {
                            if (object instanceof OracleConnection) {
                                return object;
                            }
                            if (object instanceof OraclePooledConnection) {
                                return ((OraclePooledConnection)object).getConnection();
                            }
                            break block6;
                        }
                        return object;
                    }
                    catch (SQLException sQLException) {
                        ClioSupport.ilogThrowing(null, null, null, null, sQLException);
                    }
                }
                return null;
            }

            void openProxySession(ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
                if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
                    return;
                }
                if (!this.val$upc.isOracle()) {
                    return;
                }
                OracleConnection oracleConnection = (OracleConnection)this.physicalConn;
                if (oracleConnection == null) {
                    return;
                }
                if (oracleConnection.isProxySession()) {
                    return;
                }
                JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
                Properties properties = jDBCConnectionRetrievalInfo.getProxyProperties();
                if (properties == null) {
                    return;
                }
                int n2 = jDBCConnectionRetrievalInfo.getProxyType();
                ClioSupport.ilogFinest(null, null, null, null, " Opening proxy session with Properties = " + properties);
                oracleConnection.openProxySession(n2, properties);
                ConnectionRetrievalInfo connectionRetrievalInfo2 = jDBCConnectionRetrievalInfo.getCopyWithNewProxyProperties(n2, properties);
                this.val$upc.setConnectionRetrievalInfo(connectionRetrievalInfo2);
            }

            void closeProxySession() throws SQLException {
                if (!this.val$upc.isOracle()) {
                    return;
                }
                OracleConnection oracleConnection = (OracleConnection)this.physicalConn;
                ConnectionRetrievalInfo connectionRetrievalInfo = this.val$upc.getConnectionRetrievalInfo();
                if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
                    return;
                }
                JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
                if (jDBCConnectionRetrievalInfo.getProxyProperties() == null) {
                    return;
                }
                if (oracleConnection == null) {
                    return;
                }
                oracleConnection.close(1);
                this.val$upc.setConnectionRetrievalInfo(jDBCConnectionRetrievalInfo.getCopyWithNewProxyProperties(-1, null));
            }

            static {
                try {
                    $$$methodRef$$$37 = 3.class.getDeclaredConstructor(Service.class, Instantiator.class, ServiceMember[].class, UniversalPooledConnection.class, ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$36 = 3.class.getDeclaredMethod("closeProxySession", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$35 = 3.class.getDeclaredMethod("openProxySession", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$34 = 3.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$33 = 3.class.getDeclaredMethod("onError", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$32 = 3.class.getDeclaredMethod("repurpose", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$31 = 3.class.getDeclaredMethod("fetchContainerName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$30 = 3.class.getDeclaredMethod("containerName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$29 = 3.class.getDeclaredMethod("fetchServicePlacement", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$28 = 3.class.getDeclaredMethod("serviceName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$27 = 3.class.getDeclaredMethod("setReplayable", Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$26 = 3.class.getDeclaredMethod("isReplayable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$25 = 3.class.getDeclaredMethod("reinitialize", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$24 = 3.class.getDeclaredMethod("markReconnecting", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$23 = 3.class.getDeclaredMethod("reconnecting", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$22 = 3.class.getDeclaredMethod("onReturn", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$21 = 3.class.getDeclaredMethod("onBorrow", ConnectionRetrievalInfo.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$20 = 3.class.getDeclaredMethod("labelingCost", Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$19 = 3.class.getDeclaredMethod("makeUnavailable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$18 = 3.class.getDeclaredMethod("makeAvailable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$17 = 3.class.getDeclaredMethod("available", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$16 = 3.class.getDeclaredMethod("close", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$15 = 3.class.getDeclaredMethod("handleTimeout", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$14 = 3.class.getDeclaredMethod("abort", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$13 = 3.class.getDeclaredMethod("cri", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 3.class.getDeclaredMethod("cleanupToHarvest", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 3.class.getDeclaredMethod("markCloseOnReturn", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 3.class.getDeclaredMethod("markedCloseOnReturn", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 3.class.getDeclaredMethod("markToReplace", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 3.class.getDeclaredMethod("markedToReplace", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 3.class.getDeclaredMethod("bad", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 3.class.getDeclaredMethod("normal", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 3.class.getDeclaredMethod("closed", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 3.class.getDeclaredMethod("valid", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 3.class.getDeclaredMethod("reusable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 3.class.getDeclaredMethod("lastAccessedTime", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 3.class.getDeclaredMethod("getDelegate", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 3.class.getDeclaredMethod("serviceMember", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        });
        return object3.getDelegator();
    }

    private FailoverDriver prepareFailoverDriver() {
        return new FailoverDriver(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected ConnectionSource.FailoverCallback.Result onEvent(FailoverDriver.Event event, Selector selector, Selector selector2, boolean bl2, boolean bl3) {
                ConnectionSource.FailoverCallback failoverCallback;
                Service.this.mostRecentONSEvent.set(event);
                if (Service.this.connectionSource().isDataDependentRoutingEnabled()) {
                    Service.this.routingCache().onHAEvent(event);
                }
                return null != (failoverCallback = (ConnectionSource.FailoverCallback)Service.this.failoverHandler.get()) ? failoverCallback.handle(selector, selector2, bl2, bl3) : new ConnectionSource.FailoverCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$2 = 4.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 4.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 4.class.getDeclaredMethod("onEvent", FailoverDriver.Event.class, Selector.class, Selector.class, Boolean.TYPE, Boolean.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private LoadBalancer prepareLoadBalancer() {
        return new LoadBalancer(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            protected ConnectionSource.RebalanceCallback.Result onEvent(LoadBalancer.Event event, Selector selector, Selector selector2) {
                Service.this.mostRecentONSEvent.set(event);
                ConnectionSource.RebalanceCallback rebalanceCallback = (ConnectionSource.RebalanceCallback)Service.this.rebalanceHandler.get();
                return null != rebalanceCallback ? rebalanceCallback.handle(selector, selector2) : new ConnectionSource.RebalanceCallback.Result();
            }

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$2 = 5.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 5.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 5.class.getDeclaredMethod("onEvent", LoadBalancer.Event.class, Selector.class, Selector.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public FailoverDriver.Stats failoverDriverStats() {
        return this.fdStats;
    }

    public LoadBalancer.Stats loadBalancerStats() {
        return this.lbStats;
    }

    ServiceMember underloadedInstance() {
        return this.underloadedInstance(null);
    }

    ServiceMember underloadedInstance(ConnectionRetrievalInfo connectionRetrievalInfo) {
        Object object = this.mostRecentONSEvent.get();
        if (null == object) {
            return null;
        }
        ServiceMember serviceMember = null;
        if (object instanceof LoadBalancer.Event) {
            serviceMember = this.loadBalancer.underloadedInstance(connectionRetrievalInfo);
        } else if (object instanceof FailoverDriver.Event) {
            serviceMember = this.failoverDriver.underloadedInstance(connectionRetrievalInfo);
        } else {
            throw new IllegalStateException("wrong ONS event object");
        }
        return serviceMember;
    }

    public void registerFailoverCallback(ConnectionSource.FailoverCallback failoverCallback) {
        if (null == failoverCallback) {
            throw new IllegalArgumentException("failover handler is null");
        }
        if (!this.failoverHandler.compareAndSet(null, failoverCallback)) {
            ClioSupport.ilogWarning(null, null, null, null, "failover handler has been already plugged");
        }
    }

    public void registerRebalanceCallback(ConnectionSource.RebalanceCallback rebalanceCallback) {
        if (null == rebalanceCallback) {
            throw new IllegalArgumentException("rebalance handler is null");
        }
        if (!this.rebalanceHandler.compareAndSet(null, rebalanceCallback)) {
            ClioSupport.ilogWarning(null, null, null, null, "rebalance handler has been already plugged");
        }
    }

    public Selector loadBalancedBorrowSelector(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback) {
        return this.loadBalancer.borrowSelector(connectionRetrievalInfo, connectionAffinityCallback);
    }

    private Properties getProperties(CoreConnection coreConnection) {
        UniversalPooledConnection universalPooledConnection = (UniversalPooledConnection)coreConnection.getDelegate();
        return universalPooledConnection.getDatabaseConnectionProperties();
    }

    void stop() {
        this.failoverDriver.stop();
        this.loadBalancer.stop();
    }

    @DisableTrace
    public String toString() {
        return this.name == null ? "Unnamed Service" : this.name;
    }

    public long totalBorrowTimes(ConnectionRetrievalInfo connectionRetrievalInfo, Collection<ServiceMember> collection) {
        if (connectionRetrievalInfo == null) {
            return this.lbStats.borrowTimes.totalDelta();
        }
        return collection.stream().mapToLong(serviceMember -> serviceMember.lbStats.borrowTimes.totalDelta()).sum();
    }

    int getLastDrainTimeout() {
        return this.lastDrainTimeout.get();
    }

    void setLastDrainTimeout(int n2) {
        this.lastDrainTimeout.set(n2);
    }

    private DataDependentRoutingCache prepareRoutingCache() {
        if (this.connectionSource().isShardedDatabase()) {
            return new ShardRoutingCache(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                protected Service service() {
                    return Service.this;
                }

                static {
                    try {
                        $$$methodRef$$$1 = 6.class.getDeclaredConstructor(Service.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 6.class.getDeclaredMethod("service", new Class[0]);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
        }
        return new RACDataAffinityRoutingCache(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            protected Service service() {
                return Service.this;
            }

            static {
                try {
                    $$$methodRef$$$1 = 7.class.getDeclaredConstructor(Service.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 7.class.getDeclaredMethod("service", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    public Selector serviceBasedRepurposeSelector(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl2) {
        this.awaitRegister();
        if (this.activeCount.get() + this.pendingCreateCount.get() >= this.connectionSource().limits().getMaxPerService()) {
            return Selectors.NONE;
        }
        final HashSet<String> hashSet = new HashSet<String>(this.placement.size());
        ServiceMember serviceMember = this.underloadedInstance();
        if (bl2 && serviceMember != null) {
            hashSet.add(serviceMember.name());
        } else {
            hashSet.addAll(this.placement);
        }
        return new Selector(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public boolean selected(CoreConnection coreConnection) {
                if (!coreConnection.available()) {
                    return false;
                }
                if (coreConnection.closed()) {
                    return false;
                }
                return hashSet.size() > 0 && hashSet.contains(coreConnection.serviceMember().name());
            }

            static {
                try {
                    $$$methodRef$$$1 = 8.class.getDeclaredConstructor(Service.class, Set.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 8.class.getDeclaredMethod("selected", CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    private static /* synthetic */ boolean lambda$create$2(String string, ServiceMember serviceMember) {
        return serviceMember.name().equals(string);
    }

    static {
        try {
            $$$methodRef$$$60 = Service.class.getDeclaredConstructor(Instantiator.class, Topology.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$60 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$59 = Service.class.getDeclaredMethod("access$1100", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$59 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$58 = Service.class.getDeclaredMethod("access$1000", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$58 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$57 = Service.class.getDeclaredMethod("access$900", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$57 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$56 = Service.class.getDeclaredMethod("access$800", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = Service.class.getDeclaredMethod("access$700", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = Service.class.getDeclaredMethod("access$600", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = Service.class.getDeclaredMethod("access$500", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = Service.class.getDeclaredMethod("access$400", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = Service.class.getDeclaredMethod("access$300", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = Service.class.getDeclaredMethod("access$200", Service.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = Service.class.getDeclaredMethod("access$100", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = Service.class.getDeclaredMethod("access$000", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = Service.class.getDeclaredMethod("lambda$interruptPendingCreations$0", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = Service.class.getDeclaredMethod("lambda$interruptPendingCreations$1", Map.class, Pair.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = Service.class.getDeclaredMethod("lambda$create$2", String.class, ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = Service.class.getDeclaredMethod("lambda$totalBorrowTimes$3", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = Service.class.getDeclaredMethod("serviceBasedRepurposeSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = Service.class.getDeclaredMethod("prepareRoutingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = Service.class.getDeclaredMethod("setLastDrainTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = Service.class.getDeclaredMethod("getLastDrainTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = Service.class.getDeclaredMethod("totalBorrowTimes", ConnectionRetrievalInfo.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = Service.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = Service.class.getDeclaredMethod("getProperties", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = Service.class.getDeclaredMethod("loadBalancedBorrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = Service.class.getDeclaredMethod("registerRebalanceCallback", ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Service.class.getDeclaredMethod("registerFailoverCallback", ConnectionSource.FailoverCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Service.class.getDeclaredMethod("underloadedInstance", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Service.class.getDeclaredMethod("underloadedInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Service.class.getDeclaredMethod("loadBalancerStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Service.class.getDeclaredMethod("failoverDriverStats", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Service.class.getDeclaredMethod("prepareLoadBalancer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Service.class.getDeclaredMethod("prepareFailoverDriver", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Service.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Service.class.getDeclaredMethod("interruptPendingCreations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Service.class.getDeclaredMethod("createConnectionInterruptably", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Service.class.getDeclaredMethod("isUnableToCreateConnection", UniversalConnectionPoolException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Service.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Service.class.getDeclaredMethod("name", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Service.class.getDeclaredMethod("routingCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Service.class.getDeclaredMethod("connectionSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Service.class.getDeclaredMethod("proportionalDistributionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Service.class.getDeclaredMethod("buildDistributionTable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Service.class.getDeclaredMethod("gcd", Integer[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Service.class.getDeclaredMethod("borrowedCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Service.class.getDeclaredMethod("activeCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Service.class.getDeclaredMethod("markup", LoadBalancer.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Service.class.getDeclaredMethod("markup", FailoverDriver.Event.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Service.class.getDeclaredMethod("getAllMembers", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Service.class.getDeclaredMethod("getAllMembers", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Service.class.getDeclaredMethod("getAllMembers", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Service.class.getDeclaredMethod("getMember", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Service.class.getDeclaredMethod("getMember", String.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Service.class.getDeclaredMethod("insertMember", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Service.class.getDeclaredMethod("setContainerName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Service.class.getDeclaredMethod("containerName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Service.class.getDeclaredMethod("setName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Service.class.getDeclaredMethod("activeMembersCount", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Service.class.getDeclaredMethod("checkAndRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Service.class.getDeclaredMethod("awaitRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Service.class.getDeclaredMethod("onRegister", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        rand = new Random();
        interruptableActor = new InterruptableActor();
    }
}

