/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.Service;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.RingBuffer;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public class ServiceMember {
    public static final String NONAME_INSTANCE = "***noname***";
    public static final int ADVISED_LOAD_RING_SIZE = 6;
    public static final int PEAK_BORROW_RING_SIZE = 3;
    private Key memberKey = null;
    private final String name;
    private String database = null;
    private String serviceName = null;
    private String host = null;
    private AtomicInteger dbInstanceId = new AtomicInteger(0);
    private String dbUniqueId = null;
    public final Service serviceRef;
    public final AtomicInteger activeCount = new AtomicInteger(0);
    public final AtomicInteger borrowedCount = new AtomicInteger(0);
    final AtomicInteger pendingCloseCount = new AtomicInteger(0);
    private final AtomicBoolean active = new AtomicBoolean(true);
    final AtomicBoolean affined = new AtomicBoolean(true);
    final AtomicBoolean violating = new AtomicBoolean(false);
    private final AtomicInteger id = new AtomicInteger(-1);
    public final LoadBalancer.Stats lbStats = new LoadBalancer.Stats();
    private final AdvisedLoadHistory advisedLoadHistory = new AdvisedLoadHistory();
    private final RingBuffer<Integer> peakBorrowsHistory = new RingBuffer(3);
    final AtomicInteger connsToRebalance = new AtomicInteger(0);
    private boolean isRLBHistoryClean = true;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    public ServiceMember(Properties properties, Service service) {
        this(properties.getProperty("INSTANCE_NAME", NONAME_INSTANCE), properties.getProperty("DATABASE_NAME", ""), properties.getProperty("SERVER_HOST", ""), properties.getProperty("SERVICE_NAME", ""), properties.getProperty("AUTH_GLOBALLY_UNIQUE_DBID", ""), properties.getProperty("AUTH_SC_INSTANCE_ID", ""), service);
    }

    public ServiceMember(String string, String string2, String string3, String string4, Service service) {
        this(string, string2, string3, string4, null, "0", service);
    }

    private ServiceMember(String string, String string2, String string3, String string4, String string5, String string6, Service service) {
        this.name = null == string || "".equals(string) ? NONAME_INSTANCE : ServiceMember.toLowerCase(string);
        this.database = ServiceMember.toLowerCase(string2);
        this.host = ServiceMember.toLowerCase(string3);
        this.serviceName = ServiceMember.toLowerCase(string4);
        this.dbInstanceId.set(Integer.parseInt(string6.isEmpty() ? "0" : string6));
        this.serviceRef = service;
        this.dbUniqueId = string5;
        this.memberKey = new Key(this.name, this.database, this.host, this.serviceName);
    }

    public Key key() {
        return this.memberKey;
    }

    public boolean equals(Object object) {
        if (object instanceof ServiceMember) {
            return this.key().equals(((ServiceMember)object).key());
        }
        return false;
    }

    public int hashCode() {
        return this.key().hashCode();
    }

    public void saveAdvisedLoad(float f2) {
        this.advisedLoadHistory.addItem(Float.valueOf(f2));
        this.isRLBHistoryClean = false;
    }

    public void clearRLBHistory() {
        ClioSupport.ilogFinest(null, null, null, null, "Clearing RLB advised load and peak borrow history");
        this.isRLBHistoryClean = true;
        this.advisedLoadHistory.clear();
        this.peakBorrowsHistory.clear();
    }

    public void savePeakBorrows() {
        this.peakBorrowsHistory.addItem(this.lbStats.peakBorrows.delta());
        ClioSupport.ilogFinest(null, null, null, null, "peakBorrowHistory=" + this.peakBorrowsHistory.getAsList() + (this.peaked() ? ", " : ", un") + "peaked");
    }

    boolean isRLBHistoryClean() {
        return this.isRLBHistoryClean;
    }

    public float averageAdvisedLoad() {
        return this.advisedLoadHistory.averageAdvisedLoad();
    }

    float averageAdvisedLoad(ConnectionRetrievalInfo connectionRetrievalInfo, Collection<ServiceMember> collection) {
        if (connectionRetrievalInfo == null) {
            return this.averageAdvisedLoad();
        }
        float f2 = (float)collection.stream().mapToDouble(serviceMember -> serviceMember.averageAdvisedLoad()).sum();
        return this.averageAdvisedLoad() / f2 * 100.0f;
    }

    public boolean peaked() {
        List<Integer> list = this.peakBorrowsHistory.getAsList();
        int n2 = this.activeCount.get();
        int n3 = 0;
        if (!this.active.get()) {
            return false;
        }
        if (n2 == 0) {
            for (int n4 : list) {
                n3 += n4;
            }
            if (n3 == 0) {
                return false;
            }
        }
        boolean bl2 = true;
        for (int n5 : list) {
            if (n5 >= n2) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    void initId() {
        this.id.compareAndSet(-1, this.serviceRef.idCount.getAndIncrement());
    }

    public boolean active() {
        return this.active.get();
    }

    public void markActive(boolean bl2) {
        if (this.active.compareAndSet(!bl2, bl2)) {
            if (bl2) {
                this.serviceRef.activeMembers.getAndIncrement();
            } else {
                this.serviceRef.activeMembers.getAndDecrement();
            }
            ClioSupport.ilogFinest(null, null, null, null, "about to interrupt pending connection creation operations");
            this.serviceRef.interruptPendingCreations();
        }
    }

    @DisableTrace
    public String name() {
        return this.name;
    }

    @DisableTrace
    public String database() {
        return null == this.database ? "" : this.database;
    }

    @DisableTrace
    public String service() {
        return null == this.serviceName ? "" : this.serviceName;
    }

    @DisableTrace
    public String host() {
        return null == this.host ? "" : this.host;
    }

    @DisableTrace
    public String dbUniqueId() {
        return null == this.dbUniqueId ? "" : this.dbUniqueId;
    }

    @DisableTrace
    public int dbInstanceId() {
        return this.dbInstanceId.get();
    }

    @DisableTrace
    public void markAffined(boolean bl2) {
        this.affined.set(bl2);
    }

    @DisableTrace
    public boolean affined() {
        return this.affined.get();
    }

    @DisableTrace
    public boolean violating() {
        return this.violating.get();
    }

    @DisableTrace
    public void markViolating(boolean bl2) {
        this.violating.set(bl2);
    }

    @DisableTrace
    public int id() {
        return this.id.get();
    }

    @DisableTrace
    public String toString() {
        return this.name() + ",db=" + this.database() + ",service=" + this.service() + ",host=" + this.host() + ":(activeCount:" + this.activeCount.get() + ",borrowedCount:" + this.borrowedCount.get() + ",active:" + this.active.get() + ",aff=" + this.affined.get() + ",violating=" + this.violating.get() + ",id=" + this.id.get() + ')';
    }

    private static String toLowerCase(String string) {
        return null == string ? null : string.toLowerCase();
    }

    boolean violatingRLBAdvisory() {
        float f2;
        if (!this.active()) {
            return false;
        }
        if (this.advisedLoadHistory.isEmpty()) {
            return false;
        }
        float f3 = this.averageAdvisedLoad();
        long l2 = this.lbStats.borrowTimes.totalDelta();
        long l3 = this.serviceRef.lbStats.borrowTimes.totalDelta();
        float f4 = f2 = 0L != l3 ? (float)l2 * 100.0f / (float)l3 : 0.0f;
        return !(f2 <= f3);
    }

    public long totalBorrowTimes() {
        return this.lbStats.borrowTimes.totalDelta();
    }

    static {
        try {
            $$$methodRef$$$19 = ServiceMember.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, String.class, String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = ServiceMember.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = ServiceMember.class.getDeclaredConstructor(Properties.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = ServiceMember.class.getDeclaredMethod("lambda$averageAdvisedLoad$0", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = ServiceMember.class.getDeclaredMethod("totalBorrowTimes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = ServiceMember.class.getDeclaredMethod("violatingRLBAdvisory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = ServiceMember.class.getDeclaredMethod("toLowerCase", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = ServiceMember.class.getDeclaredMethod("markActive", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = ServiceMember.class.getDeclaredMethod("active", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = ServiceMember.class.getDeclaredMethod("initId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = ServiceMember.class.getDeclaredMethod("peaked", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = ServiceMember.class.getDeclaredMethod("averageAdvisedLoad", ConnectionRetrievalInfo.class, Collection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = ServiceMember.class.getDeclaredMethod("averageAdvisedLoad", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = ServiceMember.class.getDeclaredMethod("isRLBHistoryClean", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = ServiceMember.class.getDeclaredMethod("savePeakBorrows", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = ServiceMember.class.getDeclaredMethod("clearRLBHistory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = ServiceMember.class.getDeclaredMethod("saveAdvisedLoad", Float.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = ServiceMember.class.getDeclaredMethod("hashCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = ServiceMember.class.getDeclaredMethod("equals", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = ServiceMember.class.getDeclaredMethod("key", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }

    private class AdvisedLoadHistory {
        private RingBuffer<Float> history = new RingBuffer(6);
        private volatile float averageAdvisedLoad = 0.0f;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;

        private AdvisedLoadHistory() {
        }

        private void addItem(Float f2) {
            this.history.addItem(f2);
            this.computeAverageAdvisedLoad();
            ClioSupport.ilogFinest(null, null, null, null, "advisedLoadHistory=" + this.history.getAsList() + ", average=" + this.averageAdvisedLoad());
        }

        private void clear() {
            this.history.clear();
            this.computeAverageAdvisedLoad();
        }

        private void computeAverageAdvisedLoad() {
            List<Float> list = this.history.getAsList();
            if (list.isEmpty()) {
                int n2 = ServiceMember.this.serviceRef.activeMembers.get();
                this.averageAdvisedLoad = n2 == 0 ? 100.0f : 100.0f / (float)n2;
            }
            float f2 = 0.0f;
            for (float f3 : list) {
                f2 += f3;
            }
            this.averageAdvisedLoad = f2 / (float)list.size();
        }

        private float averageAdvisedLoad() {
            return this.averageAdvisedLoad;
        }

        private boolean isEmpty() {
            return this.history.getAsList().isEmpty();
        }

        static {
            try {
                $$$methodRef$$$10 = AdvisedLoadHistory.class.getDeclaredConstructor(ServiceMember.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = AdvisedLoadHistory.class.getDeclaredConstructor(ServiceMember.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = AdvisedLoadHistory.class.getDeclaredMethod("access$400", AdvisedLoadHistory.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = AdvisedLoadHistory.class.getDeclaredMethod("access$300", AdvisedLoadHistory.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = AdvisedLoadHistory.class.getDeclaredMethod("access$200", AdvisedLoadHistory.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = AdvisedLoadHistory.class.getDeclaredMethod("access$100", AdvisedLoadHistory.class, Float.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = AdvisedLoadHistory.class.getDeclaredMethod("isEmpty", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = AdvisedLoadHistory.class.getDeclaredMethod("averageAdvisedLoad", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = AdvisedLoadHistory.class.getDeclaredMethod("computeAverageAdvisedLoad", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = AdvisedLoadHistory.class.getDeclaredMethod("clear", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = AdvisedLoadHistory.class.getDeclaredMethod("addItem", Float.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }

    @DisableTrace
    static class Key {
        private final String key;

        Key(String string, String string2, String string3, String string4) {
            this.key = this.norm(string) + ':' + this.norm(string2) + ':' + this.norm(string4);
        }

        private String norm(String string) {
            return null != string ? string : "";
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.key.equals(key.key);
            }
            return false;
        }

        public String toString() {
            return this.key;
        }
    }
}

