/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.CriStatsRegistry;
import oracle.ucp.common.Database;
import oracle.ucp.common.FailoverDriver;
import oracle.ucp.common.Instantiator;
import oracle.ucp.common.Limits;
import oracle.ucp.common.LoadBalancer;
import oracle.ucp.common.ONSDriver;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.common.Service;
import oracle.ucp.common.ServiceMember;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.routing.DataDependentRoutingCache;
import oracle.ucp.routing.ShardRoutingCache;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
public abstract class Topology
extends Database {
    private final AtomicReference<ConnectionRetrievalInfo> defaultCri = new AtomicReference<Object>(null);
    private String defaultServiceName = null;
    private final Map<String, Service> services = new ConcurrentHashMap<String, Service>();
    private Service latestRegisteredService = null;
    private final AtomicReference<ONSDriver> onsDriver = new AtomicReference<Object>(null);
    private boolean onsStarted = false;
    private boolean isShardedDatabase = false;
    private boolean isCatalogDatabase = false;
    private boolean isMultitenantDatabase = false;
    private boolean isRacDataAffinityEnabled = false;
    private boolean isDataDependentRoutingEnabled = false;
    private String poolRegionName = null;
    private final AtomicBoolean fanHeuristicallyEnabled = new AtomicBoolean(false);
    protected boolean replayable = false;
    private final CriStatsRegistry criStatsRegistry = new CriStatsRegistry();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;

    Topology() {
    }

    protected abstract String getONSConfig() throws UniversalConnectionPoolException;

    protected abstract AtomicLong cumulativeConnectionUseTime();

    public abstract Limits limits();

    protected abstract boolean shardingMode();

    @Override
    public CoreConnection create(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, EnumSet<ConnectionSource.CreateMode> enumSet, long l2) throws UniversalConnectionPoolException {
        String string;
        Object object;
        if (connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo) {
            object = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
            string = this.serviceName((ConnectionRetrievalInfo)object);
        } else {
            string = this.defaultServiceName;
        }
        object = this.service(string);
        if (object == null) {
            throw new IllegalStateException("Service " + string + " is unknown or not registered in UCP");
        }
        CoreConnection coreConnection = ((Service)object).create(connectionRetrievalInfo, connectionAffinityCallback, enumSet, l2);
        if (null == coreConnection) {
            return null;
        }
        if (!string.equalsIgnoreCase(coreConnection.serviceName())) {
            throw new IllegalArgumentException("Non existent or Unknown Service: " + string);
        }
        return coreConnection;
    }

    private String logicalServiceName(String string) {
        if (string == null) {
            return null;
        }
        if (!string.contains("%")) {
            return string;
        }
        return string.substring(string.indexOf(37) + 1);
    }

    private String extractRegionName(String string) {
        if (string == null || !string.contains("%")) {
            return null;
        }
        return string.substring(0, string.indexOf(37));
    }

    private String prefixRegionName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.poolRegionName == null ? "" : this.poolRegionName + "%";
        return string2 + this.logicalServiceName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        Util.disableImplicitBeginRequest();
        UniversalPooledConnection universalPooledConnection = null;
        try {
            universalPooledConnection = this.createPooledConnection(connectionRetrievalInfo);
            if (!(universalPooledConnection instanceof UniversalPooledConnectionImpl)) {
                this.defaultCri.compareAndSet(null, connectionRetrievalInfo);
                return;
            }
            UniversalPooledConnectionImpl universalPooledConnectionImpl = (UniversalPooledConnectionImpl)universalPooledConnection;
            this.defaultServiceName = this.logicalServiceName(universalPooledConnectionImpl.getService());
            ConnectionRetrievalInfo connectionRetrievalInfo2 = connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo ? ((JDBCConnectionRetrievalInfo)connectionRetrievalInfo).getCopyWithService(this.defaultServiceName) : connectionRetrievalInfo.getCopyWithNoLabels();
            this.defaultCri.compareAndSet(null, connectionRetrievalInfo2);
            if (!(universalPooledConnection instanceof OracleUniversalPooledConnection)) {
                return;
            }
            OracleUniversalPooledConnection oracleUniversalPooledConnection = (OracleUniversalPooledConnection)universalPooledConnection;
            boolean[] blArray = oracleUniversalPooledConnection.getShardingMode();
            this.isShardedDatabase = blArray[0];
            if (this.isShardedDatabase && !this.shardingMode()) {
                this.isShardedDatabase = false;
            }
            this.isCatalogDatabase = blArray[1];
            this.isMultitenantDatabase = oracleUniversalPooledConnection.isMultitenantDatabase();
            this.isRacDataAffinityEnabled = oracleUniversalPooledConnection.isRacDataAffinityEnabled();
            this.isDataDependentRoutingEnabled = this.isShardedDatabase | this.isRacDataAffinityEnabled;
            this.poolRegionName = this.extractRegionName(universalPooledConnectionImpl.getService());
            this.enableFANHeuristically(oracleUniversalPooledConnection);
            if (this.failoverEnabled()) {
                Util.disableDriverHA();
            }
        }
        finally {
            if (universalPooledConnection != null) {
                this.connectionsCreated().decrementAndGet();
                ((UniversalPooledConnectionImpl)universalPooledConnection).closeNoStatsUpdate();
            }
        }
    }

    @Override
    public void stop() {
        if (null != this.onsDriver.getAndSet(null)) {
            this.onsStarted = false;
            this.services.forEach((string, service) -> {
                service.stop();
                service.routingCache().destroy();
            });
            this.defaultCri.set(null);
        }
        this.services.clear();
        this.fanHeuristicallyEnabled.set(false);
    }

    @Override
    public boolean isReplayable() {
        return this.replayable;
    }

    @Override
    public void setReplayable(boolean bl2) {
        this.replayable = bl2;
    }

    @Override
    public LoadBalancer.Stats loadBalancerStats(String string) {
        Object object;
        if (string == null) {
            if (this.defaultCri() instanceof JDBCConnectionRetrievalInfo) {
                object = (JDBCConnectionRetrievalInfo)this.defaultCri();
                string = ((JDBCConnectionRetrievalInfo)object).getServiceName();
            } else {
                string = this.defaultServiceName();
            }
        }
        if ((object = this.service(string)) != null) {
            return this.service(string).loadBalancerStats();
        }
        return new LoadBalancer.Stats();
    }

    @Override
    public FailoverDriver.Stats failoverDriverStats(String string) {
        Object object;
        if (string == null) {
            if (this.defaultCri() instanceof JDBCConnectionRetrievalInfo) {
                object = (JDBCConnectionRetrievalInfo)this.defaultCri();
                string = ((JDBCConnectionRetrievalInfo)object).getServiceName();
            } else {
                string = this.defaultServiceName();
            }
        }
        if ((object = this.service(string)) != null) {
            return this.service(string).failoverDriverStats();
        }
        return new FailoverDriver.Stats();
    }

    @Override
    public Selector loadBalancedBorrowSelector(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback) {
        return this.service(this.serviceName(connectionRetrievalInfo)).loadBalancedBorrowSelector(connectionRetrievalInfo, connectionAffinityCallback);
    }

    @Override
    public Selector routingKeyBasedBorrowSelector(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl2) {
        if (this.isDataDependentRoutingEnabled) {
            final DataDependentRoutingCache dataDependentRoutingCache = this.service(this.serviceName(connectionRetrievalInfo)).routingCache();
            if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
                return Selectors.EVERY;
            }
            JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
            OracleShardingKey oracleShardingKey = jDBCConnectionRetrievalInfo.getShardingKey();
            if (oracleShardingKey == null) {
                return Selectors.EVERY;
            }
            final HashSet<ServiceMember> hashSet = new HashSet<ServiceMember>();
            if (bl2) {
                hashSet.addAll(dataDependentRoutingCache.allPriorityInstances(connectionRetrievalInfo));
            } else {
                hashSet.addAll(dataDependentRoutingCache.allInstances(connectionRetrievalInfo));
            }
            return new Selector(){
                private static Executable $$$methodRef$$$0;
                private static Logger $$$loggerRef$$$0;
                private static Executable $$$methodRef$$$1;
                private static Logger $$$loggerRef$$$1;

                @Override
                public boolean selected(CoreConnection coreConnection) {
                    return dataDependentRoutingCache.selected(coreConnection, hashSet);
                }

                static {
                    try {
                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(Topology.class, DataDependentRoutingCache.class, Set.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    try {
                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("selected", CoreConnection.class);
                    }
                    catch (Throwable throwable) {}
                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                }
            };
        }
        return Selectors.EVERY;
    }

    @Override
    public String shardConnectionStats(String string) {
        if (!this.isShardedDatabase || !this.isServiceRegistered(string)) {
            return "";
        }
        return ((ShardRoutingCache)this.service(string).routingCache()).shardConnectionStats();
    }

    @Override
    public String serviceName(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return this.defaultServiceName();
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        String string = jDBCConnectionRetrievalInfo.getServiceName();
        return this.poolRegionName == null ? string : this.prefixRegionName(string);
    }

    @Override
    public ConnectionRetrievalInfo defaultCri() {
        return this.defaultCri.get();
    }

    @Override
    public String defaultServiceName() {
        return this.defaultServiceName;
    }

    public ONSDriver onsDriver(String string) throws UniversalConnectionPoolException {
        if (this.onsDriver.compareAndSet(null, ONSDriver.instance())) {
            ONSDriver oNSDriver = this.onsDriver.get();
            this.onsStarted = oNSDriver.start(string);
        }
        if (this.onsStarted) {
            return this.onsDriver.get();
        }
        return null;
    }

    public Service service(String string) {
        if (this.poolRegionName != null) {
            string = this.prefixRegionName(string);
        }
        if (1 == this.services.size() && null != this.latestRegisteredService && this.latestRegisteredService.name().equals(string)) {
            return this.latestRegisteredService;
        }
        return this.services.get(string);
    }

    @Override
    public void registerService(Instantiator instantiator, String string, ConnectionSource.FailoverCallback failoverCallback, ConnectionSource.RebalanceCallback rebalanceCallback) {
        Service service = this.service(string);
        if (service == null) {
            boolean bl2;
            Service service2;
            this.latestRegisteredService = service2 = new Service(instantiator, this, string);
            boolean bl3 = bl2 = this.services.putIfAbsent(string, service2) == null;
            if (bl2) {
                service2.registerFailoverCallback(failoverCallback);
                service2.registerRebalanceCallback(rebalanceCallback);
            }
        }
    }

    @Override
    public boolean isServiceRegistered(String string) {
        return this.service(string) != null;
    }

    @Override
    public boolean isShardedDatabase() {
        return this.isShardedDatabase;
    }

    @Override
    public boolean isCatalogDatabase() {
        return this.isCatalogDatabase;
    }

    @Override
    public boolean isMultitenantDatabase() {
        return this.isMultitenantDatabase;
    }

    @Override
    public boolean isRacDataAffinityEnabled() {
        return this.isRacDataAffinityEnabled;
    }

    public boolean isDataDependentRoutingEnabled() {
        return this.isDataDependentRoutingEnabled;
    }

    @Override
    public boolean validateCri(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            return true;
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        if (!this.isServiceRegistered(jDBCConnectionRetrievalInfo.getServiceName())) {
            return false;
        }
        if (this.isDataDependentRoutingEnabled) {
            return this.service(this.serviceName(connectionRetrievalInfo)).routingCache().validateCri(jDBCConnectionRetrievalInfo);
        }
        return true;
    }

    @Override
    public boolean available(ConnectionRetrievalInfo connectionRetrievalInfo) {
        String string = this.serviceName(connectionRetrievalInfo);
        if (!this.isServiceRegistered(string)) {
            return false;
        }
        return this.totalCount(connectionRetrievalInfo).get() - this.borrowedCount(connectionRetrievalInfo).get() > 0;
    }

    @Override
    public Selector serviceBasedRepurposeSelector(ConnectionRetrievalInfo connectionRetrievalInfo, boolean bl2) {
        String string = this.serviceName(connectionRetrievalInfo);
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo) || !this.isServiceRegistered(string)) {
            return Selectors.NONE;
        }
        return this.service(string).serviceBasedRepurposeSelector(connectionRetrievalInfo, bl2);
    }

    String getDatabaseTopologyInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SERVICES: \n" + this.services.values().stream().map(service -> service.toString()).collect(Collectors.joining("\n")));
        for (Service service2 : this.services.values()) {
            stringBuffer.append("\nService " + service2.name() + " - INSTANCES:\n" + service2.getAllMembers().stream().map(serviceMember -> serviceMember.name()).collect(Collectors.joining("\n")));
        }
        return stringBuffer.toString();
    }

    String getShardedDatabaseInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDataDependentRoutingEnabled && this.isServiceRegistered(this.defaultServiceName)) {
            stringBuffer.append(this.service(this.defaultServiceName).routingCache().metadataInfo());
        } else {
            stringBuffer.append("Data dependent Routing metadata not populated or not connected to a sharded database");
        }
        return stringBuffer.toString();
    }

    String getShardRoutingCacheInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDataDependentRoutingEnabled && this.isServiceRegistered(this.defaultServiceName)) {
            stringBuffer.append(this.service(this.defaultServiceName).routingCache().cacheEntries());
        } else {
            stringBuffer.append("Shard routing cache not populated or not connected to a sharded database");
        }
        return stringBuffer.toString();
    }

    private void enableFANHeuristically(OracleUniversalPooledConnection oracleUniversalPooledConnection) {
        OracleConnection oracleConnection = null;
        try {
            Connection connection = oracleUniversalPooledConnection.getSQLConnection(oracleUniversalPooledConnection.getPhysicalConnection());
            if (connection instanceof OracleConnection) {
                oracleConnection = (OracleConnection)connection;
            }
        }
        catch (Exception exception) {
            oracleConnection = null;
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        if (oracleConnection == null) {
            return;
        }
        boolean bl2 = true;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class.forName("oracle.ons.ONS", false, classLoader);
        }
        catch (Throwable throwable) {
            bl2 = false;
            ClioSupport.ilogFine(null, null, null, null, "ons.jar is not on the classpath, FAN is disabled, " + throwable);
        }
        if (bl2) {
            ClioSupport.ilogFine(null, null, null, null, "Heuristically determine whether to enable FAN");
            try {
                short s2 = oracleConnection.getVersionNumber();
                if (s2 < 12101) {
                    bl2 = false;
                    ClioSupport.ilogFine(null, null, null, null, "Pre-12c DB, FAN is heuristically disabled");
                } else {
                    Properties properties = oracleConnection.getServerSessionInfo();
                    String string = properties.getProperty("AUTH_ONS_CONFIG");
                    if (string == null) {
                        bl2 = false;
                        ClioSupport.ilogFine(null, null, null, null, "Single-instance 12.x DB, FAN is heuristically disabled");
                    } else {
                        bl2 = true;
                        ClioSupport.ilogFine(null, null, null, null, "RAC/GDS 12.x, FAN is heuristically enabled");
                    }
                }
            }
            catch (Throwable throwable) {
                bl2 = false;
                ClioSupport.ilogFine(null, null, null, null, "Internal error happened, FAN is heuristically disabled, " + throwable);
            }
        }
        this.fanHeuristicallyEnabled.set(bl2);
    }

    protected boolean isFANHeuristicallyEnabled() {
        return this.fanHeuristicallyEnabled.get();
    }

    @Override
    public Counter totalCount(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.criStatsRegistry.getCriStats(connectionRetrievalInfo).totalConnCount();
    }

    @Override
    public Counter borrowedCount(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.criStatsRegistry.getCriStats(connectionRetrievalInfo).borrowedConnCount();
    }

    @Override
    public Semaphore getBorrowSemaphore(ConnectionRetrievalInfo connectionRetrievalInfo) {
        return this.criStatsRegistry.getCriStats(connectionRetrievalInfo).getBorrowSemaphore();
    }

    static {
        try {
            $$$methodRef$$$49 = Topology.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = Topology.class.getDeclaredMethod("lambda$stop$0", String.class, Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = Topology.class.getDeclaredMethod("lambda$getDatabaseTopologyInfo$1", Service.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = Topology.class.getDeclaredMethod("lambda$getDatabaseTopologyInfo$2", ServiceMember.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = Topology.class.getDeclaredMethod("costComparator", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = Topology.class.getDeclaredMethod("perfectCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = Topology.class.getDeclaredMethod("physicalConnectionSelector", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = Topology.class.getDeclaredMethod("wrongCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = Topology.class.getDeclaredMethod("matchingCriSelector", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = Topology.class.getDeclaredMethod("availableConnectionsSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = Topology.class.getDeclaredMethod("harvestableConnectionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = Topology.class.getDeclaredMethod("inactiveConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = Topology.class.getDeclaredMethod("abandonedConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = Topology.class.getDeclaredMethod("ttlConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = Topology.class.getDeclaredMethod("getBorrowSemaphore", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = Topology.class.getDeclaredMethod("borrowedCount", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = Topology.class.getDeclaredMethod("totalCount", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = Topology.class.getDeclaredMethod("isFANHeuristicallyEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = Topology.class.getDeclaredMethod("enableFANHeuristically", OracleUniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = Topology.class.getDeclaredMethod("getShardRoutingCacheInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = Topology.class.getDeclaredMethod("getShardedDatabaseInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = Topology.class.getDeclaredMethod("getDatabaseTopologyInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = Topology.class.getDeclaredMethod("serviceBasedRepurposeSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = Topology.class.getDeclaredMethod("available", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = Topology.class.getDeclaredMethod("validateCri", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = Topology.class.getDeclaredMethod("isDataDependentRoutingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = Topology.class.getDeclaredMethod("isRacDataAffinityEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = Topology.class.getDeclaredMethod("isMultitenantDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = Topology.class.getDeclaredMethod("isCatalogDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = Topology.class.getDeclaredMethod("isShardedDatabase", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = Topology.class.getDeclaredMethod("isServiceRegistered", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = Topology.class.getDeclaredMethod("registerService", Instantiator.class, String.class, ConnectionSource.FailoverCallback.class, ConnectionSource.RebalanceCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = Topology.class.getDeclaredMethod("service", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = Topology.class.getDeclaredMethod("onsDriver", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = Topology.class.getDeclaredMethod("defaultServiceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = Topology.class.getDeclaredMethod("defaultCri", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = Topology.class.getDeclaredMethod("serviceName", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = Topology.class.getDeclaredMethod("shardConnectionStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = Topology.class.getDeclaredMethod("routingKeyBasedBorrowSelector", ConnectionRetrievalInfo.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = Topology.class.getDeclaredMethod("loadBalancedBorrowSelector", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = Topology.class.getDeclaredMethod("failoverDriverStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = Topology.class.getDeclaredMethod("loadBalancerStats", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = Topology.class.getDeclaredMethod("setReplayable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = Topology.class.getDeclaredMethod("isReplayable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = Topology.class.getDeclaredMethod("stop", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = Topology.class.getDeclaredMethod("start", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = Topology.class.getDeclaredMethod("prefixRegionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = Topology.class.getDeclaredMethod("extractRegionName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = Topology.class.getDeclaredMethod("logicalServiceName", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = Topology.class.getDeclaredMethod("create", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, EnumSet.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }
}

