/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionAffinityCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalConnectionPoolStatistics;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.common.UniversalConnectionPoolStatisticsImpl;
import oracle.ucp.common.UniversalPooledConnectionImpl;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.runtime.TraceControllerImpl;
import oracle.ucp.tuners.PoolSizeTuner;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public class UniversalConnectionPoolImpl
extends UniversalConnectionPoolBase {
    public final UniversalConnectionPoolInternal m_ucpInternal = new UniversalConnectionPoolInternal(this);
    private boolean isNoWaitBorrow = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;

    public UniversalConnectionPoolImpl(ConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        Object object;
        boolean bl2;
        boolean bl3 = bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(203);
        }
        PoolSizeTuner.trigger();
        if (connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo && ((JDBCConnectionRetrievalInfo)(object = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo)).getServiceName() == null) {
            connectionRetrievalInfo = ((JDBCConnectionRetrievalInfo)object).getCopyWithService(this.getServiceName());
        }
        object = null;
        this.m_pendingRequestsCount.incrementAndGet();
        try {
            object = this.borrowConnectionAndValidate(connectionRetrievalInfo);
            this.borrowedAccumulator.addAndGet(this.getBorrowedConnectionsCount());
            this.borrowedSamples.incrementAndGet();
            if (object != null) {
                ((UniversalPooledConnectionImpl)object).setBorrowCRI(connectionRetrievalInfo);
            }
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            if (bl2) {
                this.ilogThrowing($$$loggerRef$$$0, UniversalConnectionPoolImpl.class, $$$methodRef$$$0, this, universalConnectionPoolException);
            }
            throw universalConnectionPoolException;
        }
        finally {
            this.m_pendingRequestsCount.decrementAndGet();
        }
        return object;
    }

    private UniversalPooledConnection borrowConnectionAndValidate(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        long l2;
        int n2;
        boolean bl2 = this.getValidateConnectionOnBorrow();
        if (!bl2) {
            return this.borrowConnectionWithoutCountingRequests(connectionRetrievalInfo);
        }
        UniversalPooledConnection universalPooledConnection = null;
        while (!(null == (universalPooledConnection = this.borrowConnectionWithoutCountingRequests(connectionRetrievalInfo)) || (n2 = this.getSecondsToTrustIdleConnection()) > 0 && (l2 = Clock.clock() - universalPooledConnection.getLastNetworkAccessTime()) < (long)n2 * 1000L || universalPooledConnection.isValid())) {
            universalPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
            universalPooledConnection.setLastConnectionValidationTime(0L);
            this.returnConnection(universalPooledConnection);
            universalPooledConnection = null;
        }
        if (null == universalPooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(56);
        }
        return universalPooledConnection;
    }

    protected void setNoWaitBorrow(boolean bl2) {
        boolean bl3 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.isNoWaitBorrow = bl2;
        if (bl3) {
            this.ilogFinest($$$loggerRef$$$2, UniversalConnectionPoolImpl.class, $$$methodRef$$$2, this, "isNoWaitBorrow=" + bl2);
        }
    }

    protected long computeBorrowGiveUpTimestamp() {
        return Clock.clock() + (this.isNoWaitBorrow ? 0L : (long)this.getConnectionWaitTimeout() * 1000L);
    }

    protected boolean isStillOkayToBorrow(long l2) {
        return Clock.clock() <= l2 || this.core.pendingAvailableGrows() > 0;
    }

    private UniversalPooledConnection borrowConnectionWithoutCountingRequests(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        UniversalPooledConnection universalPooledConnection;
        assert (connectionRetrievalInfo != null);
        Properties properties = connectionRetrievalInfo.getLabels();
        if (properties != null && this.getConnectionLabelingCallback() == null) {
            UCPErrorHandler.throwUniversalConnectionPoolException(92);
        }
        long l2 = Clock.clock();
        long l3 = this.computeBorrowGiveUpTimestamp();
        int n2 = 5;
        int n3 = 0;
        while (this.isStillOkayToBorrow(l3)) {
            if (!this.isLifecycleRunning()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
            this.validatePoolSizes();
            if (this.core.uselessConnsCleanerInProgress() || 0 == this.getAvailableConnectionsCount() || !this.core.available(connectionRetrievalInfo)) {
                universalPooledConnection = this.helpGrowBorrowed(connectionRetrievalInfo, this.getConnectionAffinityCallback(), l3 - Clock.clock());
                if (null != universalPooledConnection) {
                    return this.postBorrow(universalPooledConnection, l2, properties);
                }
                if (this.isNoWaitBorrow) {
                    return null;
                }
            }
            if (0 == ++n3 % 5) {
                Thread.yield();
            }
            if ((universalPooledConnection = this.getAvailableConnection(connectionRetrievalInfo, l3 - Clock.clock())) != null) {
                return this.postBorrow(universalPooledConnection, l2);
            }
            ConnectionAffinityCallback connectionAffinityCallback = this.getConnectionAffinityCallback();
            if (null == connectionAffinityCallback || null == connectionAffinityCallback.getConnectionAffinityContext()) continue;
            connectionAffinityCallback.setConnectionAffinityContext(null);
        }
        universalPooledConnection = this.getAvailableConnection(connectionRetrievalInfo, 0L);
        if (null != universalPooledConnection) {
            return this.postBorrow(universalPooledConnection, l2);
        }
        universalPooledConnection = this.helpGrowBorrowed(connectionRetrievalInfo, this.getConnectionAffinityCallback(), l3 - Clock.clock());
        if (null != universalPooledConnection) {
            return this.postBorrow(universalPooledConnection, l2, properties);
        }
        this.updateConnectionWaitCounters(false, l2);
        if (this.isNoWaitBorrow) {
            return null;
        }
        if (this.core.noMoreGrows()) {
            UCPErrorHandler.throwUniversalConnectionPoolException(65);
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(64);
        }
        return null;
    }

    private UniversalPooledConnection helpGrowBorrowed(ConnectionRetrievalInfo connectionRetrievalInfo, ConnectionAffinityCallback connectionAffinityCallback, long l2) throws UniversalConnectionPoolException {
        long l3 = Clock.clock();
        CoreConnection coreConnection = this.core.growBorrowed(connectionRetrievalInfo, connectionAffinityCallback, l2);
        this.insertToCreatedHistogram(connectionRetrievalInfo, Clock.clock() - l3);
        return null == coreConnection ? null : (UniversalPooledConnection)coreConnection.getDelegate();
    }

    private UniversalPooledConnection postBorrow(UniversalPooledConnection universalPooledConnection, long l2, Properties properties) {
        if (null == universalPooledConnection) {
            throw new IllegalArgumentException("no upc");
        }
        if (null != properties) {
            this.getConnectionLabelingCallback().configure(properties, this.getConnectionObjectForLabelingConfigure(universalPooledConnection));
        }
        universalPooledConnection.setBorrowedStartTime();
        universalPooledConnection.heartbeat();
        this.updateConnectionWaitCounters(true, l2);
        return universalPooledConnection;
    }

    private UniversalPooledConnection postBorrow(UniversalPooledConnection universalPooledConnection, long l2) {
        return this.postBorrow(universalPooledConnection, l2, null);
    }

    protected UniversalPooledConnection createOnePooledConnection() {
        boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        UniversalPooledConnection universalPooledConnection = null;
        try {
            ConnectionRetrievalInfo connectionRetrievalInfo = this.getConnectionRetrievalInfo();
            if (null == connectionRetrievalInfo) {
                UCPErrorHandler.throwUniversalConnectionPoolException(4);
            }
            universalPooledConnection = this.createOnePooledConnection(connectionRetrievalInfo);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            if (bl2) {
                this.ilogThrowing($$$loggerRef$$$9, UniversalConnectionPoolImpl.class, $$$methodRef$$$9, this, universalConnectionPoolException);
            }
            universalPooledConnection = null;
        }
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$9, UniversalConnectionPoolImpl.class, $$$methodRef$$$9, this, "upc=" + universalPooledConnection);
        }
        return universalPooledConnection;
    }

    private void updateConnectionWaitCounters(boolean bl2, long l2) {
        long l3 = Clock.clock() - l2;
        (bl2 ? this.m_cumulativeSuccessfulConnectionWaitCount : this.m_cumulativeFailedConnectionWaitCount).incrementAndGet();
        (bl2 ? this.m_cumulativeSuccessfulConnectionWaitTime : this.m_cumulativeFailedConnectionWaitTime).addAndGet(l3);
        this.m_peakConnectionWaitTime.update(l3);
    }

    @Override
    public UniversalPooledConnection createOnePooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.createOnePooledConnectionInternal(connectionRetrievalInfo);
    }

    @Override
    public void returnConnection(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        if (null == universalPooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        if (this.m_lifeCycleState.get() != UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING) {
            UCPErrorHandler.throwUniversalConnectionPoolException(60);
        }
        if (universalPooledConnection.isAvailable()) {
            return;
        }
        this.core.reclaim(universalPooledConnection.getDelegator());
    }

    @Override
    public void closeConnection(UniversalPooledConnection universalPooledConnection) throws UniversalConnectionPoolException {
        boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        if (null == universalPooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        this.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - universalPooledConnection.getBorrowedStartTime());
        if (UniversalPooledConnectionStatus.STATUS_RECONNECTING == universalPooledConnection.getStatus()) {
            Object var2_3 = null;
        } else {
            this.closePooledConnection(universalPooledConnection);
        }
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$13, UniversalConnectionPoolImpl.class, $$$methodRef$$$13, this, "pooledConnection=" + universalPooledConnection);
        }
    }

    protected void closePooledConnection(UniversalPooledConnection universalPooledConnection) {
        CoreConnection coreConnection = universalPooledConnection.getDelegator();
        if (this.core.retrieve(coreConnection)) {
            coreConnection.abort();
            coreConnection.close();
        }
    }

    @Override
    public void purge() throws UniversalConnectionPoolException {
        boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        this.core.closeAll();
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$15, UniversalConnectionPoolImpl.class, $$$methodRef$$$15, this, "purge");
        }
    }

    @Override
    public void refresh() throws UniversalConnectionPoolException {
        boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        this.core.replaceAvailable();
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$16, UniversalConnectionPoolImpl.class, $$$methodRef$$$16, this, "regresh");
        }
    }

    @Override
    public void recycle() throws UniversalConnectionPoolException {
        boolean bl2 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
        this.m_ucpInternal.checkLifecycle();
        this.core.replaceInvalidAvailable();
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$17, UniversalConnectionPoolImpl.class, $$$methodRef$$$17, this, "recycle");
        }
    }

    @Override
    void processConnectionHarvesting() {
        this.core.harvest(this.getConnectionHarvestTriggerCount(), this.getConnectionHarvestMaxCount());
    }

    @Override
    protected void setConnectionHarvestable(UniversalPooledConnection universalPooledConnection, boolean bl2) {
        block3: {
            boolean bl3 = (0x6000000000000L & TraceControllerImpl.feature) != 0L;
            try {
                universalPooledConnection.setConnectionHarvestable(bl2);
                if (bl3) {
                    this.ilogFinest($$$loggerRef$$$19, UniversalConnectionPoolImpl.class, $$$methodRef$$$19, this, "isConnectionHarvestable=" + bl2);
                }
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                if (!bl3) break block3;
                this.ilogThrowing($$$loggerRef$$$19, UniversalConnectionPoolImpl.class, $$$methodRef$$$19, this, universalConnectionPoolException);
            }
        }
    }

    @Override
    protected void closePhysicalConnection(Object object) {
        super.closePhysicalConnection(object);
    }

    @Override
    public UniversalConnectionPoolStatistics getStatistics() {
        return new UniversalConnectionPoolStatisticsImpl(this);
    }

    @Override
    protected void discardUsedConnection(Object object) {
        this.m_ucpInternal.discardUsedConnectionInternal(object);
    }

    @Override
    protected UniversalPooledConnection getUsedConnection(Object object) {
        return this.m_ucpInternal.getUsedConnectionInternal(object);
    }

    @Override
    protected boolean returnUsedPhysicalConnection(Object object) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.returnUsedPhysicalConnectionInternal(object);
    }

    @Override
    protected boolean closeUsedPhysicalConnection(Object object) throws UniversalConnectionPoolException {
        return this.m_ucpInternal.closeUsedPhysicalConnectionInternal(object);
    }

    protected UniversalPooledConnection getAvailableConnection(ConnectionRetrievalInfo connectionRetrievalInfo, long l2) throws UniversalConnectionPoolException {
        assert (connectionRetrievalInfo != null);
        Properties properties = connectionRetrievalInfo.getLabels();
        boolean bl2 = properties != null;
        UniversalPooledConnection universalPooledConnection = this.getAvailableConnectionHelper(connectionRetrievalInfo, null, l2);
        if (bl2 && universalPooledConnection == null) {
            universalPooledConnection = this.getAvailableConnectionHelper(connectionRetrievalInfo.getCopyWithNoLabels(), connectionRetrievalInfo.getLabels(), l2);
        }
        return universalPooledConnection;
    }

    private UniversalPooledConnection getAvailableConnectionHelper(ConnectionRetrievalInfo connectionRetrievalInfo, Properties properties, long l2) throws UniversalConnectionPoolException {
        Properties properties2;
        if (null == connectionRetrievalInfo) {
            throw new IllegalArgumentException("cri is null");
        }
        Properties properties3 = connectionRetrievalInfo.getLabels();
        boolean bl2 = properties3 != null || properties != null;
        CoreConnection coreConnection = this.core.borrow(connectionRetrievalInfo, this.getConnectionAffinityCallback(), l2);
        UniversalPooledConnection universalPooledConnection = null == coreConnection ? null : (UniversalPooledConnection)coreConnection.getDelegate();
        Properties properties4 = properties2 = properties3 != null ? properties3 : properties;
        if (universalPooledConnection != null && (bl2 && (this.needToConfigureConnection(universalPooledConnection, properties2) || universalPooledConnection.labelingCost(properties2) > 0) || null != properties)) {
            this.getConnectionLabelingCallback().configure(properties2, this.getConnectionObjectForLabelingConfigure(universalPooledConnection));
        }
        return universalPooledConnection;
    }

    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection universalPooledConnection) {
        return universalPooledConnection.getPhysicalConnection();
    }

    protected void incrementCumulativeConnectionsCreated() {
        this.m_cumulativeConnectionsCreated.incrementAndGet();
    }

    protected boolean needToConfigureConnection(UniversalPooledConnection universalPooledConnection, Properties properties) throws UniversalConnectionPoolException {
        return false;
    }

    protected boolean isAffinityStrict() {
        return false;
    }

    static {
        try {
            $$$methodRef$$$32 = UniversalConnectionPoolImpl.class.getDeclaredConstructor(ConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = UniversalConnectionPoolImpl.class.getDeclaredMethod("isAffinityStrict", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = UniversalConnectionPoolImpl.class.getDeclaredMethod("needToConfigureConnection", UniversalPooledConnection.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = UniversalConnectionPoolImpl.class.getDeclaredMethod("incrementCumulativeConnectionsCreated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getConnectionObjectForLabelingConfigure", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getAvailableConnectionHelper", ConnectionRetrievalInfo.class, Properties.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getAvailableConnection", ConnectionRetrievalInfo.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closeUsedPhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = UniversalConnectionPoolImpl.class.getDeclaredMethod("returnUsedPhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getUsedConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = UniversalConnectionPoolImpl.class.getDeclaredMethod("discardUsedConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = UniversalConnectionPoolImpl.class.getDeclaredMethod("getStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closePhysicalConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = UniversalConnectionPoolImpl.class.getDeclaredMethod("setConnectionHarvestable", UniversalPooledConnection.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = UniversalConnectionPoolImpl.class.getDeclaredMethod("processConnectionHarvesting", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = UniversalConnectionPoolImpl.class.getDeclaredMethod("recycle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = UniversalConnectionPoolImpl.class.getDeclaredMethod("refresh", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = UniversalConnectionPoolImpl.class.getDeclaredMethod("purge", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closePooledConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = UniversalConnectionPoolImpl.class.getDeclaredMethod("closeConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = UniversalConnectionPoolImpl.class.getDeclaredMethod("returnConnection", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = UniversalConnectionPoolImpl.class.getDeclaredMethod("createOnePooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = UniversalConnectionPoolImpl.class.getDeclaredMethod("updateConnectionWaitCounters", Boolean.TYPE, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = UniversalConnectionPoolImpl.class.getDeclaredMethod("createOnePooledConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = UniversalConnectionPoolImpl.class.getDeclaredMethod("postBorrow", UniversalPooledConnection.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = UniversalConnectionPoolImpl.class.getDeclaredMethod("postBorrow", UniversalPooledConnection.class, Long.TYPE, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = UniversalConnectionPoolImpl.class.getDeclaredMethod("helpGrowBorrowed", ConnectionRetrievalInfo.class, ConnectionAffinityCallback.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionWithoutCountingRequests", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = UniversalConnectionPoolImpl.class.getDeclaredMethod("isStillOkayToBorrow", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = UniversalConnectionPoolImpl.class.getDeclaredMethod("computeBorrowGiveUpTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = UniversalConnectionPoolImpl.class.getDeclaredMethod("setNoWaitBorrow", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnectionAndValidate", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = UniversalConnectionPoolImpl.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }

    private static final class UniversalConnectionPoolInternal {
        private final UniversalConnectionPoolImpl m_cp;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;
        private static Executable $$$methodRef$$$3;
        private static Logger $$$loggerRef$$$3;
        private static Executable $$$methodRef$$$4;
        private static Logger $$$loggerRef$$$4;
        private static Executable $$$methodRef$$$5;
        private static Logger $$$loggerRef$$$5;
        private static Executable $$$methodRef$$$6;
        private static Logger $$$loggerRef$$$6;
        private static Executable $$$methodRef$$$7;
        private static Logger $$$loggerRef$$$7;
        private static Executable $$$methodRef$$$8;
        private static Logger $$$loggerRef$$$8;
        private static Executable $$$methodRef$$$9;
        private static Logger $$$loggerRef$$$9;
        private static Executable $$$methodRef$$$10;
        private static Logger $$$loggerRef$$$10;
        private static Executable $$$methodRef$$$11;
        private static Logger $$$loggerRef$$$11;
        private static Executable $$$methodRef$$$12;
        private static Logger $$$loggerRef$$$12;
        private static Executable $$$methodRef$$$13;
        private static Logger $$$loggerRef$$$13;

        private UniversalConnectionPoolInternal(UniversalConnectionPoolImpl universalConnectionPoolImpl) throws UniversalConnectionPoolException {
            assert (null != universalConnectionPoolImpl);
            this.m_cp = universalConnectionPoolImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private UniversalPooledConnection createOnePooledConnectionInternal(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
            assert (connectionRetrievalInfo != null);
            this.checkLifecycle();
            Object object = null;
            UniversalPooledConnection universalPooledConnection = null;
            try {
                ConnectionFactoryAdapter connectionFactoryAdapter = this.m_cp.getConnectionFactoryAdapter();
                object = connectionFactoryAdapter.createConnection(connectionRetrievalInfo);
                if (null == object) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(100);
                }
                universalPooledConnection = connectionFactoryAdapter.createPooledConnection(object, connectionRetrievalInfo.getCopyWithNoLabels());
                this.m_cp.incrementConnectionsCreatedCount();
                this.m_cp.m_cumulativeConnectionsCreated.incrementAndGet();
            }
            finally {
                if (null != object && null == universalPooledConnection) {
                    this.m_cp.closePhysicalConnection(object);
                }
            }
            return universalPooledConnection;
        }

        private void checkLifecycle() throws UniversalConnectionPoolException {
            if (this.m_cp.isLifecycleFailed() || this.m_cp.isLifecycleStopped()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(60);
            }
        }

        private void discardUsedConnectionInternal(Object object) {
            UniversalPooledConnection universalPooledConnection = this.m_cp.getUsedConnection(object);
            if (null != universalPooledConnection) {
                this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - this.m_cp.getUsedConnection(object).getBorrowedStartTime());
                this.m_cp.core.retrieve(universalPooledConnection.getDelegator());
                this.m_cp.totalConnectionsCount.decrementAndGet();
                this.m_cp.borrowedConnectionsCount.decrementAndGet();
            }
        }

        private UniversalPooledConnection getUsedConnectionInternal(Object object) {
            CoreConnection coreConnection = this.m_cp.core.findSpecificConnection(object);
            return null == coreConnection ? null : (UniversalPooledConnection)coreConnection.getDelegate();
        }

        private boolean returnUsedPhysicalConnectionInternal(Object object) throws UniversalConnectionPoolException {
            UniversalPooledConnection universalPooledConnection = this.m_cp.getUsedConnection(object);
            if (universalPooledConnection == null) {
                return false;
            }
            this.m_cp.returnConnection(universalPooledConnection);
            return true;
        }

        private boolean closeUsedPhysicalConnectionInternal(Object object) throws UniversalConnectionPoolException {
            UniversalPooledConnection universalPooledConnection = this.m_cp.getUsedConnection(object);
            if (universalPooledConnection == null) {
                return false;
            }
            this.m_cp.m_cumulativeConnectionUseTime.getAndAdd(Clock.clock() - universalPooledConnection.getBorrowedStartTime());
            CoreConnection coreConnection = universalPooledConnection.getDelegator();
            if (this.m_cp.core.retrieve(coreConnection)) {
                coreConnection.abort();
                coreConnection.close();
            }
            return true;
        }

        static {
            try {
                $$$methodRef$$$13 = UniversalConnectionPoolInternal.class.getDeclaredConstructor(UniversalConnectionPoolImpl.class, 1.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$12 = UniversalConnectionPoolInternal.class.getDeclaredConstructor(UniversalConnectionPoolImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$11 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$600", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$10 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$500", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$9 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$400", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$8 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$300", UniversalConnectionPoolInternal.class, Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$7 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$200", UniversalConnectionPoolInternal.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$6 = UniversalConnectionPoolInternal.class.getDeclaredMethod("access$100", UniversalConnectionPoolInternal.class, ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$5 = UniversalConnectionPoolInternal.class.getDeclaredMethod("closeUsedPhysicalConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$4 = UniversalConnectionPoolInternal.class.getDeclaredMethod("returnUsedPhysicalConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$3 = UniversalConnectionPoolInternal.class.getDeclaredMethod("getUsedConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$2 = UniversalConnectionPoolInternal.class.getDeclaredMethod("discardUsedConnectionInternal", Object.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = UniversalConnectionPoolInternal.class.getDeclaredMethod("checkLifecycle", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = UniversalConnectionPoolInternal.class.getDeclaredMethod("createOnePooledConnectionInternal", ConnectionRetrievalInfo.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        }
    }
}

