/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Counter;
import oracle.ucp.common.UniversalConnectionPoolBase;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskHandle;
import oracle.ucp.util.TaskManagerException;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.UCPTaskBase;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.LABELING})
class UniversalPooledConnectionImpl
implements UniversalPooledConnection {
    private final UniversalConnectionPoolBase m_connectionPool;
    private final Object m_connection;
    private final AtomicReference<ConnectionRetrievalInfo> m_connectionRetrievalInfo = new AtomicReference<Object>(null);
    private ConnectionRetrievalInfo borrowCRI;
    AtomicReference<UniversalPooledConnectionStatus> m_status = new AtomicReference<UniversalPooledConnectionStatus>(UniversalPooledConnectionStatus.STATUS_NORMAL);
    private long m_lastAccessedTime = Clock.clock();
    private boolean m_sqlWithQueryTimeoutInProgress = false;
    private final AtomicLong m_availableStartTime = new AtomicLong(Clock.clock());
    private final AtomicLong m_borrowedStartTime = new AtomicLong(Clock.clock());
    private final AtomicLong m_connectionReuseTimestamp = new AtomicLong(Clock.clock());
    private final AtomicInteger m_connectionReuseCounter = new AtomicInteger(0);
    private final AtomicBoolean m_isHarvestable = new AtomicBoolean(true);
    private AtomicReference<ConnectionHarvestingCallback> m_harvestingCallback = new AtomicReference<Object>(null);
    private AtomicReference<AbandonedConnectionTimeoutCallback> m_abandonedConnCallback = new AtomicReference<Object>(null);
    private AtomicReference<TimeToLiveConnectionTimeoutCallback> m_ttlConnCallback = new AtomicReference<Object>(null);
    private final AtomicLong m_lastConnectionValidationTime = new AtomicLong(0L);
    private final AtomicBoolean wasBorrowed = new AtomicBoolean(false);
    protected final Semaphore validitySemaphore = new Semaphore(1);
    private AtomicBoolean available = new AtomicBoolean(true);
    private AtomicReference<CoreConnection> delegator = new AtomicReference<Object>(null);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;
    private static Executable $$$methodRef$$$31;
    private static Logger $$$loggerRef$$$31;
    private static Executable $$$methodRef$$$32;
    private static Logger $$$loggerRef$$$32;
    private static Executable $$$methodRef$$$33;
    private static Logger $$$loggerRef$$$33;
    private static Executable $$$methodRef$$$34;
    private static Logger $$$loggerRef$$$34;
    private static Executable $$$methodRef$$$35;
    private static Logger $$$loggerRef$$$35;
    private static Executable $$$methodRef$$$36;
    private static Logger $$$loggerRef$$$36;
    private static Executable $$$methodRef$$$37;
    private static Logger $$$loggerRef$$$37;
    private static Executable $$$methodRef$$$38;
    private static Logger $$$loggerRef$$$38;
    private static Executable $$$methodRef$$$39;
    private static Logger $$$loggerRef$$$39;
    private static Executable $$$methodRef$$$40;
    private static Logger $$$loggerRef$$$40;
    private static Executable $$$methodRef$$$41;
    private static Logger $$$loggerRef$$$41;
    private static Executable $$$methodRef$$$42;
    private static Logger $$$loggerRef$$$42;
    private static Executable $$$methodRef$$$43;
    private static Logger $$$loggerRef$$$43;
    private static Executable $$$methodRef$$$44;
    private static Logger $$$loggerRef$$$44;
    private static Executable $$$methodRef$$$45;
    private static Logger $$$loggerRef$$$45;
    private static Executable $$$methodRef$$$46;
    private static Logger $$$loggerRef$$$46;
    private static Executable $$$methodRef$$$47;
    private static Logger $$$loggerRef$$$47;
    private static Executable $$$methodRef$$$48;
    private static Logger $$$loggerRef$$$48;
    private static Executable $$$methodRef$$$49;
    private static Logger $$$loggerRef$$$49;
    private static Executable $$$methodRef$$$50;
    private static Logger $$$loggerRef$$$50;
    private static Executable $$$methodRef$$$51;
    private static Logger $$$loggerRef$$$51;
    private static Executable $$$methodRef$$$52;
    private static Logger $$$loggerRef$$$52;
    private static Executable $$$methodRef$$$53;
    private static Logger $$$loggerRef$$$53;
    private static Executable $$$methodRef$$$54;
    private static Logger $$$loggerRef$$$54;
    private static Executable $$$methodRef$$$55;
    private static Logger $$$loggerRef$$$55;
    private static Executable $$$methodRef$$$56;
    private static Logger $$$loggerRef$$$56;

    UniversalPooledConnectionImpl(UniversalConnectionPoolBase universalConnectionPoolBase, Object object, ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (null == universalConnectionPoolBase) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        if (null == object) {
            UCPErrorHandler.throwUniversalConnectionPoolException(264);
        }
        if (null == connectionRetrievalInfo) {
            UCPErrorHandler.throwUniversalConnectionPoolException(4);
        }
        this.m_connectionPool = universalConnectionPoolBase;
        this.m_connection = object;
        this.m_connectionRetrievalInfo.set(connectionRetrievalInfo);
        this.m_isHarvestable.set(true);
        this.m_connectionPool.getNeverUsedConnectionsCounter().getCounter(connectionRetrievalInfo).incrementAndGet();
    }

    @Override
    public Object getPhysicalConnection() {
        return this.m_connection;
    }

    @Override
    public ConnectionRetrievalInfo getConnectionRetrievalInfo() {
        return this.m_connectionRetrievalInfo.get();
    }

    @Override
    public void setConnectionRetrievalInfo(ConnectionRetrievalInfo connectionRetrievalInfo) {
        ConnectionRetrievalInfo connectionRetrievalInfo2 = this.m_connectionRetrievalInfo.getAndSet(connectionRetrievalInfo);
        Properties properties = connectionRetrievalInfo2.getLabels();
        Properties properties2 = connectionRetrievalInfo.getLabels();
        boolean bl2 = null != properties && !properties.isEmpty();
        boolean bl3 = null != properties2 && !properties2.isEmpty();
        Counter counter = this.m_connectionPool.labeledConnectionsCount;
        if (bl2) {
            if (!bl3) {
                counter.decrementAndGet();
            }
        } else if (bl3) {
            counter.incrementAndGet();
        }
        this.m_connectionPool.clearWFPTree();
    }

    ConnectionRetrievalInfo getBorrowCRI() {
        return this.borrowCRI;
    }

    void setBorrowCRI(ConnectionRetrievalInfo connectionRetrievalInfo) {
        this.borrowCRI = connectionRetrievalInfo;
    }

    @Override
    public void heartbeat() {
        this.m_lastAccessedTime = Clock.clock();
    }

    @Override
    public void setSqlWithQueryTimeoutInProgress(boolean bl2) {
        this.m_sqlWithQueryTimeoutInProgress = bl2;
    }

    @Override
    public boolean isSqlWithQueryTimeoutInProgress() {
        return this.m_sqlWithQueryTimeoutInProgress;
    }

    @Override
    public boolean isValid() {
        boolean bl2 = false;
        try {
            bl2 = this.isValid(this.m_connectionPool.getConnectionValidationTimeout());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid(long l2) throws SQLException {
        try {
            this.validitySemaphore.acquire();
            boolean bl2 = this.isValidHelper(l2);
            return bl2;
        }
        catch (InterruptedException interruptedException) {
            ClioSupport.ilogThrowing(null, null, null, null, interruptedException);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            this.validitySemaphore.release();
        }
    }

    private boolean isValidHelper(long l2) throws SQLException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus;
        TaskHandle<Object> taskHandle = null;
        UniversalPooledConnectionStatus universalPooledConnectionStatus2 = this.getStatus();
        if (l2 < 0L) {
            UCPErrorHandler.throwSQLException(67, null);
        }
        if (this.m_connectionPool != null && (universalPooledConnectionStatus2.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus2.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus2.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            try {
                ClioSupport.ilogFinest(null, null, null, null, "starting");
                taskHandle = UniversalConnectionPoolManagerBase.getTaskManager().submitTask(new UCPTaskBase<Object>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;

                    @Override
                    public void run() {
                        UniversalPooledConnectionImpl.this.validate();
                    }

                    static {
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredConstructor(UniversalPooledConnectionImpl.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                if (taskHandle != null) {
                    taskHandle.get(l2 * 1000L);
                    taskHandle.getTask().release();
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "failed");
                }
            }
            catch (TaskManagerException taskManagerException) {
                ClioSupport.ilogThrowing(null, null, null, null, taskManagerException);
                if (taskManagerException.getCause() instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.markBadAndCancel(taskHandle);
            }
        }
        return !(universalPooledConnectionStatus = this.getStatus()).equals(UniversalPooledConnectionStatus.STATUS_CLOSED) && !universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_BAD) && !universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
    }

    void markBadAndCancel(TaskHandle taskHandle) {
        this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "The connection is deemed invalid");
        if (taskHandle != null) {
            taskHandle.getTask().release();
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public long getLastNetworkAccessTime() {
        return 0L;
    }

    @Override
    public long getLastAccessedTime() {
        return this.m_lastAccessedTime;
    }

    @Override
    public UniversalPooledConnectionStatus getStatus() {
        return this.m_status.get();
    }

    @Override
    public void setStatus(UniversalPooledConnectionStatus universalPooledConnectionStatus) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus2;
        if (null == universalPooledConnectionStatus) {
            UCPErrorHandler.throwUniversalConnectionPoolException(152);
        }
        while (!UniversalPooledConnectionStatus.STATUS_CLOSED.equals(universalPooledConnectionStatus2 = this.getStatus()) && !this.m_status.compareAndSet(universalPooledConnectionStatus2, universalPooledConnectionStatus)) {
        }
    }

    public void setStatus(UniversalPooledConnectionStatus universalPooledConnectionStatus, String string) {
        try {
            this.setStatus(universalPooledConnectionStatus);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            ClioSupport.ilogFinest(null, null, null, null, "failed");
        }
    }

    @Override
    public long getAvailableStartTime() {
        return this.m_availableStartTime.get();
    }

    @Override
    public void setAvailableStartTime() {
        long l2 = Clock.clock();
        this.m_availableStartTime.set(l2);
    }

    @Override
    public long getBorrowedStartTime() {
        return this.m_borrowedStartTime.get();
    }

    @Override
    public void setBorrowedStartTime() {
        long l2 = Clock.clock();
        this.m_borrowedStartTime.set(l2);
    }

    @Override
    public long getLastConnectionValidationTime() {
        return this.m_lastConnectionValidationTime.get();
    }

    @Override
    public void setLastConnectionValidationTime(long l2) {
        this.m_lastConnectionValidationTime.set(l2);
    }

    @Override
    public void applyConnectionLabel(String string, String string2) throws UniversalConnectionPoolException {
        ConnectionRetrievalInfo connectionRetrievalInfo;
        Properties properties;
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (string == null || string.equals("")) {
            UCPErrorHandler.throwUniversalConnectionPoolException(153);
        }
        boolean bl2 = null == (properties = (connectionRetrievalInfo = this.m_connectionRetrievalInfo.get()).getLabels()) ? true : !properties.containsKey(string);
        boolean bl3 = null != properties && !properties.isEmpty();
        connectionRetrievalInfo.addLabel(string, string2);
        if (!bl3) {
            this.m_connectionPool.labeledConnectionsCount.incrementAndGet();
        }
        if (bl2) {
            this.m_connectionPool.clearWFPTree();
        }
    }

    @Override
    public void removeConnectionLabel(String string) throws UniversalConnectionPoolException {
        boolean bl2;
        ConnectionRetrievalInfo connectionRetrievalInfo;
        Properties properties;
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (null == string || string.equals("")) {
            UCPErrorHandler.throwUniversalConnectionPoolException(153);
        }
        boolean bl3 = null == (properties = (connectionRetrievalInfo = this.m_connectionRetrievalInfo.get()).getLabels()) ? false : properties.containsKey(string);
        boolean bl4 = null != properties && !properties.isEmpty();
        connectionRetrievalInfo.removeLabel(string);
        properties = connectionRetrievalInfo.getLabels();
        boolean bl5 = bl2 = null != properties && !properties.isEmpty();
        if (bl4 && !bl2) {
            this.m_connectionPool.labeledConnectionsCount.decrementAndGet();
        }
        if (bl3) {
            this.m_connectionPool.clearWFPTree();
        }
    }

    @Override
    public Properties getConnectionLabels() throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_connectionRetrievalInfo.get().getLabels();
    }

    @Override
    public Properties getUnmatchedConnectionLabels(Properties properties) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        Properties properties2 = this.m_connectionRetrievalInfo.get().getLabels();
        if (properties == null || properties.isEmpty()) {
            if (properties2 != null && !properties2.isEmpty()) {
                UCPErrorHandler.throwUniversalConnectionPoolException(93);
            } else {
                return null;
            }
        }
        Properties properties3 = new Properties();
        if (properties2 == null || properties2.isEmpty()) {
            properties3.putAll((Map<?, ?>)properties);
            return properties3;
        }
        Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
        Set<Map.Entry<Object, Object>> set = properties2.entrySet();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            if (set.contains(entry)) continue;
            properties3.setProperty(string, string2);
        }
        return properties3.isEmpty() ? null : properties3;
    }

    @Override
    public void setConnectionHarvestable(boolean bl2) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        this.m_isHarvestable.set(bl2);
    }

    @Override
    public boolean isConnectionHarvestable() {
        return this.m_isHarvestable.get();
    }

    @Override
    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback connectionHarvestingCallback) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (!this.m_harvestingCallback.compareAndSet(null, connectionHarvestingCallback)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(155);
        }
    }

    @Override
    public void removeConnectionHarvestingCallback() throws UniversalConnectionPoolException {
        this.m_harvestingCallback.set(null);
    }

    @Override
    public ConnectionHarvestingCallback getConnectionHarvestingCallback() throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_harvestingCallback.get();
    }

    @Override
    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback abandonedConnectionTimeoutCallback) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (!this.m_abandonedConnCallback.compareAndSet(null, abandonedConnectionTimeoutCallback)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(156);
        }
    }

    @Override
    public void removeAbandonedConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        this.m_abandonedConnCallback.set(null);
    }

    @Override
    public AbandonedConnectionTimeoutCallback getAbandonedConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_abandonedConnCallback.get();
    }

    @Override
    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback timeToLiveConnectionTimeoutCallback) throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        if (!this.m_ttlConnCallback.compareAndSet(null, timeToLiveConnectionTimeoutCallback)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(157);
        }
    }

    @Override
    public void removeTimeToLiveConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        this.m_ttlConnCallback.set(null);
    }

    @Override
    public TimeToLiveConnectionTimeoutCallback getTimeToLiveConnectionTimeoutCallback() throws UniversalConnectionPoolException {
        UniversalPooledConnectionStatus universalPooledConnectionStatus = this.getStatus();
        if (!(universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_NORMAL) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN) || universalPooledConnectionStatus.equals(UniversalPooledConnectionStatus.STATUS_REPLACE_ON_RETURN))) {
            UCPErrorHandler.throwUniversalConnectionPoolException(154);
        }
        return this.m_ttlConnCallback.get();
    }

    public int getConnectionReuseCounter() {
        return this.m_connectionReuseCounter.get();
    }

    public long getConnectionReuseTimestamp() {
        return this.m_connectionReuseTimestamp.get();
    }

    @Override
    public boolean isReusable() {
        int n2;
        long l2;
        long l3 = this.m_connectionPool.getMaxConnectionReuseTime();
        if (l3 > 0L && (l2 = this.getConnectionReuseTimestamp() + l3 * 1000L) <= Clock.clock()) {
            return false;
        }
        int n3 = this.m_connectionPool.getMaxConnectionReuseCount();
        return n3 <= 0 || (n2 = this.getConnectionReuseCounter()) < n3;
    }

    @Override
    public void close() {
        this.delegator.get().abort();
        this.delegator.get().close();
    }

    void closeNoStatsUpdate() {
        try {
            Object object = this.getPhysicalConnection();
            if (null != object) {
                this.m_connectionPool.getConnectionFactoryAdapter().closeConnection(object);
            }
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
        }
    }

    @Override
    public void abort() {
    }

    @Override
    public void handleTimeout() {
    }

    @Override
    public boolean isAvailable() {
        return this.available.get();
    }

    @Override
    public boolean setAvailable() {
        return this.setAvailable(true);
    }

    @Override
    public boolean setBorrowed() {
        return this.setAvailable(false);
    }

    private boolean setAvailable(boolean bl2) {
        boolean bl3 = this.available.compareAndSet(!bl2, bl2);
        if (bl3) {
            if (bl2) {
                this.m_connectionPool.m_cumulativeReturnedConnectionsCount.incrementAndGet();
                this.m_connectionPool.insertToBorrowedHistogram(this.getConnectionRetrievalInfo(), Clock.clock() - this.getBorrowedStartTime());
            } else {
                this.m_connectionReuseCounter.incrementAndGet();
                this.m_connectionPool.m_cumulativeBorrowedConnectionsCount.incrementAndGet();
                this.m_connectionPool.m_peakBorrowedConnectionsCount.update(this.m_connectionPool.getBorrowedConnectionsCount());
                this.m_connectionPool.insertToAvailableHistogram(this.getConnectionRetrievalInfo(), Clock.clock() - this.getAvailableStartTime());
                if (this.wasBorrowed.compareAndSet(false, true)) {
                    this.m_connectionPool.getNeverUsedConnectionsCounter().getCounter(this.getConnectionRetrievalInfo()).decrementAndGet();
                }
            }
        }
        return bl3;
    }

    @Override
    public int labelingCost(Properties properties) {
        int n2;
        Properties properties2 = this.m_connectionRetrievalInfo.get().getLabels();
        if (null == properties) {
            return null == properties2 ? 0 : Integer.MAX_VALUE;
        }
        ConnectionLabelingCallback connectionLabelingCallback = this.m_connectionPool.getConnectionLabelingCallback();
        if (null == connectionLabelingCallback) {
            return 0;
        }
        int n3 = connectionLabelingCallback.cost(properties, null == properties2 ? new Properties() : properties2);
        if (n3 >= this.m_connectionPool.getConnectionLabelingHighCost() && ((n2 = this.m_connectionPool.getTotalConnectionsCount()) < this.m_connectionPool.getHighCostConnectionReuseThreshold() || n2 < this.m_connectionPool.getMinPoolSize())) {
            return Integer.MAX_VALUE;
        }
        return n3;
    }

    @Override
    public void plugDelegator(CoreConnection coreConnection) {
        if (!this.delegator.compareAndSet(null, coreConnection)) {
            throw new IllegalStateException("delegator was already plugged");
        }
    }

    @Override
    public CoreConnection getDelegator() {
        CoreConnection coreConnection = this.delegator.get();
        if (null == coreConnection) {
            throw new IllegalStateException("delegator was not plugged yet");
        }
        return coreConnection;
    }

    public String getService() {
        return "";
    }

    @Override
    public Properties getDatabaseConnectionProperties() {
        return new Properties();
    }

    @Override
    public boolean isOracle() {
        return this.m_connectionPool.isOraclePool();
    }

    static {
        try {
            $$$methodRef$$$56 = UniversalPooledConnectionImpl.class.getDeclaredConstructor(UniversalConnectionPoolBase.class, Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$56 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$55 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isOracle", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$55 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$54 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getDatabaseConnectionProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$54 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$53 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getService", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$53 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$52 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getDelegator", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$52 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$51 = UniversalPooledConnectionImpl.class.getDeclaredMethod("plugDelegator", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$51 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$50 = UniversalPooledConnectionImpl.class.getDeclaredMethod("labelingCost", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$50 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$49 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setAvailable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$49 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$48 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setBorrowed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$48 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$47 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$47 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$46 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isAvailable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$46 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$45 = UniversalPooledConnectionImpl.class.getDeclaredMethod("handleTimeout", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$45 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$44 = UniversalPooledConnectionImpl.class.getDeclaredMethod("abort", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$44 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$43 = UniversalPooledConnectionImpl.class.getDeclaredMethod("closeNoStatsUpdate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$43 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$42 = UniversalPooledConnectionImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$42 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$41 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isReusable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$41 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$40 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionReuseTimestamp", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$40 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$39 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionReuseCounter", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$39 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$38 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getTimeToLiveConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$38 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$37 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeTimeToLiveConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$37 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$36 = UniversalPooledConnectionImpl.class.getDeclaredMethod("registerTimeToLiveConnectionTimeoutCallback", TimeToLiveConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$36 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$35 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getAbandonedConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$35 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$34 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeAbandonedConnectionTimeoutCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$34 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$33 = UniversalPooledConnectionImpl.class.getDeclaredMethod("registerAbandonedConnectionTimeoutCallback", AbandonedConnectionTimeoutCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$33 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$32 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionHarvestingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$32 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$31 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeConnectionHarvestingCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$31 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$30 = UniversalPooledConnectionImpl.class.getDeclaredMethod("registerConnectionHarvestingCallback", ConnectionHarvestingCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$29 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isConnectionHarvestable", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$28 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setConnectionHarvestable", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$27 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getUnmatchedConnectionLabels", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$26 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionLabels", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$25 = UniversalPooledConnectionImpl.class.getDeclaredMethod("removeConnectionLabel", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$24 = UniversalPooledConnectionImpl.class.getDeclaredMethod("applyConnectionLabel", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$23 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setLastConnectionValidationTime", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$22 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getLastConnectionValidationTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$21 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setBorrowedStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$20 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getBorrowedStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$19 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setAvailableStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$18 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getAvailableStartTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$17 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setStatus", UniversalPooledConnectionStatus.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$16 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setStatus", UniversalPooledConnectionStatus.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$15 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getStatus", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$14 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getLastAccessedTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$13 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getLastNetworkAccessTime", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$12 = UniversalPooledConnectionImpl.class.getDeclaredMethod("validate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$11 = UniversalPooledConnectionImpl.class.getDeclaredMethod("markBadAndCancel", TaskHandle.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$10 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isValidHelper", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$9 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isValid", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$8 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isValid", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$7 = UniversalPooledConnectionImpl.class.getDeclaredMethod("isSqlWithQueryTimeoutInProgress", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$6 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setSqlWithQueryTimeoutInProgress", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$5 = UniversalPooledConnectionImpl.class.getDeclaredMethod("heartbeat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$4 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setBorrowCRI", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$3 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getBorrowCRI", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$2 = UniversalPooledConnectionImpl.class.getDeclaredMethod("setConnectionRetrievalInfo", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$1 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getConnectionRetrievalInfo", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
        try {
            $$$methodRef$$$0 = UniversalPooledConnectionImpl.class.getDeclaredMethod("getPhysicalConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.common");
    }
}

