/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.runtime.TraceControllerImpl;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class ConnectionConnectionPool
extends JDBCConnectionPool {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public ConnectionConnectionPool(JDBCConnectionFactoryAdapter jDBCConnectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(jDBCConnectionFactoryAdapter);
        if (!(jDBCConnectionFactoryAdapter instanceof DataSourceConnectionFactoryAdapter) && !(jDBCConnectionFactoryAdapter instanceof DriverConnectionFactoryAdapter)) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(103);
        }
    }

    public Connection getConnection(JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo) throws UniversalConnectionPoolException {
        boolean bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        Connection connection = (Connection)this.borrowConnection(jDBCConnectionRetrievalInfo).getPhysicalConnection();
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$0, ConnectionConnectionPool.class, $$$methodRef$$$0, this, "connection borrowed succesfully");
        }
        return connection;
    }

    public boolean returnConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        boolean bl3 = this.returnUsedPhysicalConnection(connection);
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$1, ConnectionConnectionPool.class, $$$methodRef$$$1, this, "connection returned succesfully");
        }
        return bl3;
    }

    public boolean closeConnection(Connection connection) throws UniversalConnectionPoolException {
        boolean bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        boolean bl3 = this.closeUsedPhysicalConnection(connection);
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$2, ConnectionConnectionPool.class, $$$methodRef$$$2, this, "connection closed succesfully");
        }
        return bl3;
    }

    static {
        try {
            $$$methodRef$$$3 = ConnectionConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = ConnectionConnectionPool.class.getDeclaredMethod("closeConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = ConnectionConnectionPool.class.getDeclaredMethod("returnConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = ConnectionConnectionPool.class.getDeclaredMethod("getConnection", JDBCConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

