/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.net.URI;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.xml.XMLConfigurationParser;

public class DatasourceConfigManager {
    private static DatasourceConfigManager configManager;
    private static Map<String, Object> parsedUcpConfigMap;
    private static Map<String, PoolDataSource> poolDataSources;
    private static Map<String, PoolXADataSource> poolXADataSources;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;

    private DatasourceConfigManager() {
    }

    public static synchronized void init() throws UniversalConnectionPoolException {
        if (configManager != null) {
            return;
        }
        try {
            String string = Util.getXMLConfigurationFilePath();
            if (null != string && !string.isEmpty()) {
                URI uRI = URI.create(string);
                XMLConfigurationParser xMLConfigurationParser = XMLConfigurationParser.getInstance();
                parsedUcpConfigMap = xMLConfigurationParser.parse(uRI);
                DatasourceConfigManager.loadPoolsFromConfig();
                configManager = new DatasourceConfigManager();
            }
        }
        catch (Exception exception) {
            UCPErrorHandler.throwUniversalConnectionPoolException(387, exception);
        }
    }

    public static DatasourceConfigManager getDatasourceConfigManager() {
        if (configManager == null) {
            try {
                DatasourceConfigManager.init();
            }
            catch (UniversalConnectionPoolException universalConnectionPoolException) {
                throw new IllegalStateException(" Invalid UCP Config ", universalConnectionPoolException);
            }
        }
        return configManager;
    }

    private static void loadPoolsFromConfig() throws Exception {
        for (Map.Entry<String, Object> entry : parsedUcpConfigMap.entrySet()) {
            DatasourceConfigManager.loadPool(entry.getKey(), entry.getValue());
        }
    }

    private static void loadPool(String string, Object object) throws UniversalConnectionPoolException, Exception {
        Map map = (Map)object;
        boolean bl2 = false;
        if (Boolean.parseBoolean((String)map.get("is-xa-pool"))) {
            bl2 = true;
        }
        for (Map.Entry entry : map.entrySet()) {
            PoolDataSourceImpl poolDataSourceImpl;
            if (!((String)entry.getKey()).startsWith("data-source-")) continue;
            String string2 = ((String)entry.getKey()).substring("data-source-".length());
            if (bl2) {
                poolDataSourceImpl = new PoolXADataSourceImpl(string, string2, map);
                poolXADataSources.putIfAbsent(string2, (PoolXADataSource)((Object)poolDataSourceImpl));
                continue;
            }
            poolDataSourceImpl = new PoolDataSourceImpl(string, string2, map);
            poolDataSources.putIfAbsent(string2, poolDataSourceImpl);
        }
    }

    PoolDataSource getPoolDataSource(String string) throws SQLException {
        PoolDataSource poolDataSource = poolDataSources.get(string);
        if (poolDataSource == null) {
            UCPErrorHandler.throwSQLException(73, null);
        }
        return poolDataSource;
    }

    PoolXADataSource getPoolXADataSource(String string) throws SQLException {
        PoolXADataSource poolXADataSource = poolXADataSources.get(string);
        if (poolXADataSource == null) {
            UCPErrorHandler.throwSQLException(73, null);
        }
        return poolXADataSource;
    }

    public static boolean isPoolCreatedUsingXmlConfig(String string) {
        return parsedUcpConfigMap != null ? parsedUcpConfigMap.containsKey(string) : false;
    }

    static Map<String, Object> getPoolConfigFromXML(String string) {
        return parsedUcpConfigMap != null ? (Map)parsedUcpConfigMap.get(string) : null;
    }

    static Map<String, PoolDataSource> getPoolDataSources() {
        return poolDataSources;
    }

    static Map<String, PoolXADataSource> getPoolXADataSources() {
        return poolXADataSources;
    }

    static {
        try {
            $$$methodRef$$$10 = DatasourceConfigManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = DatasourceConfigManager.class.getDeclaredMethod("getPoolXADataSources", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = DatasourceConfigManager.class.getDeclaredMethod("getPoolDataSources", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = DatasourceConfigManager.class.getDeclaredMethod("getPoolConfigFromXML", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = DatasourceConfigManager.class.getDeclaredMethod("isPoolCreatedUsingXmlConfig", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = DatasourceConfigManager.class.getDeclaredMethod("getPoolXADataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = DatasourceConfigManager.class.getDeclaredMethod("getPoolDataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = DatasourceConfigManager.class.getDeclaredMethod("loadPool", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = DatasourceConfigManager.class.getDeclaredMethod("loadPoolsFromConfig", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = DatasourceConfigManager.class.getDeclaredMethod("getDatasourceConfigManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = DatasourceConfigManager.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        configManager = null;
        poolDataSources = new HashMap<String, PoolDataSource>();
        poolXADataSources = new HashMap<String, PoolXADataSource>();
    }
}

