/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalConnectionPoolLifeCycleState;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.oracle.OracleConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT})
public class JDBCConnectionPool
extends UniversalConnectionPoolImpl {
    private String m_SQLForValidateConnection = null;
    private int m_maxStatements = 0;
    private AtomicReference<Object> connectionfactory = new AtomicReference<Object>(null);
    protected ConnectionInitializationCallback m_connectionInitializationCallback = null;
    private AtomicReference<ConnectionProxyFactory> proxyFactory = new AtomicReference<Object>(null);
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;

    public JDBCConnectionPool(JDBCConnectionFactoryAdapter jDBCConnectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(jDBCConnectionFactoryAdapter);
    }

    public void setSQLForValidateConnection(String string) throws SQLException {
        JDBCUniversalPooledConnection jDBCUniversalPooledConnection;
        if (string != null && string.equals("")) {
            throw UCPErrorHandler.newSQLException(22);
        }
        if (this.m_lifeCycleState.get() == UniversalConnectionPoolLifeCycleState.LIFE_CYCLE_RUNNING && null != string && null != (jDBCUniversalPooledConnection = (JDBCUniversalPooledConnection)this.createOnePooledConnection())) {
            Statement statement = null;
            try {
                statement = jDBCUniversalPooledConnection.getSQLConnection(jDBCUniversalPooledConnection.getPhysicalConnection()).createStatement();
                statement.execute(string);
            }
            catch (SQLRecoverableException sQLRecoverableException) {
            }
            catch (SQLException sQLException) {
                this.setValidateConnectionOnBorrow(false);
                throw sQLException;
            }
            finally {
                if (null != statement) {
                    statement.close();
                }
                this.closePhysicalConnection(jDBCUniversalPooledConnection.getPhysicalConnection());
            }
        }
        this.m_SQLForValidateConnection = string;
    }

    public String getSQLForValidateConnection() {
        return this.m_SQLForValidateConnection;
    }

    public void setMaxStatements(int n2) throws SQLException {
        if (n2 < 0) {
            throw UCPErrorHandler.newSQLException(22);
        }
        this.m_maxStatements = n2;
    }

    public int getMaxStatements() {
        return this.m_maxStatements;
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        this.validateConnectionRetrievalInfo(connectionRetrievalInfo);
        JDBCUniversalPooledConnection jDBCUniversalPooledConnection = (JDBCUniversalPooledConnection)super.borrowConnection(connectionRetrievalInfo);
        try {
            if (jDBCUniversalPooledConnection != null) {
                jDBCUniversalPooledConnection.setMaxStatements(this.getMaxStatements());
            }
        }
        catch (SQLException sQLException) {
            throw new UniversalConnectionPoolException(sQLException);
        }
        return jDBCUniversalPooledConnection;
    }

    public synchronized void registerConnectionInitializationCallback(ConnectionInitializationCallback connectionInitializationCallback) throws UniversalConnectionPoolException {
        if (null != this.m_connectionInitializationCallback) {
            UCPErrorHandler.throwUniversalConnectionPoolException(270);
        }
        this.m_connectionInitializationCallback = connectionInitializationCallback;
    }

    public synchronized void unregisterConnectionInitializationCallback() throws UniversalConnectionPoolException {
        this.m_connectionInitializationCallback = null;
    }

    public ConnectionInitializationCallback getConnectionInitializationCallback() {
        return this.m_connectionInitializationCallback;
    }

    @Override
    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection universalPooledConnection) {
        JDBCUniversalPooledConnection jDBCUniversalPooledConnection = (JDBCUniversalPooledConnection)universalPooledConnection;
        return this.getProxyFactory().proxyForConnection(this, jDBCUniversalPooledConnection);
    }

    protected void setConnectionFactory(Object object) {
        if (this.isLifecycleRunning()) {
            throw new IllegalStateException("Cannot set factory class when the pool is started");
        }
        this.connectionfactory.compareAndSet(null, object);
    }

    Object getConnectionFactory() {
        return this.connectionfactory.get();
    }

    private void validateConnectionRetrievalInfo(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo) {
            JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
            if (this.core.connectionSource().isShardedDatabase() && !this.core.connectionSource().isCatalogDatabase()) {
                if (jDBCConnectionRetrievalInfo.getShardingKey() == null) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(277);
                }
            } else if (!(this.core.connectionSource().isRacDataAffinityEnabled() || jDBCConnectionRetrievalInfo.getShardingKey() == null && jDBCConnectionRetrievalInfo.getSuperShardingKey() == null)) {
                UCPErrorHandler.throwUniversalConnectionPoolException(278);
            }
        } else {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
    }

    public void setProxyFactory(ConnectionProxyFactory connectionProxyFactory) {
        this.proxyFactory.set(connectionProxyFactory);
    }

    public ConnectionProxyFactory getProxyFactory() {
        ConnectionProxyFactory connectionProxyFactory = this.proxyFactory.get();
        return null == connectionProxyFactory ? new OracleConnectionProxyFactory() : connectionProxyFactory;
    }

    static {
        try {
            $$$methodRef$$$14 = JDBCConnectionPool.class.getDeclaredConstructor(JDBCConnectionFactoryAdapter.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$13 = JDBCConnectionPool.class.getDeclaredMethod("getProxyFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$12 = JDBCConnectionPool.class.getDeclaredMethod("setProxyFactory", ConnectionProxyFactory.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$11 = JDBCConnectionPool.class.getDeclaredMethod("validateConnectionRetrievalInfo", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$10 = JDBCConnectionPool.class.getDeclaredMethod("getConnectionFactory", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$9 = JDBCConnectionPool.class.getDeclaredMethod("setConnectionFactory", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$8 = JDBCConnectionPool.class.getDeclaredMethod("getConnectionObjectForLabelingConfigure", UniversalPooledConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$7 = JDBCConnectionPool.class.getDeclaredMethod("getConnectionInitializationCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$6 = JDBCConnectionPool.class.getDeclaredMethod("unregisterConnectionInitializationCallback", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$5 = JDBCConnectionPool.class.getDeclaredMethod("registerConnectionInitializationCallback", ConnectionInitializationCallback.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$4 = JDBCConnectionPool.class.getDeclaredMethod("borrowConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$3 = JDBCConnectionPool.class.getDeclaredMethod("getMaxStatements", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = JDBCConnectionPool.class.getDeclaredMethod("setMaxStatements", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = JDBCConnectionPool.class.getDeclaredMethod("getSQLForValidateConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = JDBCConnectionPool.class.getDeclaredMethod("setSQLForValidateConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

