/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.jdbc.DatasourceConfigManager;
import oracle.ucp.jdbc.PoolDataSource;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.PoolXADataSourceImpl;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class PoolDataSourceFactory {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    public static PoolDataSource getPoolDataSource() {
        return new PoolDataSourceImpl();
    }

    public static PoolDataSource getPoolDataSource(String string) throws SQLException {
        DatasourceConfigManager datasourceConfigManager = DatasourceConfigManager.getDatasourceConfigManager();
        if (datasourceConfigManager == null) {
            UCPErrorHandler.throwSQLException(75, null);
        }
        return datasourceConfigManager.getPoolDataSource(string);
    }

    public static PoolDataSource getPoolDataSource(Properties properties) throws SQLException {
        PoolDataSourceFactory.validateConfig(properties, false);
        String string = properties.getProperty("dataSourceName");
        Map<String, PoolDataSource> map = DatasourceConfigManager.getPoolDataSources();
        PoolDataSourceImpl poolDataSourceImpl = new PoolDataSourceImpl();
        poolDataSourceImpl.setConfigureNewDataSource(true);
        poolDataSourceImpl.setDataSourceName(string);
        poolDataSourceImpl.reconfigureDataSource(properties);
        map.put(string, poolDataSourceImpl);
        return poolDataSourceImpl;
    }

    public static PoolXADataSource getPoolXADataSource() {
        return new PoolXADataSourceImpl();
    }

    public static PoolXADataSource getPoolXADataSource(String string) throws SQLException {
        DatasourceConfigManager datasourceConfigManager = DatasourceConfigManager.getDatasourceConfigManager();
        if (datasourceConfigManager == null) {
            UCPErrorHandler.throwSQLException(75, null);
        }
        return datasourceConfigManager.getPoolXADataSource(string);
    }

    public static PoolXADataSource getPoolXADataSource(Properties properties) throws SQLException {
        PoolDataSourceFactory.validateConfig(properties, true);
        String string = properties.getProperty("dataSourceName");
        Map<String, PoolXADataSource> map = DatasourceConfigManager.getPoolXADataSources();
        PoolXADataSourceImpl poolXADataSourceImpl = new PoolXADataSourceImpl();
        ((PoolDataSourceImpl)poolXADataSourceImpl).setConfigureNewDataSource(true);
        poolXADataSourceImpl.setDataSourceName(string);
        ((PoolDataSourceImpl)poolXADataSourceImpl).reconfigureDataSource(properties);
        map.put(string, poolXADataSourceImpl);
        return poolXADataSourceImpl;
    }

    private static void validateConfig(Properties properties, boolean bl2) throws SQLException {
        if (properties == null) {
            throw new IllegalArgumentException("Invalid datasource input configuration");
        }
        String string = properties.getProperty("connectionPoolName");
        if (string == null) {
            throw new IllegalArgumentException("Invalid input, connection pool name does not exist in input configuration");
        }
        String string2 = properties.getProperty("dataSourceName");
        if (string2 == null) {
            throw new IllegalArgumentException("Invalid input, data source name does not exist in input configuration");
        }
        Map<String, Object> map = DatasourceConfigManager.getPoolConfigFromXML(string);
        if (map == null) {
            UCPErrorHandler.throwSQLException(74, null);
        }
        if (!bl2 && Boolean.parseBoolean((String)map.get("is-xa-pool"))) {
            UCPErrorHandler.throwSQLException(79, null);
        } else if (bl2 && !Boolean.parseBoolean((String)map.get("is-xa-pool"))) {
            UCPErrorHandler.throwSQLException(80, null);
        }
        Map<String, PoolDataSource> map2 = DatasourceConfigManager.getPoolDataSources();
        Map<String, PoolXADataSource> map3 = DatasourceConfigManager.getPoolXADataSources();
        if (map2.containsKey(string2) || map3.containsKey(string2)) {
            UCPErrorHandler.throwSQLException(78, null);
        }
    }

    static {
        try {
            $$$methodRef$$$7 = PoolDataSourceFactory.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = PoolDataSourceFactory.class.getDeclaredMethod("validateConfig", Properties.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = PoolDataSourceFactory.class.getDeclaredMethod("getPoolXADataSource", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = PoolDataSourceFactory.class.getDeclaredMethod("getPoolXADataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = PoolDataSourceFactory.class.getDeclaredMethod("getPoolXADataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = PoolDataSourceFactory.class.getDeclaredMethod("getPoolDataSource", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = PoolDataSourceFactory.class.getDeclaredMethod("getPoolDataSource", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = PoolDataSourceFactory.class.getDeclaredMethod("getPoolDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

