/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.NoAvailableConnectionsException;
import oracle.ucp.UniversalConnectionPoolAdapter;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.PoolDataSourceImpl;
import oracle.ucp.jdbc.PoolXADataSource;
import oracle.ucp.jdbc.UCPXAConnectionBuilder;
import oracle.ucp.jdbc.UCPXAConnectionBuilderImpl;
import oracle.ucp.jdbc.XAConnectionConnectionPool;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleXAConnectionConnectionPool;
import oracle.ucp.jdbc.oracle.OracleXADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.proxy.oracle.OracleConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.other.OtherConnectionProxyFactory;
import oracle.ucp.logging.annotations.Blind;
import oracle.ucp.logging.runtime.TraceControllerImpl;
import oracle.ucp.util.OpaqueString;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class PoolXADataSourceImpl
extends PoolDataSourceImpl
implements Serializable,
Referenceable,
ObjectFactory,
UniversalConnectionPoolAdapter,
PoolXADataSource {
    private XADataSource m_xaDataSource = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public PoolXADataSourceImpl() {
    }

    PoolXADataSourceImpl(String string, String string2, Map<String, Object> map) throws UniversalConnectionPoolException, Exception {
        super(string, string2, map);
    }

    @Override
    protected void createPoolWithDefaultProperties() throws SQLException {
        boolean bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        String string = this.getClass().getName();
        int n2 = 27;
        try {
            this.m_xaDataSource = (XADataSource)this.m_connectionFactory;
            if (bl2) {
                this.ilogFinest($$$loggerRef$$$0, PoolXADataSourceImpl.class, $$$methodRef$$$0, this, "XADataSource is set");
            }
            n2 = 1;
            if (this.m_connectionFactoryClassName != null && this.m_connectionFactoryClassName.startsWith("oracle.jdbc")) {
                OracleXADataSourceConnectionFactoryAdapter oracleXADataSourceConnectionFactoryAdapter = new OracleXADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.m_cp = new OracleXAConnectionConnectionPool(oracleXADataSourceConnectionFactoryAdapter);
                oracleXADataSourceConnectionFactoryAdapter.setUniversalConnectionPool(this.m_cp);
                this.m_cp.setProxyFactory(new OracleConnectionProxyFactory());
                this.m_cp.setOraclePool(true);
            } else {
                XADataSourceConnectionFactoryAdapter xADataSourceConnectionFactoryAdapter = new XADataSourceConnectionFactoryAdapter(this.m_xaDataSource);
                this.m_cp = new XAConnectionConnectionPool(xADataSourceConnectionFactoryAdapter);
                xADataSourceConnectionFactoryAdapter.setUniversalConnectionPool(this.m_cp);
                this.m_cp.setProxyFactory(new OtherConnectionProxyFactory());
                this.m_cp.setOraclePool(false);
            }
            assert (this.m_cp != null);
            this.m_cp.setConnectionFactory(this.m_connectionFactory);
            if (bl2) {
                this.ilogFine($$$loggerRef$$$0, PoolXADataSourceImpl.class, $$$methodRef$$$0, this, "connection pool is created");
            }
        }
        catch (Exception exception) {
            UCPErrorHandler.throwSQLException(n2, exception);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        boolean bl2;
        boolean bl3 = bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$1, PoolXADataSourceImpl.class, $$$methodRef$$$1, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(String string, @Blind String string2) throws SQLException {
        boolean bl2;
        boolean bl3 = bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$2, PoolXADataSourceImpl.class, $$$methodRef$$$2, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(Properties properties) throws SQLException {
        boolean bl2;
        boolean bl3 = bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$3, PoolXADataSourceImpl.class, $$$methodRef$$$3, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public Connection getConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        boolean bl2;
        boolean bl3 = bl2 = (0x36000000000000L & TraceControllerImpl.feature) != 0L;
        if (bl2) {
            this.ilogFinest($$$loggerRef$$$4, PoolXADataSourceImpl.class, $$$methodRef$$$4, this, "PoolXADataSourceImpl.getConnection() is disabled");
        }
        UCPErrorHandler.throwSQLException(58, null);
        return null;
    }

    @Override
    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword(), null);
    }

    @Override
    public XAConnection getXAConnection(String string, @Blind String string2) throws SQLException {
        return this.getXAConnection(string, string2, null);
    }

    @Override
    public XAConnection getXAConnection(Properties properties) throws SQLException {
        return this.getXAConnection(this.getUser(), this.getPassword(), properties);
    }

    @Override
    public XAConnection getXAConnection(String string, @Blind String string2, Properties properties) throws SQLException {
        return this.createXAConnectionBuilder().user(string).password(string2).labels(properties).build();
    }

    XAConnection getXAConnection(UCPXAConnectionBuilderImpl uCPXAConnectionBuilderImpl) throws SQLException {
        this.startPool();
        XAConnection xAConnection = null;
        try {
            if (uCPXAConnectionBuilderImpl.serviceName == null) {
                uCPXAConnectionBuilderImpl.serviceName(this.getServiceName());
            }
            if (uCPXAConnectionBuilderImpl.user == null) {
                uCPXAConnectionBuilderImpl.user(this.getUser());
            }
            if (uCPXAConnectionBuilderImpl.password == OpaqueString.NULL) {
                uCPXAConnectionBuilderImpl.internalPassword(this.getPasswordInternal());
            }
            if (uCPXAConnectionBuilderImpl.pdbRoles == null) {
                uCPXAConnectionBuilderImpl.pdbRoles(this.getPdbRoles());
            }
            JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = new JDBCConnectionRetrievalInfo(uCPXAConnectionBuilderImpl);
            JDBCUniversalPooledConnection jDBCUniversalPooledConnection = (JDBCUniversalPooledConnection)this.m_cp.borrowConnection(jDBCConnectionRetrievalInfo);
            jDBCUniversalPooledConnection.setMaxStatements(this.m_cp.getMaxStatements());
            xAConnection = this.m_cp.getProxyFactory().proxyForXAConnection(this.m_cp, jDBCUniversalPooledConnection);
        }
        catch (NoAvailableConnectionsException noAvailableConnectionsException) {
            UCPErrorHandler.throwSQLException(28, noAvailableConnectionsException);
        }
        catch (UniversalConnectionPoolException universalConnectionPoolException) {
            UCPErrorHandler.throwSQLException(29, universalConnectionPoolException);
        }
        return xAConnection;
    }

    @Override
    public UCPXAConnectionBuilder createXAConnectionBuilder() {
        return new UCPXAConnectionBuilderImpl(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;

            @Override
            public XAConnection build() throws SQLException {
                return PoolXADataSourceImpl.this.getXAConnection(this);
            }

            static {
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredConstructor(PoolXADataSourceImpl.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("build", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    static {
        try {
            $$$methodRef$$$12 = PoolXADataSourceImpl.class.getDeclaredConstructor(String.class, String.class, Map.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$11 = PoolXADataSourceImpl.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$10 = PoolXADataSourceImpl.class.getDeclaredMethod("createXAConnectionBuilder", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$9 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", UCPXAConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$8 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$7 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$6 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$5 = PoolXADataSourceImpl.class.getDeclaredMethod("getXAConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$4 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$3 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = PoolXADataSourceImpl.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = PoolXADataSourceImpl.class.getDeclaredMethod("createPoolWithDefaultProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

