/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.ConnectionEventListener;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPool;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.jdbc")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class XADataSourceConnectionFactoryAdapter
extends JDBCConnectionFactoryAdapter {
    protected XADataSource m_xaDataSource;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;

    public XADataSourceConnectionFactoryAdapter(XADataSource xADataSource) throws UniversalConnectionPoolException {
        if (null == xADataSource) {
            UCPErrorHandler.throwUniversalConnectionPoolException(260);
        }
        this.m_xaDataSource = xADataSource;
    }

    public XADataSource getXaDataSource() {
        return this.m_xaDataSource;
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        if (!(connectionRetrievalInfo instanceof JDBCConnectionRetrievalInfo)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(252);
        }
        JDBCConnectionRetrievalInfo jDBCConnectionRetrievalInfo = (JDBCConnectionRetrievalInfo)connectionRetrievalInfo;
        XAConnection xAConnection = null;
        try {
            xAConnection = this.m_xaDataSource.getXAConnection(jDBCConnectionRetrievalInfo.getUser(), jDBCConnectionRetrievalInfo.getPassword().get());
            UniversalConnectionPool universalConnectionPool = this.getUniversalConnectionPool();
            if (universalConnectionPool != null && universalConnectionPool instanceof ConnectionEventListener) {
                xAConnection.addConnectionEventListener((ConnectionEventListener)((Object)universalConnectionPool));
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            UCPErrorHandler.throwUniversalConnectionPoolException(261, sQLException);
        }
        return xAConnection;
    }

    @Override
    public void closeConnection(Object object) throws UniversalConnectionPoolException {
        if (!(object instanceof XAConnection)) {
            UCPErrorHandler.throwUniversalConnectionPoolException(262);
        }
        XAConnection xAConnection = (XAConnection)object;
        UniversalConnectionPool universalConnectionPool = this.getUniversalConnectionPool();
        if (universalConnectionPool != null && universalConnectionPool instanceof ConnectionEventListener) {
            xAConnection.removeConnectionEventListener((ConnectionEventListener)((Object)universalConnectionPool));
        }
        try {
            xAConnection.close();
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            UCPErrorHandler.throwUniversalConnectionPoolException(263);
        }
    }

    static {
        try {
            $$$methodRef$$$3 = XADataSourceConnectionFactoryAdapter.class.getDeclaredConstructor(XADataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$2 = XADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("closeConnection", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$1 = XADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
        try {
            $$$methodRef$$$0 = XADataSourceConnectionFactoryAdapter.class.getDeclaredMethod("getXaDataSource", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc");
    }
}

