/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.ucp.jdbc.oracle.FailoverStatisticsCounters;

@DisableTrace
class FailoverStatisticsItem {
    final long timestamp;
    final Type type;
    final String serviceName;
    final String instanceName;
    final String dbUniqName;
    final String hostName;
    String reason;
    boolean successful;
    int availConns;
    int borrowedConns;
    FailoverStatisticsCounters availMarked = new FailoverStatisticsCounters();
    FailoverStatisticsCounters borrowedMarked = new FailoverStatisticsCounters();
    FailoverStatisticsCounters availClosed = new FailoverStatisticsCounters();
    FailoverStatisticsCounters borrowedClosed = new FailoverStatisticsCounters();
    int cardinality;
    int targetedToTearConns;
    int tornDownConns;
    int markedToCloseConns;
    int targetUpEventNewConns;
    int upEventNewConnCount;

    FailoverStatisticsItem(long l2, Type type) {
        this.timestamp = l2;
        this.type = type;
        this.hostName = null;
        this.dbUniqName = null;
        this.instanceName = null;
        this.serviceName = null;
    }

    FailoverStatisticsItem(Type type, String string, String string2, String string3, String string4) {
        this.timestamp = System.currentTimeMillis();
        this.type = type;
        this.serviceName = string;
        this.instanceName = string2;
        this.dbUniqName = string3;
        this.hostName = string4;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = DateFormat.getDateTimeInstance(2, 3).format(new Date(this.timestamp));
        stringBuilder.append(string).append(this.successful ? " SUCCESS" : " FAILURE");
        if (this.type == Type.SERVICE_DOWN || this.type == Type.HOST_DOWN || this.type == Type.INSTANCE_DOWN) {
            stringBuilder.append(" <Reason:").append(null != this.reason ? this.reason : "unplanned").append('>');
        }
        stringBuilder.append(" <Type:").append((Object)this.type).append('>');
        if (this.type == Type.HOST_DOWN || this.type == Type.HOST_UP) {
            stringBuilder.append(" <Host:\"").append(this.hostName).append("\">");
        } else {
            stringBuilder.append(" <Service:\"").append(this.serviceName).append("\">").append(" <Instance:\"").append(this.instanceName).append("\">").append(" <Db:\"").append(this.dbUniqName).append("\">");
        }
        stringBuilder.append(" Connections:").append("(Available=").append(this.availConns).append(" Affected=").append(this.availClosed.affected).append(" FailedToProcess=").append(this.availMarked.failed + this.availClosed.failed).append(" MarkedDown=").append(this.availMarked.markedBad).append(" Closed=").append(this.availClosed.abortedAndClosed).append(")").append("(Borrowed=").append(this.borrowedConns).append(" Affected=").append(this.borrowedClosed.affected).append(" FailedToProcess=").append(this.borrowedMarked.failed + this.borrowedClosed.failed).append(" MarkedDown=").append(this.borrowedMarked.markedBad).append(" MarkedDeferredClose=").append(this.borrowedMarked.markedCloseOnReturn).append(" Closed=").append(this.borrowedClosed.abortedAndClosed).append(")");
        if (this.type == Type.SERVICE_UP || this.type == Type.HOST_UP || this.type == Type.INSTANCE_UP) {
            stringBuilder.append(" cardinality=").append(this.cardinality).append(" targetedToTear=").append(this.targetedToTearConns).append(" tornDown=").append(this.tornDownConns).append(" markedToClose=").append(this.markedToCloseConns).append(" targetUpEventNewConns=").append(this.targetUpEventNewConns).append(" upEventNewConns=").append(this.upEventNewConnCount);
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }

    static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SERVICE_DOWN;
        public static final /* enum */ Type SERVICE_UP;
        public static final /* enum */ Type HOST_DOWN;
        public static final /* enum */ Type HOST_UP;
        public static final /* enum */ Type INSTANCE_DOWN;
        public static final /* enum */ Type INSTANCE_UP;
        public static final /* enum */ Type NOT_PROCESSED;
        private static final /* synthetic */ Type[] $VALUES;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String string) {
            return Enum.valueOf(Type.class, string);
        }

        static {
            try {
                $$$methodRef$$$2 = Type.class.getDeclaredConstructor(String.class, Integer.TYPE);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$1 = Type.class.getDeclaredMethod("valueOf", String.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            try {
                $$$methodRef$$$0 = Type.class.getDeclaredMethod("values", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            SERVICE_DOWN = new Type();
            SERVICE_UP = new Type();
            HOST_DOWN = new Type();
            HOST_UP = new Type();
            INSTANCE_DOWN = new Type();
            INSTANCE_UP = new Type();
            NOT_PROCESSED = new Type();
            $VALUES = new Type[]{SERVICE_DOWN, SERVICE_UP, HOST_DOWN, HOST_UP, INSTANCE_DOWN, INSTANCE_UP, NOT_PROCESSED};
        }
    }
}

