/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.HIGH_AVAILABILITY})
public class FailoverablePooledConnectionHelper {
    private static final Object[] NO_ARGS;
    private static final Map<Class, InvocationVector> oracleConnCache;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    static boolean isUsableOnOracleConnection(Connection connection) {
        boolean bl2 = false;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodIsUsable();
            if (null != method) {
                bl2 = (Boolean)method.invoke((Object)connection, NO_ARGS);
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke isUsable(): no such method");
                bl2 = !connection.isClosed();
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return bl2;
    }

    static long getLastNetworkAccessTime(Connection connection) {
        long l2 = 0L;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodNetworkStat();
            if (null != method) {
                NetStat netStat = (NetStat)method.invoke((Object)connection, NO_ARGS);
                if (netStat != null) {
                    l2 = netStat.getLastNetworkAccessTime();
                }
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getNetworkStat(): no such method");
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return l2;
    }

    public static Properties getSessionInfoOnOracleConnection(Connection connection) {
        Properties properties = new Properties();
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodGetServerSessionInfo();
            if (null != method) {
                properties = (Properties)method.invoke((Object)connection, NO_ARGS);
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getServerSessionInfo: method not found");
                properties = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnectionHelper(connection);
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getSessionInfoOnOracleConnectionHelper(Connection connection) throws SQLException {
        String string = "select sys_context('userenv', 'instance_name'),sys_context('userenv', 'server_host'),sys_context('userenv', 'service_name'),sys_context('userenv', 'db_unique_name') from dual";
        Properties properties = new Properties();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                String string2 = null;
                string2 = resultSet.getString(1);
                if (string2 != null) {
                    properties.setProperty("INSTANCE_NAME", string2);
                }
                if ((string2 = resultSet.getString(2)) != null) {
                    properties.setProperty("SERVER_HOST", string2);
                }
                if ((string2 = resultSet.getString(3)) != null) {
                    properties.setProperty("SERVICE_NAME", string2);
                }
                if ((string2 = resultSet.getString(4)) == null) continue;
                properties.setProperty("DATABASE_NAME", string2);
            }
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return properties;
    }

    static void cancelOnOracleConnection(Connection connection) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodCancel();
            if (null != method) {
                method.invoke((Object)connection, NO_ARGS);
                ClioSupport.ilogFinest(null, null, null, null, "conn cancelled successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to cancel a connection: method not found");
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    static void enableStatementPooling(Connection connection, int n2) throws SQLException {
        block6: {
            try {
                if (null == connection) {
                    ClioSupport.ilogFinest(null, null, null, null, "failed to get SQL conn");
                    return;
                }
                InvocationVector invocationVector = FailoverablePooledConnectionHelper.getInvocationVector(connection);
                Method method = invocationVector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)connection, n2);
                    ClioSupport.ilogFinest(null, null, null, null, "setStatementCacheSize invoked");
                }
                if (null != (method = invocationVector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)connection, true);
                    ClioSupport.ilogFinest(null, null, null, null, "setImplicitCachingEnabled invoked");
                }
                if (null != (method = invocationVector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)connection, true);
                    ClioSupport.ilogFinest(null, null, null, null, "setExplicitCachingEnabled invoked");
                }
            }
            catch (Exception exception) {
                ClioSupport.ilogThrowing(null, null, null, null, exception);
                if (!(exception instanceof SQLException)) break block6;
                throw (SQLException)exception;
            }
        }
    }

    static void disableStatementPooling(Connection connection) throws SQLException {
        block6: {
            try {
                if (null == connection) {
                    ClioSupport.ilogFinest(null, null, null, null, "failed to get SQL conn");
                    return;
                }
                InvocationVector invocationVector = FailoverablePooledConnectionHelper.getInvocationVector(connection);
                Method method = invocationVector.getMethodSetStatementCacheSize();
                if (null != method) {
                    method.invoke((Object)connection, 0);
                    ClioSupport.ilogFinest(null, null, null, null, "setStatementCacheSize invoked");
                }
                if (null != (method = invocationVector.getMethodSetImplicitCachingEnabled())) {
                    method.invoke((Object)connection, false);
                    ClioSupport.ilogFinest(null, null, null, null, "setImplicitCachingEnabled invoked");
                }
                if (null != (method = invocationVector.getMethodSetExplicitCachingEnabled())) {
                    method.invoke((Object)connection, false);
                    ClioSupport.ilogFinest(null, null, null, null, "setExplicitCachingEnabled invoked");
                }
            }
            catch (Exception exception) {
                ClioSupport.ilogThrowing(null, null, null, null, exception);
                if (!(exception instanceof SQLException)) break block6;
                throw (SQLException)exception;
            }
        }
    }

    static boolean pingDatabaseOnOracleConnection(Connection connection) {
        Object[] objectArray;
        InvocationVector invocationVector = FailoverablePooledConnectionHelper.getInvocationVector(connection);
        Method method = invocationVector.getMethodPingDatabase();
        if (null == method) {
            method = invocationVector.getMethodPingDatabaseInt();
            objectArray = new Object[]{0};
        } else {
            objectArray = NO_ARGS;
        }
        try {
            return invocationVector.getConnClass().getField("DATABASE_OK").getInt(null) == ((Integer)method.invoke((Object)connection, objectArray)).intValue();
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
            return true;
        }
    }

    public static void abortOracleConnection(final Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            final Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodAbort();
            if (null != method) {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                    private static Executable $$$methodRef$$$0;
                    private static Logger $$$loggerRef$$$0;
                    private static Executable $$$methodRef$$$1;
                    private static Logger $$$loggerRef$$$1;
                    private static Executable $$$methodRef$$$2;
                    private static Logger $$$loggerRef$$$2;

                    @Override
                    public Void run() throws IllegalAccessException, InvocationTargetException {
                        method.invoke((Object)connection, NO_ARGS);
                        return null;
                    }

                    static {
                        try {
                            $$$methodRef$$$2 = 1.class.getDeclaredConstructor(Method.class, Connection.class);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                        try {
                            $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                        }
                        catch (Throwable throwable) {}
                        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                    }
                });
                ClioSupport.ilogFinest(null, null, null, null, "connection aborted");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to abort connection: method not found");
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
    }

    protected static InvocationVector getInvocationVector(Connection connection) {
        Class<?> clazz = connection.getClass();
        InvocationVector invocationVector = oracleConnCache.get(clazz);
        if (null != invocationVector) {
            return invocationVector;
        }
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("oracle.jdbc.internal.OracleConnection", true, clazz.getClassLoader());
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        final Class<?> clazz3 = clazz2;
        invocationVector = new InvocationVector(){
            private final Method abort = this.getMethod("abort");
            private final Method cancel = this.getMethod("cancel");
            private final Method isUsable = this.getMethod("isUsable");
            private final Method setStatementCacheSize = this.getMethod("setStatementCacheSize", Integer.TYPE);
            private final Method setImplicitCachingEnabled = this.getMethod("setImplicitCachingEnabled", Boolean.TYPE);
            private final Method setExplicitCachingEnabled = this.getMethod("setExplicitCachingEnabled", Boolean.TYPE);
            private final Method getServerSessionInfo = this.getMethod("getServerSessionInfo");
            private final Method pingDatabase = this.getMethod("pingDatabase");
            private final Method pingDatabaseInt = this.getMethod("pingDatabase", Integer.TYPE);
            private final Method getVersionNumber = this.getMethod("getVersionNumber");
            private final Method attachServerConnection = this.getMethod("attachServerConnection");
            private final Method detachServerConnection = this.getMethod("detachServerConnection", String.class);
            private final Method isDRCPEnabled = this.getMethod("isDRCPEnabled");
            private final Method isDRCPMultitagEnabled = this.getMethod("isDRCPMultitagEnabled");
            private final Method getDRCPReturnTag = this.getMethod("getDRCPReturnTag");
            private final Method getDRCPPLSQLCallbackName = this.getMethod("getDRCPPLSQLCallbackName");
            private final Method getNetworkStat = this.getMethod("getNetworkStat");
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;
            private static Executable $$$methodRef$$$4;
            private static Logger $$$loggerRef$$$4;
            private static Executable $$$methodRef$$$5;
            private static Logger $$$loggerRef$$$5;
            private static Executable $$$methodRef$$$6;
            private static Logger $$$loggerRef$$$6;
            private static Executable $$$methodRef$$$7;
            private static Logger $$$loggerRef$$$7;
            private static Executable $$$methodRef$$$8;
            private static Logger $$$loggerRef$$$8;
            private static Executable $$$methodRef$$$9;
            private static Logger $$$loggerRef$$$9;
            private static Executable $$$methodRef$$$10;
            private static Logger $$$loggerRef$$$10;
            private static Executable $$$methodRef$$$11;
            private static Logger $$$loggerRef$$$11;
            private static Executable $$$methodRef$$$12;
            private static Logger $$$loggerRef$$$12;
            private static Executable $$$methodRef$$$13;
            private static Logger $$$loggerRef$$$13;
            private static Executable $$$methodRef$$$14;
            private static Logger $$$loggerRef$$$14;
            private static Executable $$$methodRef$$$15;
            private static Logger $$$loggerRef$$$15;
            private static Executable $$$methodRef$$$16;
            private static Logger $$$loggerRef$$$16;
            private static Executable $$$methodRef$$$17;
            private static Logger $$$loggerRef$$$17;
            private static Executable $$$methodRef$$$18;
            private static Logger $$$loggerRef$$$18;
            private static Executable $$$methodRef$$$19;
            private static Logger $$$loggerRef$$$19;
            private static Executable $$$methodRef$$$20;
            private static Logger $$$loggerRef$$$20;

            private Method getMethod(String string, Class clazz) {
                if (null != clazz3) {
                    try {
                        return clazz3.getMethod(string, clazz);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        ClioSupport.ilogThrowing(null, null, null, null, noSuchMethodException);
                        return null;
                    }
                }
                return null;
            }

            private Method getMethod(String string) {
                if (null != clazz3) {
                    try {
                        return clazz3.getMethod(string, new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        ClioSupport.ilogThrowing(null, null, null, null, noSuchMethodException);
                        return null;
                    }
                }
                return null;
            }

            @Override
            public Class getConnClass() {
                return clazz3;
            }

            @Override
            public Method getMethodAbort() {
                return this.abort;
            }

            @Override
            public Method getMethodCancel() {
                return this.cancel;
            }

            @Override
            public Method getMethodIsUsable() {
                return this.isUsable;
            }

            @Override
            public Method getMethodNetworkStat() {
                return this.getNetworkStat;
            }

            @Override
            public Method getMethodSetStatementCacheSize() {
                return this.setStatementCacheSize;
            }

            @Override
            public Method getMethodSetImplicitCachingEnabled() {
                return this.setImplicitCachingEnabled;
            }

            @Override
            public Method getMethodSetExplicitCachingEnabled() {
                return this.setExplicitCachingEnabled;
            }

            @Override
            public Method getMethodGetServerSessionInfo() {
                return this.getServerSessionInfo;
            }

            @Override
            public Method getMethodPingDatabase() {
                return this.pingDatabase;
            }

            @Override
            public Method getMethodPingDatabaseInt() {
                return this.pingDatabaseInt;
            }

            @Override
            public Method getMethodGetVersionNumber() {
                return this.getVersionNumber;
            }

            @Override
            public Method getMethodAttachServerConnection() {
                return this.attachServerConnection;
            }

            @Override
            public Method getMethodIsDRCPEnabled() {
                return this.isDRCPEnabled;
            }

            @Override
            public Method getMethodDetachServerConnection() {
                return this.detachServerConnection;
            }

            @Override
            public Method getMethodIsDRCPMultitagEnabled() {
                return this.isDRCPMultitagEnabled;
            }

            @Override
            public Method getMethodGetDRCPReturnTag() {
                return this.getDRCPReturnTag;
            }

            @Override
            public Method getDRCPPLSQLCallbackName() {
                return this.getDRCPPLSQLCallbackName;
            }

            static {
                try {
                    $$$methodRef$$$20 = 2.class.getDeclaredConstructor(Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$19 = 2.class.getDeclaredMethod("getDRCPPLSQLCallbackName", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$18 = 2.class.getDeclaredMethod("getMethodGetDRCPReturnTag", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$17 = 2.class.getDeclaredMethod("getMethodIsDRCPMultitagEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$16 = 2.class.getDeclaredMethod("getMethodDetachServerConnection", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$15 = 2.class.getDeclaredMethod("getMethodIsDRCPEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$14 = 2.class.getDeclaredMethod("getMethodAttachServerConnection", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$13 = 2.class.getDeclaredMethod("getMethodGetVersionNumber", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$12 = 2.class.getDeclaredMethod("getMethodPingDatabaseInt", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$11 = 2.class.getDeclaredMethod("getMethodPingDatabase", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$10 = 2.class.getDeclaredMethod("getMethodGetServerSessionInfo", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$9 = 2.class.getDeclaredMethod("getMethodSetExplicitCachingEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$8 = 2.class.getDeclaredMethod("getMethodSetImplicitCachingEnabled", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$7 = 2.class.getDeclaredMethod("getMethodSetStatementCacheSize", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$6 = 2.class.getDeclaredMethod("getMethodNetworkStat", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$5 = 2.class.getDeclaredMethod("getMethodIsUsable", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$4 = 2.class.getDeclaredMethod("getMethodCancel", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$3 = 2.class.getDeclaredMethod("getMethodAbort", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 2.class.getDeclaredMethod("getConnClass", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 2.class.getDeclaredMethod("getMethod", String.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 2.class.getDeclaredMethod("getMethod", String.class, Class.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
        oracleConnCache.put(clazz, invocationVector);
        return invocationVector;
    }

    public static int getDatabaseVersion(Connection connection) throws UniversalConnectionPoolException {
        int n2 = 0;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodGetVersionNumber();
            if (null != method) {
                n2 = ((Short)method.invoke((Object)connection, NO_ARGS)).intValue();
                ClioSupport.ilogFinest(null, null, null, null, "db version obtained successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to get db version: method not found");
            }
        }
        catch (Exception exception) {
            n2 = 0;
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return n2;
    }

    public static boolean attachServerConnection(Connection connection) throws SQLException {
        boolean bl2 = true;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodAttachServerConnection();
            if (null != method) {
                bl2 = (Boolean)method.invoke((Object)connection, NO_ARGS);
                ClioSupport.ilogFinest(null, null, null, null, "Invoked attachServerConnection Successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke attachServerConnection");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl2;
    }

    public static void detachServerConnection(Connection connection, String string) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodDetachServerConnection();
            if (null != method) {
                method.invoke((Object)connection, string);
                ClioSupport.ilogFinest(null, null, null, null, "Invoked detachServerConnection Successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke detachServerConnection");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isDRCPEnabled(Connection connection) throws SQLException {
        Boolean bl2 = Boolean.FALSE;
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodIsDRCPEnabled();
            if (null != method) {
                bl2 = (Boolean)method.invoke((Object)connection, NO_ARGS);
                ClioSupport.ilogFinest(null, null, null, null, "Invoked isDRCPEnabled Successfully");
            } else {
                ClioSupport.ilogFinest(null, null, null, null, "failed to invoke isDRCPEnabled");
            }
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return bl2;
    }

    static boolean isDRCPMultitagEnabled(Connection connection) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodIsDRCPMultitagEnabled();
            if (method != null) {
                return (Boolean)method.invoke((Object)connection, NO_ARGS);
            }
            ClioSupport.ilogFinest(null, null, null, null, "failed to invoke isDRCPMultitagEnabled");
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return false;
    }

    static String getDRCPReturnTag(Connection connection) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getMethodGetDRCPReturnTag();
            if (method != null) {
                return (String)method.invoke((Object)connection, NO_ARGS);
            }
            ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getDRCPReturnTag");
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return null;
    }

    static String getDRCPPLSQLCallbackName(Connection connection) throws SQLException {
        try {
            Method method = FailoverablePooledConnectionHelper.getInvocationVector(connection).getDRCPPLSQLCallbackName();
            if (method != null) {
                return (String)method.invoke((Object)connection, NO_ARGS);
            }
            ClioSupport.ilogFinest(null, null, null, null, "failed to invoke getDRCPPLSQLCallbackName");
        }
        catch (Exception exception) {
            ClioSupport.ilogThrowing(null, null, null, null, exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInstanceNumber(Connection connection) throws SQLException {
        Properties properties = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(connection);
        String string = properties.getProperty("AUTH_SC_INSTANCE_ID");
        if (string != null && !"".equals(string)) {
            return Integer.parseInt(string);
        }
        ClioSupport.ilogFinest(null, null, null, null, "Failed to obtain instance number without roundtrip, doing a query");
        String string2 = "select sys_context('userenv', 'instance') from dual";
        int n2 = -1;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
            resultSet.next();
            n2 = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            ClioSupport.ilogThrowing(null, null, null, null, sQLException);
            n2 = -1;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        return n2;
    }

    public static Date getInstanceStartTime(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.indexOf(".", 18);
        stringBuffer.delete(n2, n2 + 10);
        stringBuffer.insert(n2 + 1, "GMT");
        ClioSupport.ilogFinest(null, null, null, null, "instance start time string: " + stringBuffer);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        simpleDateFormat.setLenient(false);
        Date date = null;
        try {
            date = simpleDateFormat.parse(stringBuffer.toString());
        }
        catch (ParseException parseException) {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid instance start time, return null: " + stringBuffer);
            date = null;
        }
        return date;
    }

    static {
        try {
            $$$methodRef$$$20 = FailoverablePooledConnectionHelper.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$19 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("access$000", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$18 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getInstanceStartTime", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$17 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getInstanceNumber", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$16 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getDRCPPLSQLCallbackName", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$15 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getDRCPReturnTag", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$14 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("isDRCPMultitagEnabled", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$13 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("isDRCPEnabled", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$12 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("detachServerConnection", Connection.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$11 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("attachServerConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$10 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getDatabaseVersion", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$9 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getInvocationVector", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$8 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("abortOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$7 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("pingDatabaseOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("disableStatementPooling", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("enableStatementPooling", Connection.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("cancelOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getSessionInfoOnOracleConnectionHelper", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getSessionInfoOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("getLastNetworkAccessTime", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = FailoverablePooledConnectionHelper.class.getDeclaredMethod("isUsableOnOracleConnection", Connection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        NO_ARGS = new Object[0];
        oracleConnCache = Collections.synchronizedMap(new HashMap());
    }

    static interface InvocationVector {
        public Class getConnClass();

        public Method getMethodAbort();

        public Method getMethodCancel();

        public Method getMethodIsUsable();

        public Method getMethodSetStatementCacheSize();

        public Method getMethodSetImplicitCachingEnabled();

        public Method getMethodSetExplicitCachingEnabled();

        public Method getMethodGetServerSessionInfo();

        public Method getMethodPingDatabase();

        public Method getMethodPingDatabaseInt();

        public Method getMethodGetVersionNumber();

        public Method getMethodAttachServerConnection();

        public Method getMethodDetachServerConnection();

        public Method getMethodIsDRCPEnabled();

        public Method getMethodIsDRCPMultitagEnabled();

        public Method getMethodGetDRCPReturnTag();

        public Method getDRCPPLSQLCallbackName();

        public Method getMethodNetworkStat();
    }
}

