/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.common.FailoverEvent;
import oracle.ucp.common.FailoverEventHandlerTaskBase;
import oracle.ucp.common.Failoverable;
import oracle.ucp.jdbc.oracle.ONSDatabaseFailoverEvent;
import oracle.ucp.jdbc.oracle.ONSOracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.jdbc.oracle.OracleFailoverEventSubscriber;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.util.TaskManager;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
class ONSDatabaseEventHandlerTask
extends FailoverEventHandlerTaskBase {
    private final OracleFailoverEventSubscriber m_onsSubscriber;
    private final boolean m_subscriberFailed;
    private final TaskManager m_taskManager;
    private final LinkedList<OracleFailoverEvent> m_recentEvents = new LinkedList();
    private static final int EVENT_AGE_OUT_PERIOD = 120000;
    private long m_timestampOfLastEvent;
    private static final String FAN_STATUS_FIELD = "status";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;

    ONSDatabaseEventHandlerTask(String string, Failoverable failoverable, TaskManager taskManager) throws UniversalConnectionPoolException {
        this(string, failoverable, null, taskManager);
    }

    protected ONSDatabaseEventHandlerTask(String string, Failoverable failoverable, OracleFailoverEventSubscriber oracleFailoverEventSubscriber, TaskManager taskManager) throws UniversalConnectionPoolException {
        super(failoverable);
        ONS oNS = ((RACManagerImpl)failoverable).getONS();
        if (null == oracleFailoverEventSubscriber) {
            ONSOracleFailoverEventSubscriber oNSOracleFailoverEventSubscriber = new ONSOracleFailoverEventSubscriber(string, oNS);
            this.m_subscriberFailed = oNSOracleFailoverEventSubscriber.isFailed();
            this.m_onsSubscriber = oNSOracleFailoverEventSubscriber;
        } else {
            this.m_subscriberFailed = false;
            this.m_onsSubscriber = oracleFailoverEventSubscriber;
        }
        this.m_taskManager = taskManager;
    }

    ONSDatabaseEventHandlerTask(Failoverable failoverable, TaskManager taskManager) throws UniversalConnectionPoolException {
        this("", failoverable, null, taskManager);
    }

    protected ONSDatabaseEventHandlerTask(Failoverable failoverable, OracleFailoverEventSubscriber oracleFailoverEventSubscriber, TaskManager taskManager) throws UniversalConnectionPoolException {
        this("", failoverable, oracleFailoverEventSubscriber, taskManager);
    }

    @Override
    public void run() {
        Notification notification = null;
        boolean bl2 = false;
        if (!this.m_subscriberFailed) {
            while (!this.isTerminate()) {
                ClioSupport.ilogFinest(null, null, null, null, "check for events");
                try {
                    notification = this.m_onsSubscriber.receive();
                    if (notification != null) {
                        ONSDatabaseFailoverEvent oNSDatabaseFailoverEvent = notification.get(FAN_STATUS_FIELD) != null ? new ONSDatabaseFailoverEvent(notification) : new ONSDatabaseFailoverEvent(notification.type(), notification.body());
                        this.handleEvent(oNSDatabaseFailoverEvent);
                        ClioSupport.ilogFinest(null, null, null, null, "event triggered: " + ((Object)oNSDatabaseFailoverEvent).toString());
                    } else {
                        ClioSupport.ilogFinest(null, null, null, null, "received null event");
                    }
                }
                catch (UniversalConnectionPoolException universalConnectionPoolException) {
                    ClioSupport.ilogThrowing(null, null, null, null, universalConnectionPoolException);
                    bl2 = true;
                }
                if (!bl2) continue;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    ClioSupport.ilogFinest(null, null, null, null, "sleep interrupted");
                }
                bl2 = false;
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "ONS subscriber failed");
        }
    }

    @Override
    public void handleEvent(FailoverEvent failoverEvent) throws UniversalConnectionPoolException {
        OracleFailoverEvent oracleFailoverEvent = (OracleFailoverEvent)failoverEvent;
        if (!oracleFailoverEvent.isValid()) {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid HA event received: " + failoverEvent);
            return;
        }
        long l2 = oracleFailoverEvent.getTimestamp();
        if (l2 >= 0L && l2 < this.m_timestampOfLastEvent) {
            ClioSupport.ilogFinest(null, null, null, null, "Out-of-order HA event received: " + failoverEvent);
            return;
        }
        Iterator<OracleFailoverEvent> iterator = this.m_recentEvents.descendingIterator();
        boolean bl2 = false;
        String string = oracleFailoverEvent.getEventType();
        String string2 = oracleFailoverEvent.getServiceName();
        String string3 = oracleFailoverEvent.getInstanceName();
        String string4 = oracleFailoverEvent.getDbUniqueName();
        String string5 = oracleFailoverEvent.getHostName();
        String string6 = oracleFailoverEvent.getStatus();
        if (null != string2 && string2.contains("%")) {
            OracleFailoverEvent oracleFailoverEvent2;
            ClioSupport.ilogFinest(null, null, null, null, "GDS service name: " + string2 + ", processing GDS-based filtering");
            if (string.equals("database/event/service")) {
                String string7 = null;
                while (iterator.hasNext()) {
                    oracleFailoverEvent2 = iterator.next();
                    string7 = oracleFailoverEvent2.getInstanceName();
                    if (string6 == null || !string6.equals(oracleFailoverEvent2.getStatus()) || string2 == null || !string2.equals(oracleFailoverEvent2.getServiceName()) || string4 == null || !string4.equals(oracleFailoverEvent2.getDbUniqueName()) || string5 == null || !string5.equals(oracleFailoverEvent2.getHostName()) || (string3 != null || string7 != null) && (string3 == null || string7 != null && !string3.equals(string7))) continue;
                    bl2 = true;
                    ClioSupport.ilogFinest(null, null, null, null, "Redundant HA service event received and ignored: " + oracleFailoverEvent);
                    break;
                }
            } else if (string.equals("database/event/host")) {
                while (iterator.hasNext()) {
                    oracleFailoverEvent2 = iterator.next();
                    if (string5 == null || !string5.equals(oracleFailoverEvent2.getHostName())) continue;
                    bl2 = true;
                    ClioSupport.ilogFinest(null, null, null, null, "Redundant HA host event received and ignored: " + oracleFailoverEvent);
                    break;
                }
            }
            if (!bl2) {
                this.m_recentEvents.addLast(oracleFailoverEvent);
                this.m_timestampOfLastEvent = oracleFailoverEvent.getTimestamp();
                super.handleEvent(failoverEvent);
                while ((oracleFailoverEvent2 = this.m_recentEvents.peekFirst()) != null && this.m_timestampOfLastEvent > oracleFailoverEvent2.getTimestamp() + 120000L) {
                    ClioSupport.ilogFinest(null, null, null, null, "about to remove " + oracleFailoverEvent2.toString());
                    this.m_recentEvents.removeFirst();
                }
            }
        } else {
            ClioSupport.ilogFinest(null, null, null, null, "non-GDS service name: " + string2 + ", skipping GDS-based filtering");
            super.handleEvent(failoverEvent);
        }
    }

    @Override
    public void setTerminate(boolean bl2) {
        super.setTerminate(bl2);
        if (bl2) {
            this.m_onsSubscriber.close();
        }
    }

    @Override
    protected TaskManager getTaskManager() {
        return this.m_taskManager;
    }

    static {
        try {
            $$$methodRef$$$7 = ONSDatabaseEventHandlerTask.class.getDeclaredConstructor(Failoverable.class, OracleFailoverEventSubscriber.class, TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$6 = ONSDatabaseEventHandlerTask.class.getDeclaredConstructor(Failoverable.class, TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$5 = ONSDatabaseEventHandlerTask.class.getDeclaredConstructor(String.class, Failoverable.class, OracleFailoverEventSubscriber.class, TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$4 = ONSDatabaseEventHandlerTask.class.getDeclaredConstructor(String.class, Failoverable.class, TaskManager.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$3 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("getTaskManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$2 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("setTerminate", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$1 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("handleEvent", FailoverEvent.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ONSDatabaseEventHandlerTask.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

