/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.ons.Notification;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEventImpl;
import oracle.ucp.logging.ClioSupport;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.LOAD_BALANCING, Feature.HIGH_AVAILABILITY})
final class ONSDatabaseFailoverEvent
extends OracleFailoverEventImpl {
    private static final String ONS_FAILOVER_EVENT_DELIMITER = "{} =";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;

    ONSDatabaseFailoverEvent(Notification notification) throws UniversalConnectionPoolException {
        super(notification.type());
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        ClioSupport.ilogFinest(null, null, null, null, "Notification: " + notification + ", eventType: " + notification.type() + ", eventBody: " + notification.body());
        String string9 = notification.get("version");
        if (string9 != null && !string9.startsWith("1.")) {
            ClioSupport.ilogFinest(null, null, null, null, "Invalid Event version " + string9);
            this.setValidity(false);
            return;
        }
        String string10 = notification.get("service");
        if (string10 != null) {
            this.setServiceName(string10.trim().toLowerCase());
        }
        if ((string8 = notification.get("instance")) != null && !string8.equals(" ")) {
            this.setInstanceName(string8.trim().toLowerCase());
        }
        if ((string7 = notification.get("database")) != null) {
            this.setDbUniqueName(string7.trim().toLowerCase());
        }
        if ((string6 = notification.get("host")) != null) {
            this.setHostName(string6.trim().toLowerCase());
        }
        if ((string5 = notification.get("db_domain")) != null) {
            this.setDbDomainName(string5.trim().toLowerCase());
        }
        if ((string4 = notification.get("status")) != null) {
            this.setStatus(string4);
        }
        if ((string3 = notification.get("card")) != null) {
            try {
                this.setCardinality(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                ClioSupport.ilogFinest(null, null, null, null, "invalid cardinality " + numberFormatException.getMessage());
                this.setValidity(false);
                return;
            }
        }
        if ((string2 = notification.get("reason")) != null) {
            this.setReason(string2.trim().toLowerCase());
        }
        if ((string = notification.get("drain_timeout")) != null) {
            try {
                this.setDrainTimeout(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                ClioSupport.ilogFinest(null, null, null, null, "invalid drain_timeout " + numberFormatException.getMessage());
                this.setValidity(false);
                return;
            }
        }
        String string11 = null;
        String string12 = null;
        String string13 = notification.get("timestamp");
        if (string13 != null) {
            string11 = string13;
        }
        String string14 = notification.get("timezone");
        if (string13 != null) {
            string12 = "GMT" + string14;
        }
        if (string11 == null && string12 == null) {
            ClioSupport.ilogFinest(null, null, null, null, "Older server, no timestamp/timezone in HA event");
        } else {
            SimpleDateFormat simpleDateFormat = string12 != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            simpleDateFormat.setLenient(false);
            Date date = null;
            String string15 = string12 != null ? string11 + " " + string12 : string11;
            try {
                date = simpleDateFormat.parse(string15);
            }
            catch (ParseException parseException) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + string15);
                this.setValidity(false);
                return;
            }
            if (date == null) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + string15);
                this.setValidity(false);
                return;
            }
            this.setTimestamp(date);
            this.setTimeZone(string12);
        }
    }

    ONSDatabaseFailoverEvent(String string, byte[] byArray) throws UniversalConnectionPoolException {
        super(string);
        Object object;
        Object object2;
        ClioSupport.ilogFinest(null, null, null, null, "eventType: " + string + ", eventBody: " + byArray);
        StringTokenizer stringTokenizer = null;
        try {
            stringTokenizer = new StringTokenizer(new String(byArray, "UTF-8"), ONS_FAILOVER_EVENT_DELIMITER, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ClioSupport.ilogThrowing(null, null, null, null, unsupportedEncodingException);
        }
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = null;
            string2 = stringTokenizer.nextToken();
            if (string2.equals("=") && stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            } else {
                string4 = string2;
            }
            if (string4.equalsIgnoreCase("version") && string3 != null && !string3.startsWith("1.")) {
                ClioSupport.ilogFinest(null, null, null, null, "Invalid Event version " + string3);
                this.setValidity(false);
                return;
            }
            if (string4.equalsIgnoreCase("service") && string3 != null) {
                this.setServiceName(string3.trim().toLowerCase());
                continue;
            }
            if (string4.equalsIgnoreCase("instance") && string3 != null && !string3.equals(" ")) {
                this.setInstanceName(string3.trim().toLowerCase());
                continue;
            }
            if (string4.equalsIgnoreCase("database") && string3 != null) {
                this.setDbUniqueName(string3.trim().toLowerCase());
                continue;
            }
            if (string4.equalsIgnoreCase("host") && string3 != null) {
                this.setHostName(string3.trim().toLowerCase());
                continue;
            }
            if (string4.equalsIgnoreCase("db_domain") && string3 != null) {
                this.setDbDomainName(string3.trim().toLowerCase());
                continue;
            }
            if (string4.equalsIgnoreCase("status") && string3 != null) {
                this.setStatus(string3);
                continue;
            }
            if (string4.equalsIgnoreCase("card") && string3 != null) {
                try {
                    this.setCardinality(Integer.parseInt(string3));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    ClioSupport.ilogFinest(null, null, null, null, "invalid cardinality " + numberFormatException.getMessage());
                    this.setValidity(false);
                    return;
                }
            }
            if (string4.equalsIgnoreCase("reason") && string3 != null) {
                this.setReason(string3.trim().toLowerCase());
                continue;
            }
            if (string4.equalsIgnoreCase("timestamp") && string3 != null) {
                object2 = stringTokenizer.nextToken();
                object = stringTokenizer.nextToken();
                string5 = string3 + " " + (String)object;
                continue;
            }
            if (string4.equalsIgnoreCase("timezone") && string3 != null) {
                string6 = "GMT" + string3;
                continue;
            }
            if (!string4.equalsIgnoreCase("drain_timeout") || string3 == null) continue;
            try {
                this.setDrainTimeout(Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                ClioSupport.ilogFinest(null, null, null, null, "invalid drain_timeout " + numberFormatException.getMessage());
                this.setValidity(false);
                return;
            }
        }
        if (string5 == null && string6 == null) {
            ClioSupport.ilogFinest(null, null, null, null, "Older server, no timestamp/timezone in HA event");
        } else {
            object2 = string6 != null ? new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ((DateFormat)object2).setLenient(false);
            object = null;
            String string7 = string6 != null ? string5 + " " + string6 : string5;
            try {
                object = ((DateFormat)object2).parse(string7);
            }
            catch (ParseException parseException) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + string7);
                this.setValidity(false);
                return;
            }
            if (object == null) {
                ClioSupport.ilogWarning(null, null, null, null, "Invalid timestamp/timezone in HA event: " + string7);
                this.setValidity(false);
                return;
            }
            this.setTimestamp((Date)object);
            this.setTimeZone(string6);
        }
        stringTokenizer = null;
    }

    static {
        try {
            $$$methodRef$$$1 = ONSDatabaseFailoverEvent.class.getDeclaredConstructor(String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
        try {
            $$$methodRef$$$0 = ONSDatabaseFailoverEvent.class.getDeclaredConstructor(Notification.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp.jdbc.oracle");
    }
}

